/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.xml;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.deploy.ReferenceObject;
import com.sap.engine.services.deploy.ear.exceptions.BaseWrongStructureException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ApplicationJ2EEEngineDocument {
    public static final String dtd = "<!DOCTYPE application-j2ee-engine SYSTEM 'application-j2ee-engine.dtd'>";
    protected Document mainDocument;
    protected Element mainElement;
    protected Vector references = null;
    protected String classPath = null;
    protected String providerName = null;
    protected Hashtable modules = null;
    protected String failOverEnable = "";
    protected String startUpMode = "";

    public Document loadDocumentFromFields() throws Exception {
        this.mainDocument = StandardDOMParser.createDocument();
        this.mainElement = this.mainDocument.createElement("application-j2ee-engine");
        this.mainDocument.appendChild(this.mainElement);
        this.loadReference(this.mainElement);
        this.loadClassPath(this.mainElement);
        this.loadProviderName(this.mainElement);
        this.loadModules(this.mainElement);
        this.loadFailOverEnable(this.mainElement);
        this.laodStartup(this.mainElement);
        return this.mainDocument;
    }

    private void clear() {
        if (this.references == null) {
            this.references = new Vector();
        } else {
            this.references.clear();
        }
        if (this.modules == null) {
            this.modules = new Hashtable();
        } else {
            this.modules.clear();
        }
    }

    public void loadFieldsFromDocument(Document document) throws WrongStructureException {
        this.clear();
        if (document == null || document.getDocumentElement() == null) {
            return;
        }
        NodeList list = document.getDocumentElement().getChildNodes();
        Element element = null;
        String tag = null;
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i) != null && list.item(i).getNodeType() == 1 && (tag = (element = (Element)list.item(i)).getTagName()) != null) {
                if (tag.equals("reference")) {
                    this.references.add(this.initReference(element));
                } else if (tag.equals("classpath")) {
                    this.classPath = this.initClasPath(element);
                } else if (tag.equals("provider-name")) {
                    this.providerName = this.initProviderName(element);
                } else if (tag.equals("modules-additional")) {
                    this.modules = this.initModules(element);
                } else if (tag.equals("fail-over-enable")) {
                    this.failOverEnable = this.initFailOverEnable(element);
                } else if (tag.equals("start-up")) {
                    this.startUpMode = this.initStartUpMode(element);
                }
            }
            ++i;
        }
    }

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public String getDTD() {
        return dtd;
    }

    public void setMainDocument(Document document) throws WrongStructureException {
        if (!document.getDocumentElement().getNodeName().equals("application-j2ee-engine")) {
            throw new BaseWrongStructureException("deploy_2026", new String[]{"application-j2ee-engine"});
        }
        this.mainDocument = document;
    }

    public void loadClassPath(Element elmnt) {
        if (this.classPath == null || this.classPath.trim().equals("")) {
            return;
        }
        Element classPathElement = this.mainDocument.createElement("classpath");
        classPathElement.appendChild(this.mainDocument.createTextNode(this.classPath));
        elmnt.appendChild(classPathElement);
    }

    public void loadProviderName(Element elmnt) {
        if (this.providerName == null || this.providerName.trim().equals("")) {
            return;
        }
        Element providerNameElement = this.mainDocument.createElement("provider-name");
        providerNameElement.appendChild(this.mainDocument.createTextNode(this.providerName));
        elmnt.appendChild(providerNameElement);
    }

    public void loadReference(Element elmnt) {
        if (this.references == null) {
            return;
        }
        ReferenceObject refObj = null;
        Element tempEl = null;
        int i = 0;
        while (i < this.references.size()) {
            refObj = (ReferenceObject)this.references.elementAt(i);
            if (refObj != null && (refObj.getReferenceTarget() != null && !refObj.getReferenceTarget().trim().equals("") || refObj.getReferenceType() != null && !refObj.getReferenceType().trim().equals("") || refObj.getReferenceTargetType() != null && !refObj.getReferenceTargetType().trim().equals("") || refObj.getReferenceProviderName() != null && !refObj.getReferenceProviderName().trim().equals(""))) {
                Element refObjElement = this.mainDocument.createElement("reference");
                refObjElement.setAttribute("reference-type", refObj.getReferenceType());
                tempEl = this.load(refObjElement, refObj.getReferenceTarget(), "reference-target");
                tempEl.setAttribute("target-type", refObj.getReferenceTargetType());
                if (refObj.getReferenceProviderName() != null && !refObj.getReferenceProviderName().trim().equals("")) {
                    tempEl.setAttribute("provider-name", refObj.getReferenceProviderName().trim());
                }
                elmnt.appendChild(refObjElement);
            }
            ++i;
        }
    }

    public void loadModules(Element elmnt) {
        if (this.modules == null) {
            return;
        }
        Element mainModuleEl = this.mainDocument.createElement("modules-additional");
        Element moduleEl = null;
        String key = null;
        String value = null;
        Enumeration keyEnum = this.modules.keys();
        while (keyEnum.hasMoreElements()) {
            key = (String)keyEnum.nextElement();
            if (key == null || (value = (String)this.modules.get(key)) == null) continue;
            moduleEl = this.mainDocument.createElement("module");
            this.load(moduleEl, key, "entry-name");
            StringTokenizer containetTypes = new StringTokenizer(value, ";");
            if (containetTypes != null) {
                while (containetTypes.hasMoreTokens()) {
                    this.load(moduleEl, containetTypes.nextToken(), "container-type");
                }
            }
            mainModuleEl.appendChild(moduleEl);
        }
        elmnt.appendChild(mainModuleEl);
    }

    public void laodStartup(Element el) {
        Element startUpEl = this.mainDocument.createElement("start-up");
        Object att = null;
        if (this.startUpMode == null || this.startUpMode.trim().equals("")) {
            return;
        }
        startUpEl.setAttribute("mode", this.startUpMode);
        el.appendChild(startUpEl);
    }

    public void loadFailOverEnable(Element elmnt) {
        Element failOverEl = this.mainDocument.createElement("fail-over-enable");
        if (this.failOverEnable == null || this.failOverEnable.equals("") || !this.failOverEnable.equals("on_attribute") && !this.failOverEnable.equals("on_request") && !this.failOverEnable.equals("disable")) {
            this.failOverEnable = "disable";
        }
        failOverEl.setAttribute("mode", this.failOverEnable);
        elmnt.appendChild(failOverEl);
    }

    public String initStartUpMode(Element arg) {
        String res = "";
        if (arg.hasAttribute("mode")) {
            res = arg.getAttribute("mode");
        }
        return res;
    }

    public Hashtable initModules(Element elmnt) {
        Hashtable<String, String> newModules = null;
        NodeList modulesList = elmnt.getChildNodes();
        NodeList elementList = null;
        String key = null;
        String value = null;
        if (modulesList != null) {
            Element module = null;
            Element moduleParts = null;
            int i = 0;
            while (i < modulesList.getLength()) {
                if (modulesList.item(i).getNodeType() == 1 && (module = (Element)modulesList.item(i)) != null && "module".equals(module.getNodeName()) && (elementList = module.getChildNodes()) != null) {
                    key = null;
                    value = null;
                    int j = 0;
                    while (j < elementList.getLength()) {
                        if (elementList.item(j).getNodeType() == 1 && (moduleParts = (Element)elementList.item(j)) != null) {
                            if ("entry-name".equals(moduleParts.getNodeName())) {
                                key = this.getTextValue(moduleParts);
                            } else if ("container-type".equals(moduleParts.getNodeName())) {
                                value = value == null ? "" : value + ";";
                                value = value + this.getTextValue(moduleParts);
                            }
                        }
                        ++j;
                    }
                    if (key != null && value != null) {
                        if (newModules == null) {
                            newModules = new Hashtable<String, String>();
                        }
                        newModules.put(key, value);
                    }
                }
                ++i;
            }
        }
        return newModules;
    }

    private String initFailOverEnable(Element elmnt) throws BaseWrongStructureException {
        String attr = elmnt.getAttribute("mode");
        if (attr != null && !attr.trim().equals("")) {
            if (attr.equals("disable") || attr.equals("on_attribute") || attr.equals("on_request")) {
                return attr;
            }
            throw new BaseWrongStructureException("deploy_5083");
        }
        String value = this.getTextValue(elmnt);
        if (value == null || value.trim().equals("")) {
            return "disable";
        }
        if ("disable".equals(value) || "on_attribute".equals(value) || "on_request".equals(value)) {
            return value;
        }
        throw new BaseWrongStructureException("deploy_5083");
    }

    public String initClasPath(Element elmnt) {
        return this.getTextValue(elmnt);
    }

    public String initProviderName(Element elmnt) throws BaseWrongStructureException {
        String value = this.getTextValue(elmnt);
        if (value.length() == 0) {
            throw new BaseWrongStructureException("deploy_5092");
        }
        return value;
    }

    public ReferenceObject initReference(Element elmnt) throws BaseWrongStructureException {
        NodeList refList = elmnt.getChildNodes();
        String temp = null;
        if (refList != null) {
            ReferenceObject refObj = null;
            int k = 0;
            while (k < refList.getLength()) {
                Element nextEl;
                String nextElTag;
                if (refList.item(k).getNodeType() == 1 && (nextElTag = (nextEl = (Element)refList.item(k)).getNodeName()).equals("reference-target")) {
                    refObj = new ReferenceObject();
                    refObj.setReferenceType(elmnt.getAttribute("reference-type"));
                    String referenceTarget = this.getTextValue(nextEl);
                    if (referenceTarget != null && !referenceTarget.trim().equals("")) {
                        refObj.setReferenceTarget(referenceTarget);
                        refObj.setReferenceTargetType(nextEl.getAttribute("target-type"));
                        if (nextEl.hasAttribute("provider-name") && (temp = nextEl.getAttribute("provider-name")) != null && temp.length() == 0) {
                            throw new BaseWrongStructureException("deploy_5092");
                        }
                        if (temp != null && !temp.trim().equals("")) {
                            refObj.setReferenceProviderName(temp);
                        }
                    }
                }
                ++k;
            }
            return refObj;
        }
        return null;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public void setReferences(ReferenceObject[] refs) {
        if (refs == null || refs.length == 0) {
            this.references = null;
            return;
        }
        this.references = new Vector();
        int i = 0;
        while (i < refs.length) {
            this.references.add(refs[i]);
            ++i;
        }
    }

    public ReferenceObject[] getReferences() {
        if (this.references == null || this.references.size() == 0) {
            return null;
        }
        Object[] refArr = new ReferenceObject[this.references.size()];
        this.references.copyInto(refArr);
        return refArr;
    }

    public Hashtable getModules() {
        return this.modules;
    }

    public void setModules(Hashtable modules) {
        this.modules = modules;
    }

    public void setFailOverValue(String value) {
        this.failOverEnable = value;
    }

    public String getFailOverValue() {
        return this.failOverEnable;
    }

    public String getStartUpMode() {
        return this.startUpMode;
    }

    public void setStartUpMode(String startUpMode) {
        this.startUpMode = startUpMode;
    }

    private Element load(Element el, String value, String tagName) {
        if (value == null) {
            value = new String("");
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private String getTextValue(Element element) {
        if (element == null) {
            return new String();
        }
        Node node = element.getFirstChild();
        if (node != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return new String("");
    }
}

