/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.common;

import com.sap.engine.services.deploy.ear.common.EqualUtils;
import java.io.Serializable;

public class SecurityRoles
implements Serializable {
    static final long serialVersionUID = 5346787443016912540L;
    protected String roleName = "";
    protected String roleDescription = null;
    protected int[] userSIDs = null;
    protected int[] groupSIDs = null;
    protected String[] userNames = null;
    protected String[] userGroups = null;
    protected String serverRoleName = null;

    public SecurityRoles() {
    }

    public SecurityRoles(String name) {
        this.roleName = name;
    }

    public SecurityRoles(String name, String descr) {
        this.roleName = name;
        this.roleDescription = descr;
    }

    public SecurityRoles(String name, int[] uSIDs) {
        this.roleName = name;
        this.userSIDs = uSIDs;
    }

    public SecurityRoles(String name, String description, int[] userSIDs) {
        this.roleName = name;
        this.roleDescription = description;
        this.userSIDs = userSIDs;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String name) {
        this.roleName = name;
    }

    public int[] getUserSIDs() {
        return this.userSIDs;
    }

    public void setUserSIDs(int[] identity) {
        this.userSIDs = identity;
    }

    public int getUserElement(int index) throws ArrayIndexOutOfBoundsException {
        if (this.userSIDs != null && index < this.userSIDs.length && index > -1) {
            return this.userSIDs[index];
        }
        throw new ArrayIndexOutOfBoundsException("Index " + index + " not found.");
    }

    public void setUserSIDsElement(int index, int idElement) {
        if (index < 0) {
            return;
        }
        if (this.userSIDs == null || index >= this.userSIDs.length) {
            int[] newIdentity = new int[index + 1];
            if (this.userSIDs != null) {
                System.arraycopy(this.userSIDs, 0, newIdentity, 0, this.userSIDs.length);
            }
            this.userSIDs = newIdentity;
        }
        this.userSIDs[index] = idElement;
    }

    public void setUserSIDsElement(int idElement) {
        if (this.userSIDs == null || this.userSIDs.length == 0) {
            this.userSIDs = new int[1];
            this.userSIDs[0] = idElement;
        } else {
            int j = 0;
            while (j < this.userSIDs.length) {
                if (idElement == this.userSIDs[j]) {
                    return;
                }
                ++j;
            }
            int[] newIdentity = new int[this.userSIDs.length + 1];
            System.arraycopy(this.userSIDs, 0, newIdentity, 0, this.userSIDs.length);
            newIdentity[this.userSIDs.length] = idElement;
            this.userSIDs = newIdentity;
        }
    }

    public void removeUserSIDs(int idElement) {
        if (this.userSIDs == null || this.userSIDs.length == 0) {
            return;
        }
        int index = -1;
        int j = 0;
        while (j < this.userSIDs.length) {
            if (idElement == this.userSIDs[j]) {
                index = j;
                break;
            }
            ++j;
        }
        if (index == -1) {
            return;
        }
        int[] newIdentity = new int[this.userSIDs.length - 1];
        System.arraycopy(this.userSIDs, 0, newIdentity, 0, index);
        System.arraycopy(this.userSIDs, index + 1, newIdentity, index, this.userSIDs.length - 1 - index);
        this.userSIDs = newIdentity;
    }

    public void removeGroupSIDs(int idElement) {
        if (this.groupSIDs == null || this.groupSIDs.length == 0) {
            return;
        }
        int index = -1;
        int j = 0;
        while (j < this.groupSIDs.length) {
            if (idElement == this.groupSIDs[j]) {
                index = j;
                break;
            }
            ++j;
        }
        if (index == -1) {
            return;
        }
        int[] newIdentity = new int[this.groupSIDs.length - 1];
        System.arraycopy(this.groupSIDs, 0, newIdentity, 0, index);
        System.arraycopy(this.groupSIDs, index + 1, newIdentity, index, this.groupSIDs.length - 1 - index);
        this.groupSIDs = newIdentity;
    }

    public int[] getGroupSIDs() {
        return this.groupSIDs;
    }

    public void setGroupSIDs(int[] identity) {
        this.groupSIDs = identity;
    }

    public int getGroupIdentElement(int index) throws ArrayIndexOutOfBoundsException {
        if (this.groupSIDs != null && index < this.groupSIDs.length && index > -1) {
            return this.groupSIDs[index];
        }
        throw new ArrayIndexOutOfBoundsException("Index " + index + " not found.");
    }

    public void setGroupIdentElement(int index, int idElement) {
        if (index < 0) {
            return;
        }
        if (this.groupSIDs == null || index >= this.groupSIDs.length) {
            int[] newIdentity = new int[index + 1];
            if (this.groupSIDs != null) {
                System.arraycopy(this.groupSIDs, 0, newIdentity, 0, this.groupSIDs.length);
            }
            this.groupSIDs = newIdentity;
        }
        this.groupSIDs[index] = idElement;
    }

    public void setGroupSIDsElement(int idElement) {
        if (this.groupSIDs == null || this.groupSIDs.length == 0) {
            this.groupSIDs = new int[1];
            this.groupSIDs[0] = idElement;
        } else {
            int j = 0;
            while (j < this.groupSIDs.length) {
                if (idElement == this.groupSIDs[j]) {
                    return;
                }
                ++j;
            }
            int[] newIdentity = new int[this.groupSIDs.length + 1];
            System.arraycopy(this.groupSIDs, 0, newIdentity, 0, this.groupSIDs.length);
            newIdentity[this.groupSIDs.length] = idElement;
            this.groupSIDs = newIdentity;
        }
    }

    public String getRoleDescription() {
        return this.roleDescription;
    }

    public void setRoleDescription(String description) {
        this.roleDescription = description;
    }

    public void removeUserNames(String name) {
        if (this.userNames != null && this.userNames.length > 0) {
            int index = -1;
            int j = 0;
            while (j < this.userNames.length) {
                if (this.userNames[j].equals(name)) {
                    index = j;
                    break;
                }
                ++j;
            }
            if (index > -1) {
                String[] newIdentity = new String[this.userNames.length - 1];
                System.arraycopy(this.userNames, 0, newIdentity, 0, index);
                System.arraycopy(this.userNames, index + 1, newIdentity, index, this.userNames.length - 1 - index);
                this.userNames = newIdentity;
            }
        }
    }

    public void removeGroupNames(String name) {
        if (this.userGroups != null && this.userGroups.length > 0) {
            int index = -1;
            int j = 0;
            while (j < this.userGroups.length) {
                if (this.userGroups[j].equals(name)) {
                    index = j;
                    break;
                }
                ++j;
            }
            if (index > -1) {
                String[] newIdentity = new String[this.userGroups.length - 1];
                System.arraycopy(this.userGroups, 0, newIdentity, 0, index);
                System.arraycopy(this.userGroups, index + 1, newIdentity, index, this.userGroups.length - 1 - index);
                this.userGroups = newIdentity;
            }
        }
    }

    public String[] getUserNames() {
        return this.userNames;
    }

    public String[] getUserGroup() {
        return this.userGroups;
    }

    public void setUserName(String name) {
        if (name == null || name.equals("")) {
            return;
        }
        if (this.userNames == null || this.userNames.length == 0) {
            this.userNames = new String[1];
            this.userNames[0] = name;
        } else {
            int j = 0;
            while (j < this.userNames.length) {
                if (name == this.userNames[j]) {
                    return;
                }
                ++j;
            }
            String[] names = new String[this.userNames.length + 1];
            System.arraycopy(this.userNames, 0, names, 0, this.userNames.length);
            names[this.userNames.length] = name;
            this.userNames = names;
        }
        if (this.userNames != null && this.userNames.length > 0) {
            this.serverRoleName = null;
        }
    }

    public void setUserGroup(String group) {
        if (group == null || group.equals("")) {
            return;
        }
        if (this.userGroups == null || this.userGroups.length == 0) {
            this.userGroups = new String[1];
            this.userGroups[0] = group;
        } else {
            int j = 0;
            while (j < this.userGroups.length) {
                if (group == this.userGroups[j]) {
                    return;
                }
                ++j;
            }
            String[] groups = new String[this.userGroups.length + 1];
            System.arraycopy(this.userGroups, 0, groups, 0, this.userGroups.length);
            groups[this.userGroups.length] = group;
            this.userGroups = groups;
        }
        if (this.userGroups != null && this.userGroups.length > 0) {
            this.serverRoleName = null;
        }
    }

    public void setUserGroups(String[] groups) {
        this.userGroups = groups;
        if (this.userGroups != null && this.userGroups.length > 0) {
            this.serverRoleName = null;
        }
    }

    public void setUserNames(String[] names) {
        this.userNames = names;
        if (this.userNames != null && this.userNames.length > 0) {
            this.serverRoleName = null;
        }
    }

    public String getName() {
        return this.getRoleName();
    }

    public String getDescription() {
        return this.getRoleDescription();
    }

    public void addUser(String name) {
        this.setUserName(name);
    }

    public void removeUser(String name) {
        this.removeUserNames(name);
    }

    public String[] getUsers() {
        return this.getUserNames();
    }

    public void setServerRoleName(String name) {
        this.serverRoleName = name;
        if (this.serverRoleName != null && !this.serverRoleName.equals("")) {
            this.userNames = null;
            this.userGroups = null;
        }
    }

    public String getServerRoleName() {
        return this.serverRoleName;
    }

    public boolean simpleEquals(Object secRoles) {
        if (secRoles == null) {
            return false;
        }
        if (secRoles instanceof SecurityRoles) {
            if (!EqualUtils.equalObjects(this.getName(), ((SecurityRoles)secRoles).getName())) {
                return false;
            }
            return EqualUtils.equalObjects(this.getDescription(), ((SecurityRoles)secRoles).getDescription());
        }
        return false;
    }

    public boolean equals(Object secRoles) {
        if (secRoles == null) {
            return false;
        }
        if (!this.simpleEquals(secRoles)) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.serverRoleName, ((SecurityRoles)secRoles).serverRoleName)) {
            return false;
        }
        if (!EqualUtils.equalOrderedArrays(this.getUserNames(), ((SecurityRoles)secRoles).getUserNames())) {
            return false;
        }
        if (!EqualUtils.equalOrderedArrays(this.getUserSIDs(), ((SecurityRoles)secRoles).getUserSIDs())) {
            return false;
        }
        if (!EqualUtils.equalOrderedArrays(this.getUserGroup(), ((SecurityRoles)secRoles).getUserGroup())) {
            return false;
        }
        return EqualUtils.equalOrderedArrays(this.getGroupSIDs(), ((SecurityRoles)secRoles).getGroupSIDs());
    }

    public Object clone() {
        SecurityRoles secRoles = new SecurityRoles(this.roleName);
        if (this.userSIDs != null) {
            secRoles.userSIDs = new int[this.userSIDs.length];
            System.arraycopy(this.userSIDs, 0, secRoles.userSIDs, 0, this.userSIDs.length);
        }
        if (this.groupSIDs != null) {
            secRoles.groupSIDs = new int[this.groupSIDs.length];
            System.arraycopy(this.groupSIDs, 0, secRoles.groupSIDs, 0, this.groupSIDs.length);
        }
        if (this.userGroups != null) {
            secRoles.userGroups = new String[this.userGroups.length];
            System.arraycopy(this.userGroups, 0, secRoles.userGroups, 0, this.userGroups.length);
        }
        if (this.userNames != null) {
            secRoles.userNames = new String[this.userNames.length];
            System.arraycopy(this.userNames, 0, secRoles.userNames, 0, this.userNames.length);
        }
        secRoles.roleDescription = this.roleDescription;
        secRoles.serverRoleName = this.serverRoleName;
        return secRoles;
    }
}

