/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.common;

import com.sap.engine.services.deploy.ear.common.EqualUtils;
import java.io.Serializable;

public class EnvironmentEntry
implements Serializable {
    static final long serialVersionUID = -8738623693437114943L;
    private String entryName;
    private String entryType;
    private Object entryValue;
    private String entryDescription;

    public EnvironmentEntry() {
    }

    public EnvironmentEntry(String name, String type) {
        this.entryName = name;
        this.entryType = type;
    }

    public EnvironmentEntry(String name, String type, Object value) {
        this.entryName = name;
        this.entryType = type;
        this.entryValue = this.checkValue(value);
    }

    public EnvironmentEntry(String name, String type, Object value, String description) {
        this.entryName = name;
        this.entryType = type;
        this.entryValue = this.checkValue(value);
        this.entryDescription = description;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String name) {
        this.entryName = name;
    }

    public String getEntryType() {
        return this.entryType;
    }

    public void setEntryType(String type) {
        this.entryType = type;
    }

    private void setEntryTypeInClone(String type) {
        this.entryType = type;
    }

    public Object getEntryValue() {
        return this.entryValue;
    }

    public void setEntryValue(Object value) {
        this.entryValue = value != null ? this.checkValue(value) : value;
    }

    public String getEntryDescription() {
        return this.entryDescription;
    }

    public void setEntryDescription(String description) {
        this.entryDescription = description;
    }

    private Object checkValue(Object value) {
        if (value instanceof String || value instanceof Integer || value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof Short || value instanceof Long || value instanceof Float || value instanceof Double) {
            return value;
        }
        return null;
    }

    public Object clone() {
        EnvironmentEntry envEntry = new EnvironmentEntry();
        envEntry.setEntryName(this.entryName == null ? null : new String(this.entryName));
        envEntry.setEntryTypeInClone(this.entryType == null ? null : new String(this.entryType));
        if (this.entryValue != null && this.entryType != null) {
            if (this.entryValue.toString().startsWith("${")) {
                envEntry.setEntryValue(this.entryValue.toString());
            } else if (this.entryType.equals("java.lang.Double")) {
                envEntry.setEntryValue(new Double(this.entryValue.toString()));
            } else if (this.entryType.equals("java.lang.Byte")) {
                envEntry.setEntryValue(new Byte(this.entryValue.toString()));
            } else if (this.entryType.equals("java.lang.Short")) {
                envEntry.setEntryValue(new Short(this.entryValue.toString()));
            } else if (this.entryType.equals("java.lang.Integer")) {
                envEntry.setEntryValue(new Integer(this.entryValue.toString()));
            } else if (this.entryType.equals("java.lang.Long")) {
                envEntry.setEntryValue(new Long(this.entryValue.toString()));
            } else if (this.entryType.equals("java.lang.Boolean")) {
                envEntry.setEntryValue(new Boolean(this.entryValue.toString()));
            } else if (this.entryType.equals("java.lang.Float")) {
                envEntry.setEntryValue(new Float(this.entryValue.toString()));
            } else if (this.entryType.equals("java.lang.String")) {
                envEntry.setEntryValue(new String(this.entryValue.toString()));
            } else if (this.entryType.equals("java.lang.Character")) {
                envEntry.setEntryValue(new Character(this.entryValue.toString().charAt(0)));
            }
        } else {
            envEntry.setEntryValue(null);
        }
        envEntry.setEntryDescription(this.entryDescription == null ? null : new String(this.entryDescription));
        return envEntry;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentEntry)) {
            return false;
        }
        EnvironmentEntry envEntry = (EnvironmentEntry)obj;
        if (!EqualUtils.equalObjects(this.entryName, envEntry.getEntryName())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.entryType, envEntry.getEntryType())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.entryValue, envEntry.getEntryValue())) {
            return false;
        }
        return EqualUtils.equalObjects(this.entryDescription, envEntry.getEntryDescription());
    }
}

