/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.common;

import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import java.io.Serializable;

public class ComponentReference
implements Serializable {
    static final long serialVersionUID = -6871072531249887377L;
    public static final int SERVICE = 0;
    public static final int INTERFACE = 1;
    private String name = null;
    private int type = 0;
    private String jndiName = null;
    private String description = null;

    public ComponentReference() {
    }

    public ComponentReference(String compRefName, int compType, String jndi) {
        this.setName(compRefName);
        this.setType(compType);
        this.setJndiName(jndi);
    }

    public void setName(String _name) {
        this.name = _name;
    }

    public String getName() {
        return this.name;
    }

    public void setType(int _type) {
        this.type = _type == 1 ? 1 : 0;
    }

    public void setType(String _type) throws IllegalArgumentException {
        if (_type.equalsIgnoreCase("INTERFACE")) {
            this.type = 1;
        } else if (_type.equalsIgnoreCase("SERVICE")) {
            this.type = 0;
        } else {
            throw new BaseIllegalArgumentException("deploy_2014", new String[]{_type});
        }
    }

    public int getType() {
        return this.type;
    }

    public void setJndiName(String jndi) {
        this.jndiName = jndi;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentReference)) {
            return false;
        }
        ComponentReference ref = (ComponentReference)obj;
        if (this.name != null ? !this.name.equals(ref.name) : ref.name != null) {
            return false;
        }
        if (this.type != ref.type) {
            return false;
        }
        if (this.jndiName != null ? !this.jndiName.equals(ref.jndiName) : ref.jndiName != null) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(ref.description) : ref.description != null);
    }

    public Object clone() {
        ComponentReference cloning = new ComponentReference();
        cloning.name = this.name == null ? null : new String(this.name);
        cloning.type = this.type;
        cloning.jndiName = this.jndiName == null ? null : new String(this.jndiName);
        cloning.description = this.description == null ? null : new String(this.description);
        return cloning;
    }

    public String toString() {
        return "Server Component Reference [name: " + this.name + "; type: " + (this.type == 1 ? "Interface" : "Service") + "; jndi: " + this.jndiName + "; description: " + this.description + "]";
    }
}

