/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ReferenceObjectIntf;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.common.CloneUtils;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import java.util.Hashtable;
import java.util.Vector;

public class SimpleEarDescriptor
extends AdditionalAppInfo {
    protected String description = null;
    protected String displayName = null;
    protected SerializableFile smallIcon = null;
    protected SerializableFile largeIcon = null;
    protected SecurityRoles[] roles = null;
    protected J2EEModule[] modules = null;
    protected Hashtable archiveTable = null;
    protected Hashtable componentTable = null;
    protected ReferenceObjectIntf[] references = null;
    protected String classPath = null;
    protected String providerName = "sap.com";
    protected Hashtable additionalModules = null;

    public SimpleEarDescriptor() {
    }

    public SimpleEarDescriptor(String displayName) {
        this.displayName = displayName;
    }

    public J2EEModule[] getModules() {
        return this.modules;
    }

    public void setModules(J2EEModule[] modules) {
        this.modules = modules;
    }

    public Hashtable getAdditionalModules() {
        return this.additionalModules;
    }

    public void setAdditionalModules(Hashtable additionalModules) {
        this.additionalModules = additionalModules;
    }

    public ReferenceObjectIntf[] getReferences() {
        return this.references;
    }

    public void setReferences(ReferenceObjectIntf[] references) {
        this.references = references;
    }

    public ReferenceObjectIntf getReference(int number) {
        if (this.references != null && number < this.references.length && number > -1) {
            return this.references[number];
        }
        return null;
    }

    public void setReference(int number, ReferenceObjectIntf reference) {
        if (this.references == null || number >= this.references.length) {
            ReferenceObjectIntf[] newReferences = new ReferenceObjectIntf[number + 1];
            if (this.references != null) {
                int j = 0;
                while (j < this.references.length) {
                    newReferences[j] = this.references[j];
                    ++j;
                }
            }
            this.references = newReferences;
        }
        this.references[number] = reference;
    }

    public SecurityRoles[] getRoles() {
        return this.roles;
    }

    public void setRoles(SecurityRoles[] roles) {
        this.roles = roles;
    }

    public J2EEModule[] getServices() {
        Object[] services = null;
        Vector<J2EEModule> serviceElements = new Vector<J2EEModule>();
        if (this.modules == null) {
            return null;
        }
        int i = 0;
        while (i < this.modules.length) {
            if (this.modules[i] != null && this.modules[i].getType() == 2) {
                serviceElements.add(this.modules[i]);
            }
            ++i;
        }
        if (serviceElements.size() == 0) {
            return null;
        }
        services = new J2EEModule[serviceElements.size()];
        serviceElements.copyInto(services);
        return services;
    }

    public J2EEModule[] getEJBs() {
        Object[] ejbs = null;
        Vector<J2EEModule> ejbElements = new Vector<J2EEModule>();
        if (this.modules == null) {
            return null;
        }
        int i = 0;
        while (i < this.modules.length) {
            if (this.modules[i] != null && this.modules[i].getType() == 1) {
                ejbElements.add(this.modules[i]);
            }
            ++i;
        }
        if (ejbElements.size() == 0) {
            return null;
        }
        ejbs = new J2EEModule[ejbElements.size()];
        ejbElements.copyInto(ejbs);
        return ejbs;
    }

    public J2EEModule[] getAdapters() {
        Object[] adapters = null;
        Vector<J2EEModule> adapterElements = new Vector<J2EEModule>();
        if (this.modules == null) {
            return null;
        }
        int i = 0;
        while (i < this.modules.length) {
            if (this.modules[i] != null && this.modules[i].getType() == 5) {
                adapterElements.add(this.modules[i]);
            }
            ++i;
        }
        if (adapterElements.size() == 0) {
            return null;
        }
        adapters = new J2EEModule[adapterElements.size()];
        adapterElements.copyInto(adapters);
        return adapters;
    }

    public J2EEModule[] getWEBs() {
        Object[] webs = null;
        Vector<J2EEModule> webElements = new Vector<J2EEModule>();
        if (this.modules == null) {
            return null;
        }
        int i = 0;
        while (i < this.modules.length) {
            if (this.modules[i] != null && this.modules[i].getType() == 4) {
                webElements.add(this.modules[i]);
            }
            ++i;
        }
        if (webElements.size() == 0) {
            return null;
        }
        webs = new J2EEModule[webElements.size()];
        webElements.copyInto(webs);
        return webs;
    }

    public J2EEModule[] getClients() {
        Object[] clients = null;
        Vector<J2EEModule> clientElements = new Vector<J2EEModule>();
        if (this.modules == null) {
            return null;
        }
        int i = 0;
        while (i < this.modules.length) {
            if (this.modules[i] != null && this.modules[i].getType() == 3) {
                clientElements.add(this.modules[i]);
            }
            ++i;
        }
        if (clientElements.size() == 0) {
            return null;
        }
        clients = new J2EEModule[clientElements.size()];
        clientElements.copyInto(clients);
        return clients;
    }

    public J2EEModule[] getConnectors() {
        Object[] conecotrs = null;
        Vector<J2EEModule> connectorElements = new Vector<J2EEModule>();
        if (this.modules == null) {
            return null;
        }
        int i = 0;
        while (i < this.modules.length) {
            if (this.modules[i] != null && this.modules[i].getType() == 5) {
                connectorElements.add(this.modules[i]);
            }
            ++i;
        }
        if (connectorElements.size() == 0) {
            return null;
        }
        conecotrs = new J2EEModule[connectorElements.size()];
        connectorElements.copyInto(conecotrs);
        return conecotrs;
    }

    public J2EEModule[] getOthers() {
        Object[] others = null;
        Vector<J2EEModule> otherElements = new Vector<J2EEModule>();
        if (this.modules == null) {
            return null;
        }
        int i = 0;
        while (i < this.modules.length) {
            if (this.modules[i] != null && this.modules[i].getType() == 0) {
                otherElements.add(this.modules[i]);
            }
            ++i;
        }
        if (otherElements.size() == 0) {
            return null;
        }
        others = new J2EEModule[otherElements.size()];
        otherElements.copyInto(others);
        return others;
    }

    public boolean isExtended() {
        return this.getServices() != null || this.getOthers() != null;
    }

    public void replaceModules(J2EEModule[] newModules) {
        if (newModules != null && this.modules != null) {
            int i = 0;
            while (i < this.modules.length) {
                int j = 0;
                while (j < newModules.length) {
                    if (this.modules[i] != null && newModules[j] != null && this.modules[i].getUri() != null && this.modules[i].getUri().equals(newModules[j].getUri())) {
                        this.modules[i] = newModules[j];
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void addModule(J2EEModule module) {
        if (module == null || module.getUri() == null) {
            return;
        }
        if (this.modules != null) {
            int i = 0;
            while (i < this.modules.length) {
                if (module.getUri().equals(this.modules[i].getUri())) {
                    return;
                }
                ++i;
            }
        } else {
            this.modules = new J2EEModule[1];
            this.modules[0] = module;
            return;
        }
        J2EEModule[] newModules = new J2EEModule[this.modules.length + 1];
        System.arraycopy(this.modules, 0, newModules, 0, this.modules.length);
        newModules[this.modules.length] = module;
        this.modules = newModules;
    }

    public void removeModule(J2EEModule module) {
        if (module == null || module.getUri() == null) {
            return;
        }
        int index = -1;
        if (this.modules != null) {
            int i = 0;
            while (i < this.modules.length) {
                if (module.getUri().equals(this.modules[i].getUri())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index > -1) {
            J2EEModule[] newModules = new J2EEModule[this.modules.length - 1];
            System.arraycopy(this.modules, 0, newModules, 0, index);
            System.arraycopy(this.modules, index + 1, newModules, index, newModules.length - 1 - index);
            this.modules = newModules;
        }
    }

    public void removeModule(String uri) {
        int index = -1;
        if (this.modules != null) {
            int i = 0;
            while (i < this.modules.length) {
                if (uri.equals(this.modules[i].getUri())) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        if (index > -1) {
            J2EEModule[] newModules = new J2EEModule[this.modules.length - 1];
            System.arraycopy(this.modules, 0, newModules, 0, index);
            System.arraycopy(this.modules, index + 1, newModules, index, this.modules.length - 1 - index);
            this.modules = newModules;
        }
    }

    public Hashtable getArchiveTable() {
        return this.archiveTable;
    }

    public void setArchiveTable(Hashtable archiveTable1) {
        this.archiveTable = archiveTable1;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public void setSmallIconName(String icon) {
        this.smallIcon = new SerializableFile(icon);
    }

    public void setLargeIconName(String icon) {
        this.largeIcon = new SerializableFile(icon);
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getSmallIconName() {
        if (this.smallIcon != null) {
            return this.smallIcon.getFileName();
        }
        return null;
    }

    public String getLargeIconName() {
        if (this.largeIcon != null) {
            return this.largeIcon.getFileName();
        }
        return null;
    }

    public SerializableFile getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(SerializableFile smallIcon) {
        this.smallIcon = smallIcon;
    }

    public SerializableFile getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(SerializableFile largeIcon) {
        this.largeIcon = largeIcon;
    }

    public void initModules() {
        this.modules = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleEarDescriptor)) {
            return false;
        }
        SimpleEarDescriptor earD = (SimpleEarDescriptor)obj;
        if (!EqualUtils.equalObjects(earD.description, this.description)) {
            return false;
        }
        if (!EqualUtils.equalObjects(earD.displayName, this.displayName)) {
            return false;
        }
        if (!EqualUtils.equalObjects(earD.smallIcon, this.smallIcon)) {
            return false;
        }
        if (!EqualUtils.equalObjects(earD.largeIcon, this.largeIcon)) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(earD.getRoles(), this.getRoles())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(earD.getModules(), this.getModules())) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.getReferences(), earD.getReferences())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.getClassPath(), earD.getClassPath())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.getProviderName(), earD.getProviderName())) {
            return false;
        }
        if (!EqualUtils.equalHashtable(this.getAdditionalModules(), earD.getAdditionalModules())) {
            return false;
        }
        return !EqualUtils.equalObjects(this.getFailOverValue(), earD.getFailOverValue());
    }

    public Object clone() {
        SimpleEarDescriptor descr = new SimpleEarDescriptor();
        descr.description = this.description;
        descr.displayName = this.displayName;
        if (this.smallIcon != null) {
            descr.smallIcon = (SerializableFile)this.smallIcon.clone();
        }
        if (this.largeIcon != null) {
            descr.largeIcon = (SerializableFile)this.largeIcon.clone();
        }
        if (this.roles != null) {
            descr.roles = new SecurityRoles[this.roles.length];
            System.arraycopy(this.roles, 0, descr.roles, 0, this.roles.length);
        }
        if (this.modules != null) {
            descr.modules = new J2EEModule[this.modules.length];
            System.arraycopy(this.modules, 0, descr.modules, 0, this.modules.length);
        }
        if (this.references != null && this.references.length != 0) {
            descr.setReferences(new ReferenceObjectIntf[this.references.length]);
            int i = 0;
            while (i < this.references.length) {
                if (this.references[i] != null) {
                    descr.setReference(i, this.references[i]);
                }
                ++i;
            }
        }
        descr.setClassPath(this.classPath != null ? new String(this.classPath) : null);
        descr.setProviderName(this.providerName != null ? new String(this.providerName) : null);
        if (this.additionalModules != null) {
            descr.setAdditionalModules(CloneUtils.cloneStrStrHashtable(this.getAdditionalModules()));
        }
        descr.setFailOverValue(this.failOverValue);
        return descr;
    }

    public Hashtable getCompTable() {
        return this.componentTable;
    }

    public void setCompTable(Hashtable compTable) {
        this.componentTable = compTable;
    }

    public String getApplicationID() {
        String id = "";
        String pName = this.getProviderName();
        id = pName == null || pName.trim().equals("") ? "sap.com" : pName;
        id = id + "/" + this.getDisplayName();
        return id;
    }
}

