/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.converter;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.JarExtractor;
import com.sap.engine.lib.jar.JarHandler;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.exceptions.BaseEarException;
import com.sap.engine.services.deploy.exceptions.BaseIOException;
import com.sap.engine.services.deploy.exceptions.BaseWrongStructureException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public abstract class J2EEConverter {
    protected String[] fileNames;
    protected String[] altDDs;
    protected String tempDir;
    protected ClassLoader parent = null;
    protected ClassLoader loader = null;
    protected JarHandler handler = new JarHandler();
    protected Vector warnings = new Vector();
    protected StandardDOMParser domParser = null;
    private TransformerFactory factory = null;

    public J2EEConverter() {
        this.initXMLToolkit();
    }

    public J2EEConverter(String[] files) {
        this.fileNames = files;
        this.altDDs = null;
        this.initXMLToolkit();
    }

    public abstract ArchiveDescriptor readXML(String var1) throws BaseWrongStructureException, BaseEarException, BaseIOException, DeploymentException;

    public abstract void applyChanges(ArchiveDescriptor var1);

    public abstract void storeXMLs(ArchiveDescriptor var1, String var2, String var3) throws BaseIOException, DeploymentException;

    public abstract void convertArchive(String var1) throws BaseWrongStructureException, BaseEarException, BaseIOException, DeploymentException;

    public abstract void convert() throws BaseWrongStructureException, BaseEarException, BaseIOException, DeploymentException;

    public ClassLoader getParent() {
        return this.parent;
    }

    public void setParent(ClassLoader parent) {
        this.parent = parent;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public void setFileNames(String[] fileNames) {
        this.fileNames = fileNames;
    }

    public String[] getAltDDs() {
        return this.altDDs;
    }

    public void setAltDDs(String[] altDDs) {
        this.altDDs = altDDs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] extractEntries(String jarName, String[] entries, String outputDir) throws BaseIOException {
        String[] res = new String[entries.length];
        JarFile zip = null;
        try {
            try {
                zip = new JarFile(jarName);
                File dir = new File(outputDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                Enumeration<JarEntry> enumeration = zip.entries();
                String entryName = null;
                JarEntry theEntry = null;
                int count = 0;
                while (enumeration.hasMoreElements()) {
                    theEntry = enumeration.nextElement();
                    entryName = theEntry.getName().toLowerCase();
                    int i = 0;
                    while (i < entries.length) {
                        if (entryName.equals(entries[i].toLowerCase())) {
                            res[i] = outputDir + File.separator + theEntry.getName();
                            new JarExtractor().extractFile(zip, theEntry.getName(), outputDir);
                            ++count;
                            break;
                        }
                        ++i;
                    }
                    if (count != entries.length) continue;
                    break;
                }
            }
            catch (IOException ioe) {
                throw new BaseIOException("deploy_4408", new String[]{jarName}, (Throwable)ioe);
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                zip.close();
                throw throwable;
            }
            catch (IOException ioex) {
                throw new BaseIOException("deploy_4407", new String[]{jarName}, (Throwable)ioex);
            }
        }
        try {}
        catch (IOException ioex) {
            throw new BaseIOException("deploy_4407", new String[]{jarName}, (Throwable)ioex);
        }
        zip.close();
        return res;
    }

    public String extractEntries(String jarName, String entries, String outputDir) throws BaseIOException {
        return this.extractEntries(jarName, new String[]{entries}, outputDir)[0];
    }

    public void updateJarFile(String oldJar, File directory, Vector filters) throws BaseIOException {
        JarFile oldZip = null;
        int count = 0;
        Vector<String> nEntry = new Vector<String>();
        Vector<JarEntry> oEntry = new Vector<JarEntry>();
        JarHandler handler = new JarHandler();
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        JarOutputStream zip = null;
        String constJar = ".jar";
        String temp_name = SystemProperties.getProperty("user.dir") + File.separator + "temporary";
        File tmp = null;
        Vector allFiles = new Vector();
        handler.listDir(directory.getAbsolutePath(), allFiles);
        tmp = new File(temp_name + constJar);
        while (tmp.exists()) {
            tmp = new File(temp_name + count++ + constJar);
        }
        try {
            if (oldJar != null) {
                oldZip = new JarFile(oldJar);
            }
            if (oldZip != null) {
                Enumeration<JarEntry> oldEntries = oldZip.entries();
                int i = 0;
                while (i < allFiles.size()) {
                    nEntry.add(((InfoObject)allFiles.elementAt(i)).getEntryName());
                    ++i;
                }
                while (oldEntries.hasMoreElements()) {
                    oEntry.addElement(oldEntries.nextElement());
                }
                fos = new FileOutputStream(tmp);
                bos = new BufferedOutputStream(fos);
                zip = new JarOutputStream(bos);
                zip.setMethod(0);
                JarEntry tempEntry = null;
                boolean found = false;
                int i2 = 0;
                while (i2 < oEntry.size()) {
                    tempEntry = (JarEntry)oEntry.elementAt(i2);
                    found = false;
                    int k = 0;
                    while (k < nEntry.size()) {
                        if (((String)nEntry.elementAt(k)).toLowerCase().equals(tempEntry.getName().toLowerCase())) {
                            found = true;
                            break;
                        }
                        ++k;
                    }
                    if (!found) {
                        handler.writeEntry(zip, new BufferedInputStream(oldZip.getInputStream(tempEntry)), (int)tempEntry.getSize(), this.checkEntryName(tempEntry.getName()));
                    }
                    ++i2;
                }
                InfoObject info = null;
                InputStream in = null;
                if (filters != null && !filters.isEmpty()) {
                    int j = 0;
                    while (j < allFiles.size()) {
                        info = (InfoObject)allFiles.elementAt(j);
                        int ind = 0;
                        while (ind < filters.size()) {
                            if (info.getEntryName().endsWith((String)filters.elementAt(ind))) {
                                tempEntry = new JarEntry(info.getEntryName());
                                in = new FileInputStream(info.getFilePath());
                                handler.writeEntry(zip, new BufferedInputStream(in), in.available(), this.checkEntryName(tempEntry.getName()));
                                break;
                            }
                            ++ind;
                        }
                        ++j;
                    }
                    in.close();
                } else {
                    int j = 0;
                    while (j < allFiles.size()) {
                        info = (InfoObject)allFiles.elementAt(j);
                        tempEntry = new JarEntry(info.getEntryName());
                        in = new FileInputStream(info.getFilePath());
                        handler.writeEntry(zip, new BufferedInputStream(in), in.available(), this.checkEntryName(tempEntry.getName()));
                        in.close();
                        ++j;
                    }
                }
                oldZip.close();
                ((FilterOutputStream)zip).flush();
                zip.finish();
                zip.close();
                bos.flush();
                bos.close();
                fos.flush();
                fos.close();
                handler.transferFile(tmp, oldJar);
            }
        }
        catch (IOException ioe) {
            throw new BaseIOException("deploy_4409", new String[]{oldJar}, (Throwable)ioe);
        }
        tmp.delete();
    }

    public Vector getWarnings() {
        return this.warnings;
    }

    public void setWarnings(Vector warnings) {
        this.warnings = warnings;
    }

    public void addWarning(String warning) {
        if (this.warnings == null) {
            this.warnings = new Vector();
        }
        this.warnings.add(warning);
    }

    private String checkEntryName(String entryName) {
        if (entryName.toUpperCase().startsWith("WEB-INF")) {
            return "WEB-INF" + entryName.substring("WEB-INF".length());
        }
        return entryName;
    }

    protected int getArchiveIndex(String jarName) {
        int index = -1;
        if (this.fileNames != null && jarName != null) {
            int i = 0;
            while (i < this.fileNames.length) {
                if (jarName.equals(this.fileNames[i])) {
                    index = i;
                    break;
                }
                ++i;
            }
        }
        return index;
    }

    protected void initXMLToolkit() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.domParser = new StandardDOMParser();
        Thread.currentThread().setContextClassLoader(cl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void convertXml(String outputDir, String inXml, String outXml, String xsl, String jarName, boolean web) throws BaseIOException {
        FileOutputStream fos;
        block11: {
            InputStream xslStream = null;
            fos = null;
            try {
                try {
                    xslStream = this.getClass().getClassLoader().getResourceAsStream(xsl);
                    Transformer transformer = this.getTransformerFactory().newTransformer(new StreamSource(xslStream));
                    fos = web ? new FileOutputStream(outputDir + File.separator + "WEB-INF" + File.separator + outXml) : new FileOutputStream(outputDir + File.separator + "META-INF" + File.separator + outXml);
                    Document doc = this.domParser.parse(inXml);
                    transformer.transform(new DOMSource(doc), new StreamResult(fos));
                }
                catch (Exception exc) {
                    throw new BaseIOException("deploy_4411", new String[]{inXml, jarName}, (Throwable)exc);
                }
                Object var12_12 = null;
                if (xslStream == null) break block11;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (xslStream != null) {
                    try {
                        xslStream.close();
                    }
                    catch (IOException ioexc) {
                        throw new BaseIOException("deploy_4410", new String[]{xsl}, (Throwable)ioexc);
                    }
                }
                if (fos == null) throw throwable;
                try {
                    fos.close();
                    throw throwable;
                }
                catch (IOException ioexc) {
                    throw new BaseIOException("deploy_4410", new String[]{outXml}, (Throwable)ioexc);
                }
            }
            try {}
            catch (IOException ioexc) {
                throw new BaseIOException("deploy_4410", new String[]{xsl}, (Throwable)ioexc);
            }
            xslStream.close();
        }
        if (fos == null) return;
        try {}
        catch (IOException ioexc) {
            throw new BaseIOException("deploy_4410", new String[]{outXml}, (Throwable)ioexc);
        }
        fos.close();
    }

    private TransformerFactory getTransformerFactory() {
        if (this.factory == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.factory = TransformerFactory.newInstance();
            Thread.currentThread().setContextClassLoader(cl);
        }
        return this.factory;
    }
}

