/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.converter;

import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.converter.EJBJarDocument;
import com.sap.engine.services.deploy.converter.J2EEConverter;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.exceptions.BaseEarException;
import com.sap.engine.services.deploy.exceptions.BaseIOException;
import com.sap.engine.services.deploy.exceptions.BaseWrongStructureException;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.SAXException;

public class EJBConverter
extends J2EEConverter {
    public EJBConverter() {
    }

    public EJBConverter(String[] files) {
        super(files);
    }

    public ArchiveDescriptor readXML(String xmlName) throws BaseWrongStructureException, BaseEarException, BaseIOException, DeploymentException {
        return null;
    }

    public ArchiveDescriptor parseDocument(Document doc) throws BaseWrongStructureException, BaseEarException {
        EJBJarDocument ejbjarParser = new EJBJarDocument();
        ejbjarParser.setLoader(this.loader);
        EJBJarDescriptor descr = ejbjarParser.loadEJBJarDescriptor(doc);
        this.warnings.addAll(ejbjarParser.getWarnings());
        return descr;
    }

    public void applyChanges(ArchiveDescriptor descr) {
    }

    public void storeXMLs(ArchiveDescriptor archDescr1, String dirName, String altDD) throws BaseIOException, DeploymentException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void convertArchive(String jarName) throws BaseWrongStructureException, BaseEarException, BaseIOException, DeploymentException {
        String outputDir;
        block17: {
            block18: {
                outputDir = this.tempDir + File.separator + System.currentTimeMillis();
                try {
                    Vector<String> filters;
                    String storageXml;
                    block20: {
                        String[] xmls = this.extractEntries(jarName, new String[]{"META-INF/ejb-jar.xml", "META-INF/persistent.xml", "META-INF/storage.xml"}, outputDir);
                        int index = this.getArchiveIndex(jarName);
                        storageXml = xmls[2];
                        if (xmls == null || xmls[0] == null || xmls[1] != null) break block17;
                        if (!this.isForConvert(xmls[0])) {
                            if (storageXml != null) {
                                this.convertXml(outputDir, storageXml, "persistent.xml", "com/sap/engine/services/deploy/converter/xsl/persistent.xsl", jarName, false);
                            }
                            Object var15_6 = null;
                            break block18;
                        }
                        this.convertXml(outputDir, xmls[0], "new-ejb-jar.xml", "com/sap/engine/services/deploy/converter/xsl/ejbjar.xsl", jarName, false);
                        this.convertXml(outputDir, xmls[0], "ejb-j2ee-engine.xml", "com/sap/engine/services/deploy/converter/xsl/ejbj2eeengine.xsl", jarName, false);
                        filters = new Vector<String>();
                        File addXML = new File(outputDir + File.separator + "META-INF" + File.separator + "ejb-j2ee-engine.xml");
                        if (addXML.exists()) {
                            BufferedReader reader = null;
                            try {
                                try {
                                    reader = new BufferedReader(new InputStreamReader(new FileInputStream(addXML)));
                                    boolean isFileEmpty = true;
                                    String fileText = reader.readLine();
                                    while (fileText != null) {
                                        if (!fileText.trim().equals("")) {
                                            isFileEmpty = false;
                                            break;
                                        }
                                        fileText = reader.readLine();
                                    }
                                    if (isFileEmpty) {
                                        filters.add("ejb-jar.xml");
                                    } else {
                                        filters.add(".xml");
                                    }
                                }
                                catch (IOException ioexc) {
                                    throw new BaseIOException("deploy_4413", ioexc);
                                }
                                Object var12_15 = null;
                                if (reader == null) break block20;
                            }
                            catch (Throwable throwable) {
                                Object var12_16 = null;
                                if (reader == null) throw throwable;
                                try {
                                    reader.close();
                                    throw throwable;
                                }
                                catch (IOException io) {
                                    throw new BaseIOException("deploy_4410", new String[]{"ejb-j2ee-engine.xml"}, (Throwable)io);
                                }
                            }
                            try {}
                            catch (IOException io) {
                                throw new BaseIOException("deploy_4410", new String[]{"ejb-j2ee-engine.xml"}, (Throwable)io);
                            }
                            reader.close();
                        }
                    }
                    new File(outputDir + File.separator + "META-INF" + File.separator + "ejb-jar.xml").delete();
                    new File(outputDir + File.separator + "META-INF" + File.separator + "new-ejb-jar.xml").renameTo(new File(outputDir + File.separator + "META-INF" + File.separator + "ejb-jar.xml"));
                    if (storageXml != null) {
                        this.convertXml(outputDir, storageXml, "persistent.xml", "com/sap/engine/services/deploy/converter/xsl/persistent.xsl", jarName, false);
                    }
                    this.updateJarFile(jarName, new File(outputDir), filters);
                    break block17;
                }
                catch (Throwable throwable) {
                    Object var15_8 = null;
                    FileUtils.deleteDirectory(new File(outputDir));
                    throw throwable;
                }
            }
            FileUtils.deleteDirectory(new File(outputDir));
            return;
        }
        Object var15_7 = null;
        FileUtils.deleteDirectory(new File(outputDir));
    }

    public void convert() throws BaseWrongStructureException, BaseEarException, BaseIOException, DeploymentException {
        if (this.fileNames != null) {
            int i = 0;
            while (i < this.fileNames.length) {
                this.convertArchive(this.fileNames[i]);
                ++i;
            }
        }
    }

    private boolean isForConvert(String xmlName) throws BaseIOException {
        try {
            String newDtd;
            Document document = this.domParser.parse(xmlName);
            DocumentType dt = document.getDoctype();
            if (dt != null && ((newDtd = dt.getSystemId()) == null || "<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>".equals(newDtd) || EJBJarDocument.simpleDTD.equals(newDtd))) {
                return true;
            }
        }
        catch (IOException ioe) {
            throw new BaseIOException("deploy_4404", new String[]{xmlName}, (Throwable)ioe);
        }
        catch (SAXException saxe) {
            throw new BaseIOException("deploy_4404", new String[]{xmlName}, (Throwable)saxe);
        }
        return false;
    }
}

