/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.converter;

import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.appclient.descriptor.xml.J2EEApplicationAdditionalDocument;
import com.sap.engine.services.appclient.descriptor.xml.J2EEApplicationDocument;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.converter.ApplicationDocument;
import com.sap.engine.services.deploy.converter.J2EEConverter;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.exceptions.BaseIOException;
import com.sap.engine.services.deploy.exceptions.BaseWrongStructureException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;
import org.w3c.dom.Document;

public class ApplicationClientConverter
extends J2EEConverter {
    public ApplicationClientConverter() {
    }

    public ApplicationClientConverter(String[] files) {
        super(files);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArchiveDescriptor readXML(String xmlName) throws BaseWrongStructureException, BaseIOException, DeploymentException {
        ApplicationDocument parser = new ApplicationDocument();
        ApplicationClientDescriptor result = null;
        BufferedInputStream bStream = null;
        try {
            try {
                bStream = new BufferedInputStream(new FileInputStream(xmlName));
                result = parser.parseXml(bStream, xmlName);
            }
            catch (FileNotFoundException fnfe) {
                throw new BaseIOException("deploy_4401", new String[]{xmlName}, (Throwable)fnfe);
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            try {
                bStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new BaseIOException("deploy_4410", new String[]{xmlName}, (Throwable)ioe);
            }
        }
        try {}
        catch (IOException ioe) {
            throw new BaseIOException("deploy_4410", new String[]{xmlName}, (Throwable)ioe);
        }
        bStream.close();
        return result;
    }

    public void applyChanges(ArchiveDescriptor descr) {
    }

    public void storeXMLs(ArchiveDescriptor archDescr1, String dirName, String altDD) throws BaseIOException {
        ApplicationClientDescriptor archDescr = (ApplicationClientDescriptor)archDescr1;
        if (dirName == null) {
            dirName = ".";
        }
        File jarDir = new File(dirName);
        jarDir.mkdirs();
        String filePath = null;
        Document doc = null;
        StandardDOMWriter domWriter = new StandardDOMWriter();
        try {
            J2EEApplicationDocument document4 = new J2EEApplicationDocument();
            J2EEApplicationAdditionalDocument document5 = new J2EEApplicationAdditionalDocument();
            new File(jarDir.getAbsolutePath() + File.separator + "META-INF" + File.separator).mkdirs();
            filePath = altDD == null ? jarDir.getAbsolutePath() + File.separator + "META-INF" + File.separator + "application-client.xml" : altDD;
            doc = document4.loadDocument(archDescr);
            if (doc != null) {
                domWriter.write(doc, filePath, "<!DOCTYPE application-client [\n<!ELEMENT application-client (icon?, display-name, description?, env-entry*, ejb-ref*, resource-ref*, resource-env-ref*, callback-handler?)>\n<!ELEMENT icon (small-icon?, large-icon?)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-sharing-scope?)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-sharing-scope (#PCDATA)>\n<!ELEMENT resource-env-ref (description?, resource-env-ref-name, resource-env-ref-type)>\n<!ELEMENT resource-env-ref-name (#PCDATA)>\n<!ELEMENT resource-env-ref-type (#PCDATA)>\n<!ELEMENT callback-handler (#PCDATA)>\n<!ATTLIST application-client id ID #IMPLIED>\n<!ATTLIST callback-handler id ID #IMPLIED>\n<!ATTLIST description id ID #IMPLIED>\n<!ATTLIST display-name id ID #IMPLIED>\n<!ATTLIST ejb-link id ID #IMPLIED>\n<!ATTLIST ejb-ref id ID #IMPLIED>\n<!ATTLIST ejb-ref-name id ID #IMPLIED>\n<!ATTLIST ejb-ref-type id ID #IMPLIED>\n<!ATTLIST env-entry id ID #IMPLIED>\n<!ATTLIST env-entry-name id ID #IMPLIED>\n<!ATTLIST env-entry-type id ID #IMPLIED>\n<!ATTLIST env-entry-value id ID #IMPLIED>\n<!ATTLIST home id ID #IMPLIED>\n<!ATTLIST icon id ID #IMPLIED>\n<!ATTLIST large-icon id ID #IMPLIED>\n<!ATTLIST remote id ID #IMPLIED>\n<!ATTLIST res-auth id ID #IMPLIED>\n<!ATTLIST res-ref-name id ID #IMPLIED>\n<!ATTLIST res-sharing-scope id ID #IMPLIED>\n<!ATTLIST res-type id ID #IMPLIED>\n<!ATTLIST resource-env-ref id ID #IMPLIED>\n<!ATTLIST resource-env-ref-name id ID #IMPLIED>\n<!ATTLIST resource-env-ref-type id ID #IMPLIED>\n<!ATTLIST resource-ref id ID #IMPLIED>\n<!ATTLIST small-icon id ID #IMPLIED> \n]>", "UTF-8");
            }
            filePath = jarDir.getAbsolutePath() + File.separator + "META-INF" + File.separator + "application-client-additional.xml";
            doc = document5.loadClientAdditionalElements(archDescr);
            if (doc != null && document5.toSave) {
                domWriter.write(doc, filePath, "<!DOCTYPE appclient-j2ee-engine SYSTEM 'appclient-j2ee-engine.dtd'>", "UTF-8");
            }
        }
        catch (IOException ioe) {
            throw new BaseIOException("deploy_4403", new String[]{"appclication client"}, (Throwable)ioe);
        }
    }

    public void convertArchive(String warName) throws BaseWrongStructureException, BaseIOException, DeploymentException {
        ApplicationClientDescriptor result = null;
        Object altDDStream = null;
        String outputDir = this.tempDir + File.separator + System.currentTimeMillis();
        String xmls = this.extractEntries(warName, "meta-inf/application-client.xml", outputDir);
        int index = this.getArchiveIndex(warName);
        if (xmls != null && (result = this.altDDs[index] == null ? (ApplicationClientDescriptor)this.readXML(xmls) : (ApplicationClientDescriptor)this.readXML(this.altDDs[index])) != null) {
            this.applyChanges(result);
            String dirName = this.tempDir + File.separator + System.currentTimeMillis();
            File dir = new File(dirName);
            dir.mkdirs();
            this.storeXMLs(result, dirName, this.altDDs[index]);
            Vector<String> filters = new Vector<String>();
            filters.add(".xml");
            this.updateJarFile(warName, dir, filters);
            FileUtils.deleteDirectory(new File(dirName));
        }
        FileUtils.deleteDirectory(new File(outputDir));
    }

    public void convert() throws BaseWrongStructureException, BaseIOException, DeploymentException {
        if (this.fileNames != null) {
            int i = 0;
            while (i < this.fileNames.length) {
                this.convertArchive(this.fileNames[i]);
                ++i;
            }
        }
    }
}

