/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.container;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.deploy.container.ExportDescriptor;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.ear.common.ContextParam;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExportDocument {
    public static final String dtd = "<!DOCTYPE application-status [\n<!ELEMENT application-status (application-name, component+)>\n<!ELEMENT application-name (#PCDATA)>\n<!ELEMENT component (component-name, additional-info?)>\n<!ELEMENT component-name (#PCDATA)>\n<!ATTLIST component-name Type (web|ejb|client) #REQUIRED>\n<!ELEMENT additional-info (ejb-ref*, res-ref*, entry*, context-param*, user-role-mapping, dbpool-name?)>\n<!ELEMENT entry (entry-name, entry-type, value, description?)>\n<!ELEMENT entry-name (#PCDATA)>\n<!ELEMENT entry-type (#PCDATA)>\n<!ELEMENT value (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT res-ref (ref-name, ref-link, description?)>\n<!ELEMENT ref-name (#PCDATA)>\n<!ELEMENT ref-link (#PCDATA)>\n<!ELEMENT ejb-ref (ref-name, ref-link, description?)>\n<!ELEMENT context-param (param-name, param-value, description?)>\n<!ELEMENT param-name (#PCDATA)>\n<!ELEMENT param-value (#PCDATA)>\n<!ELEMENT user-role-mapping (role-name+)>\n<!ELEMENT role-name (#PCDATA|mapping)*>\n<!ELEMENT mapping (name, type)>\n<!ELEMENT name (#PCDATA)>\n<!ELEMENT type (#PCDATA)>\n<!ELEMENT dbpool-name (#PCDATA)>\n]>";
    private Document mainDocument = null;
    private ExportDescriptor descriptor = null;

    public ExportDescriptor loadDescriptor(Document document) throws WrongStructureException {
        Element rootElement = document.getDocumentElement();
        this.loadDescriptor(rootElement);
        return this.descriptor;
    }

    private void loadDescriptor(Element docElement) {
        this.descriptor = new ExportDescriptor();
        Node applName = this.getFirstChild(docElement, "application-name");
        if (applName != null) {
            this.loadApplicationName((Element)applName);
        }
        NodeList componentList = docElement.getElementsByTagName("component");
        this.loadComponents(componentList);
    }

    private void loadApplicationName(Element applName) {
        String name = this.getElementValue(applName);
        if (name != null && !name.equals("")) {
            this.descriptor.setApplicationName(name);
        }
    }

    private void loadComponents(NodeList list) {
        Element next = null;
        int i = 0;
        while (i < list.getLength()) {
            next = (Element)list.item(i);
            this.loadComponent(next);
            ++i;
        }
    }

    private void loadComponent(Element compElement) {
        ExportInfo comp = null;
        Node child = null;
        child = this.getFirstChild(compElement, "component-name");
        if (child != null) {
            String attr;
            String name = this.getElementValue((Element)child);
            comp = new ExportInfo();
            if (!name.equals("")) {
                comp.setComponentName(name);
            }
            if ((attr = ((Element)child).getAttribute("Type")).equalsIgnoreCase("web")) {
                comp.setType((byte)2);
            } else if (attr.equalsIgnoreCase("ejb")) {
                comp.setType((byte)1);
            } else if (attr.equalsIgnoreCase("client")) {
                comp.setType((byte)3);
            }
        }
        if ((child = this.getFirstChild(compElement, "additional-info")) != null) {
            comp = this.loadAdditionalInfo((Element)child, comp);
        }
        this.descriptor.addComponent(comp);
    }

    private ExportInfo loadAdditionalInfo(Element addInfo, ExportInfo component) {
        String name;
        Node child;
        Node mapping;
        NodeList ejbList = addInfo.getElementsByTagName("ejb-ref");
        component = this.loadEJBeanRefs(ejbList, component);
        NodeList resourceList = addInfo.getElementsByTagName("res-ref");
        component = this.loadResourceRefs(resourceList, component);
        NodeList entryList = addInfo.getElementsByTagName("entry");
        component = this.loadEnvironmentEntries(entryList, component);
        if (component.getType() == 2) {
            NodeList paramList = addInfo.getElementsByTagName("context-param");
            component = this.loadContextParams(paramList, component);
        }
        if ((mapping = this.getFirstChild(addInfo, "user-role-mapping")) != null) {
            component = this.loadUserRoleMapping((Element)mapping, component);
        }
        if ((child = this.getFirstChild(addInfo, "dbpool-name")) != null && (name = this.getElementValue((Element)child)) != null && !name.equals("")) {
            component.setDBPoolName(name);
        }
        return component;
    }

    private ExportInfo loadEnvironmentEntries(NodeList entryList, ExportInfo component) {
        Element entryEl = null;
        Node child = null;
        EnvironmentEntry[] entries = new EnvironmentEntry[entryList.getLength()];
        String temp = null;
        int i = 0;
        while (i < entryList.getLength()) {
            entryEl = (Element)entryList.item(i);
            child = this.getFirstChild(entryEl, "entry-name");
            if (child != null) {
                temp = this.getElementValue((Element)child);
                entries[i] = new EnvironmentEntry();
                if (!temp.equals("")) {
                    entries[i].setEntryName(temp);
                }
            }
            if ((child = this.getFirstChild(entryEl, "entry-type")) != null) {
                temp = this.getElementValue((Element)child);
                if (entries[i] != null && !temp.equals("")) {
                    entries[i].setEntryType(temp);
                }
            }
            if ((child = this.getFirstChild(entryEl, "value")) != null) {
                temp = this.getElementValue((Element)child);
                if (entries[i] != null) {
                    Object value = null;
                    if (entries[i].getEntryType().equals("java.lang.Integer")) {
                        value = Integer.valueOf(temp);
                    } else if (entries[i].getEntryType().equals("java.lang.Boolean")) {
                        value = Boolean.valueOf(temp);
                    } else if (entries[i].getEntryType().equals("java.lang.Float")) {
                        value = Float.valueOf(temp);
                    } else if (entries[i].getEntryType().equals("java.lang.Double")) {
                        value = Double.valueOf(temp);
                    } else if (entries[i].getEntryType().equals("java.lang.String")) {
                        value = temp;
                    }
                    if (!value.equals("")) {
                        entries[i].setEntryValue(value);
                    }
                }
            }
            if ((child = this.getFirstChild(entryEl, "description")) != null) {
                temp = this.getElementValue((Element)child);
                if (entries[i] != null && !temp.equals("")) {
                    entries[i].setEntryDescription(temp);
                }
            }
            ++i;
        }
        component.setEnvironmentEntries(entries);
        return component;
    }

    private ExportInfo loadResourceRefs(NodeList resourceList, ExportInfo component) {
        Element resourceEl = null;
        Node child = null;
        ResourceReference[] resources = new ResourceReference[resourceList.getLength()];
        String temp = null;
        int i = 0;
        while (i < resourceList.getLength()) {
            resourceEl = (Element)resourceList.item(i);
            child = this.getFirstChild(resourceEl, "ref-name");
            if (child != null) {
                temp = this.getElementValue((Element)child);
                resources[i] = new ResourceReference();
                if (!temp.equals("")) {
                    resources[i].setResourceName(temp);
                }
            }
            if ((child = this.getFirstChild(resourceEl, "ref-link")) != null) {
                temp = this.getElementValue((Element)child);
                if (resources[i] != null && !temp.equals("")) {
                    resources[i].setResourceLink(temp);
                }
            }
            if ((child = this.getFirstChild(resourceEl, "description")) != null) {
                temp = this.getElementValue((Element)child);
                if (resources[i] != null && !temp.equals("")) {
                    resources[i].setResourceDescription(temp);
                }
            }
            ++i;
        }
        component.setResourceReferences(resources);
        return component;
    }

    private ExportInfo loadEJBeanRefs(NodeList ejbList, ExportInfo component) {
        Element ejbEl = null;
        Node child = null;
        EJBeanReference[] ejbs = new EJBeanReference[ejbList.getLength()];
        String temp = null;
        int i = 0;
        while (i < ejbList.getLength()) {
            ejbEl = (Element)ejbList.item(i);
            child = this.getFirstChild(ejbEl, "ref-name");
            if (child != null) {
                temp = this.getElementValue((Element)child);
                ejbs[i] = new EJBeanReference();
                if (!temp.equals("")) {
                    ejbs[i].setReferenceName(temp);
                }
            }
            if ((child = this.getFirstChild(ejbEl, "ref-link")) != null) {
                temp = this.getElementValue((Element)child);
                if (ejbs[i] != null && !temp.equals("")) {
                    ejbs[i].setReferenceJndiLink(temp);
                }
            }
            if ((child = this.getFirstChild(ejbEl, "description")) != null) {
                temp = this.getElementValue((Element)child);
                if (ejbs[i] != null && !temp.equals("")) {
                    ejbs[i].setReferenceDescription(temp);
                }
            }
            ++i;
        }
        component.setEJBeanReferences(ejbs);
        return component;
    }

    private ExportInfo loadContextParams(NodeList paramList, ExportInfo component) {
        Element paramEl = null;
        Node child = null;
        ContextParam[] params = new ContextParam[paramList.getLength()];
        String temp = null;
        int i = 0;
        while (i < paramList.getLength()) {
            paramEl = (Element)paramList.item(i);
            child = this.getFirstChild(paramEl, "param-name");
            if (child != null) {
                temp = this.getElementValue((Element)child);
                params[i] = new ContextParam(temp);
            }
            if ((child = this.getFirstChild(paramEl, "param-value")) != null) {
                temp = this.getElementValue((Element)child);
                if (params[i] != null && !temp.equals("")) {
                    params[i].setParamValue(temp);
                }
            }
            if ((child = this.getFirstChild(paramEl, "description")) != null) {
                temp = this.getElementValue((Element)child);
                if (params[i] != null && !temp.equals("")) {
                    params[i].setDescription(temp);
                }
            }
            ++i;
        }
        component.setContextParams(params);
        return component;
    }

    private ExportInfo loadUserRoleMapping(Element elem, ExportInfo component) {
        Element roleEl = null;
        Node child = null;
        String temp = null;
        Element mappingEl = null;
        NodeList mappingList = null;
        String name = null;
        NodeList roleList = elem.getElementsByTagName("role-name");
        SecurityRoles[] roles = new SecurityRoles[roleList.getLength()];
        int i = 0;
        while (i < roleList.getLength()) {
            roleEl = (Element)roleList.item(i);
            temp = this.getElementValue(roleEl);
            roles[i] = temp != null ? new SecurityRoles(temp) : new SecurityRoles();
            mappingList = roleEl.getElementsByTagName("mapping");
            int j = 0;
            while (j < mappingList.getLength()) {
                mappingEl = (Element)mappingList.item(j);
                child = this.getFirstChild(mappingEl, "name");
                name = child != null ? this.getElementValue((Element)child) : null;
                child = this.getFirstChild(mappingEl, "type");
                if (child != null) {
                    temp = this.getElementValue((Element)child);
                    if (temp.equalsIgnoreCase("group")) {
                        if (!name.equals("")) {
                            roles[i].setUserGroup(name);
                        }
                    } else if (!name.equals("")) {
                        roles[i].setUserName(name);
                    }
                }
                ++j;
            }
            ++i;
        }
        component.setSecurityRoles(roles);
        return component;
    }

    private Node getFirstChild(Element el, String name) {
        NodeList list = el.getElementsByTagName(name);
        if (list == null || list.getLength() == 0) {
            return null;
        }
        return list.item(0);
    }

    private String getElementValue(Element el) {
        Node child = el.getFirstChild();
        if (child == null) {
            return null;
        }
        return child.getNodeValue().trim();
    }

    public Document loadDocument(ExportDescriptor descr) {
        this.mainDocument = StandardDOMParser.createDocument();
        Element docElement = this.mainDocument.createElement("application-status");
        this.loadApplicationName(docElement, descr.getApplicationName());
        this.loadComponents(docElement, descr.getComponents());
        this.mainDocument.appendChild(docElement);
        return this.mainDocument;
    }

    private void loadApplicationName(Element el, String name) {
        this.createSimpleElement(el, "application-name", name);
    }

    private void loadComponents(Element el, ExportInfo[] components) {
        if (components != null && components.length != 0) {
            int i = 0;
            while (i < components.length) {
                this.loadComponent(el, components[i]);
                ++i;
            }
        }
    }

    private void loadComponent(Element el, ExportInfo comp) {
        if (comp != null) {
            Element compEl = this.createElement(el, "component");
            Element nameEl = this.createElement(compEl, "component-name");
            String attr = null;
            if (comp.getType() == 1) {
                attr = "ejb";
            } else if (comp.getType() == 2) {
                attr = "web";
            } else if (comp.getType() == 3) {
                attr = "client";
            }
            nameEl.setAttribute("Type", attr);
            nameEl.appendChild(this.mainDocument.createTextNode(comp.getComponentName()));
            Element addInfoEl = null;
            if (comp.getEJBeanReferences() != null || comp.getResourceReferences() != null || comp.getEnvironmentEntries() != null || comp.getSecurityRoles() != null || comp.getType() == 2 && comp.getContextParams() != null || comp.getDBPoolName() != null && !comp.getDBPoolName().equals("") && comp.getType() == 1) {
                addInfoEl = this.createElement(compEl, "additional-info");
                this.loadEJBeanReferences(addInfoEl, comp.getEJBeanReferences());
                this.loadResourceReferences(addInfoEl, comp.getResourceReferences());
                this.loadEnvironmentEntries(addInfoEl, comp.getEnvironmentEntries());
                this.loadContextParams(addInfoEl, comp.getContextParams());
                this.loadUserRoleMapping(addInfoEl, comp.getSecurityRoles());
                if (comp.getDBPoolName() != null && !comp.getDBPoolName().equals("")) {
                    this.createSimpleElement(addInfoEl, "dbpool-name", comp.getDBPoolName());
                }
            }
        }
    }

    private void loadEnvironmentEntries(Element addInfoEl, EnvironmentEntry[] entries) {
        if (entries != null) {
            Element entryEl = null;
            int i = 0;
            while (i < entries.length) {
                if (entries[i] != null) {
                    entryEl = this.createElement(addInfoEl, "entry");
                    this.createSimpleElement(entryEl, "entry-name", entries[i].getEntryName());
                    this.createSimpleElement(entryEl, "entry-type", entries[i].getEntryType());
                    this.createSimpleElement(entryEl, "value", String.valueOf(entries[i].getEntryValue()));
                    if (entries[i].getEntryDescription() != null) {
                        this.createSimpleElement(entryEl, "description", entries[i].getEntryDescription());
                    }
                }
                ++i;
            }
        }
    }

    private void loadResourceReferences(Element addInfoEl, ResourceReference[] resources) {
        if (resources != null) {
            Element resEl = null;
            int i = 0;
            while (i < resources.length) {
                if (resources[i] != null) {
                    resEl = this.createElement(addInfoEl, "res-ref");
                    this.createSimpleElement(resEl, "ref-name", resources[i].getResourceName());
                    this.createSimpleElement(resEl, "ref-link", resources[i].getResourceLink());
                    if (resources[i].getResourceDescription() != null) {
                        this.createSimpleElement(resEl, "description", resources[i].getResourceDescription());
                    }
                }
                ++i;
            }
        }
    }

    private void loadEJBeanReferences(Element addInfoEl, EJBeanReference[] ejbs) {
        if (ejbs != null) {
            Element ejbEl = null;
            String refLink = null;
            int i = 0;
            while (i < ejbs.length) {
                if (ejbs[i] != null) {
                    ejbEl = this.createElement(addInfoEl, "ejb-ref");
                    this.createSimpleElement(ejbEl, "ref-name", ejbs[i].getReferenceName());
                    refLink = ejbs[i].getReferenceJndiLink();
                    this.createSimpleElement(ejbEl, "ref-link", refLink);
                    if (ejbs[i].getReferenceDescription() != null) {
                        this.createSimpleElement(ejbEl, "description", ejbs[i].getReferenceDescription());
                    }
                }
                ++i;
            }
        }
    }

    private void loadContextParams(Element addInfoEl, ContextParam[] params) {
        if (params != null) {
            Element paramEl = null;
            int i = 0;
            while (i < params.length) {
                if (params[i] != null) {
                    paramEl = this.createElement(addInfoEl, "context-param");
                    this.createSimpleElement(paramEl, "param-name", params[i].getParamName());
                    this.createSimpleElement(paramEl, "param-value", params[i].getParamValue());
                    if (params[i].getDescription() != null) {
                        this.createSimpleElement(paramEl, "description", params[i].getDescription());
                    }
                }
                ++i;
            }
        }
    }

    private void loadUserRoleMapping(Element addInfoEl, SecurityRoles[] roles) {
        if (roles != null) {
            Element urmapping = this.createElement(addInfoEl, "user-role-mapping");
            Element roleEl = null;
            Element mappEl = null;
            String[] users = null;
            String[] groups = null;
            int i = 0;
            while (i < roles.length) {
                if (roles[i] != null) {
                    int j;
                    roleEl = this.createElement(urmapping, "role-name");
                    roleEl.appendChild(this.mainDocument.createTextNode(roles[i].getRoleName()));
                    users = roles[i].getUserNames();
                    if (users != null) {
                        j = 0;
                        while (j < users.length) {
                            mappEl = this.createElement(roleEl, "mapping");
                            this.createSimpleElement(mappEl, "name", users[j]);
                            this.createSimpleElement(mappEl, "type", "user");
                            ++j;
                        }
                    }
                    if ((groups = roles[i].getUserGroup()) != null) {
                        j = 0;
                        while (j < groups.length) {
                            mappEl = this.createElement(roleEl, "mapping");
                            this.createSimpleElement(mappEl, "name", groups[j]);
                            this.createSimpleElement(mappEl, "type", "group");
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
    }

    private Element createElement(Element parent, String child) {
        Element newEl = this.mainDocument.createElement(child);
        parent.appendChild(newEl);
        return newEl;
    }

    private Element createSimpleElement(Element parent, String tag, String value) {
        Element newEl = this.mainDocument.createElement(tag);
        newEl.appendChild(this.mainDocument.createTextNode(value));
        parent.appendChild(newEl);
        return newEl;
    }
}

