/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy;

import com.sap.engine.services.deploy.container.ReferenceObjectIntf;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import java.util.StringTokenizer;

public class ReferenceObject
implements ReferenceObjectIntf {
    static final long serialVersionUID = 7681465152273687351L;
    private static final Character DELIMITER = new Character('\n');
    private String referenceTarget = null;
    private String referenceTargetType = null;
    private String referenceProviderName = null;
    private String referenceType = null;

    public ReferenceObject() {
    }

    public ReferenceObject(String referenceTarget, String referenceTargetType, String referenceType) {
        this.setReferenceTargetType(referenceTargetType);
        this.setReferenceType(referenceType);
        this.setReferenceTarget(referenceTarget);
    }

    public ReferenceObject(String compositeName, String referenceType) {
        this.setCompositeName(compositeName);
        this.setReferenceType(referenceType);
    }

    public void setCompositeName(String compositeName) throws IllegalArgumentException {
        if (compositeName == null) {
            throw new IllegalArgumentException("not specified composite name of the reference");
        }
        String tarType = null;
        String tarName = null;
        if (compositeName.startsWith("library:")) {
            tarType = "library";
            if (compositeName.length() == "library:".length()) {
                throw new IllegalArgumentException("no library name is specified");
            }
            tarName = compositeName.substring("library:".length());
        } else if (compositeName.startsWith("service:")) {
            tarType = "service";
            if (compositeName.length() == "service:".length()) {
                throw new IllegalArgumentException("no service name is specified");
            }
            tarName = compositeName.substring("service:".length());
        } else if (compositeName.startsWith("interface:")) {
            tarType = "interface";
            if (compositeName.length() == "interface:".length()) {
                throw new IllegalArgumentException("no interface name is specified");
            }
            tarName = compositeName.substring("interface:".length());
        } else if (compositeName.startsWith("application:")) {
            tarType = "application";
            if (compositeName.length() == "application:".length()) {
                throw new IllegalArgumentException("no application name is specified");
            }
            tarName = compositeName.substring("application:".length());
        } else {
            tarType = "application";
            tarName = compositeName;
        }
        if (tarType.equals("application") && tarName.indexOf(47) != -1) {
            this.setReferenceProviderName(tarName.substring(0, tarName.indexOf(47)));
            tarName = tarName.substring(tarName.indexOf(47) + 1);
        }
        this.setReferenceTarget(tarName);
        this.setReferenceTargetType(tarType);
    }

    public String getReferenceTarget() {
        return this.referenceTarget;
    }

    public void setReferenceTarget(String referenceTarget) {
        if (referenceTarget != null) {
            referenceTarget = referenceTarget.replace('/', '~');
        }
        this.referenceTarget = referenceTarget;
    }

    public String getReferenceTargetType() {
        return this.referenceTargetType;
    }

    public void setReferenceTargetType(String _referenceTargetType) throws IllegalArgumentException {
        if ("library".equals(_referenceTargetType) || "interface".equals(_referenceTargetType) || "service".equals(_referenceTargetType)) {
            this.referenceTargetType = _referenceTargetType;
            if (this.referenceTarget != null) {
                this.referenceTarget = this.referenceTarget.replace('/', '~');
            }
        } else if ("application".equals(_referenceTargetType)) {
            this.referenceTargetType = _referenceTargetType;
        } else {
            throw new IllegalArgumentException("Unsupported reference_target type: " + _referenceTargetType);
        }
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(String _referenceType) throws IllegalArgumentException {
        if (!"hard".equals(_referenceType) && !"weak".equals(_referenceType)) {
            throw new IllegalArgumentException("Unsupported reference type: " + _referenceType);
        }
        this.referenceType = _referenceType;
    }

    public void setReferenceProviderName(String referenceProviderName) {
        this.referenceProviderName = referenceProviderName;
    }

    public String getReferenceProviderName() {
        return this.referenceProviderName;
    }

    public boolean equalsSimple(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceObject)) {
            return false;
        }
        ReferenceObject refObject = (ReferenceObject)obj;
        if (!EqualUtils.equalObjects(this.getReferenceTarget(), refObject.getReferenceTarget())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.getReferenceTargetType(), refObject.getReferenceTargetType())) {
            return false;
        }
        if (EqualUtils.equalObjects(this.getReferenceType(), refObject.getReferenceType())) {
            return false;
        }
        return EqualUtils.equalObjects(this.getReferenceProviderName(), refObject.getReferenceProviderName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceObject)) {
            return false;
        }
        ReferenceObject refObject = (ReferenceObject)obj;
        if (!EqualUtils.equalObjects(this.getReferenceTarget(), refObject.getReferenceTarget())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.getReferenceTargetType(), refObject.getReferenceTargetType())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.getReferenceType(), refObject.getReferenceType())) {
            return false;
        }
        return EqualUtils.equalObjects(this.getReferenceProviderName(), refObject.getReferenceProviderName());
    }

    public Object clone() {
        ReferenceObject refClone = new ReferenceObject();
        refClone.setReferenceTarget(this.getReferenceTarget() == null ? null : new String(this.getReferenceTarget()));
        refClone.setReferenceTargetType(this.getReferenceTargetType() == null ? null : new String(this.getReferenceTargetType()));
        refClone.setReferenceType(this.getReferenceType() == null ? null : new String(this.getReferenceType()));
        refClone.setReferenceProviderName(this.getReferenceProviderName() == null ? null : new String(this.getReferenceProviderName()));
        return refClone;
    }

    public String toString() {
        String target = this.getReferenceTarget();
        if ("application".equals(this.getReferenceTargetType())) {
            target = this.getReferenceProviderName() == null || this.getReferenceProviderName().equals("") ? "sap.com/" + target : this.getReferenceProviderName() + "/" + target;
        } else {
            if (!(this.getReferenceProviderName() == null || this.getReferenceProviderName().equals("") || this.getReferenceProviderName().equals("engine.sap.com") || this.getReferenceProviderName().equals("sap.com"))) {
                target = this.getReferenceProviderName() + "~" + target;
            }
            target = this.getReferenceTargetType() + ":" + target;
        }
        return target;
    }

    public String getName() {
        String target = this.getReferenceTarget();
        if ("application".equals(this.getReferenceTargetType())) {
            target = this.getReferenceProviderName() == null || this.getReferenceProviderName().equals("") ? "sap.com/" + target : this.getReferenceProviderName() + "/" + target;
        } else if (!(this.getReferenceProviderName() == null || this.getReferenceProviderName().equals("") || this.getReferenceProviderName().equals("engine.sap.com") || this.getReferenceProviderName().equals("sap.com"))) {
            target = this.getReferenceProviderName() + "~" + target;
        }
        return target;
    }

    public String decode() {
        String decode = "";
        decode = decode + (this.getReferenceProviderName() == null ? "" : this.getReferenceProviderName()) + DELIMITER.toString();
        decode = decode + (this.getReferenceTarget() == null ? "" : this.getReferenceTarget()) + DELIMITER.toString();
        decode = decode + (this.getReferenceTargetType() == null ? "" : this.getReferenceTargetType()) + DELIMITER.toString();
        decode = decode + (this.getReferenceType() == null ? "" : this.getReferenceType()) + DELIMITER.toString();
        return decode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReferenceObject encode(String encode) throws IllegalArgumentException {
        if (encode == null) {
            return null;
        }
        ReferenceObject refObject = new ReferenceObject();
        String token = null;
        StringTokenizer tokenizer = new StringTokenizer(encode, DELIMITER.toString(), true);
        if (!tokenizer.hasMoreTokens()) throw new IllegalArgumentException("Error in decoding String into RefernceObject: wrong String.");
        token = tokenizer.nextToken();
        if (!token.equals(DELIMITER.toString())) {
            refObject.setReferenceProviderName(token);
            if (!tokenizer.hasMoreTokens()) throw new IllegalArgumentException("Error in decoding String into RefernceObject: missing delititer.");
            tokenizer.nextToken();
        }
        if (!tokenizer.hasMoreTokens()) throw new IllegalArgumentException("Error in decoding String into RefernceObject: wrong String.");
        token = tokenizer.nextToken();
        if (!token.equals(DELIMITER.toString())) {
            refObject.setReferenceTarget(token);
            if (!tokenizer.hasMoreTokens()) throw new IllegalArgumentException("Error in decoding String into RefernceObject: missing delititer.");
            tokenizer.nextToken();
        }
        if (!tokenizer.hasMoreTokens()) throw new IllegalArgumentException("Error in decoding String into RefernceObject: wrong String.");
        token = tokenizer.nextToken();
        if (!token.equals(DELIMITER.toString())) {
            refObject.setReferenceTargetType(token);
            if (!tokenizer.hasMoreTokens()) throw new IllegalArgumentException("Error in decoding String into RefernceObject: missing delititer.");
            tokenizer.nextToken();
        }
        if (!tokenizer.hasMoreTokens()) throw new IllegalArgumentException("Error in decoding String into RefernceObject: wrong String.");
        token = tokenizer.nextToken();
        if (token.equals(DELIMITER.toString())) return refObject;
        refObject.setReferenceType(token);
        if (!tokenizer.hasMoreTokens()) throw new IllegalArgumentException("Error in decoding String into RefernceObject: missing delititer.");
        tokenizer.nextToken();
        return refObject;
    }
}

