/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy;

import com.sap.engine.services.deploy.DeployCallback;
import com.sap.engine.services.deploy.DeployEvent;
import com.sap.engine.services.deploy.DeployListener;
import com.sap.engine.services.deploy.container.ProgressEvent;
import com.sap.engine.services.rmi_p4.P4RemoteObject;

public class DeployCallbackImpl
extends P4RemoteObject
implements DeployCallback {
    private DeployListener[] listeners = new DeployListener[0];

    public void processApplicationEvent(DeployEvent event) {
        int j = this.listeners.length - 1;
        while (j >= 0) {
            this.listeners[j].processApplicationEvent(event);
            --j;
        }
    }

    public void processLibraryEvent(DeployEvent event) {
        int j = this.listeners.length - 1;
        while (j >= 0) {
            this.listeners[j].processLibraryEvent(event);
            --j;
        }
    }

    public void processInterfaceEvent(DeployEvent event) {
        int j = this.listeners.length - 1;
        while (j >= 0) {
            this.listeners[j].processInterfaceEvent(event);
            --j;
        }
    }

    public void processServiceEvent(DeployEvent event) {
        int j = this.listeners.length - 1;
        while (j >= 0) {
            this.listeners[j].processServiceEvent(event);
            --j;
        }
    }

    public void processContainerEvent(ProgressEvent event) {
        int j = this.listeners.length - 1;
        while (j >= 0) {
            this.listeners[j].processContainerEvent(event);
            --j;
        }
    }

    public void processReferenceEvent(DeployEvent event) {
        int j = this.listeners.length - 1;
        while (j >= 0) {
            this.listeners[j].processReferenceEvent(event);
            --j;
        }
    }

    public void processStandaloneModuleEvent(DeployEvent event) {
        int j = this.listeners.length - 1;
        while (j >= 0) {
            this.listeners[j].processStandaloneModuleEvent(event);
            --j;
        }
    }

    public void addDeployListener(DeployListener listener) {
        if (listener == null) {
            return;
        }
        if (this.found(listener) != -1) {
            return;
        }
        DeployListener[] temp = new DeployListener[this.listeners.length + 1];
        System.arraycopy(this.listeners, 0, temp, 0, this.listeners.length);
        temp[this.listeners.length] = listener;
        this.listeners = temp;
    }

    private int found(DeployListener l) {
        int j = this.listeners.length;
        while (j > 0) {
            if (l == this.listeners[j - 1]) {
                return j - 1;
            }
            --j;
        }
        return -1;
    }

    public void removeDeployListener(DeployListener listener) {
        int index = this.found(listener);
        if (index == -1) {
            return;
        }
        DeployListener[] temp = new DeployListener[this.listeners.length - 1];
        System.arraycopy(this.listeners, 0, temp, 0, index);
        if (index != this.listeners.length - 1) {
            System.arraycopy(this.listeners, index + 1, temp, index, this.listeners.length - index - 1);
        }
        this.listeners = temp;
    }

    public DeployListener[] getDeployListeners() {
        return this.listeners;
    }

    public void callbackLost(String serverName) {
        int j = this.listeners.length - 1;
        while (j >= 0) {
            this.listeners[j].callbackLost(serverName);
            --j;
        }
    }

    public void serverAdded(String serverName) {
        int j = this.listeners.length - 1;
        while (j >= 0) {
            this.listeners[j].serverAdded(serverName);
            --j;
        }
    }
}

