/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.wrappers;

import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.cci.ConnectionHandle;
import com.sap.engine.services.dbpool.exceptions.BaseSQLException;
import com.sap.sql.jdbc.common.CommonConnection;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class StatementWrapper
implements Statement {
    private static final int SET_MAX_FIELD_SIZE = 0;
    private static final int SET_MAX_ROWS = 1;
    private static final int SET_ESCAPE_PROCESSING = 2;
    private static final int SET_QUERY_TIMEOUT = 3;
    private static final int SET_CURSOR_NAME = 4;
    private static final int SET_FETCH_SIZE = 5;
    private static final int SET_FETCH_DIRECTION = 6;
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$wrappers$StatementWrapper == null ? (class$com$sap$engine$services$dbpool$wrappers$StatementWrapper = StatementWrapper.class$("com.sap.engine.services.dbpool.wrappers.StatementWrapper")) : class$com$sap$engine$services$dbpool$wrappers$StatementWrapper));
    protected static final int logDebug = 100;
    protected Statement stmt;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected boolean set_rstype_rscon = false;
    protected ConnectionHandle conHandle;
    protected boolean isDirect = false;
    private boolean isClosed = false;
    private boolean isDissociated = false;
    private HashMapIntObject stmtCalledMethods = new HashMapIntObject();
    private ArrayList batch = new ArrayList();
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$wrappers$StatementWrapper;

    public StatementWrapper(Statement _stmt) {
        this.stmt = _stmt;
    }

    public void setConnectionHandle(ConnectionHandle _conHandle) {
        this.conHandle = _conHandle;
        if (location.beLogged(100)) {
            location.logT(100, "StatementWrapper.setConnectionHandle(): " + this.logDSName() + ". ConnectionHandle: " + this.conHandle + ". StatementWrapper object: " + this);
        }
    }

    public void setCreateParameters(int _resultSetType, int _resultSetConcurrency) {
        if (location.beLogged(100)) {
            location.logT(100, "StatementWrapper.setCreateParameters(): " + this.logDSName() + ". ConnectionHandle: " + this.conHandle + ". StatementWrapper object: " + this + ", parameters: resultSetType = " + _resultSetType + ", resultSetConcurrency = " + _resultSetConcurrency);
        }
        this.resultSetType = _resultSetType;
        this.resultSetConcurrency = _resultSetConcurrency;
        this.set_rstype_rscon = true;
    }

    public void setDirect() {
        if (location.beLogged(100)) {
            location.logT(100, "StatementWrapper.setDirect(): " + this.logDSName() + ". ConnectionHandle: " + this.conHandle + ". StatementWrapper object: " + this);
        }
        this.isDirect = true;
    }

    public void internalClose() throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> StatementWrapper.internalClose(): " + this.logDSName() + ". ConnectionHandle: " + this.conHandle + ". StatementWrapper object: " + this);
        }
        this.stmt.close();
        this.isClosed = true;
        if (location.beLogged(100)) {
            location.logT(100, "<-- StatementWrapper.internalClose(): " + this.logDSName() + ". StatementWrapper object: " + this);
        }
    }

    public void dissociateStatement() throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> StatementWrapper.dissociateStatement(): " + this.logDSName() + ". ConnectionHandle: " + this.conHandle + ". StatementWrapper object: " + this);
        }
        this.stmt.close();
        this.isDissociated = true;
        if (location.beLogged(100)) {
            location.logT(100, "<-- StatementWrapper.dissociateStatement(): " + this.logDSName() + ". StatementWrapper object: " + this);
        }
    }

    public void associateStatement() throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> StatementWrapper.associateStatement(): " + this.logDSName() + ". ConnectionHandle: " + this.conHandle + ". StatementWrapper object: " + this);
        }
        this.conHandle.checkIfValid();
        this.stmt = this.set_rstype_rscon ? (this.isDirect ? ((CommonConnection)this.conHandle.getPhysicalConnection()).createDirectStatement(this.resultSetType, this.resultSetConcurrency) : this.conHandle.getPhysicalConnection().createStatement(this.resultSetType, this.resultSetConcurrency)) : (this.isDirect ? ((CommonConnection)this.conHandle.getPhysicalConnection()).createDirectStatement() : this.conHandle.getPhysicalConnection().createStatement());
        this.initStatement();
        if (location.beLogged(100)) {
            location.logT(100, "<-- StatementWrapper.associateStatement(): " + this.logDSName() + ". StatementWrapper object: " + this);
        }
    }

    protected void initStatement() throws SQLException {
        int[] methodIDs = this.stmtCalledMethods.getAllKeys();
        int i = 0;
        while (i < methodIDs.length) {
            Object value = this.stmtCalledMethods.get(methodIDs[i]);
            switch (methodIDs[i]) {
                case 0: {
                    this.stmt.setMaxFieldSize((Integer)value);
                    break;
                }
                case 1: {
                    this.stmt.setMaxRows((Integer)value);
                    break;
                }
                case 2: {
                    this.stmt.setEscapeProcessing((Boolean)value);
                    break;
                }
                case 3: {
                    this.stmt.setQueryTimeout((Integer)value);
                    break;
                }
                case 4: {
                    this.stmt.setCursorName((String)value);
                    break;
                }
                case 5: {
                    this.stmt.setFetchSize((Integer)value);
                    break;
                }
                case 6: {
                    this.stmt.setFetchDirection((Integer)value);
                }
            }
            ++i;
        }
        Iterator iter = ((AbstractList)this.batch).iterator();
        while (iter.hasNext()) {
            this.stmt.addBatch((String)iter.next());
        }
    }

    protected void checkIfValid() throws SQLException {
        if (this.isClosed) {
            throw new BaseSQLException("dbpool_0316");
        }
        if (this.isDissociated) {
            this.associateStatement();
            this.isDissociated = false;
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        this.checkIfValid();
        return this.stmt.executeUpdate(sql);
    }

    public boolean execute(String sql) throws SQLException {
        this.checkIfValid();
        return this.stmt.execute(sql);
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkIfValid();
        return this.stmt.executeQuery(sql);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkIfValid();
        this.stmt.setMaxFieldSize(max);
        this.stmtCalledMethods.put(0, new Integer(max));
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkIfValid();
        this.stmt.setMaxRows(max);
        this.stmtCalledMethods.put(1, new Integer(max));
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkIfValid();
        this.stmt.setEscapeProcessing(enable);
        this.stmtCalledMethods.put(2, new Boolean(enable));
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkIfValid();
        this.stmt.setQueryTimeout(seconds);
        this.stmtCalledMethods.put(3, new Integer(seconds));
    }

    public void setCursorName(String name) throws SQLException {
        this.checkIfValid();
        this.stmt.setCursorName(name);
        this.stmtCalledMethods.put(4, name);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkIfValid();
        this.stmt.setFetchSize(rows);
        this.stmtCalledMethods.put(5, new Integer(rows));
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkIfValid();
        this.stmt.setFetchDirection(direction);
        this.stmtCalledMethods.put(6, new Integer(direction));
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkIfValid();
        return this.stmt.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        this.checkIfValid();
        return this.stmt.getMaxRows();
    }

    public int getQueryTimeout() throws SQLException {
        this.checkIfValid();
        return this.stmt.getQueryTimeout();
    }

    public int getUpdateCount() throws SQLException {
        this.checkIfValid();
        return this.stmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.checkIfValid();
        return this.stmt.getMoreResults();
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkIfValid();
        return this.stmt.getResultSet();
    }

    public int getFetchSize() throws SQLException {
        this.checkIfValid();
        return this.stmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkIfValid();
        return this.stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        this.checkIfValid();
        return this.stmt.getResultSetType();
    }

    public int getFetchDirection() throws SQLException {
        this.checkIfValid();
        return this.stmt.getFetchDirection();
    }

    public int[] executeBatch() throws SQLException {
        this.checkIfValid();
        this.batch.clear();
        return this.stmt.executeBatch();
    }

    public void addBatch(String sql) throws SQLException {
        this.checkIfValid();
        this.stmt.addBatch(sql);
        this.batch.add(sql);
    }

    public void clearBatch() throws SQLException {
        this.checkIfValid();
        this.stmt.clearBatch();
        this.batch.clear();
    }

    public Connection getConnection() throws SQLException {
        this.checkIfValid();
        return this.stmt.getConnection();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkIfValid();
        return this.stmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkIfValid();
        this.stmt.clearWarnings();
    }

    public void close() throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> StatementWrapper.close(): " + this.logDSName() + ". ConnectionHandle: " + this.conHandle + ". StatementWrapper object: " + this);
        }
        if (this.isClosed) {
            return;
        }
        if (!this.isDissociated) {
            this.stmt.close();
        }
        this.conHandle.removeStatement(this);
        this.isClosed = true;
        if (location.beLogged(100)) {
            location.logT(100, "<-- StatementWrapper.close(): " + this.logDSName() + ". StatementWrapper object: " + this);
        }
    }

    public void cancel() throws SQLException {
        this.checkIfValid();
        this.stmt.cancel();
    }

    protected String logDSName() {
        if (this.conHandle == null) {
            return "Statement is dissociated";
        }
        return "DataSource name = " + PoolFrame.getDSName(this.conHandle.getMcf());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

