/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.spi;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.cci.ConnectionFactoryImpl;
import com.sap.engine.services.dbpool.deploy.ContainerImpl;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.dbpool.exceptions.BaseIOException;
import com.sap.engine.services.dbpool.exceptions.BaseInstantiationException;
import com.sap.engine.services.dbpool.exceptions.BaseResourceException;
import com.sap.engine.services.dbpool.spi.CommonXAManagedConnectionImpl;
import com.sap.engine.services.dbpool.spi.ConnectionRequestInfoImpl;
import com.sap.engine.services.dbpool.spi.DirectXAManagedConnectionImpl;
import com.sap.engine.services.dbpool.spi.XAManagedConnectionImpl;
import com.sap.sql.connect.OpenSQLConnectionFactory;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class XAManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
Serializable {
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$spi$XAManagedConnectionFactoryImpl == null ? (class$com$sap$engine$services$dbpool$spi$XAManagedConnectionFactoryImpl = XAManagedConnectionFactoryImpl.class$("com.sap.engine.services.dbpool.spi.XAManagedConnectionFactoryImpl")) : class$com$sap$engine$services$dbpool$spi$XAManagedConnectionFactoryImpl));
    private static final int logDebug = 100;
    private JDBCDescriptor descr;
    private long mcfid;
    private long mcid;
    private transient XADataSource xads;
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$spi$XAManagedConnectionFactoryImpl;
    static /* synthetic */ Class class$java$lang$String;

    public XAManagedConnectionFactoryImpl(ContainerImpl container, JDBCDescriptor descr, long mcfid) throws InstantiationException {
        this.descr = descr;
        this.mcfid = mcfid;
        this.mcid = 0L;
        String objectFactoryName = descr.getObjectFactory();
        Properties props20 = descr.getProps20();
        ApplicationServiceContext serviceContext = PoolFrame.getAppContext();
        LoadContext classLoaderContext = serviceContext.getCoreContext().getLoadContext();
        if (objectFactoryName == null || "".equals(objectFactoryName)) {
            try {
                Class cl;
                if ("SYSTEM_DRIVER".equals(descr.getDriverName())) {
                    cl = Class.forName(descr.getXADSClassName());
                } else {
                    ResourceLoader loader = (ResourceLoader)classLoaderContext.getClassLoader("library:" + descr.getDriverName());
                    container.ensureOpenSqlResForLoader(loader);
                    cl = loader.loadClass(descr.getXADSClassName());
                }
                this.xads = (XADataSource)cl.newInstance();
                Enumeration<?> enumeration = props20.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String propName = (String)enumeration.nextElement();
                    String mthName = "set".concat(propName.substring(0, 1).toUpperCase().concat(propName.substring(1)));
                    try {
                        Method method = cl.getMethod(mthName, class$java$lang$String == null ? XAManagedConnectionFactoryImpl.class$("java.lang.String") : class$java$lang$String);
                        method.invoke((Object)this.xads, props20.getProperty(propName));
                    }
                    catch (NoSuchMethodException nsme) {
                        try {
                            Method method = cl.getMethod(mthName, Integer.TYPE);
                            method.invoke((Object)this.xads, new Integer(props20.getProperty(propName)));
                        }
                        catch (NoSuchMethodException nsme_string) {
                            throw new BaseInstantiationException("dbpool_0801", new Object[]{mthName, descr.getXADSClassName()}, (Throwable)nsme_string);
                        }
                        catch (NumberFormatException nfe) {
                            throw new BaseInstantiationException("dbpool_0802", propName, (Throwable)nfe);
                        }
                    }
                }
            }
            catch (ClassNotFoundException cnfex) {
                throw new BaseInstantiationException("dbpool_0800", descr.getXADSClassName(), (Throwable)cnfex);
            }
            catch (IllegalAccessException illAccEx) {
                throw new BaseInstantiationException("dbpool_0803", descr.getXADSClassName(), (Throwable)illAccEx);
            }
            catch (InvocationTargetException ite) {
                throw new BaseInstantiationException("dbpool_0804", descr.getXADSClassName(), (Throwable)ite);
            }
        }
        Reference ref = new Reference(descr.getXADSClassName(), objectFactoryName, "");
        Enumeration<?> enumeration = props20.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            ref.add(new StringRefAddr(propName, props20.getProperty(propName)));
        }
        try {
            Class cl;
            if ("SYSTEM_DRIVER".equals(descr.getDriverName())) {
                cl = Class.forName(objectFactoryName);
            } else {
                ResourceLoader loader = (ResourceLoader)classLoaderContext.getClassLoader("library:" + descr.getDriverName());
                container.ensureOpenSqlResForLoader(loader);
                cl = loader.loadClass(objectFactoryName);
            }
            ObjectFactory objectFactory = (ObjectFactory)cl.newInstance();
            this.xads = (XADataSource)objectFactory.getObjectInstance(ref, null, null, null);
        }
        catch (Exception ex) {
            throw new BaseInstantiationException("dbpool_0800", "XAManagedConnectionFactoryImpl", (Throwable)ex);
        }
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return new ConnectionFactoryImpl(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        return new ConnectionFactoryImpl(this, null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "XAManagedConnectionFactoryImpl.createManagedConnection(): DataSource name = " + this.descr.getDataSourceName() + ". XAManagedConnectionFactoryImpl object: " + this);
        }
        try {
            XAConnection xacon = null;
            ConnectionRequestInfoImpl infoImpl = null;
            Properties dbiProps = new Properties();
            String userName = null;
            String password = null;
            if (info == null) {
                xacon = this.xads.getXAConnection();
                Properties props20 = this.descr.getProps20();
                userName = props20.getProperty("user");
                password = props20.getProperty("password");
            } else {
                infoImpl = (ConnectionRequestInfoImpl)info;
                userName = infoImpl.getUser();
                password = infoImpl.getPassword();
                xacon = this.xads.getXAConnection(userName, password);
            }
            if (userName != null) {
                dbiProps.setProperty("user", userName);
            }
            if (password != null) {
                dbiProps.setProperty("password", password);
            }
            dbiProps.setProperty("jndiName", this.descr.getDataSourceName());
            dbiProps.setProperty("systemDataSource", new Boolean(this.descr.isDefaultDS()).toString());
            if (PoolFrame.getAppContext() == null) {
                dbiProps.setProperty("clusterId", Integer.toString(-1));
            } else {
                dbiProps.setProperty("clusterId", Integer.toString(PoolFrame.getAppContext().getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId()));
            }
            if (this.descr.isOpenSQL()) {
                return new CommonXAManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, OpenSQLConnectionFactory.createCommonXAConnection((XAConnection)xacon, (Properties)dbiProps), this.descr.getIsolationLevel(), this.mcid++);
            }
            if (this.descr.isNativeSQL()) {
                return new DirectXAManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, OpenSQLConnectionFactory.createDirectXAConnection((XAConnection)xacon, (Properties)dbiProps), this.descr.getIsolationLevel(), this.mcid++);
            }
            return new XAManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, xacon, this.descr.getIsolationLevel(), this.mcid++);
        }
        catch (SQLException sex) {
            if (location.beLogged(500)) {
                location.logT(500, "XAManagedConnectionFactoryImpl.createManagedConnection(): SQLException occured while creating XAManagedConnection: " + sex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)sex);
            }
            throw new BaseResourceException("dbpool_0204", sex.toString(), (Throwable)sex);
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> XAManagedConnectionFactoryImpl.matchManagedConnections(): DataSource name = " + this.descr.getDataSourceName() + ". XAManagedConnectionFactoryImpl object: " + this);
        }
        Iterator it = connectionSet.iterator();
        while (it.hasNext()) {
            XAManagedConnectionImpl mc;
            ManagedConnectionFactory mcf;
            Object obj = it.next();
            if (!(obj instanceof XAManagedConnectionImpl) || !(mcf = (mc = (XAManagedConnectionImpl)obj).getManagedConnectionFactory()).equals((Object)this) || (info != null || mc.getConnectionRequestInfo() != null) && (info == null || !info.equals((Object)mc.getConnectionRequestInfo()))) continue;
            if (location.beLogged(100)) {
                location.logT(100, "<-- XAManagedConnectionFactoryImpl.matchManagedConnections(): DataSource name = " + this.descr.getDataSourceName() + ". XAManagedConnectionFactoryImpl object: " + this + ". Matched ManagedConnection ID = " + mc);
            }
            return mc;
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- XAManagedConnectionFactoryImpl.matchManagedConnections(): DataSource name = " + this.descr.getDataSourceName() + ". XAManagedConnectionFactoryImpl object: " + this + ". Match not found.");
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        try {
            this.xads.setLogWriter(out);
        }
        catch (SQLException ex) {
            throw new BaseResourceException("dbpool_0204", ex.toString(), (Throwable)ex);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        try {
            return this.xads.getLogWriter();
        }
        catch (SQLException ex) {
            throw new BaseResourceException("dbpool_0204", ex.toString(), (Throwable)ex);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof XAManagedConnectionFactoryImpl) {
            String objDSName = ((XAManagedConnectionFactoryImpl)obj).descr.getDataSourceName();
            return this.descr.getDataSourceName().equals(objDSName);
        }
        return false;
    }

    public int hashCode() {
        return this.descr.getDataSourceName().hashCode();
    }

    public long getMCFID() {
        return this.mcfid;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Class<?> cl2;
        stream.defaultReadObject();
        ApplicationServiceContext serviceContext = PoolFrame.getAppContext();
        Reference ref = new Reference(this.descr.getXADSClassName(), this.descr.getObjectFactory(), "");
        Properties props20 = this.descr.getProps20();
        String objectFactoryName = this.descr.getObjectFactory();
        LoadContext classLoaderContext = serviceContext.getCoreContext().getLoadContext();
        String errorMessage = "";
        if (objectFactoryName == null || "".equals(objectFactoryName)) {
            try {
                Class<?> cl2;
                if (serviceContext != null) {
                    errorMessage = "at the server side ";
                    cl2 = "SYSTEM_DRIVER".equals(this.descr.getDriverName()) ? Class.forName(this.descr.getXADSClassName()) : classLoaderContext.getClassLoader("library:" + this.descr.getDriverName()).loadClass(this.descr.getXADSClassName());
                } else {
                    errorMessage = "at the client side ";
                    cl2 = Class.forName(this.descr.getXADSClassName());
                }
                this.xads = (XADataSource)cl2.newInstance();
                Enumeration<?> enumeration = props20.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String propName = (String)enumeration.nextElement();
                    String mthName = "set".concat(propName.substring(0, 1).toUpperCase().concat(propName.substring(1)));
                    try {
                        Method method = cl2.getMethod(mthName, class$java$lang$String == null ? XAManagedConnectionFactoryImpl.class$("java.lang.String") : class$java$lang$String);
                        method.invoke((Object)this.xads, props20.getProperty(propName));
                    }
                    catch (NoSuchMethodException nsme) {
                        try {
                            Method method = cl2.getMethod(mthName, Integer.TYPE);
                            method.invoke((Object)this.xads, new Integer(props20.getProperty(propName)));
                        }
                        catch (NoSuchMethodException nsme_string) {
                            throw new BaseIOException("dbpool_0503", new Object[]{mthName, this.descr.getXADSClassName()}, (Throwable)nsme_string);
                        }
                        catch (NumberFormatException nfe) {
                            throw new BaseIOException("dbpool_0504", propName, (Throwable)nfe);
                        }
                    }
                }
            }
            catch (ClassNotFoundException cnfex) {
                throw new BaseIOException("dbpool_0500", this.descr.getXADSClassName(), (Throwable)cnfex);
            }
            catch (IllegalAccessException illAccEx) {
                throw new BaseIOException("dbpool_0505", this.descr.getXADSClassName(), (Throwable)illAccEx);
            }
            catch (InvocationTargetException ite) {
                throw new BaseIOException("dbpool_0506", this.descr.getXADSClassName(), (Throwable)ite);
            }
            catch (InstantiationException instEx) {
                throw new BaseIOException("dbpool_0500", this.descr.getXADSClassName(), (Throwable)instEx);
            }
        }
        Enumeration<?> enumeration = props20.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propName = (String)enumeration.nextElement();
            ref.add(new StringRefAddr(propName, props20.getProperty(propName)));
        }
        if (serviceContext != null) {
            errorMessage = "at the server side ";
            cl2 = "SYSTEM_DRIVER".equals(this.descr.getDriverName()) ? Class.forName(this.descr.getObjectFactory()) : classLoaderContext.getClassLoader("library:" + this.descr.getDriverName()).loadClass(this.descr.getObjectFactory());
        } else {
            errorMessage = "at the client side ";
            cl2 = Class.forName(this.descr.getObjectFactory());
        }
        try {
            ObjectFactory objectFactory = (ObjectFactory)cl2.newInstance();
            this.xads = (XADataSource)objectFactory.getObjectInstance(ref, null, null, null);
        }
        catch (Exception ex) {
            throw new BaseIOException("dbpool_0502", errorMessage, (Throwable)ex);
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return null;
    }

    public void setResourceAdapter(ResourceAdapter arg0) throws ResourceException {
    }

    public JDBCDescriptor getJDBCDescriptor() {
        return this.descr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

