/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.spi;

import com.sap.engine.services.dbpool.exceptions.BaseResourceException;
import com.sap.engine.services.dbpool.spi.ConnectionRequestInfoImpl;
import com.sap.engine.services.dbpool.spi.LocalTXManagedConnectionImpl;
import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionMetaData;

public class ManagedConnectionMetaDataImpl
implements ManagedConnectionMetaData {
    private LocalTXManagedConnectionImpl mc;

    public ManagedConnectionMetaDataImpl(LocalTXManagedConnectionImpl mc) {
        this.mc = mc;
    }

    public String getEISProductName() throws ResourceException {
        try {
            Connection con = this.mc.getPhysicalConnection();
            return con.getMetaData().getDatabaseProductName();
        }
        catch (SQLException sex) {
            throw new BaseResourceException("dbpool_0204", sex.toString(), (Throwable)sex);
        }
    }

    public String getEISProductVersion() throws ResourceException {
        try {
            Connection con = this.mc.getPhysicalConnection();
            return con.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException sex) {
            throw new BaseResourceException("dbpool_0204", sex.toString(), (Throwable)sex);
        }
    }

    public int getMaxConnections() throws ResourceException {
        try {
            Connection con = this.mc.getPhysicalConnection();
            return con.getMetaData().getMaxConnections();
        }
        catch (SQLException sex) {
            throw new BaseResourceException("dbpool_0204", sex.toString(), (Throwable)sex);
        }
    }

    public String getUserName() throws ResourceException {
        if (this.mc.isDestroyed()) {
            throw new BaseResourceException("dbpool_0209");
        }
        String str = null;
        ConnectionRequestInfoImpl cri = (ConnectionRequestInfoImpl)this.mc.getConnectionRequestInfo();
        if (cri != null) {
            str = cri.getUser();
        }
        if (cri != null || str != null || !str.equals("")) {
            return str;
        }
        return null;
    }
}

