/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.spi;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.cci.ConnectionFactoryImpl;
import com.sap.engine.services.dbpool.deploy.ContainerImpl;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.dbpool.exceptions.BaseIOException;
import com.sap.engine.services.dbpool.exceptions.BaseInstantiationException;
import com.sap.engine.services.dbpool.exceptions.BaseResourceException;
import com.sap.engine.services.dbpool.spi.CommonManagedConnectionImpl;
import com.sap.engine.services.dbpool.spi.ConnectionRequestInfoImpl;
import com.sap.engine.services.dbpool.spi.DirectManagedConnectionImpl;
import com.sap.engine.services.dbpool.spi.LocalTXManagedConnectionImpl;
import com.sap.sql.connect.OpenSQLConnectionFactory;
import com.sap.sql.connect.OpenSQLDataSource;
import com.sap.sql.connect.OpenSQLProperties;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.security.auth.Subject;

public class ManagedConnectionFactoryImpl
implements ManagedConnectionFactory,
Serializable {
    static final long serialVersionUID = 6864912442934384377L;
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$spi$ManagedConnectionFactoryImpl == null ? (class$com$sap$engine$services$dbpool$spi$ManagedConnectionFactoryImpl = ManagedConnectionFactoryImpl.class$("com.sap.engine.services.dbpool.spi.ManagedConnectionFactoryImpl")) : class$com$sap$engine$services$dbpool$spi$ManagedConnectionFactoryImpl));
    private static final int logDebug = 100;
    private JDBCDescriptor descr;
    private long mcfid;
    private long mcid;
    private transient Driver driver = null;
    private transient PrintWriter logWriter = null;
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$spi$ManagedConnectionFactoryImpl;

    public ManagedConnectionFactoryImpl(ContainerImpl container, JDBCDescriptor descr, long mcfid) throws InstantiationException {
        this.descr = descr;
        this.mcfid = mcfid;
        this.mcid = 0L;
        if (descr.getDBConnectInfo() == null) {
            try {
                Class cl;
                if ("SYSTEM_DRIVER".equals(descr.getDriverName())) {
                    cl = Class.forName(descr.getDriverClassName());
                } else {
                    ApplicationServiceContext serviceContext = PoolFrame.getAppContext();
                    LoadContext classLoaderContext = serviceContext.getCoreContext().getLoadContext();
                    ResourceLoader loader = (ResourceLoader)classLoaderContext.getClassLoader("library:" + descr.getDriverName());
                    container.ensureOpenSqlResForLoader(loader);
                    cl = loader.loadClass(descr.getDriverClassName());
                }
                this.driver = (Driver)cl.newInstance();
            }
            catch (Exception ex) {
                throw new BaseInstantiationException("dbpool_0800", "ManagedConnectionFactoryImpl", (Throwable)ex);
            }
        }
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        return new ConnectionFactoryImpl(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        return new ConnectionFactoryImpl(this, null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "ManagedConnectionFactoryImpl.createManagedConnection(): DataSource name = " + this.descr.getDataSourceName() + ". ManagedConnectionFactoryImpl object: " + this);
        }
        try {
            Properties connProps = new Properties();
            Connection con = null;
            ConnectionRequestInfoImpl infoImpl = null;
            if (this.descr.getDBConnectInfo() != null) {
                OpenSQLDataSource openSQLds = OpenSQLDataSource.newInstance();
                int connType = this.descr.isOpenSQL() ? 1 : (this.descr.isNativeSQL() ? 2 : 3);
                openSQLds.setConnectionType(connType);
                openSQLds.setDataSourceName(this.descr.getDBConnectInfo());
                OpenSQLProperties props = openSQLds.getOpenSQLProperties();
                props.setConnectionName(this.descr.getDataSourceName());
                props.setVmId(Integer.toString(PoolFrame.getAppContext().getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId()));
                props.setSystemDataSource(this.descr.isDefaultDS());
                if (info == null) {
                    if (this.descr.isOpenSQL()) {
                        return new CommonManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, openSQLds.getPooledConnection(), this.descr.getIsolationLevel(), this.mcid++);
                    }
                    if (this.descr.isNativeSQL()) {
                        return new DirectManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, openSQLds.getPooledConnection(), this.descr.getIsolationLevel(), this.mcid++);
                    }
                    return new LocalTXManagedConnectionImpl(this, infoImpl, openSQLds.getConnection(), this.descr.getIsolationLevel(), this.mcid++);
                }
                infoImpl = (ConnectionRequestInfoImpl)info;
                if (this.descr.isOpenSQL()) {
                    return new CommonManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, openSQLds.getPooledConnection(infoImpl.getUser(), infoImpl.getPassword()), this.descr.getIsolationLevel(), this.mcid++);
                }
                if (this.descr.isNativeSQL()) {
                    return new DirectManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, openSQLds.getPooledConnection(infoImpl.getUser(), infoImpl.getPassword()), this.descr.getIsolationLevel(), this.mcid++);
                }
                return new LocalTXManagedConnectionImpl(this, infoImpl, openSQLds.getConnection(infoImpl.getUser(), infoImpl.getPassword()), this.descr.getIsolationLevel(), this.mcid++);
            }
            if (info == null) {
                connProps.setProperty("user", this.descr.getUsername());
                connProps.setProperty("password", this.descr.getPassword());
            } else {
                infoImpl = (ConnectionRequestInfoImpl)info;
                connProps.setProperty("user", infoImpl.getUser());
                connProps.setProperty("password", infoImpl.getPassword());
            }
            Properties additionalProps = this.descr.getProps1x();
            if (additionalProps != null) {
                Enumeration enumeration = ((Hashtable)additionalProps).keys();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    connProps.setProperty(key, additionalProps.getProperty(key));
                }
            }
            if ((con = this.driver.connect(this.descr.getURL(), connProps)) == null) {
                throw new BaseResourceException("dbpool_0210");
            }
            Properties dbiProps = (Properties)((Hashtable)connProps).clone();
            dbiProps.setProperty("jndiName", this.descr.getDataSourceName());
            dbiProps.setProperty("systemDataSource", new Boolean(this.descr.isDefaultDS()).toString());
            if (PoolFrame.getAppContext() == null) {
                dbiProps.setProperty("clusterId", Integer.toString(-1));
            } else {
                dbiProps.setProperty("clusterId", Integer.toString(PoolFrame.getAppContext().getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId()));
            }
            if (this.descr.isOpenSQL()) {
                return new CommonManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, OpenSQLConnectionFactory.createCommonPooledConnection((Connection)con, (Properties)dbiProps), this.descr.getIsolationLevel(), this.mcid++);
            }
            if (this.descr.isNativeSQL()) {
                return new DirectManagedConnectionImpl((ManagedConnectionFactory)this, (ConnectionRequestInfo)infoImpl, OpenSQLConnectionFactory.createDirectPooledConnection((Connection)con, (Properties)dbiProps), this.descr.getIsolationLevel(), this.mcid++);
            }
            return new LocalTXManagedConnectionImpl(this, infoImpl, con, this.descr.getIsolationLevel(), this.mcid++);
        }
        catch (SQLException sex) {
            if (location.beLogged(500)) {
                location.logT(500, "ManagedConnectionFactoryImpl.createManagedConnection(): SQLException occured while creating ManagedConnection: " + sex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)sex);
            }
            throw new BaseResourceException("dbpool_0204", sex.toString(), (Throwable)sex);
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ManagedConnectionFactoryImpl.matchManagedConnections(): DataSource name = " + this.descr.getDataSourceName() + ". ManagedConnectionFactoryImpl object: " + this);
        }
        try {
            Iterator it = connectionSet.iterator();
            while (it.hasNext()) {
                LocalTXManagedConnectionImpl mc;
                ManagedConnectionFactory mcf;
                Object obj = it.next();
                if (!(obj instanceof LocalTXManagedConnectionImpl) || !(mcf = (mc = (LocalTXManagedConnectionImpl)obj).getManagedConnectionFactory()).equals((Object)this) || (info != null || mc.getConnectionRequestInfo() != null) && (info == null || !info.equals((Object)mc.getConnectionRequestInfo()))) continue;
                if (location.beLogged(100)) {
                    location.logT(100, "<-- ManagedConnectionFactoryImpl.matchManagedConnections(): DataSource name = " + this.descr.getDataSourceName() + ". ManagedConnectionFactoryImpl object: " + this + ". Matched ManagedConnection ID = " + mc);
                }
                return mc;
            }
            if (location.beLogged(100)) {
                location.logT(100, "<-- ManagedConnectionFactoryImpl.matchManagedConnections(): DataSource name = " + this.descr.getDataSourceName() + ". ManagedConnectionFactoryImpl object: " + this + ". Match not found.");
            }
            return null;
        }
        catch (Exception e) {
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "ManagedConnectionFactoryImpl.matchManagedConnections(): Exception occured while matching connections. Full stacktrace:", (Throwable)e);
            }
            return null;
        }
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ManagedConnectionFactoryImpl) {
            String objDSName = ((ManagedConnectionFactoryImpl)obj).descr.getDataSourceName();
            return this.descr.getDataSourceName().equals(objDSName);
        }
        return false;
    }

    public int hashCode() {
        return this.descr.getDataSourceName().hashCode();
    }

    public long getMCFID() {
        return this.mcfid;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.descr.getDBConnectInfo() == null) {
            ApplicationServiceContext serviceContext = PoolFrame.getAppContext();
            if (serviceContext != null) {
                Class<?> cl;
                if ("SYSTEM_DRIVER".equals(this.descr.getDriverName())) {
                    cl = Class.forName(this.descr.getDriverClassName());
                } else {
                    LoadContext classLoaderContext = serviceContext.getCoreContext().getLoadContext();
                    cl = classLoaderContext.getClassLoader("library:" + this.descr.getDriverName()).loadClass(this.descr.getDriverClassName());
                }
                try {
                    this.driver = (Driver)cl.newInstance();
                }
                catch (Exception ex) {
                    throw new BaseIOException("dbpool_0502", "at the server side ", (Throwable)ex);
                }
            }
            Class<?> cl = Class.forName(this.descr.getDriverClassName());
            try {
                this.driver = (Driver)cl.newInstance();
            }
            catch (Exception ex) {
                throw new BaseIOException("dbpool_0502", "at the client side ", (Throwable)ex);
            }
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return null;
    }

    public void setResourceAdapter(ResourceAdapter arg0) throws ResourceException {
    }

    public JDBCDescriptor getJDBCDescriptor() {
        return this.descr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

