/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.spi;

import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.spi.JDBCListenerWrapper;
import com.sap.engine.services.dbpool.spi.LocalTXManagedConnectionImpl;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.Iterator;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.PooledConnection;

public class CPManagedConnectionImpl
extends LocalTXManagedConnectionImpl {
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$spi$CPManagedConnectionImpl == null ? (class$com$sap$engine$services$dbpool$spi$CPManagedConnectionImpl = CPManagedConnectionImpl.class$("com.sap.engine.services.dbpool.spi.CPManagedConnectionImpl")) : class$com$sap$engine$services$dbpool$spi$CPManagedConnectionImpl));
    private PooledConnection pooledCon;
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$spi$CPManagedConnectionImpl;

    public CPManagedConnectionImpl(ManagedConnectionFactory mcf, ConnectionRequestInfo cri, PooledConnection pooledCon, int isolationLevel, long mcid) throws ResourceException {
        super(mcf, cri, pooledCon, isolationLevel, mcid);
        this.pooledCon = pooledCon;
    }

    public void destroy() throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> CPManagedConnectionImpl.destroy(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". CPManagedConnectionImpl ID = " + this + ". Full stacktrace: " + PoolFrame.getMessageAndStackTrace(new Exception()));
        }
        if (this.connectionEventListenerList != null && !this.connectionEventListenerList.isEmpty()) {
            Iterator iter = this.clone(this.connectionEventListenerList).iterator();
            while (iter.hasNext()) {
                ConnectionEventListener element = (ConnectionEventListener)iter.next();
                this.removeConnectionEventListener(element);
            }
        }
        super.destroy();
        try {
            this.pooledCon.close();
        }
        catch (SQLException ex) {
            this.throwBaseResourceException(ex);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- CPManagedConnectionImpl.destroy(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". CPManagedConnectionImpl ID = " + this);
        }
    }

    public void cleanup() throws ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> CPManagedConnectionImpl.cleanup(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". CPManagedConnectionImpl ID = " + this);
        }
        this.commonCleanup();
        try {
            this.con.close();
            this.con = this.pooledCon.getConnection();
        }
        catch (SQLException ex) {
            this.throwBaseResourceException(ex);
        }
        this.nonXACleanup();
        if (location.beLogged(100)) {
            location.logT(100, "<-- CPManagedConnectionImpl.cleanup(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". CPManagedConnectionImpl ID = " + this);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (location.beLogged(100)) {
            location.logT(100, "--> CPManagedConnectionImpl.addConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". CPManagedConnectionImpl ID = " + this + ". ConnectionEventListener object: " + listener);
        }
        super.addConnectionEventListener(listener);
        JDBCListenerWrapper jdbcListener = new JDBCListenerWrapper(listener, this);
        this.pooledCon.addConnectionEventListener(jdbcListener);
        if (location.beLogged(100)) {
            location.logT(100, "<-- CPManagedConnectionImpl.addConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". CPManagedConnectionImpl ID = " + this);
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (location.beLogged(100)) {
            location.logT(100, "--> CPManagedConnectionImpl.removeConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". CPManagedConnectionImpl ID = " + this + ". ConnectionEventListener object: " + listener);
        }
        if (listener == null) {
            return;
        }
        JDBCListenerWrapper jDBCListenerWrapper = new JDBCListenerWrapper(listener, this);
        this.pooledCon.removeConnectionEventListener(jDBCListenerWrapper);
        super.removeConnectionEventListener(listener);
        if (location.beLogged(100)) {
            location.logT(100, "<-- CPManagedConnectionImpl.removeConnectionEventListener(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". CPManagedConnectionImpl ID = " + this);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

