/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.opensql;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.opensql.TimeoutListenerAdapter;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.sql.j2ee.TimeoutListener;
import com.sap.sql.j2ee.TimeoutRegistry;
import com.sap.sql.log.CommonSQLException;
import com.sap.sql.log.ExceptionType;
import java.sql.SQLException;
import java.util.Hashtable;

public class TimeoutRegistryImpl
implements TimeoutRegistry {
    private static final String className = "TimeoutRegistryImpl";
    private TimeoutManager manager;
    private Hashtable listeners;

    public TimeoutRegistryImpl() throws SQLException {
        ApplicationServiceContext serviceContext = PoolFrame.getAppContext();
        if (serviceContext == null) {
            throw new CommonSQLException(className, className, ExceptionType.RESOURCE_NOT_AVAILABLE, "PoolFrame not yet initialized");
        }
        this.manager = (TimeoutManager)serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("timeout");
        this.listeners = new Hashtable();
    }

    public void addTimeoutListener(TimeoutListener timeoutListener, long delay, long period) {
        TimeoutListenerAdapter adapter = new TimeoutListenerAdapter(timeoutListener);
        this.listeners.put(timeoutListener, adapter);
        this.manager.registerTimeoutListener(adapter, delay, period);
    }

    public void removeTimeoutListener(TimeoutListener timeoutListener) {
        TimeoutListenerAdapter adapter = (TimeoutListenerAdapter)this.listeners.remove(timeoutListener);
        if (adapter != null) {
            this.manager.unregisterTimeoutListener(adapter);
        }
    }
}

