/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.opensql;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.opensql.MemoryListenerAdapter;
import com.sap.engine.services.memory.MemoryManager;
import com.sap.sql.j2ee.MemoryListener;
import com.sap.sql.j2ee.MemoryRegistry;
import com.sap.sql.log.CommonSQLException;
import com.sap.sql.log.ExceptionType;
import java.sql.SQLException;
import java.util.Hashtable;

public class MemoryRegistryImpl
implements MemoryRegistry {
    private static final String className = "MemoryRegistryImpl";
    private MemoryManager manager;
    private Hashtable listeners;

    public MemoryRegistryImpl() throws SQLException {
        ApplicationServiceContext serviceContext = PoolFrame.getAppContext();
        if (serviceContext == null) {
            throw new CommonSQLException(className, className, ExceptionType.RESOURCE_NOT_AVAILABLE, "PoolFrame not yet initialized");
        }
        this.manager = (MemoryManager)serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("memory");
        this.listeners = new Hashtable();
    }

    public void addMemoryListener(MemoryListener memoryListener) {
        MemoryListenerAdapter adapter = new MemoryListenerAdapter(memoryListener);
        int listenerID = this.manager.registerMemoryListener((com.sap.engine.services.memory.MemoryListener)adapter);
        this.listeners.put(memoryListener, new Integer(listenerID));
    }

    public void removeMemoryListener(MemoryListener memoryListener) {
        Object listenerID = this.listeners.remove(memoryListener);
        if (listenerID != null) {
            this.manager.unregisterMemoryListener(((Integer)listenerID).intValue());
        }
    }
}

