/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.gui;

import com.sap.engine.services.dbpool.deploy.StatementEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StatementsPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    JScrollPane jScrollPane1 = new JScrollPane();
    JList theList = new JList();
    JCheckBox checkBox;
    JButton addButton = new JButton();
    JButton removeButton = new JButton();
    JButton editButton = new JButton();
    JButton importBtn = new JButton();
    JButton exportBtn = new JButton();
    JButton modifyBtn = new JButton();
    JButton executeBtn = new JButton();
    ActionListener additional;
    Border border1 = new EtchedBorder(1, Color.white, new Color(134, 134, 134));
    TitledBorder titledBorder1;
    String title = "Title";
    String newText = "Enter name:";
    String editText = "Edit name:";
    String checkBoxText = "";
    Frame frame = null;
    Vector componentsVector = new Vector();
    protected ChangeListener listener;

    public StatementsPanel() throws Exception {
        this.init();
    }

    public StatementsPanel(String title, String newText, String editText, String checkBoxText, ActionListener additional) {
        this.title = title;
        this.newText = newText;
        this.editText = editText;
        this.checkBoxText = checkBoxText;
        this.additional = additional;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.addButton.setText("Add Statement");
        this.addButton.addActionListener(this);
        this.removeButton.setText("Remove Statement");
        this.removeButton.addActionListener(this);
        this.editButton.setText("Edit Statement");
        this.editButton.addActionListener(this);
        this.importBtn.setText("Import");
        this.importBtn.setToolTipText("Import SQL statements from XML");
        this.importBtn.addActionListener(this.additional);
        this.exportBtn.setText("Export");
        this.exportBtn.setToolTipText("Export all SQL statements to XML");
        this.exportBtn.addActionListener(this.additional);
        this.modifyBtn.setText("Save");
        this.modifyBtn.setToolTipText("Save current SQL statements");
        this.modifyBtn.addActionListener(this.additional);
        this.executeBtn.setText("Execute");
        this.executeBtn.setToolTipText("Save and execute current SQL statements");
        this.executeBtn.addActionListener(this.additional);
        this.checkBox = new JCheckBox(this.checkBoxText, false);
        this.checkBox.addActionListener(this);
        this.checkBox.setEnabled(false);
        this.titledBorder1 = new TitledBorder(this.border1, this.title);
        this.jScrollPane1.setBorder(this.titledBorder1);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 3, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 5, 5), 0, 0));
        this.add((Component)this.removeButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.editButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.checkBox, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.importBtn);
        buttonsPanel.add(this.exportBtn);
        buttonsPanel.add(this.modifyBtn);
        buttonsPanel.add(this.executeBtn);
        this.add((Component)buttonsPanel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.theList, null);
        this.theList.addListSelectionListener(this);
        this.theList.setSelectionMode(0);
    }

    public void setChangeListener(ChangeListener cl) {
        this.listener = cl;
    }

    public void setEnabled(boolean flag) {
        this.addButton.setEnabled(flag);
        this.removeButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.theList.setEnabled(flag);
        this.checkBox.setEnabled(flag);
        this.importBtn.setEnabled(flag);
        this.exportBtn.setEnabled(false);
        this.modifyBtn.setEnabled(flag);
        this.executeBtn.setEnabled(false);
    }

    public void initList(StatementEntry[] entries) {
        this.componentsVector.clear();
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                this.componentsVector.add(entries[i]);
                ++i;
            }
        }
        this.theList.setListData(this.componentsVector);
        if (this.componentsVector.isEmpty()) {
            this.exportBtn.setEnabled(false);
            this.executeBtn.setEnabled(false);
        } else {
            this.exportBtn.setEnabled(true);
            this.executeBtn.setEnabled(true);
        }
    }

    public StatementEntry[] getListDataArray() {
        return this.componentsVector.toArray(new StatementEntry[this.componentsVector.size()]);
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.addButton) {
            this.addButtonAction();
        } else if (src == this.removeButton) {
            this.removeButtonAction();
        } else if (src == this.editButton) {
            this.editButtonAction();
        }
        if (e.getSource() == this.checkBox && !this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            StatementEntry se = (StatementEntry)this.componentsVector.get(index);
            StatementEntry newSE = new StatementEntry(se.getStatement(), this.checkBox.isSelected());
            this.componentsVector.setElementAt(newSE, index);
        }
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    private void addButtonAction() {
        String component = JOptionPane.showInputDialog(this.frame, this.newText, "New Statement", -1);
        if (component == null) {
            return;
        }
        if ((component = component.trim()).length() == 0) {
            return;
        }
        StatementEntry se = new StatementEntry(component, false);
        this.componentsVector.add(se);
        this.theList.setListData(this.componentsVector);
        this.exportBtn.setEnabled(true);
        this.executeBtn.setEnabled(true);
    }

    private void removeButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            this.componentsVector.remove(index);
            this.theList.setListData(this.componentsVector);
            if (this.componentsVector.isEmpty()) {
                this.exportBtn.setEnabled(false);
                this.executeBtn.setEnabled(false);
            }
        }
    }

    public void editButtonAction() {
        if (!this.theList.isSelectionEmpty()) {
            int index = this.theList.getSelectedIndex();
            StatementEntry se = (StatementEntry)this.componentsVector.get(index);
            String value = se.getStatement();
            String name = (String)JOptionPane.showInputDialog(this.frame, this.editText, "Edit Statement", -1, null, null, value);
            if (name == null) {
                return;
            }
            if ((name = name.trim()).length() == 0) {
                return;
            }
            StatementEntry newSE = new StatementEntry(name, se.getIgnoreError());
            this.componentsVector.setElementAt(newSE, index);
            this.theList.setListData(this.componentsVector);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.theList.isSelectionEmpty()) {
            this.removeButton.setEnabled(true);
            this.editButton.setEnabled(true);
            this.checkBox.setEnabled(true);
            int index = this.theList.getSelectedIndex();
            StatementEntry se = (StatementEntry)this.componentsVector.get(index);
            this.checkBox.setSelected(se.getIgnoreError());
        } else {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.checkBox.setEnabled(false);
        }
    }
}

