/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.gui;

import com.sap.engine.services.dbpool.gui.ErrorDialog;
import com.sap.engine.services.dbpool.gui.PropertiesTableModel;
import com.sap.engine.services.dbpool.gui.PropsEditorLogical;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SimpleListPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    JTable table = new JTable();
    JButton addButton = new JButton();
    JButton removeButton = new JButton();
    JButton redirectButton = new JButton();
    String title = "Title";
    String newText = "Enter name:";
    String redirectText = "Redirect to:";
    String addBtnText = "Add";
    String removeBtnText = "Remove";
    String redirectBtnText = "Redirect";
    Frame frame = null;
    protected PropertiesTableModel tableModel;
    protected ChangeListener listener;
    private PropsEditorLogical jdbcConnectorGUI = null;

    public SimpleListPanel() {
        this.tableModel = new PropertiesTableModel();
        this.init();
    }

    public SimpleListPanel(String title, String newText, String redirectText, String addButtonText, String removeButtonText, String redirectButtonText, String keyColumnName, String valueColumnName) {
        this.tableModel = new PropertiesTableModel(keyColumnName, valueColumnName);
        this.title = title;
        this.newText = newText;
        this.redirectText = redirectText;
        this.addBtnText = addButtonText;
        this.removeBtnText = removeButtonText;
        this.redirectBtnText = redirectButtonText;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.addButton.setText(this.addBtnText);
        this.addButton.addActionListener(this);
        this.removeButton.setText(this.removeBtnText);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        this.redirectButton.setText(this.redirectBtnText);
        this.redirectButton.setEnabled(false);
        this.redirectButton.addActionListener(this);
        EtchedBorder border1 = new EtchedBorder(1, Color.white, new Color(134, 134, 134));
        TitledBorder titledBorder1 = new TitledBorder(border1, this.title);
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setBorder(titledBorder1);
        this.add((Component)jScrollPane1, new GridBagConstraints(0, 0, 1, 3, 0.1, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 5, 5), 0, 0));
        this.add((Component)this.removeButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.redirectButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        jScrollPane1.getViewport().add((Component)this.table, null);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setModel(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(this);
    }

    public void setChangeListener(ChangeListener cl) {
        this.listener = cl;
    }

    public void setJdbcConnectorGUI(PropsEditorLogical gui) {
        this.jdbcConnectorGUI = gui;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void setTableContents(Vector contents) {
        this.tableModel.clearAll();
        this.table.getSelectionModel().clearSelection();
        if (contents == null) {
            return;
        }
        Enumeration enumeration = contents.elements();
        while (enumeration.hasMoreElements()) {
            String[] row = (String[])enumeration.nextElement();
            this.tableModel.addRow(row[0], row[1]);
        }
    }

    public Vector getTableContents() {
        Vector<String[]> contents = new Vector<String[]>();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            contents.add(new String[]{(String)this.tableModel.getValueAt(i, 0), (String)this.tableModel.getValueAt(i, 1)});
            ++i;
        }
        return contents;
    }

    public String[] getListDataArray() {
        Vector<Object> column1 = new Vector<Object>();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            String deployer = (String)this.tableModel.getValueAt(i, 1);
            if (deployer.endsWith(" DataSource")) {
                column1.add(this.tableModel.getValueAt(i, 0));
            }
            ++i;
        }
        return column1.toArray(new String[0]);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.addButtonAction();
        } else if (e.getSource() == this.removeButton) {
            this.removeButtonAction();
        } else if (e.getSource() == this.redirectButton) {
            this.redirectButtonAction();
        }
        this.valueChanged(null);
    }

    private void addButtonAction() {
        String alias = JOptionPane.showInputDialog(this.frame, this.newText, this.addBtnText, -1);
        if (alias == null) {
            return;
        }
        if ((alias = alias.trim()).length() == 0) {
            return;
        }
        try {
            String message = this.jdbcConnectorGUI.addAlias(alias);
            if (!"Aliases will not be modified".equals(message)) {
                if (message != null && !"".equals(message)) {
                    JOptionPane.showMessageDialog(this.frame, message, "Info", 1);
                }
                this.tableModel.addRow(alias, this.jdbcConnectorGUI.getCurrentDSName().concat(" DataSource"));
            }
        }
        catch (RemoteException rex) {
            ErrorDialog.showErrorDialog(this.frame, "Error occured while adding alias:\n" + alias, rex);
        }
    }

    private void removeButtonAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        String alias = (String)this.tableModel.getValueAt(selRow, 0);
        String deployer = this.tableModel.getValueAt(selRow, 1).toString();
        try {
            String message = this.jdbcConnectorGUI.removeAlias(alias, deployer, false);
            if (!"Aliases will not be modified".equals(message)) {
                if (message != null && !"".equals(message)) {
                    JOptionPane.showMessageDialog(this.frame, message, "Info", 1);
                }
                this.tableModel.removeRow(selRow);
            }
        }
        catch (RemoteException rex) {
            ErrorDialog.showErrorDialog(this.frame, "Error occured while removing alias:\n" + alias, rex);
        }
    }

    public void redirectButtonAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        String alias = (String)this.tableModel.getValueAt(selRow, 0);
        String newDS = JOptionPane.showInputDialog(this.frame, this.redirectText.concat(" '").concat(alias).concat("':"), this.redirectBtnText, -1);
        if (newDS == null) {
            return;
        }
        if ((newDS = newDS.trim()).length() == 0) {
            return;
        }
        String appNameOfNewDS = this.jdbcConnectorGUI.getAppNameForDS(newDS);
        if (appNameOfNewDS == null) {
            JOptionPane.showMessageDialog(this.frame, "DataSource '" + newDS + "' does not exist", "Info", 1);
            return;
        }
        if (JOptionPane.showConfirmDialog(this.frame, "If redirect operation affects applications, your changes\nwill be lost when you redeploy these applications.\nWould you like to continue?", "Question", 0) == 1) {
            return;
        }
        try {
            String message = "";
            Vector<String> deployers = new Vector<String>();
            int i = 0;
            while (i < this.tableModel.getRowCount()) {
                if (alias.equals(this.tableModel.getValueAt(i, 0))) {
                    String deployer = this.tableModel.getValueAt(i, 1).toString();
                    deployers.add(deployer);
                    String localMessage = this.jdbcConnectorGUI.removeAlias(alias, deployer, true);
                    if (localMessage == null) {
                        JOptionPane.showMessageDialog(this.frame, "You cannot redirect alias which was not previously deployed", "Info", 1);
                        return;
                    }
                    if (localMessage.equals("Aliases will not be modified")) {
                        return;
                    }
                    if ("".equals(message)) {
                        message = localMessage;
                    }
                }
                ++i;
            }
            boolean hasMore = true;
            while (hasMore) {
                hasMore = false;
                int i2 = 0;
                while (i2 < this.tableModel.getRowCount()) {
                    if (alias.equals(this.tableModel.getValueAt(i2, 0))) {
                        this.tableModel.removeRow(i2);
                        hasMore = true;
                    }
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < deployers.size()) {
                String deployer = (String)deployers.get(i3);
                if (deployer.endsWith(" DataSource")) {
                    String localMessage = this.jdbcConnectorGUI.addAliasToDS(alias, newDS, appNameOfNewDS, message);
                    if ("".equals(message)) {
                        message = localMessage;
                    }
                    deployers.remove(i3);
                    break;
                }
                ++i3;
            }
            int i4 = 0;
            while (i4 < deployers.size()) {
                String deployer = (String)deployers.get(i4);
                String localMessage = this.jdbcConnectorGUI.addAliasToAppLibOrServ(alias, newDS, deployer);
                if ("".equals(message)) {
                    message = localMessage;
                }
                ++i4;
            }
            if (!"".equals(message)) {
                JOptionPane.showMessageDialog(this.frame, message, "Info", 1);
            }
        }
        catch (RemoteException rex) {
            ErrorDialog.showErrorDialog(this.frame, "Error occured while redirecting alias:\n" + alias, rex);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.removeButton.setEnabled(false);
            this.redirectButton.setEnabled(false);
        } else {
            this.removeButton.setEnabled(true);
            this.redirectButton.setEnabled(true);
        }
    }
}

