/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.gui;

import com.sap.engine.gui.CScrollField;
import com.sap.engine.gui.diagram.DoubleDiagramPanel;
import com.sap.engine.services.dbpool.gui.LibraryTreeCellRenderer;
import com.sap.engine.services.dbpool.gui.PropertyEditor;
import com.sap.engine.services.dbpool.gui.SimpleListPanel;
import com.sap.engine.services.dbpool.gui.StatementsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class PropsEditorView
extends JPanel
implements ActionListener,
ItemListener,
TreeSelectionListener,
ChangeListener,
DocumentListener,
AdjustmentListener {
    public static final String IMAGES_DIR = "images/";
    protected static String[] OPEN_SQL_ISOLATION_COMBO = new String[]{"DEFAULT", "TRANSACTION_READ_UNCOMMITTED", "TRANSACTION_READ_COMMITTED"};
    protected static String[] THE_REST_ISOLATION_VALUES = new String[]{"TRANSACTION_NONE", "TRANSACTION_REPEATABLE_READ", "TRANSACTION_SERIALIZABLE"};
    protected static String[] JDBC_VER_COMBO = new String[]{"1.x (no XA support)", "2.0 (with XA support)"};
    protected static String[] XADS_CPDS_COMBO = new String[]{"ConnectionPoolDataSource", "XADataSource"};
    protected Frame frame;
    protected JTabbedPane tabPane = new JTabbedPane();
    private boolean isDSPaneLoaded = false;
    private boolean isDrvPaneLoaded = false;
    protected JButton importBtn;
    protected JButton exportBtn;
    protected JButton defDrvBtn;
    protected JButton undefDrvBtn;
    protected JButton newBtn;
    protected JButton removeBtn;
    protected JButton saveBtn;
    protected JButton refreshBtn;
    protected JButton startBtn;
    protected JButton stopBtn;
    protected JButton copyBtn;
    protected JButton pasteBtn;
    protected JPanel poolsPanel;
    protected JTree resTree;
    protected DefaultMutableTreeNode resTreeRoot;
    protected DefaultTreeModel resTreeModel;
    protected DefaultMutableTreeNode sysDSNode;
    protected DefaultMutableTreeNode dsNode;
    protected DefaultMutableTreeNode drvNode;
    protected TreePath dsNodePath;
    protected TreePath drvNodePath;
    protected PropertyEditor propertyEditor;
    protected JPanel poolSettingsPanel;
    protected JPanel settingsPanel;
    protected SimpleListPanel aliasesPanel;
    protected JPanel jdbc1Panel;
    protected JPanel jdbc2Panel;
    protected JTextField appNameField;
    protected JTextField nameField;
    protected JTextField descrField;
    protected JTextField urlField;
    protected JTextField userField;
    protected JPasswordField passField;
    protected JComboBox jdbcVerComboBox;
    protected JComboBox driverComboBox;
    protected JComboBox cpdsComboBox;
    protected JTextField driverField;
    protected JTextField factoryField;
    protected JTextField cpdsNameField;
    protected JTextField xadsNameField;
    protected JLabel cpdsLabel;
    protected JLabel xadsLabel;
    protected JPanel driversPanel;
    protected JTree libTree;
    protected DefaultMutableTreeNode libTreeRoot;
    protected DefaultTreeModel libTreeModel;
    protected JPanel additionalPanel;
    protected JPanel connectionPoolingPanel;
    protected JPanel dbiPanel;
    protected JRadioButton openSQLButton;
    protected JRadioButton nativeSQLButton;
    protected JRadioButton vendorSQLButton;
    protected JCheckBox expCheckBox;
    protected CScrollField connLifeField;
    protected CScrollField runThreadField;
    protected CScrollField initConnField;
    protected CScrollField maxConnField;
    protected CScrollField ttwConnField;
    protected JComboBox isolation;
    protected MutableComboBoxModel isolationModel;
    protected JPanel dbInitPanel;
    protected StatementsPanel statementsPanel;
    protected JPanel diagramsPanel;
    protected DoubleDiagramPanel doubleDiagram;
    protected Object isoCBoxLastSel = "";
    protected Object cpdsCBoxLastSel = "";
    protected Object verCBoxLastSel = "";

    public PropsEditorView() {
        this.initView();
    }

    public void initView() {
        this.importBtn = new JButton(new ImageIcon(this.getClass().getResource("images/import.gif")));
        this.importBtn.setToolTipText("Import DataSources from XML");
        this.importBtn.addActionListener(this);
        this.importBtn.setEnabled(true);
        this.exportBtn = new JButton(new ImageIcon(this.getClass().getResource("images/export.gif")));
        this.exportBtn.setToolTipText("Export Selected/All DataSources to XML");
        this.exportBtn.addActionListener(this);
        this.defDrvBtn = new JButton(new ImageIcon(this.getClass().getResource("images/define.gif")));
        this.defDrvBtn.addActionListener(this);
        this.defDrvBtn.setToolTipText("Mark a Library as JDBC Driver");
        this.undefDrvBtn = new JButton(new ImageIcon(this.getClass().getResource("images/undefine.gif")));
        this.undefDrvBtn.addActionListener(this);
        this.undefDrvBtn.setToolTipText("Unmark Selected JDBC Driver");
        this.newBtn = new JButton(new ImageIcon(this.getClass().getResource("images/add.gif")));
        this.newBtn.setToolTipText("Create New Driver or DataSource");
        this.newBtn.addActionListener(this);
        this.removeBtn = new JButton(new ImageIcon(this.getClass().getResource("images/remove.gif")));
        this.removeBtn.setToolTipText("Remove Selected Driver, Standalone Application or DataSource");
        this.removeBtn.addActionListener(this);
        this.saveBtn = new JButton(new ImageIcon(this.getClass().getResource("images/save.gif")));
        this.saveBtn.setToolTipText("Save Changes");
        this.saveBtn.addActionListener(this);
        this.refreshBtn = new JButton(new ImageIcon(this.getClass().getResource("images/reload.gif")));
        this.refreshBtn.setToolTipText("Refresh");
        this.refreshBtn.addActionListener(this);
        this.refreshBtn.setEnabled(true);
        this.startBtn = new JButton(new ImageIcon(this.getClass().getResource("images/start.gif")));
        this.startBtn.setToolTipText("Start Selected Standalone Application");
        this.startBtn.addActionListener(this);
        this.stopBtn = new JButton(new ImageIcon(this.getClass().getResource("images/stop.gif")));
        this.stopBtn.setToolTipText("Stop Selected Standalone Application");
        this.stopBtn.addActionListener(this);
        this.copyBtn = new JButton(new ImageIcon(this.getClass().getResource("images/copy.gif")));
        this.copyBtn.setToolTipText("Copy All DataSource Properties");
        this.copyBtn.addActionListener(this);
        this.pasteBtn = new JButton(new ImageIcon(this.getClass().getResource("images/paste.gif")));
        this.pasteBtn.setToolTipText("Paste All DataSource Properties");
        this.pasteBtn.addActionListener(this);
        this.initPoolsPanel();
        this.initConnectionPoolingPanel();
        this.initJDBCPanel1x();
        this.initJDBCPanel20();
        this.initSettingsPanel();
        this.initDriversPanel();
        this.initPoolSettingsPanel();
        this.initSQLEnginePanel();
        this.initAdditionalPanel();
        this.initDBInitPanel();
        this.initMonitoring();
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, true, this.poolsPanel, this.tabPane);
        splitPane.setDividerLocation(212);
        this.add((Component)splitPane, "Center");
    }

    private void initPoolsPanel() {
        this.poolsPanel = new JPanel(new GridBagLayout());
        this.poolsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "DataSources and JDBC Drivers"));
        this.initResourcesTree();
        JScrollPane resTreeScroll = new JScrollPane(this.resTree);
        resTreeScroll.setPreferredSize(new Dimension(20, 40));
        this.poolsPanel.add((Component)resTreeScroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void initPoolSettingsPanel() {
        this.poolSettingsPanel = new JPanel();
        this.poolSettingsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.poolSettingsPanel.setLayout(new GridBagLayout());
        JPanel additionalPanel = new JPanel();
        additionalPanel.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Application Name:");
        additionalPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.appNameField = new JTextField();
        additionalPanel.add((Component)this.appNameField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.poolSettingsPanel.add((Component)additionalPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.poolSettingsPanel.add((Component)this.settingsPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void initAdditionalPanel() {
        this.additionalPanel = new JPanel();
        this.additionalPanel.setLayout(new GridBagLayout());
        this.additionalPanel.setBorder(BorderFactory.createEtchedBorder());
        this.propertyEditor = new PropertyEditor();
        this.propertyEditor.setBorder(BorderFactory.createTitledBorder("Additional Properties"));
        this.propertyEditor.setChangeListener(this);
        this.additionalPanel.add((Component)this.propertyEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.additionalPanel.add((Component)this.connectionPoolingPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.additionalPanel.add((Component)this.dbiPanel, new GridBagConstraints(0, 2, 0, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void initSettingsPanel() {
        this.settingsPanel = new JPanel();
        this.settingsPanel.setBorder(BorderFactory.createTitledBorder("DataSource"));
        this.settingsPanel.setLayout(new GridBagLayout());
        JPanel additionalPanel = new JPanel();
        additionalPanel.setLayout(new GridBagLayout());
        JLabel label = new JLabel("* Name:");
        additionalPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.nameField = new JTextField();
        additionalPanel.add((Component)this.nameField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        label = new JLabel("Description:");
        additionalPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.descrField = new JTextField();
        additionalPanel.add((Component)this.descrField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.settingsPanel.add((Component)additionalPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.aliasesPanel = new SimpleListPanel("", "Enter alias:", "Enter DataSource name for alias", "Add Alias", "Remove Alias", "Redirect Alias", "Alias", "Deployer");
        this.aliasesPanel.setBorder(BorderFactory.createTitledBorder("Aliases"));
        this.aliasesPanel.setChangeListener(this);
        this.settingsPanel.add((Component)this.aliasesPanel, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        additionalPanel = new JPanel();
        additionalPanel.setLayout(new GridBagLayout());
        label = new JLabel("Driver Name:");
        additionalPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.driverComboBox = new JComboBox();
        additionalPanel.add((Component)this.driverComboBox, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        label = new JLabel("JDBC Version:");
        additionalPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jdbcVerComboBox = new JComboBox<String>(JDBC_VER_COMBO);
        this.verCBoxLastSel = JDBC_VER_COMBO[0];
        this.jdbcVerComboBox.setSelectedIndex(0);
        additionalPanel.add((Component)this.jdbcVerComboBox, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.settingsPanel.add((Component)additionalPanel, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.addJDBCPanel1x();
    }

    private void initConnectionPoolingPanel() {
        this.connectionPoolingPanel = new JPanel();
        this.connectionPoolingPanel.setBorder(BorderFactory.createTitledBorder("Connection Pooling"));
        this.connectionPoolingPanel.setLayout(new GridBagLayout());
        JLabel label = new JLabel("Initial Connections:");
        this.connectionPoolingPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.initConnField = new CScrollField();
        this.initConnField.setMinimumValue(0);
        this.initConnField.setMaximumValue(Integer.MAX_VALUE);
        this.connectionPoolingPanel.add((Component)this.initConnField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        label = new JLabel("Maximum Connections:");
        this.connectionPoolingPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.maxConnField = new CScrollField();
        this.maxConnField.setMinimumValue(1);
        this.maxConnField.setValue(25);
        this.maxConnField.setMaximumValue(Integer.MAX_VALUE);
        this.connectionPoolingPanel.add((Component)this.maxConnField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        label = new JLabel("Maximum Time to Wait for Connection:");
        this.connectionPoolingPanel.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.ttwConnField = new CScrollField();
        this.ttwConnField.setMinimumValue(0);
        this.ttwConnField.setValue(60);
        this.ttwConnField.setMaximumValue(Integer.MAX_VALUE);
        this.connectionPoolingPanel.add((Component)this.ttwConnField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        label = new JLabel("Expiration:");
        this.connectionPoolingPanel.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.expCheckBox = new JCheckBox("", false);
        this.expCheckBox.addItemListener(this);
        this.connectionPoolingPanel.add((Component)this.expCheckBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        label = new JLabel("Connection Lifetime:");
        this.connectionPoolingPanel.add((Component)label, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.connLifeField = new CScrollField();
        this.connLifeField.setMinimumValue(0);
        this.connLifeField.setValue(600);
        this.connLifeField.setMaximumValue(Integer.MAX_VALUE);
        this.connectionPoolingPanel.add((Component)this.connLifeField, new GridBagConstraints(3, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        label = new JLabel("Cleanup Thread:");
        this.connectionPoolingPanel.add((Component)label, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.runThreadField = new CScrollField();
        this.runThreadField.setMinimumValue(0);
        this.runThreadField.setValue(60);
        this.runThreadField.setMaximumValue(Integer.MAX_VALUE);
        this.connectionPoolingPanel.add((Component)this.runThreadField, new GridBagConstraints(3, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.connLifeField.setEnabled(false);
        this.runThreadField.setEnabled(false);
        label = new JLabel("Default Connection Isolation:");
        this.connectionPoolingPanel.add((Component)label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.isolation = new JComboBox<String>(OPEN_SQL_ISOLATION_COMBO);
        this.isoCBoxLastSel = OPEN_SQL_ISOLATION_COMBO[0];
        this.isolation.setSelectedIndex(0);
        this.isolationModel = (MutableComboBoxModel)this.isolation.getModel();
        this.connectionPoolingPanel.add((Component)this.isolation, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
    }

    protected void initSQLEnginePanel() {
        this.dbiPanel = new JPanel();
        this.dbiPanel.setBorder(BorderFactory.createTitledBorder("SQL Engine"));
        this.dbiPanel.setLayout(new GridBagLayout());
        ButtonGroup bg = new ButtonGroup();
        this.openSQLButton = new JRadioButton("Open SQL", true);
        this.nativeSQLButton = new JRadioButton("Native SQL", false);
        this.vendorSQLButton = new JRadioButton("Vendor SQL", false);
        bg.add(this.openSQLButton);
        bg.add(this.nativeSQLButton);
        bg.add(this.vendorSQLButton);
        this.dbiPanel.add((Component)this.openSQLButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.dbiPanel.add((Component)this.nativeSQLButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.dbiPanel.add((Component)this.vendorSQLButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void initDriversPanel() {
        this.driversPanel = new JPanel();
        this.driversPanel.setLayout(new GridBagLayout());
        this.initLibrariesTree();
        JScrollPane libTreeScroll = new JScrollPane(this.libTree);
        this.driversPanel.add((Component)libTreeScroll, new GridBagConstraints(0, 0, 1, 4, 0.4, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initLibrariesTree() {
        this.libTreeRoot = new DefaultMutableTreeNode("Libraries:");
        this.libTree = new JTree(this.libTreeRoot);
        this.libTree.getSelectionModel().setSelectionMode(1);
        this.libTree.putClientProperty("JTree.lineStyle", "Angled");
        this.libTree.addTreeSelectionListener(this);
        this.libTreeModel = (DefaultTreeModel)this.libTree.getModel();
        LibraryTreeCellRenderer renderer = new LibraryTreeCellRenderer(this.libTreeRoot);
        this.libTree.setCellRenderer(renderer);
    }

    protected void initResourcesTree() {
        this.resTreeRoot = new DefaultMutableTreeNode("Resources");
        this.resTree = new JTree(this.resTreeRoot);
        this.resTree.getSelectionModel().setSelectionMode(1);
        this.resTree.putClientProperty("JTree.lineStyle", "Angled");
        this.resTree.addTreeSelectionListener(this);
        this.resTreeModel = (DefaultTreeModel)this.resTree.getModel();
        this.resTreeModel.setRoot(this.resTreeRoot);
        this.sysDSNode = null;
        this.dsNode = new DefaultMutableTreeNode("DataSources");
        this.drvNode = new DefaultMutableTreeNode("Drivers");
        this.resTreeModel.insertNodeInto(this.dsNode, this.resTreeRoot, 0);
        this.resTreeModel.insertNodeInto(this.drvNode, this.resTreeRoot, 1);
        this.dsNodePath = new TreePath(this.resTreeModel.getPathToRoot(this.dsNode));
        this.drvNodePath = new TreePath(this.resTreeModel.getPathToRoot(this.drvNode));
        this.resTree.expandRow(0);
    }

    protected void initJDBCPanel1x() {
        this.jdbc1Panel = new JPanel();
        this.jdbc1Panel.setLayout(new GridBagLayout());
        this.jdbc1Panel.setBorder(BorderFactory.createTitledBorder("JDBC 1.x Compliant"));
        JLabel label = new JLabel("* Driver Class:");
        this.jdbc1Panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.driverField = new JTextField();
        this.jdbc1Panel.add((Component)this.driverField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        label = new JLabel("* Database URL:");
        this.jdbc1Panel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.urlField = new JTextField();
        this.jdbc1Panel.add((Component)this.urlField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        JPanel additionalPanel = new JPanel();
        additionalPanel.setLayout(new GridBagLayout());
        label = new JLabel("* User:");
        additionalPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 53, 2, 2), 0, 0));
        this.userField = new JTextField(){

            public Dimension getPreferredSize() {
                return new Dimension(0, 22);
            }
        };
        additionalPanel.add((Component)this.userField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        label = new JLabel("* Password:");
        additionalPanel.add((Component)label, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.passField = new JPasswordField(){

            public Dimension getPreferredSize() {
                return new Dimension(0, 22);
            }
        };
        additionalPanel.add((Component)this.passField, new GridBagConstraints(3, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 0), 0, 0));
        this.jdbc1Panel.add((Component)additionalPanel, new GridBagConstraints(0, 3, 0, 1, 0.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
    }

    protected void initJDBCPanel20() {
        this.jdbc2Panel = new JPanel();
        this.jdbc2Panel.setLayout(new GridBagLayout());
        this.jdbc2Panel.setBorder(BorderFactory.createTitledBorder("JDBC 2.0 Compliant"));
        JLabel label = new JLabel("Object Factory:");
        this.jdbc2Panel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.factoryField = new JTextField();
        this.jdbc2Panel.add((Component)this.factoryField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        label = new JLabel("DataSource Type:");
        this.jdbc2Panel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.cpdsLabel = new JLabel("* CPDS Classname:");
        this.xadsLabel = new JLabel("* XADS Classname:");
        this.cpdsNameField = new JTextField();
        this.xadsNameField = new JTextField();
        this.cpdsComboBox = new JComboBox<String>(XADS_CPDS_COMBO);
        this.cpdsCBoxLastSel = XADS_CPDS_COMBO[1];
        this.cpdsComboBox.setSelectedIndex(1);
        this.jdbc2Panel.add((Component)this.cpdsComboBox, new GridBagConstraints(1, 1, 0, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.addXADSPanel();
    }

    protected void initDBInitPanel() {
        this.dbInitPanel = new JPanel();
        this.dbInitPanel.setLayout(new GridBagLayout());
        this.dbInitPanel.setBorder(BorderFactory.createEtchedBorder());
        this.statementsPanel = new StatementsPanel("", "Enter SQL Statement:", "Edit SQL Statement:", "Ignore Error", this);
        this.statementsPanel.setBorder(BorderFactory.createTitledBorder("SQL Statements"));
        this.dbInitPanel.add((Component)this.statementsPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    protected void initMonitoring() {
        this.diagramsPanel = new JPanel(new BorderLayout());
        this.doubleDiagram = new DoubleDiagramPanel(false);
    }

    protected void addJDBCPanel1x() {
        this.settingsPanel.remove(this.jdbc2Panel);
        this.settingsPanel.add((Component)this.jdbc1Panel, new GridBagConstraints(0, 3, 0, 1, 0.1, 0.1, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.settingsPanel.invalidate();
        this.settingsPanel.validate();
        this.settingsPanel.repaint();
    }

    protected void addJDBCPanel20() {
        this.settingsPanel.remove(this.jdbc1Panel);
        this.settingsPanel.add((Component)this.jdbc2Panel, new GridBagConstraints(0, 3, 0, 1, 0.1, 0.1, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.settingsPanel.invalidate();
        this.settingsPanel.validate();
        this.settingsPanel.repaint();
    }

    protected void addCPDSPanel() {
        this.jdbc2Panel.remove(this.xadsLabel);
        this.jdbc2Panel.remove(this.xadsNameField);
        this.jdbc2Panel.add((Component)this.cpdsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jdbc2Panel.add((Component)this.cpdsNameField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jdbc2Panel.invalidate();
        this.jdbc2Panel.validate();
        this.jdbc2Panel.repaint();
    }

    protected void addXADSPanel() {
        this.jdbc2Panel.remove(this.cpdsLabel);
        this.jdbc2Panel.remove(this.cpdsNameField);
        this.jdbc2Panel.add((Component)this.xadsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.jdbc2Panel.add((Component)this.xadsNameField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.jdbc2Panel.invalidate();
        this.jdbc2Panel.validate();
        this.jdbc2Panel.repaint();
    }

    protected void clearTabPane() {
        if (this.isDSPaneLoaded || this.isDrvPaneLoaded) {
            this.isDSPaneLoaded = false;
            this.isDrvPaneLoaded = false;
            this.tabPane.removeAll();
        }
    }

    protected void loadDSTabPane() {
        if (!this.isDSPaneLoaded) {
            this.clearTabPane();
            this.tabPane.add((Component)this.poolSettingsPanel, "Main");
            this.tabPane.add((Component)this.additionalPanel, "Additional");
            this.tabPane.add((Component)this.dbInitPanel, "DB Initialization");
            this.tabPane.add((Component)this.diagramsPanel, "Monitoring");
            this.tabPane.invalidate();
            this.tabPane.validate();
            this.tabPane.repaint();
            this.isDSPaneLoaded = true;
        }
    }

    protected void loadDriversTabPane() {
        if (!this.isDrvPaneLoaded) {
            this.clearTabPane();
            this.tabPane.add((Component)this.driversPanel, "Deployed Libraries");
            this.tabPane.invalidate();
            this.tabPane.validate();
            this.tabPane.repaint();
            this.isDrvPaneLoaded = true;
        }
    }

    protected void enableListeners() {
        this.appNameField.getDocument().addDocumentListener(this);
        this.nameField.getDocument().addDocumentListener(this);
        this.descrField.getDocument().addDocumentListener(this);
        this.urlField.getDocument().addDocumentListener(this);
        this.userField.getDocument().addDocumentListener(this);
        this.passField.getDocument().addDocumentListener(this);
        this.driverField.getDocument().addDocumentListener(this);
        this.factoryField.getDocument().addDocumentListener(this);
        this.cpdsNameField.getDocument().addDocumentListener(this);
        this.xadsNameField.getDocument().addDocumentListener(this);
        this.openSQLButton.addChangeListener(this);
        this.nativeSQLButton.addChangeListener(this);
        this.vendorSQLButton.addChangeListener(this);
        this.driverComboBox.addItemListener(this);
        this.jdbcVerComboBox.addItemListener(this);
        this.cpdsComboBox.addItemListener(this);
        this.isolation.addItemListener(this);
        this.expCheckBox.addItemListener(this);
        this.connLifeField.addAdjustmentListener((AdjustmentListener)this);
        this.runThreadField.addAdjustmentListener((AdjustmentListener)this);
        this.initConnField.addAdjustmentListener((AdjustmentListener)this);
        this.maxConnField.addAdjustmentListener((AdjustmentListener)this);
        this.ttwConnField.addAdjustmentListener((AdjustmentListener)this);
    }

    protected void disableListeners() {
        this.appNameField.getDocument().removeDocumentListener(this);
        this.nameField.getDocument().removeDocumentListener(this);
        this.descrField.getDocument().removeDocumentListener(this);
        this.urlField.getDocument().removeDocumentListener(this);
        this.userField.getDocument().removeDocumentListener(this);
        this.passField.getDocument().removeDocumentListener(this);
        this.driverField.getDocument().removeDocumentListener(this);
        this.factoryField.getDocument().removeDocumentListener(this);
        this.cpdsNameField.getDocument().removeDocumentListener(this);
        this.xadsNameField.getDocument().removeDocumentListener(this);
        this.openSQLButton.removeChangeListener(this);
        this.nativeSQLButton.removeChangeListener(this);
        this.vendorSQLButton.removeChangeListener(this);
        this.driverComboBox.removeItemListener(this);
        this.jdbcVerComboBox.removeItemListener(this);
        this.cpdsComboBox.removeItemListener(this);
        this.isolation.removeItemListener(this);
        this.expCheckBox.removeItemListener(this);
        this.connLifeField.removeAdjustmentListener((AdjustmentListener)this);
        this.runThreadField.removeAdjustmentListener((AdjustmentListener)this);
        this.initConnField.removeAdjustmentListener((AdjustmentListener)this);
        this.maxConnField.removeAdjustmentListener((AdjustmentListener)this);
        this.ttwConnField.removeAdjustmentListener((AdjustmentListener)this);
    }

    public abstract void actionPerformed(ActionEvent var1);

    public abstract void itemStateChanged(ItemEvent var1);

    public abstract void valueChanged(TreeSelectionEvent var1);

    public abstract void stateChanged(ChangeEvent var1);

    public abstract void changedUpdate(DocumentEvent var1);

    public abstract void removeUpdate(DocumentEvent var1);

    public abstract void insertUpdate(DocumentEvent var1);

    public abstract void adjustmentValueChanged(AdjustmentEvent var1);
}

