/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.deploy;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.dbpool.deploy.StatementEntry;
import com.sap.engine.services.dbpool.exceptions.BaseIOException;
import com.sap.engine.services.dbpool.exceptions.BaseIllegalArgumentException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLUtils {
    public static final String DEFAULT_DS_VAR = "${com.sap.datasource.default}";
    public static final String DATA_SOURCES_DTD = "<!DOCTYPE data-sources SYSTEM 'data-sources.dtd'>";
    public static final String DATA_SOURCE_ALIASES_DTD = "<!DOCTYPE data-source-aliases SYSTEM 'data-source-aliases.dtd'>";
    public static final String DB_INIT_DTD = "<!DOCTYPE db-init SYSTEM 'db-init.dtd'>";
    private static final Category category = Category.SYS_SERVER;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$deploy$XMLUtils == null ? (class$com$sap$engine$services$dbpool$deploy$XMLUtils = XMLUtils.class$("com.sap.engine.services.dbpool.deploy.XMLUtils")) : class$com$sap$engine$services$dbpool$deploy$XMLUtils));
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$deploy$XMLUtils;

    public static Document generateXMLOutputStream(String applicationName, JDBCDescriptor descr, OutputStream xmlOutputStream, boolean noPassword) throws IOException {
        DocumentBuilder builder = XMLUtils.createDocumentBuilder();
        Document mainDocument = builder.newDocument();
        Element appDSElem = mainDocument.createElement("data-sources");
        mainDocument.appendChild(appDSElem);
        if (applicationName != null && !"".equals(applicationName)) {
            XMLUtils.load(mainDocument, appDSElem, applicationName, "application-name");
        }
        XMLUtils.addDataSource(mainDocument, appDSElem, descr, noPassword);
        XMLUtils.writeDocumentToOutputStream(mainDocument, xmlOutputStream, DATA_SOURCES_DTD);
        return mainDocument;
    }

    public static Document generateXML(String applicationName, JDBCDescriptor descr, String xmlFilename) throws IOException {
        Document document;
        FileOutputStream fos = new FileOutputStream(xmlFilename);
        try {
            document = XMLUtils.generateXMLOutputStream(applicationName, descr, fos, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fos.close();
            throw throwable;
        }
        fos.close();
        return document;
    }

    public static Document generateXMLForExport(String applicationName, JDBCDescriptor descr, String xmlFilename) throws IOException {
        Document document;
        FileOutputStream fos = new FileOutputStream(xmlFilename);
        try {
            document = XMLUtils.generateXMLOutputStream(applicationName, descr, fos, true);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fos.close();
            throw throwable;
        }
        fos.close();
        return document;
    }

    public static Document generateAllXMLOutputStream(String applicationName, Vector dataSources, OutputStream xmlOutputStream, boolean noPassword) throws IOException {
        DocumentBuilder builder = XMLUtils.createDocumentBuilder();
        Document mainDocument = builder.newDocument();
        Element appDSElem = mainDocument.createElement("data-sources");
        mainDocument.appendChild(appDSElem);
        if (applicationName != null && !"".equals(applicationName)) {
            XMLUtils.load(mainDocument, appDSElem, applicationName, "application-name");
        }
        Enumeration enumeration = dataSources.elements();
        while (enumeration.hasMoreElements()) {
            XMLUtils.addDataSource(mainDocument, appDSElem, (JDBCDescriptor)enumeration.nextElement(), noPassword);
        }
        XMLUtils.writeDocumentToOutputStream(mainDocument, xmlOutputStream, DATA_SOURCES_DTD);
        return mainDocument;
    }

    public static Document generateAllXML(String applicationName, Vector dataSources, String xmlFilename) throws IOException {
        Document document;
        FileOutputStream fos = new FileOutputStream(xmlFilename);
        try {
            document = XMLUtils.generateAllXMLOutputStream(applicationName, dataSources, fos, false);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fos.close();
            throw throwable;
        }
        fos.close();
        return document;
    }

    public static Document generateAllXMLForExport(String applicationName, Vector dataSources, String xmlFilename) throws IOException {
        Document document;
        FileOutputStream fos = new FileOutputStream(xmlFilename);
        try {
            document = XMLUtils.generateAllXMLOutputStream(applicationName, dataSources, fos, true);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fos.close();
            throw throwable;
        }
        fos.close();
        return document;
    }

    public static Document generateAliasesXMLOutputStream(String appName, Hashtable alaises, OutputStream xmlOutputStream) throws IOException {
        DocumentBuilder builder = XMLUtils.createDocumentBuilder();
        Document mainDocument = builder.newDocument();
        Element dataSourceAliasesElem = mainDocument.createElement("data-source-aliases");
        mainDocument.appendChild(dataSourceAliasesElem);
        XMLUtils.addAliases(mainDocument, dataSourceAliasesElem, appName, alaises);
        XMLUtils.writeDocumentToOutputStream(mainDocument, xmlOutputStream, DATA_SOURCE_ALIASES_DTD);
        return mainDocument;
    }

    public static void generateAliasesXML(String appName, Hashtable alaises, String xmlFilename) throws IOException {
        FileOutputStream fos = new FileOutputStream(xmlFilename);
        try {
            XMLUtils.generateAliasesXMLOutputStream(appName, alaises, fos);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fos.close();
            throw throwable;
        }
        fos.close();
    }

    public static void generateStmtXMLOutputStream(String dsName, StatementEntry[] statements, OutputStream xmlOutputStream) throws IOException {
        DocumentBuilder builder = XMLUtils.createDocumentBuilder();
        Document mainDocument = builder.newDocument();
        Element dbInitElem = mainDocument.createElement("db-init");
        mainDocument.appendChild(dbInitElem);
        XMLUtils.addDatabaseInitialization(mainDocument, dbInitElem, dsName, statements);
        XMLUtils.writeDocumentToOutputStream(mainDocument, xmlOutputStream, DB_INIT_DTD);
    }

    public static void generateStmtXML(String dsName, StatementEntry[] statements, String xmlFilename) throws IOException {
        FileOutputStream fos = new FileOutputStream(xmlFilename);
        try {
            XMLUtils.generateStmtXMLOutputStream(dsName, statements, fos);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fos.close();
            throw throwable;
        }
        fos.close();
    }

    private static void writeDocumentToOutputStream(Document mainDocument, OutputStream xmlOutputStream, String dtd) throws IOException {
        StandardDOMWriter domWriter = XMLUtils.createStandardDOMWriter();
        domWriter.write(mainDocument, xmlOutputStream, dtd);
    }

    public static Document isDataSourceXML(File xmlFile) throws IOException, IllegalArgumentException {
        return XMLUtils.isDataSourceXML(new BufferedInputStream(new FileInputStream(xmlFile)));
    }

    public static Document isDataSourceXML(InputStream xmlStream) throws IOException, IllegalArgumentException {
        Document doc = null;
        StandardDOMParser parser = XMLUtils.createStandardDOMParser();
        try {
            parser.setValidation(true);
            doc = parser.parse(xmlStream);
        }
        catch (SAXException saxException) {
            throw new BaseIllegalArgumentException("dbpool_0600", new Object[]{"SAXException", "XMLUtils.isDataSourceXML()"}, (Throwable)saxException);
        }
        Node mainTag = doc.getElementsByTagName("data-sources").item(0);
        if (mainTag == null) {
            mainTag = doc.getElementsByTagName("app-data-source").item(0);
        }
        if (mainTag != null) {
            return doc;
        }
        return null;
    }

    public static boolean isAliasesXML(File xmlFile) throws IOException, IllegalArgumentException {
        return XMLUtils.isAliasesXML(new BufferedInputStream(new FileInputStream(xmlFile)));
    }

    public static boolean isAliasesXML(InputStream xmlStream) throws IOException, IllegalArgumentException {
        Document doc = null;
        StandardDOMParser parser = XMLUtils.createStandardDOMParser();
        try {
            parser.setValidation(true);
            doc = parser.parse(xmlStream);
        }
        catch (SAXException saxException) {
            throw new BaseIllegalArgumentException("dbpool_0600", new Object[]{"SAXException", "XMLUtils.isAliasesXML()"}, (Throwable)saxException);
        }
        Node mainTag = doc.getElementsByTagName("data-source-aliases").item(0);
        return mainTag != null;
    }

    public static Vector processXML(File xmlFile) throws IOException, IllegalArgumentException {
        return XMLUtils.processXML(new BufferedInputStream(new FileInputStream(xmlFile)));
    }

    public static Vector processXML(InputStream xmlStream) throws IOException, IllegalArgumentException {
        StandardDOMParser parser = XMLUtils.createStandardDOMParser();
        try {
            parser.setValidation(true);
            return XMLUtils.processXML(parser.parse(xmlStream));
        }
        catch (SAXException saxException) {
            throw new BaseIllegalArgumentException("dbpool_0600", new Object[]{"SAXException", "XMLUtils.processXML()"}, (Throwable)saxException);
        }
    }

    public static Vector processXML(Document doc) throws IllegalArgumentException {
        Node mainTag = doc.getElementsByTagName("data-sources").item(0);
        if (mainTag == null) {
            mainTag = doc.getElementsByTagName("app-data-source").item(0);
        }
        if (mainTag == null) {
            throw new BaseIllegalArgumentException("dbpool_0603", "data-sources");
        }
        NodeList mainList = mainTag.getChildNodes();
        Vector<JDBCDescriptor> descrVtr = new Vector<JDBCDescriptor>();
        int i = 0;
        while (i < mainList.getLength()) {
            Element element;
            String tag;
            if (mainList.item(i).getNodeType() == 1 && (tag = (element = (Element)mainList.item(i)).getNodeName()).equals("data-source")) {
                JDBCDescriptor descr = XMLUtils.processDataSource(element);
                descrVtr.add(descr);
            }
            ++i;
        }
        return descrVtr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JDBCDescriptor processDataSource(Element element) throws IllegalArgumentException {
        JDBCDescriptor jdbcDescriptor = new JDBCDescriptor();
        Vector<String> aliases = new Vector<String>();
        Properties properties = new Properties();
        Properties properties1x = new Properties();
        NodeList jdbcList = element.getChildNodes();
        int j = 0;
        while (j < jdbcList.getLength()) {
            if (jdbcList.item(j).getNodeType() == 1) {
                Element jdbcElement = (Element)jdbcList.item(j);
                String jdbcTag = jdbcElement.getNodeName();
                if (jdbcTag.equals("description")) {
                    jdbcDescriptor.setDescription(XMLUtils.getTextValue(jdbcElement));
                } else if (jdbcTag.equals("data-source-name")) {
                    String dataSourceName = XMLUtils.getTextValue(jdbcElement);
                    if ("".equals(dataSourceName)) {
                        throw new BaseIllegalArgumentException("dbpool_0601", "data-source-name");
                    }
                    if (DEFAULT_DS_VAR.equals(dataSourceName)) {
                        throw new BaseIllegalArgumentException("dbpool_0609");
                    }
                    jdbcDescriptor.setDataSourceName(dataSourceName);
                } else if (jdbcTag.equals("alias")) {
                    String alias = XMLUtils.getTextValue(jdbcElement);
                    if ("".equals(alias)) throw new BaseIllegalArgumentException("dbpool_0601", "alias");
                    if (aliases.contains(alias)) {
                        if (category.beLogged(400)) {
                            category.logT(400, location, "The alias '" + alias + "' is declared more than once in '" + jdbcDescriptor.getDataSourceName() + "' DataSource descriptor. Only one will be considered.");
                        }
                    } else {
                        aliases.addElement(alias);
                    }
                } else if (jdbcTag.equals("driver-name")) {
                    String driverName = XMLUtils.getTextValue(jdbcElement);
                    if ("".equals(driverName)) throw new BaseIllegalArgumentException("dbpool_0601", "driver-name");
                    jdbcDescriptor.setDriverName(driverName);
                } else {
                    String propTag;
                    Element propEl;
                    int t;
                    NodeList propList;
                    Element nextEl;
                    String nextTag;
                    int n;
                    NodeList entList;
                    int k;
                    if (jdbcTag.equals("init-connections")) {
                        String initConn = XMLUtils.getTextValue(jdbcElement);
                        if ("".equals(initConn)) throw new BaseIllegalArgumentException("dbpool_0601", "init-connections");
                        try {
                            jdbcDescriptor.setInitConnections(new Integer(initConn));
                        }
                        catch (NumberFormatException nfe) {
                            throw new BaseIllegalArgumentException("dbpool_0602", new Object[]{"init-connections", initConn}, (Throwable)nfe);
                        }
                    }
                    if (jdbcTag.equals("max-connections")) {
                        String maxConn = XMLUtils.getTextValue(jdbcElement);
                        if ("".equals(maxConn)) throw new BaseIllegalArgumentException("dbpool_0601", "max-connections");
                        try {
                            jdbcDescriptor.setMaxConnections(new Integer(maxConn));
                        }
                        catch (NumberFormatException nfe) {
                            throw new BaseIllegalArgumentException("dbpool_0602", new Object[]{"max-connections", maxConn}, (Throwable)nfe);
                        }
                    }
                    if (jdbcTag.equals("max-time-to-wait-connection")) {
                        String ttwConn = XMLUtils.getTextValue(jdbcElement);
                        if ("".equals(ttwConn)) throw new BaseIllegalArgumentException("dbpool_0601", "max-time-to-wait-connection");
                        try {
                            jdbcDescriptor.setMaxTimeToWaitConn(new Integer(ttwConn));
                        }
                        catch (NumberFormatException nfe) {
                            throw new BaseIllegalArgumentException("dbpool_0602", new Object[]{"max-time-to-wait-connection", ttwConn}, (Throwable)nfe);
                        }
                    }
                    if (jdbcTag.equals("isolation-level")) {
                        String isolationLevelName = XMLUtils.getTextValue(jdbcElement);
                        int isolationLevel = -1;
                        if ("TRANSACTION_NONE".equals(isolationLevelName)) {
                            isolationLevel = 0;
                        } else if ("TRANSACTION_READ_UNCOMMITTED".equals(isolationLevelName)) {
                            isolationLevel = 1;
                        } else if ("TRANSACTION_READ_COMMITTED".equals(isolationLevelName)) {
                            isolationLevel = 2;
                        } else if ("TRANSACTION_REPEATABLE_READ".equals(isolationLevelName)) {
                            isolationLevel = 4;
                        } else if ("TRANSACTION_SERIALIZABLE".equals(isolationLevelName)) {
                            isolationLevel = 8;
                        } else {
                            if (!"".equals(isolationLevelName)) throw new BaseIllegalArgumentException("dbpool_0602", new Object[]{"isolation-level", isolationLevelName});
                            throw new BaseIllegalArgumentException("dbpool_0601", "isolation-level");
                        }
                        jdbcDescriptor.setIsolationLevel(isolationLevel);
                    } else if (jdbcTag.equals("jdbc-2.0")) {
                        jdbcDescriptor.setNewDriver(true);
                        NodeList list20 = jdbcElement.getChildNodes();
                        k = 0;
                        while (k < list20.getLength()) {
                            if (list20.item(k).getNodeType() == 1) {
                                Element element20 = (Element)list20.item(k);
                                String tag20 = element20.getNodeName();
                                if (tag20.equals("xads-class-name")) {
                                    String xadsName = XMLUtils.getTextValue(element20);
                                    jdbcDescriptor.setXADS(true);
                                    if ("".equals(xadsName)) throw new BaseIllegalArgumentException("dbpool_0601", "xads-class-name");
                                    jdbcDescriptor.setXADSClassName(xadsName);
                                } else if (tag20.equals("cpds-class-name")) {
                                    String cpdsName = XMLUtils.getTextValue(element20);
                                    jdbcDescriptor.setXADS(false);
                                    if ("".equals(cpdsName)) throw new BaseIllegalArgumentException("dbpool_0601", "cpds-class-name");
                                    jdbcDescriptor.setCPDSClassName(cpdsName);
                                } else if (tag20.equals("object-factory")) {
                                    String objectFactory = XMLUtils.getTextValue(element20);
                                    if ("".equals(objectFactory)) throw new BaseIllegalArgumentException("dbpool_0601", "object-factory");
                                    jdbcDescriptor.setObjectFactory(objectFactory);
                                } else if (tag20.equals("properties")) {
                                    entList = element20.getChildNodes();
                                    String propertyName = null;
                                    String propertyValue = null;
                                    n = 0;
                                    while (n < entList.getLength()) {
                                        if (entList.item(n).getNodeType() == 1 && (nextTag = (nextEl = (Element)entList.item(n)).getNodeName()).equals("property")) {
                                            propList = nextEl.getChildNodes();
                                            t = 0;
                                            while (t < propList.getLength()) {
                                                if (propList.item(t).getNodeType() == 1) {
                                                    propEl = (Element)propList.item(t);
                                                    propTag = propEl.getNodeName();
                                                    if (propTag.equals("property-name")) {
                                                        propertyName = XMLUtils.getTextValue(propEl);
                                                    } else if (propTag.equals("property-value")) {
                                                        propertyValue = "true".equalsIgnoreCase(propEl.getAttribute("encrypted")) ? XMLUtils.decrypt(XMLUtils.getTextValue(propEl)) : XMLUtils.getTextValue(propEl);
                                                    }
                                                }
                                                ++t;
                                            }
                                            if ("".equals(propertyName)) throw new BaseIllegalArgumentException("dbpool_0601", "property-name");
                                            if ("url".equalsIgnoreCase(propertyName)) {
                                                XMLUtils.verifyURL(propertyValue);
                                            }
                                            properties.setProperty(propertyName, propertyValue);
                                        }
                                        ++n;
                                    }
                                }
                                jdbcDescriptor.setProps20(properties);
                            }
                            ++k;
                        }
                    } else if (jdbcTag.equals("jdbc-1.x")) {
                        jdbcDescriptor.setNewDriver(false);
                        NodeList list1x = jdbcElement.getChildNodes();
                        k = 0;
                        while (k < list1x.getLength()) {
                            if (list1x.item(k).getNodeType() == 1) {
                                Element element1x = (Element)list1x.item(k);
                                String tag1x = element1x.getNodeName();
                                if (tag1x.equals("driver-class-name")) {
                                    String driverClassName = XMLUtils.getTextValue(element1x);
                                    if ("".equals(driverClassName)) throw new BaseIllegalArgumentException("dbpool_0601", "driver-class-name");
                                    jdbcDescriptor.setDriverClassName(driverClassName);
                                } else if (tag1x.equals("url")) {
                                    String url = XMLUtils.getTextValue(element1x);
                                    if ("".equals(url)) throw new BaseIllegalArgumentException("dbpool_0601", "url");
                                    XMLUtils.verifyURL(url);
                                    jdbcDescriptor.setURL(url);
                                } else if (tag1x.equals("user-name")) {
                                    String user = XMLUtils.getTextValue(element1x);
                                    if ("".equals(user)) throw new BaseIllegalArgumentException("dbpool_0601", "user-name");
                                    jdbcDescriptor.setUsername(user);
                                } else if (tag1x.equals("password")) {
                                    String password = XMLUtils.getTextValue(element1x);
                                    if ("true".equalsIgnoreCase(element1x.getAttribute("encrypted"))) {
                                        password = XMLUtils.decrypt(password);
                                    }
                                    jdbcDescriptor.setPassword(password);
                                } else if (tag1x.equals("properties")) {
                                    entList = element1x.getChildNodes();
                                    String property1xName = null;
                                    String property1xValue = null;
                                    n = 0;
                                    while (n < entList.getLength()) {
                                        if (entList.item(n).getNodeType() == 1 && (nextTag = (nextEl = (Element)entList.item(n)).getNodeName()).equals("property")) {
                                            propList = nextEl.getChildNodes();
                                            t = 0;
                                            while (t < propList.getLength()) {
                                                if (propList.item(t).getNodeType() == 1) {
                                                    propEl = (Element)propList.item(t);
                                                    propTag = propEl.getNodeName();
                                                    if (propTag.equals("property-name")) {
                                                        property1xName = XMLUtils.getTextValue(propEl);
                                                    } else if (propTag.equals("property-value")) {
                                                        property1xValue = "true".equalsIgnoreCase(propEl.getAttribute("encrypted")) ? XMLUtils.decrypt(XMLUtils.getTextValue(propEl)) : XMLUtils.getTextValue(propEl);
                                                    }
                                                }
                                                ++t;
                                            }
                                            if ("".equals(property1xName)) throw new BaseIllegalArgumentException("dbpool_0601", "property-name");
                                            if ("url".equalsIgnoreCase(property1xName)) {
                                                XMLUtils.verifyURL(property1xValue);
                                            }
                                            properties1x.setProperty(property1xName, property1xValue);
                                        }
                                        ++n;
                                    }
                                }
                                jdbcDescriptor.setProps1x(properties1x);
                            }
                            ++k;
                        }
                    } else if (jdbcTag.equals("expiration-control")) {
                        NodeList listExpCtrl = jdbcElement.getChildNodes();
                        k = 0;
                        while (k < listExpCtrl.getLength()) {
                            if (listExpCtrl.item(k).getNodeType() == 1) {
                                Element elementExpCtrl = (Element)listExpCtrl.item(k);
                                String tagExpCtrl = elementExpCtrl.getNodeName();
                                if (tagExpCtrl.equals("connection-lifetime")) {
                                    String connLifetime = XMLUtils.getTextValue(elementExpCtrl);
                                    if ("".equals(connLifetime)) throw new BaseIllegalArgumentException("dbpool_0601", "connection-lifetime");
                                    try {
                                        jdbcDescriptor.setConnLifetime(new Integer(connLifetime));
                                    }
                                    catch (NumberFormatException nfe) {
                                        throw new BaseIllegalArgumentException("dbpool_0602", new Object[]{"connection-lifetime", connLifetime}, (Throwable)nfe);
                                    }
                                }
                                if (tagExpCtrl.equals("run-cleanup-thread")) {
                                    String runCleanupThread = XMLUtils.getTextValue(elementExpCtrl);
                                    if ("".equals(runCleanupThread)) throw new BaseIllegalArgumentException("dbpool_0601", "run-cleanup-thread");
                                    try {
                                        jdbcDescriptor.setRunCleanupThread(new Integer(runCleanupThread));
                                    }
                                    catch (NumberFormatException nfe) {
                                        throw new BaseIllegalArgumentException("dbpool_0602", new Object[]{"run-cleanup-thread", runCleanupThread}, (Throwable)nfe);
                                    }
                                }
                            }
                            ++k;
                        }
                    } else if (jdbcTag.equals("sql-engine")) {
                        String sqlEngine = XMLUtils.getTextValue(jdbcElement);
                        if ("open_sql".equalsIgnoreCase(sqlEngine) || "native_sql".equalsIgnoreCase(sqlEngine) || "vendor_sql".equalsIgnoreCase(sqlEngine)) {
                            int isoLvl = jdbcDescriptor.getIsolationLevel();
                            if ("open_sql".equalsIgnoreCase(sqlEngine) && isoLvl != -1 && isoLvl != 2 && isoLvl != 1) {
                                throw new BaseIllegalArgumentException("dbpool_0607", XMLUtils.getIsolationLevel(isoLvl));
                            }
                            jdbcDescriptor.setSQLEngine(sqlEngine);
                        } else {
                            if (!"".equals(sqlEngine)) throw new BaseIllegalArgumentException("dbpool_0602", new Object[]{"sql-engine", sqlEngine});
                            throw new BaseIllegalArgumentException("dbpool_0601", "sql-engine");
                        }
                    }
                }
            }
            ++j;
        }
        jdbcDescriptor.setAliases(aliases.toArray(new String[0]));
        if (jdbcDescriptor.getInitConnections() <= jdbcDescriptor.getMaxConnections() || jdbcDescriptor.getMaxConnections() != 25) return jdbcDescriptor;
        jdbcDescriptor.setMaxConnections(jdbcDescriptor.getInitConnections());
        return jdbcDescriptor;
    }

    public static Hashtable processDBInitXML(File xmlFile) throws IOException, IllegalArgumentException {
        BufferedInputStream xmlStream = new BufferedInputStream(new FileInputStream(xmlFile));
        Document doc = null;
        StandardDOMParser parser = XMLUtils.createStandardDOMParser();
        try {
            parser.setValidation(true);
            doc = parser.parse((InputStream)xmlStream);
        }
        catch (SAXException saxException) {
            throw new BaseIllegalArgumentException("dbpool_0600", new Object[]{"SAXException", "XMLUtils.processDBInitXML()"}, (Throwable)saxException);
        }
        Node mainTag = doc.getElementsByTagName("db-init").item(0);
        NodeList mainList = mainTag.getChildNodes();
        Hashtable<String, StatementEntry[]> dbInit = new Hashtable<String, StatementEntry[]>();
        String dsName = null;
        int i = 0;
        while (i < mainList.getLength()) {
            Element element;
            String tag;
            if (mainList.item(i).getNodeType() == 1 && (tag = (element = (Element)mainList.item(i)).getNodeName()).equals("init-statements")) {
                NodeList listDBInit = element.getChildNodes();
                Vector<StatementEntry> statementEntries = new Vector<StatementEntry>();
                int k = 0;
                while (k < listDBInit.getLength()) {
                    if (listDBInit.item(k).getNodeType() == 1) {
                        Element elementDBInit = (Element)listDBInit.item(k);
                        String tagDBInit = elementDBInit.getNodeName();
                        if (tagDBInit.equals("data-source-name")) {
                            dsName = XMLUtils.getTextValue(elementDBInit);
                            if ("".equals(dsName)) {
                                throw new BaseIllegalArgumentException("dbpool_0601", "data-source-name");
                            }
                        } else if (tagDBInit.equals("sql-statement")) {
                            String sqlStmt = XMLUtils.getTextValue(elementDBInit);
                            if (!"".equals(sqlStmt)) {
                                StatementEntry se = new StatementEntry(sqlStmt, "true".equalsIgnoreCase(elementDBInit.getAttribute("ignore-error")));
                                statementEntries.add(se);
                            } else {
                                throw new BaseIllegalArgumentException("dbpool_0601", "sql-statement");
                            }
                        }
                    }
                    ++k;
                }
                dbInit.put(dsName, statementEntries.toArray(new StatementEntry[0]));
            }
            ++i;
        }
        return dbInit;
    }

    public static Hashtable processAliasesXML(InputStream xmlStream) throws IOException, IllegalArgumentException {
        Document doc = null;
        StandardDOMParser parser = XMLUtils.createStandardDOMParser();
        try {
            parser.setValidation(true);
            doc = parser.parse(xmlStream);
        }
        catch (SAXException saxException) {
            throw new BaseIllegalArgumentException("dbpool_0600", new Object[]{"SAXException", "XMLUtils.processAliasesXML()"}, (Throwable)saxException);
        }
        Node mainTag = doc.getElementsByTagName("data-source-aliases").item(0);
        NodeList mainList = mainTag.getChildNodes();
        Hashtable<String, String[]> aliases = new Hashtable<String, String[]>();
        String dsName = null;
        int i = 0;
        while (i < mainList.getLength()) {
            Element element;
            String tag;
            if (mainList.item(i).getNodeType() == 1 && (tag = (element = (Element)mainList.item(i)).getNodeName()).equals("aliases")) {
                NodeList listDSAliases = element.getChildNodes();
                Vector<String> aliasesVtr = new Vector<String>();
                int k = 0;
                while (k < listDSAliases.getLength()) {
                    if (listDSAliases.item(k).getNodeType() == 1) {
                        Element elementDSAlias = (Element)listDSAliases.item(k);
                        String tagDSAlias = elementDSAlias.getNodeName();
                        if (tagDSAlias.equals("data-source-name")) {
                            JDBCDescriptor defDSDescr;
                            DataSourceManager dsManager;
                            dsName = XMLUtils.getTextValue(elementDSAlias);
                            if ("".equals(dsName)) {
                                throw new BaseIllegalArgumentException("dbpool_0601", "data-source-name");
                            }
                            if (DEFAULT_DS_VAR.equals(dsName) && (dsManager = PoolFrame.getDataSourceManager()) != null && (defDSDescr = dsManager.getSystemDataSourceDescriptor()) != null) {
                                dsName = defDSDescr.getDataSourceName();
                            }
                        } else if (tagDSAlias.equals("alias")) {
                            String alias = XMLUtils.getTextValue(elementDSAlias);
                            if (!"".equals(alias)) {
                                aliasesVtr.add(alias);
                            } else {
                                throw new BaseIllegalArgumentException("dbpool_0601", "alias");
                            }
                        }
                    }
                    ++k;
                }
                aliases.put(dsName, aliasesVtr.toArray(new String[0]));
            }
            ++i;
        }
        return aliases;
    }

    public static Hashtable processAliasesXML(File xmlFile) throws IOException, IllegalArgumentException {
        return XMLUtils.processAliasesXML(new BufferedInputStream(new FileInputStream(xmlFile)));
    }

    public static String getApplicationName(File xmlFile) throws IOException, IllegalArgumentException {
        BufferedInputStream xmlStream = new BufferedInputStream(new FileInputStream(xmlFile));
        Document doc = null;
        StandardDOMParser parser = XMLUtils.createStandardDOMParser();
        try {
            parser.setValidation(true);
            doc = parser.parse((InputStream)xmlStream);
        }
        catch (SAXException saxException) {
            throw new BaseIllegalArgumentException("dbpool_0600", new Object[]{"SAXException", "XMLUtils.getApplicationName()"}, (Throwable)saxException);
        }
        Node mainTag = doc.getElementsByTagName("data-sources").item(0);
        if (mainTag == null) {
            mainTag = doc.getElementsByTagName("app-data-source").item(0);
        }
        if (mainTag == null) {
            mainTag = doc.getElementsByTagName("data-source-aliases").item(0);
        }
        if (mainTag == null) {
            throw new BaseIllegalArgumentException("dbpool_0603", "data-sources> or <data-source-aliases");
        }
        NodeList mainList = mainTag.getChildNodes();
        int i = 0;
        while (i < mainList.getLength()) {
            Element element;
            String tag;
            if (mainList.item(i).getNodeType() == 1 && (tag = (element = (Element)mainList.item(i)).getNodeName()).equals("application-name")) {
                String appName = XMLUtils.getTextValue(element);
                if (!"".equals(appName)) {
                    return appName;
                }
                throw new BaseIllegalArgumentException("dbpool_0601", "application-name");
            }
            ++i;
        }
        throw new BaseIllegalArgumentException("dbpool_0608");
    }

    public static JDBCDescriptor loadJdbcDescriptor(Properties sysDSProps, ApplicationServiceContext serviceContext) {
        JDBCDescriptor descr = new JDBCDescriptor();
        descr.setDataSourceName(XMLUtils.getStringProperty(sysDSProps, "sysDS.dataSourceName", null));
        descr.setAliases(XMLUtils.getStringArrayProperty(sysDSProps, "sysDS.aliases"));
        descr.setDriverName(XMLUtils.getStringProperty(sysDSProps, "sysDS.driverName", "SYSTEM_DRIVER"));
        descr.setInitConnections(XMLUtils.getIntProperty(sysDSProps, "sysDS.initialConnections", 0));
        descr.setMaxConnections(XMLUtils.getIntProperty(sysDSProps, "sysDS.maximumConnections", 25));
        descr.setMaxTimeToWaitConn(XMLUtils.getIntProperty(sysDSProps, "sysDS.maxTimeToWaitConnection", 60));
        descr.setConnLifetime(XMLUtils.getIntProperty(sysDSProps, "sysDS.connectionLifetime", 0));
        descr.setRunCleanupThread(XMLUtils.getIntProperty(sysDSProps, "sysDS.runCleanupThreadInterval", 0));
        descr.setSQLEngine(XMLUtils.getStringProperty(sysDSProps, "sysDS.SQLEngine", "open_sql"));
        String isolationLevelName = XMLUtils.getStringProperty(sysDSProps, "sysDS.isolationLevel", "-1");
        int isolationLevel = -1;
        if ("TRANSACTION_NONE".equals(isolationLevelName)) {
            if ("open_sql".equalsIgnoreCase(descr.getSQLEngine())) {
                if (category.beLogged(400)) {
                    category.logT(400, location, "DataSource '" + descr.getDataSourceName() + "': TRANSACTION_NONE is an illegal isolation level for the Open SQL engine and it will be ignored.");
                }
            } else {
                isolationLevel = 0;
            }
        } else if ("TRANSACTION_READ_UNCOMMITTED".equals(isolationLevelName)) {
            isolationLevel = 1;
        } else if ("TRANSACTION_READ_COMMITTED".equals(isolationLevelName)) {
            isolationLevel = 2;
        } else if ("TRANSACTION_REPEATABLE_READ".equals(isolationLevelName)) {
            if ("open_sql".equalsIgnoreCase(descr.getSQLEngine())) {
                if (category.beLogged(400)) {
                    category.logT(400, location, "DataSource '" + descr.getDataSourceName() + "': TRANSACTION_REPEATABLE_READ is an illegal isolation level for the Open SQL engine and it will be ignored.");
                }
            } else {
                isolationLevel = 4;
            }
        } else if ("TRANSACTION_SERIALIZABLE".equals(isolationLevelName)) {
            if ("open_sql".equalsIgnoreCase(descr.getSQLEngine())) {
                if (category.beLogged(400)) {
                    category.logT(400, location, "DataSource '" + descr.getDataSourceName() + "': TRANSACTION_SERIALIZABLE is an illegal isolation level for the Open SQL engine and it will be ignored.");
                }
            } else {
                isolationLevel = 8;
            }
        }
        descr.setIsolationLevel(isolationLevel);
        descr.setNewDriver(false);
        descr.setProps1x(new Properties());
        descr.setDefaultDS(true);
        String dbConnectInfo = XMLUtils.getStringProperty(sysDSProps, "sysDS.DBConnectInfo", "");
        if ("".equals(dbConnectInfo)) {
            Properties configManProps = serviceContext.getCoreContext().getConfigurationHandlerFactory().getCurrentProperties();
            String configDBConnectInfo = configManProps.getProperty("rdbms.connection");
            if (configDBConnectInfo != null && !configDBConnectInfo.equals("")) {
                descr.setDBConnectInfo(configDBConnectInfo);
                descr.setDriverClassName("**********");
                descr.setURL("**********");
                descr.setUsername("**********");
                descr.setPassword("**********");
            } else {
                descr.setDriverClassName(XMLUtils.getStringProperty(sysDSProps, "sysDS.driverClassName", null));
                descr.setURL(XMLUtils.getStringProperty(sysDSProps, "sysDS.URL", null));
                descr.setUsername(XMLUtils.getStringProperty(sysDSProps, "sysDS.User", null));
                String encryptedPwd = XMLUtils.getStringProperty(sysDSProps, "sysDS.isPasswordEncrypted", "no");
                String password = XMLUtils.getStringProperty(sysDSProps, "sysDS.Password", null);
                if ("yes".equalsIgnoreCase(encryptedPwd) || "true".equalsIgnoreCase(encryptedPwd)) {
                    descr.setPassword(XMLUtils.decrypt(password));
                } else {
                    descr.setPassword(password);
                }
            }
        } else {
            descr.setDBConnectInfo(dbConnectInfo);
            descr.setDriverClassName("**********");
            descr.setURL("**********");
            descr.setUsername("**********");
            descr.setPassword("**********");
        }
        return descr;
    }

    private static String getStringProperty(Properties props, String name, String defValue) {
        String value = props.getProperty(name);
        if (value == null) {
            if (defValue == null) {
                throw new BaseIllegalArgumentException("dbpool_0604", name);
            }
            return defValue;
        }
        return value;
    }

    private static String[] getStringArrayProperty(Properties props, String name) {
        String aliases = XMLUtils.getStringProperty(props, name, "");
        StringTokenizer st = new StringTokenizer(aliases, ",");
        Vector<String> aliasesVtr = new Vector<String>();
        while (st.hasMoreTokens()) {
            String alias = st.nextToken().trim();
            if (aliasesVtr.contains(alias)) {
                if (!category.beLogged(400)) continue;
                category.logT(400, location, "The alias '" + alias + "' is declared more than once in the default DataSource properties.");
                continue;
            }
            aliasesVtr.add(alias);
        }
        return aliasesVtr.toArray(new String[0]);
    }

    private static int getIntProperty(Properties props, String name, int defValue) {
        String value = XMLUtils.getStringProperty(props, name, new Integer(defValue).toString());
        try {
            return "".equals(value) ? defValue : new Integer(value);
        }
        catch (NumberFormatException nfe) {
            throw new BaseIllegalArgumentException("dbpool_0605", new Object[]{name, value}, (Throwable)nfe);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties convertJDBCDescrToProps(JDBCDescriptor descr) {
        int runCleanup;
        int connLifetime;
        int maxTimeToWait;
        int maxConn;
        int initConn;
        String driver;
        Properties props = new Properties();
        String dsName = descr.getDataSourceName();
        if (dsName == null || "".equals(dsName)) {
            throw new IllegalArgumentException("You must specify a DataSource name.");
        }
        props.setProperty("sysDS.dataSourceName", dsName);
        String[] aliases = descr.getAliases();
        if (aliases != null && aliases.length != 0) {
            StringBuffer aliasesBuffer = new StringBuffer();
            int i = 0;
            while (i < aliases.length) {
                aliasesBuffer.append(aliases[i]);
                aliasesBuffer.append(',');
                ++i;
            }
            props.setProperty("sysDS.aliases", aliasesBuffer.substring(0, aliasesBuffer.length() - 1));
        }
        if ((driver = descr.getDriverName()) != null && !"SYSTEM_DRIVER".equals(driver)) {
            props.setProperty("sysDS.driverName", driver);
        }
        if ((initConn = descr.getInitConnections()) > 0) {
            props.setProperty("sysDS.initialConnections", String.valueOf(initConn));
        }
        if ((maxConn = descr.getMaxConnections()) > 0) {
            props.setProperty("sysDS.maximumConnections", String.valueOf(maxConn));
        }
        if ((maxTimeToWait = descr.getMaxTimeToWaitConn()) > 0) {
            props.setProperty("sysDS.maxTimeToWaitConnection", String.valueOf(maxTimeToWait));
        }
        if ((connLifetime = descr.getConnLifetime()) > 0) {
            props.setProperty("sysDS.connectionLifetime", String.valueOf(connLifetime));
        }
        if ((runCleanup = descr.getRunCleanupThread()) > 0) {
            props.setProperty("sysDS.runCleanupThreadInterval", String.valueOf(runCleanup));
        }
        String sqlEngine = descr.getSQLEngine();
        props.setProperty("sysDS.SQLEngine", sqlEngine);
        int isoLvl = descr.getIsolationLevel();
        if (isoLvl != -1) {
            String isoLvlString = null;
            switch (isoLvl) {
                case 0: {
                    if ("open_sql".equalsIgnoreCase(sqlEngine)) {
                        if (!category.beLogged(400)) break;
                        category.logT(400, location, "DataSource '" + dsName + "': TRANSACTION_NONE is an illegal isolation level for the Open SQL engine and it will be ignored.");
                        break;
                    }
                    isoLvlString = "TRANSACTION_NONE";
                    break;
                }
                case 1: {
                    isoLvlString = "TRANSACTION_READ_UNCOMMITTED";
                    break;
                }
                case 2: {
                    isoLvlString = "TRANSACTION_READ_COMMITTED";
                    break;
                }
                case 4: {
                    if ("open_sql".equalsIgnoreCase(sqlEngine)) {
                        if (!category.beLogged(400)) break;
                        category.logT(400, location, "DataSource '" + dsName + "': TRANSACTION_REPEATABLE_READ is an illegal isolation level for the Open SQL engine and it will be ignored.");
                        break;
                    }
                    isoLvlString = "TRANSACTION_REPEATABLE_READ";
                    break;
                }
                case 8: {
                    if ("open_sql".equalsIgnoreCase(sqlEngine)) {
                        if (!category.beLogged(400)) break;
                        category.logT(400, location, "DataSource '" + dsName + "': TRANSACTION_SERIALIZABLE is an illegal isolation level for the Open SQL engine and it will be ignored.");
                        break;
                    }
                    isoLvlString = "TRANSACTION_SERIALIZABLE";
                }
            }
            if (isoLvlString != null) {
                props.setProperty("sysDS.isolationLevel", isoLvlString);
            }
        }
        if (descr.getDBConnectInfo() == null) {
            String isPwdEnc;
            String driverClass = descr.getDriverClassName();
            if (driverClass == null || "".equals(driverClass)) {
                throw new IllegalArgumentException("You must specify a driver classname.");
            }
            props.setProperty("sysDS.driverClassName", driverClass);
            String url = descr.getURL();
            if (url == null || "".equals(url)) {
                throw new IllegalArgumentException("You must specify an URL to the database.");
            }
            props.setProperty("sysDS.URL", url);
            String user = descr.getUsername();
            if (user == null || "".equals(user)) {
                throw new IllegalArgumentException("You must specify an username.");
            }
            props.setProperty("sysDS.User", user);
            String pwd = descr.getPassword();
            if (pwd == null) throw new IllegalArgumentException("You must specify a password.");
            boolean encryptPwd = false;
            Properties oldProps = PoolFrame.getServiceProperties();
            if (oldProps != null && (isPwdEnc = oldProps.getProperty("sysDS.isPasswordEncrypted")) != null && ("true".equals(isPwdEnc) || "yes".equals(isPwdEnc))) {
                encryptPwd = true;
            }
            if (encryptPwd) {
                pwd = XMLUtils.encrypt(pwd);
            }
            props.setProperty("sysDS.Password", pwd);
            props.setProperty("sysDS.isPasswordEncrypted", String.valueOf(encryptPwd));
            return props;
        } else {
            props.setProperty("sysDS.DBConnectInfo", descr.getDBConnectInfo());
        }
        return props;
    }

    private static String getTextValue(Element element) {
        if (element == null) {
            return new String();
        }
        Node node = element.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return "";
    }

    private static void addDataSource(Document mainDocument, Element el, JDBCDescriptor descr, boolean noPassword) {
        block24: {
            Element dsElem;
            block23: {
                Properties props;
                dsElem = mainDocument.createElement("data-source");
                el.appendChild(dsElem);
                String description = descr.getDescription();
                if (description != null && !"".equals(description)) {
                    XMLUtils.load(mainDocument, dsElem, description, "description");
                }
                XMLUtils.load(mainDocument, dsElem, descr.getDataSourceName(), "data-source-name");
                String[] aliases = descr.getAliases();
                if (aliases != null && aliases.length > 0) {
                    int i = 0;
                    while (i < aliases.length) {
                        XMLUtils.load(mainDocument, dsElem, aliases[i], "alias");
                        ++i;
                    }
                }
                XMLUtils.load(mainDocument, dsElem, descr.getDriverName(), "driver-name");
                if (descr.getInitConnections() > 0) {
                    XMLUtils.load(mainDocument, dsElem, String.valueOf(descr.getInitConnections()), "init-connections");
                }
                if (descr.getMaxConnections() >= 0) {
                    XMLUtils.load(mainDocument, dsElem, String.valueOf(descr.getMaxConnections()), "max-connections");
                }
                if (descr.getMaxTimeToWaitConn() >= 0) {
                    XMLUtils.load(mainDocument, dsElem, String.valueOf(descr.getMaxTimeToWaitConn()), "max-time-to-wait-connection");
                }
                if (descr.isExpControlEnabled()) {
                    Element expControl = mainDocument.createElement("expiration-control");
                    dsElem.appendChild(expControl);
                    XMLUtils.load(mainDocument, expControl, String.valueOf(descr.getConnLifetime()), "connection-lifetime");
                    XMLUtils.load(mainDocument, expControl, String.valueOf(descr.getRunCleanupThread()), "run-cleanup-thread");
                }
                if (descr.getIsolationLevel() > -1) {
                    XMLUtils.load(mainDocument, dsElem, XMLUtils.getIsolationLevel(descr.getIsolationLevel()), "isolation-level");
                }
                if (descr.getSQLEngine() != null) {
                    XMLUtils.load(mainDocument, dsElem, descr.getSQLEngine(), "sql-engine");
                }
                if (!descr.isNewDriver()) break block23;
                Element jdbc20Elem = mainDocument.createElement("jdbc-2.0");
                dsElem.appendChild(jdbc20Elem);
                if (descr.isXADS()) {
                    XMLUtils.load(mainDocument, jdbc20Elem, descr.getXADSClassName(), "xads-class-name");
                } else {
                    XMLUtils.load(mainDocument, jdbc20Elem, descr.getCPDSClassName(), "cpds-class-name");
                }
                String objFactory = descr.getObjectFactory();
                if (objFactory != null && !"".equals(objFactory)) {
                    XMLUtils.load(mainDocument, jdbc20Elem, objFactory, "object-factory");
                }
                if ((props = descr.getProps20()) == null) break block24;
                Enumeration enumeration = ((Hashtable)props).keys();
                Element props20Elem = mainDocument.createElement("properties");
                if (enumeration.hasMoreElements()) {
                    jdbc20Elem.appendChild(props20Elem);
                }
                while (enumeration.hasMoreElements()) {
                    Element propElem = mainDocument.createElement("property");
                    props20Elem.appendChild(propElem);
                    String key = (String)enumeration.nextElement();
                    XMLUtils.load(mainDocument, propElem, key, "property-name");
                    if ("password".equalsIgnoreCase(key)) {
                        if (noPassword) {
                            XMLUtils.load(mainDocument, propElem, "**********", "property-value");
                            continue;
                        }
                        XMLUtils.load(mainDocument, propElem, XMLUtils.encrypt(props.getProperty(key)), "property-value", "true", "encrypted");
                        continue;
                    }
                    XMLUtils.load(mainDocument, propElem, props.getProperty(key), "property-value");
                }
                break block24;
            }
            Element jdbc1xElem = mainDocument.createElement("jdbc-1.x");
            dsElem.appendChild(jdbc1xElem);
            XMLUtils.load(mainDocument, jdbc1xElem, descr.getDriverClassName(), "driver-class-name");
            XMLUtils.load(mainDocument, jdbc1xElem, descr.getURL(), "url");
            XMLUtils.load(mainDocument, jdbc1xElem, descr.getUsername(), "user-name");
            if (noPassword) {
                XMLUtils.load(mainDocument, jdbc1xElem, "**********", "password");
            } else {
                XMLUtils.load(mainDocument, jdbc1xElem, XMLUtils.encrypt(descr.getPassword()), "password", "true", "encrypted");
            }
            Properties props = descr.getProps1x();
            if (props != null) {
                Enumeration enumeration = ((Hashtable)props).keys();
                Element props1xElem = mainDocument.createElement("properties");
                if (enumeration.hasMoreElements()) {
                    jdbc1xElem.appendChild(props1xElem);
                }
                while (enumeration.hasMoreElements()) {
                    Element propElem = mainDocument.createElement("property");
                    props1xElem.appendChild(propElem);
                    String key = (String)enumeration.nextElement();
                    XMLUtils.load(mainDocument, propElem, key, "property-name");
                    if ("password".equalsIgnoreCase(key)) {
                        if (noPassword) {
                            XMLUtils.load(mainDocument, propElem, "**********", "property-value");
                            continue;
                        }
                        XMLUtils.load(mainDocument, propElem, XMLUtils.encrypt(props.getProperty(key)), "property-value", "true", "encrypted");
                        continue;
                    }
                    XMLUtils.load(mainDocument, propElem, props.getProperty(key), "property-value");
                }
            }
        }
    }

    private static void addDatabaseInitialization(Document mainDocument, Element dbInitElem, String dsName, StatementEntry[] statements) {
        Element databaseInitializationElem = mainDocument.createElement("init-statements");
        dbInitElem.appendChild(databaseInitializationElem);
        if (dsName != null && !"".equals(dsName)) {
            XMLUtils.load(mainDocument, databaseInitializationElem, dsName, "data-source-name");
        }
        if (statements != null) {
            int i = 0;
            while (i < statements.length) {
                if (statements[i].getIgnoreError()) {
                    XMLUtils.load(mainDocument, databaseInitializationElem, statements[i].getStatement(), "sql-statement", "true", "ignore-error");
                } else {
                    XMLUtils.load(mainDocument, databaseInitializationElem, statements[i].getStatement(), "sql-statement");
                }
                ++i;
            }
        }
    }

    private static void addAliases(Document mainDocument, Element dataSourceAliasesElem, String appName, Hashtable aliases) {
        Element aliasesElem = null;
        Enumeration enumeration = aliases.keys();
        String dataSourceName = null;
        String[] aliasesArr = null;
        if (appName != null && !"".equals(appName)) {
            XMLUtils.load(mainDocument, dataSourceAliasesElem, appName, "application-name");
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                aliasesElem = mainDocument.createElement("aliases");
                dataSourceAliasesElem.appendChild(aliasesElem);
                dataSourceName = (String)enumeration.nextElement();
                XMLUtils.load(mainDocument, aliasesElem, dataSourceName, "data-source-name");
                aliasesArr = (String[])aliases.get(dataSourceName);
                if (aliases == null || aliasesArr.length <= 0) continue;
                int i = 0;
                while (i < aliasesArr.length) {
                    XMLUtils.load(mainDocument, aliasesElem, aliasesArr[i], "alias");
                    ++i;
                }
            }
        }
    }

    private static Element load(Document mainDocument, Element el, String tagValue, String tagName, String attrValue, String attrName) {
        if (tagValue == null) {
            tagValue = "";
        }
        Element nextElement = mainDocument.createElement(tagName);
        if (attrName != null && attrValue != null) {
            nextElement.setAttribute(attrName, attrValue);
        }
        Text textNode = mainDocument.createTextNode(tagValue);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }

    private static Element load(Document mainDocument, Element el, String tagValue, String tagName) {
        return XMLUtils.load(mainDocument, el, tagValue, tagName, null, null);
    }

    private static String getIsolationLevel(int level) {
        switch (level) {
            case 0: {
                return "TRANSACTION_NONE";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
        }
        return "-1";
    }

    private static void verifyURL(String url) {
        if (url.indexOf(":sap:") >= 0 && location.beLogged(300)) {
            location.logT(300, "XMLUtils.verifyURL(): URL contains :sap: subprotocol.");
        }
    }

    private static String encrypt(String s) {
        StringBuffer encrypted = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            StringBuffer sb = new StringBuffer();
            String chBin = Integer.toBinaryString(s.charAt(i));
            int j = 8;
            while (j > chBin.length()) {
                sb.append('0');
                --j;
            }
            sb.append(chBin);
            StringBuffer even = new StringBuffer(sb.length() / 2);
            StringBuffer odd = new StringBuffer(sb.length() / 2);
            int j2 = 0;
            while (j2 < sb.length()) {
                if (j2 % 2 == 0) {
                    even.append(sb.charAt(j2));
                } else {
                    odd.append(sb.charAt(j2));
                }
                ++j2;
            }
            encrypted.append(Integer.toHexString(Integer.parseInt(even.toString(), 2)));
            encrypted.append(Integer.toHexString(Integer.parseInt(odd.toString(), 2)));
            ++i;
        }
        return encrypted.toString();
    }

    private static String decrypt(String s) {
        StringBuffer decrypted = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            String chBin = Integer.toBinaryString(Integer.parseInt(s.substring(i, i + 1), 16));
            StringBuffer even = new StringBuffer();
            int j = 4;
            while (j > chBin.length()) {
                even.append('0');
                --j;
            }
            even.append(chBin);
            chBin = Integer.toBinaryString(Integer.parseInt(s.substring(i + 1, i + 2), 16));
            StringBuffer odd = new StringBuffer();
            int j2 = 4;
            while (j2 > chBin.length()) {
                odd.append('0');
                --j2;
            }
            odd.append(chBin);
            StringBuffer sb = new StringBuffer(even.length() + odd.length());
            int j3 = 0;
            while (j3 < even.length()) {
                sb.append(even.charAt(j3));
                sb.append(odd.charAt(j3));
                ++j3;
            }
            decrypted.append((char)Integer.parseInt(sb.toString(), 2));
            i += 2;
        }
        return decrypted.toString();
    }

    private static StandardDOMParser createStandardDOMParser() {
        ClassLoader previousLoader = null;
        try {
            previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$dbpool$deploy$XMLUtils == null ? (class$com$sap$engine$services$dbpool$deploy$XMLUtils = XMLUtils.class$("com.sap.engine.services.dbpool.deploy.XMLUtils")) : class$com$sap$engine$services$dbpool$deploy$XMLUtils).getClassLoader());
            StandardDOMParser standardDOMParser = new StandardDOMParser();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            return standardDOMParser;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    private static StandardDOMWriter createStandardDOMWriter() {
        ClassLoader previousLoader = null;
        try {
            previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$dbpool$deploy$XMLUtils == null ? (class$com$sap$engine$services$dbpool$deploy$XMLUtils = XMLUtils.class$("com.sap.engine.services.dbpool.deploy.XMLUtils")) : class$com$sap$engine$services$dbpool$deploy$XMLUtils).getClassLoader());
            StandardDOMWriter standardDOMWriter = new StandardDOMWriter();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            return standardDOMWriter;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    private static DocumentBuilder createDocumentBuilder() throws IOException {
        ClassLoader previousLoader = null;
        try {
            try {
                previousLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$dbpool$deploy$XMLUtils == null ? (class$com$sap$engine$services$dbpool$deploy$XMLUtils = XMLUtils.class$("com.sap.engine.services.dbpool.deploy.XMLUtils")) : class$com$sap$engine$services$dbpool$deploy$XMLUtils).getClassLoader());
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Object var3_3 = null;
                Thread.currentThread().setContextClassLoader(previousLoader);
                return documentBuilder;
            }
            catch (ParserConfigurationException pcfe) {
                throw new BaseIOException("dbpool_0500", "javax.xml.parsers.DocumentBuilder", (Throwable)pcfe);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

