/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.deploy;

import com.sap.engine.lib.xml.StandardDOMParser;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class LibProviderDocument {
    public static final String dtd = "<!DOCTYPE provider-descriptor [<!ELEMENT provider-descriptor (display-name, component-name, description?, major-version, minor-version, micro-version, provider-name?, group-name?, references?, jars)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT component-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT major-version (#PCDATA)>\n<!ELEMENT minor-version (#PCDATA)>\n<!ELEMENT micro-version (#PCDATA)>\n<!ELEMENT provider-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT references (reference)*>\n<!ELEMENT reference (#PCDATA)>\n  <!ATTLIST reference type (service|library|interface) #REQUIRED>\n  <!ATTLIST reference strength (weak) #REQUIRED>\n<!ELEMENT jars (jar-name)+>\n<!ELEMENT jar-name (#PCDATA)>\n]>";
    public static final String WEAK_REF = "weak";
    private String displayName = null;
    private String componentName = null;
    private String description = null;
    private String majorVersion = "1";
    private String minorVersion = "1";
    private String microVersion = "1";
    private String providerName = "sap.com";
    private Hashtable references = null;
    private Hashtable refStrength = null;
    private String[] jars = null;
    private Document mainDocument = null;

    public Document getMainDocument() {
        return this.mainDocument;
    }

    public void loadDocumentFromFields() {
        ClassLoader previousLoader = null;
        try {
            previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.mainDocument = StandardDOMParser.createDocument();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
        Element mainElement = this.mainDocument.createElement("provider-descriptor");
        this.mainDocument.appendChild(mainElement);
        this.load(mainElement, this.displayName, "display-name");
        this.load(mainElement, this.componentName, "component-name");
        if (this.description != null) {
            this.load(mainElement, this.description, "description");
        }
        this.load(mainElement, this.majorVersion, "major-version");
        this.load(mainElement, this.minorVersion, "minor-version");
        this.load(mainElement, this.microVersion, "micro-version");
        if (this.providerName != null) {
            this.load(mainElement, this.providerName, "provider-name");
        }
        if (this.references != null && this.references.size() > 0) {
            this.loadRefs(mainElement);
        }
        this.loadJars(mainElement);
    }

    private void loadJars(Element parent) {
        Element jarsEl = this.mainDocument.createElement("jars");
        int i = 0;
        while (i < this.jars.length) {
            this.load(jarsEl, this.jars[i], "jar-name");
            ++i;
        }
        parent.appendChild(jarsEl);
    }

    private void loadRefs(Element parent) {
        Element refsEl = this.mainDocument.createElement("references");
        String key = null;
        String t = null;
        Element el = null;
        Enumeration enumeration = this.references.keys();
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            t = (String)this.references.get(key);
            el = this.load(refsEl, key, "reference");
            el.setAttribute("type", t);
            el.setAttribute("strength", WEAK_REF);
        }
        parent.appendChild(refsEl);
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMajorVersion(String majorVersion) {
        this.majorVersion = majorVersion;
    }

    public void setMinorVersion(String minorVersion) {
        this.minorVersion = minorVersion;
    }

    public void setMicroVersion(String microVersion) {
        this.microVersion = microVersion;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public void setReferences(Hashtable references) {
        this.references = references;
    }

    public void setJars(String[] jars) {
        this.jars = jars;
    }

    private Element load(Element el, String value, String tagName) {
        if (value == null) {
            value = "";
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return nextElement;
    }
}

