/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.deploy;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.container.monitor.SystemMonitor;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.lib.jar.JarUtils;
import com.sap.engine.lib.util.ArrayLong;
import com.sap.engine.lib.util.HashMapLongObject;
import com.sap.engine.lib.util.concurrent.CountDown;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.connector.ResourceObjectFactory;
import com.sap.engine.services.connector.jca.ConnectionHashSet;
import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.cci.ConnectionHandle;
import com.sap.engine.services.dbpool.deploy.ContainerImpl;
import com.sap.engine.services.dbpool.deploy.DBInitializer;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.dbpool.deploy.LibProviderDocument;
import com.sap.engine.services.dbpool.deploy.StatementEntry;
import com.sap.engine.services.dbpool.deploy.XMLUtils;
import com.sap.engine.services.dbpool.exceptions.BaseRemoteException;
import com.sap.engine.services.dbpool.spi.LocalTXManagedConnectionImpl;
import com.sap.engine.services.deploy.DeployService;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.rmi.PortableRemoteObject;

public class DataSourceManagerImpl
extends PortableRemoteObject
implements DataSourceManager {
    private Properties ctxProps;
    private ApplicationServiceContext serviceContext;
    private DeployService deployService;
    private ContainerImpl containerImpl;
    private String workDir;
    private JDBCDescriptor sysDSDescr;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$deploy$DataSourceManagerImpl == null ? (class$com$sap$engine$services$dbpool$deploy$DataSourceManagerImpl = DataSourceManagerImpl.class$("com.sap.engine.services.dbpool.deploy.DataSourceManagerImpl")) : class$com$sap$engine$services$dbpool$deploy$DataSourceManagerImpl));
    private static final Category category = Category.SYS_SERVER;
    private static final int logDebug = 100;
    protected static final String APP_NAME = "DBInitProcess";
    protected static final String ROOT_CFG_NAME = "dbpool";
    private static final String DRV_HT_NAME = "drv";
    private static final String DBINIT_HT_NAME = "dbInit";
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$deploy$DataSourceManagerImpl;

    public DataSourceManagerImpl(ApplicationServiceContext _serviceContext, JDBCDescriptor _sysDSDescr) throws RemoteException {
        this.serviceContext = _serviceContext;
        this.sysDSDescr = _sysDSDescr;
        this.ctxProps = new Properties();
        ((Hashtable)this.ctxProps).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        ((Hashtable)this.ctxProps).put("domain", "true");
        this.workDir = this.serviceContext.getServiceState().getWorkingDirectoryName();
        this.deployService = (DeployService)this.serviceContext.getContainerContext().getObjectRegistry().getServiceInterface("deploy");
    }

    public void deployJdbcDriver(String driverName, SerializableFile[] driverFiles) throws RemoteException {
        String libJar;
        if (location.beLogged(100)) {
            location.logT(100, "--> DataSourceManagerImpl.deployJdbcDriver(): Driver name = " + driverName);
        }
        if ("SYSTEM_DRIVER".equals(driverName)) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0412", "overwrite");
            brex.log();
            throw brex;
        }
        String[] fileNames = new String[driverFiles.length];
        LoadContext loadCtx = this.serviceContext.getCoreContext().getLoadContext();
        if (loadCtx.getClassLoader("library:" + driverName) != null) {
            if (category.beLogged(300)) {
                category.logT(300, location, "'" + driverName + "' JDBC driver library will be updated...");
            }
            this.undeployJdbcDriver(driverName);
        }
        int i = 0;
        while (i < driverFiles.length) {
            this.checkSerializableFile(driverFiles[i], "JDBC driver");
            fileNames[i] = this.writeLocalFile(driverFiles[i]).getAbsolutePath();
            ++i;
        }
        try {
            libJar = this.makeLibraryJar(driverName, fileNames, null);
        }
        catch (IOException ioex) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0401", driverName, (Throwable)ioex);
            brex.log();
            throw brex;
        }
        try {
            this.deployService.deployLibrary(libJar);
            if (category.beLogged(300)) {
                category.logT(300, location, "Created '" + driverName + "' JDBC driver library.");
            }
            Object var10_10 = null;
            new File(libJar).delete();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            new File(libJar).delete();
            throw throwable;
        }
        Hashtable drivers = this.getDrivers();
        drivers.put(driverName, fileNames);
        this.updateConfigEntry(DRV_HT_NAME, drivers);
        if (location.beLogged(100)) {
            location.logT(100, "<-- DataSourceManagerImpl.deployJdbcDriver(): Driver name = " + driverName);
        }
    }

    public void undeployJdbcDriver(String driverName) throws RemoteException {
        if (location.beLogged(100)) {
            location.logT(100, "--> DataSourceManagerImpl.undeployJdbcDriver(): Driver name = " + driverName);
        }
        if ("SYSTEM_DRIVER".equals(driverName)) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0412", "remove");
            brex.log();
            throw brex;
        }
        this.deployService.removeLibrary(driverName);
        if (category.beLogged(300)) {
            category.logT(300, location, "Removed '" + driverName + "' JDBC driver library.");
        }
        Hashtable drivers = this.getDrivers();
        drivers.remove(driverName);
        this.updateConfigEntry(DRV_HT_NAME, drivers);
        if (location.beLogged(100)) {
            location.logT(100, "<-- DataSourceManagerImpl.undeployJdbcDriver(): Driver name = " + driverName);
        }
    }

    public String defineJdbcDriver(String driverName) throws RemoteException {
        if ("SYSTEM_DRIVER".equals(driverName)) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0412", "overwrite");
            brex.log();
            throw brex;
        }
        Hashtable drivers = this.getDrivers();
        if (drivers.get(driverName) == null) {
            SystemMonitor systemMonitor = this.serviceContext.getContainerContext().getSystemMonitor();
            drivers.put(driverName, systemMonitor.getLibrary(driverName).getJars());
            this.updateConfigEntry(DRV_HT_NAME, drivers);
            return " Driver is defined successfully";
        }
        return " This driver is defined already";
    }

    public String undefineJdbcDriver(String driverName) throws RemoteException {
        if ("SYSTEM_DRIVER".equals(driverName)) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0412", "undefine");
            brex.log();
            throw brex;
        }
        Hashtable drivers = this.getDrivers();
        if (drivers.remove(driverName) != null) {
            this.updateConfigEntry(DRV_HT_NAME, drivers);
            return " Driver is undefined successfully";
        }
        return " This driver was not defined";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String deploy(SerializableFile xmlFile) throws RemoteException {
        String appName;
        block6: {
            if (location.beLogged(100)) {
                location.logT(100, "--> DataSourceManagerImpl.deploy(): SerializableFile name = " + xmlFile.getFileName());
            }
            this.checkSerializableFile(xmlFile, "DataSource descriptor");
            File temp = this.writeLocalFile(xmlFile);
            Properties props = new Properties();
            props.setProperty("isStandAlone", "true");
            try {
                try {
                    String[] depInfo = this.deployService.deploy(temp.getAbsolutePath(), "JDBCConnector", null, props);
                    appName = depInfo[0].substring("Application : ".length());
                }
                catch (WarningException wex) {
                    location.traceThrowableT(300, "Deploy Warning: ", (Throwable)wex);
                    appName = wex.getResult()[0].substring("Application : ".length());
                    Object var7_8 = null;
                    temp.delete();
                    break block6;
                }
                Object var7_7 = null;
                temp.delete();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                temp.delete();
                throw throwable;
            }
        }
        this.startApplication(appName);
        if (location.beLogged(100)) {
            location.logT(100, "<-- DataSourceManagerImpl.deploy(): SerializableFile name = " + xmlFile.getFileName());
        }
        return appName;
    }

    public String createDataSource(String applicationName, JDBCDescriptor jdbcDescriptor) throws RemoteException {
        if (location.beLogged(100)) {
            location.logT(100, "--> DataSourceManagerImpl.createDataSource(): Application name = " + applicationName);
        }
        if (applicationName == null) {
            try {
                PoolFrame._setServiceProperties(XMLUtils.convertJDBCDescrToProps(jdbcDescriptor));
            }
            catch (IllegalArgumentException iaex) {
                BaseRemoteException brex = new BaseRemoteException("dbpool_0413", iaex);
                if (category.beLogged(500)) {
                    category.logThrowableT(500, location, "The properties of the default DataSource you tried to save are not correct.", (Throwable)iaex);
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "DataSourceManagerImpl.createDataSource(): The default DataSource properties are not correct. Full stacktrace: ", (Throwable)brex);
                }
                throw brex;
            }
            catch (ServiceException sex) {
                BaseRemoteException brex = new BaseRemoteException("dbpool_0414", (Throwable)((Object)sex));
                if (category.beLogged(500)) {
                    category.logThrowableT(500, location, "Cannot save the properties of the default DataSource. Possible reasons: The Configuration is locked or there is a problem with the kernel.", (Throwable)((Object)sex));
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "DataSourceManagerImpl.createDataSource(): Cannot save the DBPool Service properties. Full stacktrace: ", (Throwable)brex);
                }
                throw brex;
            }
            if (location.beLogged(100)) {
                location.logT(100, "<-- DataSourceManagerImpl.createDataSource(): Application name = " + applicationName);
            }
            return null;
        }
        String file = this.workDir + File.separatorChar + jdbcDescriptor.getDataSourceName() + ".xml";
        try {
            XMLUtils.generateXML(applicationName, jdbcDescriptor, file);
        }
        catch (IOException ioex) {
            if (location.beLogged(500)) {
                location.logT(500, "DataSourceManagerImpl.createDataSource(): Cannot generate file '" + file + "'. Reason: " + ioex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)ioex);
            }
            throw new BaseRemoteException("dbpool_0402", file, (Throwable)ioex);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- DataSourceManagerImpl.createDataSource(): Application name = " + applicationName + ". Calling DataSourceManagerImpl.deploy()...");
        }
        return this.deploy(new SerializableFile(file));
    }

    public String testDS(String dsName, String sql) throws RemoteException {
        return this.executeFromAppThread(dsName, new StatementEntry[]{new StatementEntry(sql, false)});
    }

    public Hashtable getDrivers() throws RemoteException {
        return this.readConfigEntry(DRV_HT_NAME);
    }

    public Hashtable getDataSources() throws RemoteException {
        return this.containerImpl.appsDescr;
    }

    public Hashtable getAliases() throws RemoteException {
        return this.containerImpl.dsAliases;
    }

    public Hashtable getServerLibraries() throws RemoteException {
        return this.deployService.getServerLibraries();
    }

    public String dbInit(SerializableFile xmlFile) throws RemoteException {
        Hashtable dbInitHT;
        if (location.beLogged(100)) {
            location.logT(100, "--> DataSourceManagerImpl.dbInit(): SerializableFile name = " + xmlFile.getFileName());
        }
        this.checkSerializableFile(xmlFile, "DB init descriptor");
        File temp = this.writeLocalFile(xmlFile);
        try {
            try {
                dbInitHT = XMLUtils.processDBInitXML(temp);
            }
            catch (IOException ioex) {
                BaseRemoteException brex = new BaseRemoteException("dbpool_0403", xmlFile.getFileName(), (Throwable)ioex);
                brex.log();
                throw brex;
            }
            catch (IllegalArgumentException iaex) {
                BaseRemoteException brex = new BaseRemoteException("dbpool_0403", xmlFile.getFileName(), (Throwable)iaex);
                brex.log();
                throw brex;
            }
            Object var8_4 = null;
            temp.delete();
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            temp.delete();
            throw throwable;
        }
        Vector<String> initFailedDSNames = new Vector<String>();
        Enumeration enumeration = dbInitHT.keys();
        while (enumeration.hasMoreElements()) {
            String dsName = (String)enumeration.nextElement();
            StatementEntry[] statements = (StatementEntry[])dbInitHT.get(dsName);
            this.addInitStatements(dsName, statements);
            try {
                this.executeInitStatements(dsName);
                if (!category.beLogged(300)) continue;
                category.logT(300, location, "DataSource '" + dsName + "' was successfully initialized with the SQL statements from '" + xmlFile.getFileName() + "' file.");
            }
            catch (RemoteException rex) {
                category.logThrowableT(500, location, "DataSource '" + dsName + "' was NOT initialized with the SQL statements from '" + xmlFile.getFileName() + "' file.", (Throwable)rex);
                initFailedDSNames.add(dsName);
            }
        }
        if (!initFailedDSNames.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            String[] dsNames = initFailedDSNames.toArray(new String[0]);
            if (dsNames.length == 1) {
                sb.append(" DataSource ");
            } else {
                sb.append(" DataSources ");
            }
            int i = 0;
            while (i < dsNames.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("'");
                sb.append(dsNames[i]);
                sb.append("'");
                ++i;
            }
            sb.append(" could not be initialized properly. View log files for more details.");
            if (location.beLogged(100)) {
                location.logT(100, "<-- DataSourceManagerImpl.dbInit(): SerializableFile name = " + xmlFile.getFileName());
            }
            return sb.toString();
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- DataSourceManagerImpl.dbInit(): SerializableFile name = " + xmlFile.getFileName());
        }
        return " DB Initialization accomplished.";
    }

    public void addInitStatements(String dsName, StatementEntry[] statements) throws RemoteException {
        if (location.beLogged(100)) {
            location.logT(100, "--> DataSourceManagerImpl.addInitStatements(): DataSource name = " + dsName);
        }
        if (this.getJDBCDescriptorFromContainer(dsName) == null) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0404", dsName);
            brex.log();
            throw brex;
        }
        if (statements == null || statements.length == 0) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0405", dsName);
            brex.log();
            throw brex;
        }
        Hashtable dbInitStatements = this.getInitStatements();
        dbInitStatements.put(dsName, statements);
        this.updateConfigEntry(DBINIT_HT_NAME, dbInitStatements);
        if (location.beLogged(100)) {
            location.logT(100, "<-- DataSourceManagerImpl.addInitStatements(): DataSource name = " + dsName);
        }
    }

    public String removeInitStatements(String dsName) throws RemoteException {
        Hashtable dbInitStatements;
        if (location.beLogged(100)) {
            location.logT(100, "--> DataSourceManagerImpl.removeInitStatements(): DataSource name = " + dsName);
        }
        if ((dbInitStatements = this.getInitStatements()).remove(dsName) != null) {
            this.updateConfigEntry(DBINIT_HT_NAME, dbInitStatements);
            if (location.beLogged(100)) {
                location.logT(100, "<-- DataSourceManagerImpl.removeInitStatements(): DataSource name = " + dsName);
            }
            return " Statements are removed successfully.";
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- DataSourceManagerImpl.removeInitStatements(): DataSource name = " + dsName);
        }
        return " There are no statements specified for this DataSource.";
    }

    public Hashtable getInitStatements() throws RemoteException {
        return this.readConfigEntry(DBINIT_HT_NAME);
    }

    public String executeInitStatements(String dsName) throws RemoteException {
        if (location.beLogged(100)) {
            location.logT(100, "--> DataSourceManagerImpl.executeInitStatements(): DataSource name = " + dsName);
        }
        Hashtable dbInitStatements = this.getInitStatements();
        StatementEntry[] statements = (StatementEntry[])dbInitStatements.get(dsName);
        if (location.beLogged(100)) {
            location.logT(100, "<-- DataSourceManagerImpl.executeInitStatements(): DataSource name = " + dsName);
        }
        if (statements != null && statements.length > 0) {
            return this.executeFromAppThread(dsName, statements);
        }
        return " There are no statements specified for this DataSource.";
    }

    public ArrayLong listFreeConnections(String dsName) throws RemoteException {
        try {
            ConnectionHashSet cs = ResourceObjectFactory.getConnectionSet(dsName);
            ArrayLong mcIDs = new ArrayLong();
            if (cs != null) {
                ConnectionHashSet connectionHashSet = cs;
                synchronized (connectionHashSet) {
                    Iterator iter = cs.iterator();
                    while (iter.hasNext()) {
                        mcIDs.add(((LocalTXManagedConnectionImpl)iter.next()).getMCID());
                    }
                }
            }
            return mcIDs;
        }
        catch (ResourceException rex) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0406", new Object[]{"ResourceException", "DataSourceManager.listFreeConnections()"}, (Throwable)rex);
            throw brex;
        }
    }

    public HashMapLongObject listUsedConnections(String dsName) throws RemoteException {
        try {
            ConnectionHashSet cs = ResourceObjectFactory.getConnectionSet(dsName);
            HashMapLongObject usedMCIDs = new HashMapLongObject();
            if (cs != null) {
                ConnectionHashSet connectionHashSet = cs;
                synchronized (connectionHashSet) {
                    Iterator iter = cs.getGivenConnections().iterator();
                    while (iter.hasNext()) {
                        LocalTXManagedConnectionImpl mc = (LocalTXManagedConnectionImpl)iter.next();
                        ArrayLong handleIDs = new ArrayLong();
                        Iterator hIter = mc.getConnectionSet().iterator();
                        while (hIter.hasNext()) {
                            handleIDs.add(((ConnectionHandle)hIter.next()).getHandleID());
                        }
                        usedMCIDs.put(mc.getMCID(), handleIDs);
                    }
                }
            }
            return usedMCIDs;
        }
        catch (ResourceException rex) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0406", new Object[]{"ResourceException", "DataSourceManager.listUsedConnections()"}, (Throwable)rex);
            throw brex;
        }
    }

    public void removeApplication(String appName) throws RemoteException {
        this.deployService.remove(appName);
    }

    public void startApplication(String appName) throws RemoteException {
        this.containerImpl.deployCommunicator.startApplicationAndWait(appName);
    }

    public void stopApplication(String appName) throws RemoteException {
        this.containerImpl.deployCommunicator.stopApplicationAndWait(appName);
    }

    public boolean isApplicationStarted(String appName) throws RemoteException {
        return "STARTED".equals(this.deployService.getApplicationStatus(appName));
    }

    public String[] getMyApplications() throws RemoteException {
        return this.containerImpl.deployCommunicator.getMyApplications();
    }

    public boolean isStandAloneApplication(String appName) throws RemoteException {
        try {
            return this.containerImpl.deployCommunicator.isStandAloneApplication(appName);
        }
        catch (DeploymentException dex) {
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "DataSourceManagerImpl.isStandAloneApplication(): Failed to determine if the application is standalone. Full stacktrace:", (Throwable)((Object)dex));
            }
            throw new BaseRemoteException("dbpool_0407", appName, (Throwable)((Object)dex));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateDataSourceApplication(String appName, Vector dsVtr, boolean restartApp) throws RemoteException {
        block43: {
            Enumeration enumeration2;
            Throwable throwable3;
            block42: {
                if (location.beLogged(100)) {
                    location.logT(100, "--> DataSourceManagerImpl.updateDataSourceApplication(): Application name = " + appName);
                }
                if (appName.endsWith(" Service") || appName.endsWith(" Library")) {
                    String filename = this.workDir + File.separatorChar + "data-sources.xml";
                    try {
                        try {
                            XMLUtils.generateAllXML(null, dsVtr, filename);
                            File file = new File(filename);
                            if (appName.endsWith(" Service")) {
                                PoolFrame.setServicePersistentFile(appName.substring(0, appName.indexOf(" Service")), file, true);
                            } else {
                                PoolFrame.setLibraryPersistentFile(appName.substring(0, appName.indexOf(" Library")), file, true);
                            }
                        }
                        catch (IOException ioex) {
                            BaseRemoteException brex = new BaseRemoteException("dbpool_0415", new Object[]{appName, filename}, (Throwable)ioex);
                            brex.log();
                            throw brex;
                        }
                        catch (ServiceException sex) {
                            BaseRemoteException brex = new BaseRemoteException("dbpool_0415", new Object[]{appName, filename}, (Throwable)((Object)sex));
                            brex.log();
                            throw brex;
                        }
                        Object var9_9 = null;
                        new File(filename).delete();
                    }
                    catch (Throwable throwable2) {
                        Object var9_10 = null;
                        new File(filename).delete();
                        throw throwable2;
                    }
                }
                Vector<File> files = new Vector<File>();
                try {
                    try {
                        Configuration appConfig = this.containerImpl.deployCommunicator.startRuntimeChanges(appName).getSubConfiguration("JDBCConnector");
                        String[] dbFiles = this.containerImpl.getAllSecureFilenames(appConfig);
                        int i = 0;
                        while (i < dbFiles.length) {
                            if (XMLUtils.isDataSourceXML(this.containerImpl.getSecureFile(appConfig, dbFiles[i])) != null) {
                                String filename = this.workDir + File.separatorChar + dbFiles[i];
                                XMLUtils.generateAllXML(appName, dsVtr, filename);
                                File xmlFile = new File(filename);
                                files.add(xmlFile);
                                this.containerImpl.storeSecureFile(appConfig, dbFiles[i], xmlFile);
                                this.containerImpl.beforeRuntimeChangesInDataSources(appName, dsVtr, restartApp);
                                this.containerImpl.deployCommunicator.makeRuntimeChanges(appName, restartApp);
                                Object var12_28 = null;
                                Enumeration enumeration2 = files.elements();
                                while (enumeration2.hasMoreElements()) {
                                    ((File)enumeration2.nextElement()).delete();
                                }
                                return;
                            }
                            ++i;
                        }
                    }
                    catch (RemoteException rex) {
                        block38: {
                            try {
                                this.containerImpl.deployCommunicator.rollbackRuntimeChanges(appName);
                            }
                            catch (RemoteException innerRex) {
                                if (location.beLogged(500)) {
                                    location.logT(500, "DataSourceManagerImpl.updateDataSourceApplication(): RemoteException occured during rollbackRuntimeChanges() of the application '" + appName + "'. Reason: " + innerRex.toString());
                                }
                                if (!location.beLogged(100)) break block38;
                                location.traceThrowableT(100, "Full stacktrace:", (Throwable)innerRex);
                            }
                        }
                        location.logT(500, "DataSourceManagerImpl.updateDataSourceApplication(): RemoteException occured during makeRuntimeChanges() of the application '" + appName + "'. Reason: " + rex.toString());
                        if (location.beLogged(100)) {
                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                        }
                        throw rex;
                    }
                    catch (IOException ioex) {
                        block39: {
                            try {
                                this.containerImpl.deployCommunicator.rollbackRuntimeChanges(appName);
                            }
                            catch (RemoteException innerRex) {
                                if (location.beLogged(500)) {
                                    location.logT(500, "DataSourceManagerImpl.updateDataSourceApplication(): RemoteException occured during rollbackRuntimeChanges() of the application '" + appName + "'. Reason: " + innerRex.toString());
                                }
                                if (!location.beLogged(100)) break block39;
                                location.traceThrowableT(100, "Full stacktrace:", (Throwable)innerRex);
                            }
                        }
                        BaseRemoteException brex = new BaseRemoteException("dbpool_0408", appName, (Throwable)ioex);
                        brex.log();
                        throw brex;
                    }
                    catch (ConfigurationException cex) {
                        block40: {
                            try {
                                this.containerImpl.deployCommunicator.rollbackRuntimeChanges(appName);
                            }
                            catch (RemoteException innerRex) {
                                if (location.beLogged(500)) {
                                    location.logT(500, "DataSourceManagerImpl.updateDataSourceApplication(): RemoteException occured during rollbackRuntimeChanges() of the application '" + appName + "'. Reason: " + innerRex.toString());
                                }
                                if (!location.beLogged(100)) break block40;
                                location.traceThrowableT(100, "Full stacktrace:", (Throwable)innerRex);
                            }
                        }
                        BaseRemoteException brex = new BaseRemoteException("dbpool_0408", appName, (Throwable)((Object)cex));
                        brex.log();
                        throw brex;
                    }
                    catch (DeploymentException dex) {
                        block41: {
                            try {
                                this.containerImpl.deployCommunicator.rollbackRuntimeChanges(appName);
                            }
                            catch (RemoteException innerRex) {
                                if (location.beLogged(500)) {
                                    location.logT(500, "DataSourceManagerImpl.updateDataSourceApplication(): RemoteException occured during rollbackRuntimeChanges() of the application '" + appName + "'. Reason: " + innerRex.toString());
                                }
                                if (!location.beLogged(100)) break block41;
                                location.traceThrowableT(100, "Full stacktrace:", (Throwable)innerRex);
                            }
                        }
                        BaseRemoteException brex = new BaseRemoteException("dbpool_0408", appName, (Throwable)((Object)dex));
                        brex.log();
                        throw brex;
                    }
                }
                catch (Throwable throwable3) {
                    Object var12_30 = null;
                    enumeration2 = files.elements();
                    break block42;
                }
                Object var12_29 = null;
                Enumeration enumeration2 = files.elements();
                while (enumeration2.hasMoreElements()) {
                    ((File)enumeration2.nextElement()).delete();
                }
                break block43;
            }
            while (true) {
                if (!enumeration2.hasMoreElements()) {
                    throw throwable3;
                }
                ((File)enumeration2.nextElement()).delete();
            }
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- DataSourceManagerImpl.updateDataSourceApplication(): Application name = " + appName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateAliasesApplication(String appName, Hashtable aliases) throws RemoteException {
        block53: {
            Enumeration enumeration2;
            Throwable throwable3;
            block51: {
                Vector<File> files;
                block46: {
                    block45: {
                        block52: {
                            if (location.beLogged(100)) {
                                location.logT(100, "--> DataSourceManagerImpl.updateAliasesApplication(): Application name = " + appName);
                            }
                            if (!appName.endsWith(" Service") && !appName.endsWith(" Library")) break block52;
                            if (aliases.isEmpty()) {
                                try {
                                    if (appName.endsWith(" Service")) {
                                        PoolFrame.setServicePersistentFile(appName.substring(0, appName.indexOf(" Service")), null, false);
                                    }
                                    PoolFrame.setLibraryPersistentFile(appName.substring(0, appName.indexOf(" Library")), null, false);
                                }
                                catch (ServiceException sex) {
                                    BaseRemoteException brex = new BaseRemoteException("dbpool_0415", new Object[]{appName, "data-source-aliases.xml"}, (Throwable)((Object)sex));
                                    brex.log();
                                    throw brex;
                                }
                            } else {
                                String filename = this.workDir + File.separatorChar + "data-source-aliases.xml";
                                try {
                                    try {
                                        XMLUtils.generateAliasesXML(null, aliases, filename);
                                        File file = new File(filename);
                                        if (appName.endsWith(" Service")) {
                                            PoolFrame.setServicePersistentFile(appName.substring(0, appName.indexOf(" Service")), file, false);
                                        } else {
                                            PoolFrame.setLibraryPersistentFile(appName.substring(0, appName.indexOf(" Library")), file, false);
                                        }
                                    }
                                    catch (IOException ioex) {
                                        BaseRemoteException brex = new BaseRemoteException("dbpool_0415", new Object[]{appName, filename}, (Throwable)ioex);
                                        brex.log();
                                        throw brex;
                                    }
                                    catch (ServiceException sex) {
                                        BaseRemoteException brex = new BaseRemoteException("dbpool_0415", new Object[]{appName, filename}, (Throwable)((Object)sex));
                                        brex.log();
                                        throw brex;
                                    }
                                    Object var8_10 = null;
                                    new File(filename).delete();
                                }
                                catch (Throwable throwable2) {
                                    Object var8_11 = null;
                                    new File(filename).delete();
                                    throw throwable2;
                                }
                            }
                        }
                        files = new Vector<File>();
                        try {
                            try {
                                Configuration appConfig = this.containerImpl.deployCommunicator.startRuntimeChanges(appName).getSubConfiguration("JDBCConnector");
                                String[] dbFiles = this.containerImpl.getAllSecureFilenames(appConfig);
                                if (dbFiles.length == 0 && !aliases.isEmpty()) {
                                    String filename = this.workDir + File.separatorChar + "data-source-aliases.xml";
                                    XMLUtils.generateAliasesXML(appName, aliases, filename);
                                    File xmlFile = new File(filename);
                                    files.add(xmlFile);
                                    this.containerImpl.storeSecureFile(appConfig, "data-source-aliases.xml", xmlFile);
                                    this.containerImpl.beforeRuntimeChangesInAliases(appName, aliases);
                                    this.containerImpl.deployCommunicator.makeRuntimeChanges(appName, true);
                                    Object var11_31 = null;
                                    Enumeration enumeration2 = files.elements();
                                    while (enumeration2.hasMoreElements()) {
                                        ((File)enumeration2.nextElement()).delete();
                                    }
                                    return;
                                }
                                int i = 0;
                                while (i < dbFiles.length) {
                                    if (XMLUtils.isAliasesXML(this.containerImpl.getSecureFile(appConfig, dbFiles[i]))) {
                                        if (aliases.isEmpty()) {
                                            this.containerImpl.deleteSecureFile(appConfig, dbFiles[i]);
                                        } else {
                                            String filename = this.workDir + File.separatorChar + dbFiles[i];
                                            XMLUtils.generateAliasesXML(appName, aliases, filename);
                                            File xmlFile = new File(filename);
                                            files.add(xmlFile);
                                            this.containerImpl.storeSecureFile(appConfig, dbFiles[i], xmlFile);
                                        }
                                        this.containerImpl.beforeRuntimeChangesInAliases(appName, aliases);
                                        this.containerImpl.deployCommunicator.makeRuntimeChanges(appName, true);
                                        break block45;
                                    }
                                    ++i;
                                }
                                break block46;
                            }
                            catch (RemoteException rex) {
                                block47: {
                                    try {
                                        this.containerImpl.deployCommunicator.rollbackRuntimeChanges(appName);
                                    }
                                    catch (RemoteException innerRex) {
                                        if (location.beLogged(500)) {
                                            location.logT(500, "DataSourceManagerImpl.updateAliasesApplication(): RemoteException occured during rollbackRuntimeChanges() of the application '" + appName + "'. Reason: " + innerRex.toString());
                                        }
                                        if (!location.beLogged(100)) break block47;
                                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)innerRex);
                                    }
                                }
                                location.logT(500, "DataSourceManagerImpl.updateAliasesApplication(): RemoteException occured during makeRuntimeChanges() of the application '" + appName + "'. Reason: " + rex.toString());
                                if (location.beLogged(100)) {
                                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                                }
                                throw rex;
                            }
                            catch (IOException ioex) {
                                block48: {
                                    try {
                                        this.containerImpl.deployCommunicator.rollbackRuntimeChanges(appName);
                                    }
                                    catch (RemoteException innerRex) {
                                        if (location.beLogged(500)) {
                                            location.logT(500, "DataSourceManagerImpl.updateAliasesApplication(): RemoteException occured during rollbackRuntimeChanges() of the application '" + appName + "'. Reason: " + innerRex.toString());
                                        }
                                        if (!location.beLogged(100)) break block48;
                                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)innerRex);
                                    }
                                }
                                BaseRemoteException brex = new BaseRemoteException("dbpool_0408", appName, (Throwable)ioex);
                                brex.log();
                                throw brex;
                            }
                            catch (ConfigurationException cex) {
                                block49: {
                                    try {
                                        this.containerImpl.deployCommunicator.rollbackRuntimeChanges(appName);
                                    }
                                    catch (RemoteException innerRex) {
                                        if (location.beLogged(500)) {
                                            location.logT(500, "DataSourceManagerImpl.updateAliasesApplication(): RemoteException occured during rollbackRuntimeChanges() of the application '" + appName + "'. Reason: " + innerRex.toString());
                                        }
                                        if (!location.beLogged(100)) break block49;
                                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)innerRex);
                                    }
                                }
                                BaseRemoteException brex = new BaseRemoteException("dbpool_0408", appName, (Throwable)((Object)cex));
                                brex.log();
                                throw brex;
                            }
                            catch (DeploymentException dex) {
                                block50: {
                                    try {
                                        this.containerImpl.deployCommunicator.rollbackRuntimeChanges(appName);
                                    }
                                    catch (RemoteException innerRex) {
                                        if (location.beLogged(500)) {
                                            location.logT(500, "DataSourceManagerImpl.updateAliasesApplication(): RemoteException occured during rollbackRuntimeChanges() of the application '" + appName + "'. Reason: " + innerRex.toString());
                                        }
                                        if (!location.beLogged(100)) break block50;
                                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)innerRex);
                                    }
                                }
                                BaseRemoteException brex = new BaseRemoteException("dbpool_0408", appName, (Throwable)((Object)dex));
                                brex.log();
                                throw brex;
                            }
                        }
                        catch (Throwable throwable3) {
                            Object var11_34 = null;
                            enumeration2 = files.elements();
                            break block51;
                        }
                    }
                    Object var11_32 = null;
                    Enumeration enumeration2 = files.elements();
                    while (enumeration2.hasMoreElements()) {
                        ((File)enumeration2.nextElement()).delete();
                    }
                    return;
                }
                Object var11_33 = null;
                Enumeration enumeration2 = files.elements();
                while (enumeration2.hasMoreElements()) {
                    ((File)enumeration2.nextElement()).delete();
                }
                break block53;
            }
            while (true) {
                if (!enumeration2.hasMoreElements()) {
                    throw throwable3;
                }
                ((File)enumeration2.nextElement()).delete();
            }
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- DataSourceManagerImpl.updateAliasesApplication(): Application name = " + appName);
        }
    }

    public void registerManagementListener(ManagementListener managementListener) {
        this.containerImpl.setManagementListener(managementListener);
    }

    public int getInitSize(String dataSourceName) throws RemoteException {
        JDBCDescriptor descr = this.getJDBCDescriptorFromContainer(dataSourceName);
        if (descr == null) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0404", dataSourceName);
            brex.log();
            throw brex;
        }
        return descr.getInitConnections();
    }

    public int getMinSize(String dataSourceName) throws RemoteException {
        return 0;
    }

    public int getMaxSize(String dataSourceName) throws RemoteException {
        JDBCDescriptor descr = this.getJDBCDescriptorFromContainer(dataSourceName);
        if (descr == null) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0404", dataSourceName);
            brex.log();
            throw brex;
        }
        return descr.getMaxConnections();
    }

    public int getCurrentSize(String dataSourceName) throws RemoteException {
        int size;
        block2: {
            size = -1;
            try {
                size = this.listFreeConnections(dataSourceName).size();
            }
            catch (RemoteException rex) {
                if (!location.beLogged(100)) break block2;
                location.traceThrowableT(100, "DataSource '" + dataSourceName + "' does not exist.", (Throwable)rex);
            }
        }
        return size;
    }

    public int getIncrementStep(String dataSourceName) throws RemoteException {
        return 0;
    }

    public int getUsedConnectionsCount(String dataSourceName) throws RemoteException {
        int size;
        block2: {
            size = -1;
            try {
                size = this.listUsedConnections(dataSourceName).size();
            }
            catch (RemoteException rex) {
                if (!location.beLogged(100)) break block2;
                location.traceThrowableT(100, "DataSource '" + dataSourceName + "' does not exist.", (Throwable)rex);
            }
        }
        return size;
    }

    public JDBCDescriptor getSystemDataSourceDescriptor() throws RemoteException {
        return this.sysDSDescr;
    }

    public void setContainerImpl(ContainerImpl _containerImpl) {
        this.containerImpl = _containerImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Hashtable readConfigEntry(String name) throws RemoteException {
        Hashtable hashtable;
        ConfigurationHandler handler = null;
        ClassLoader previousLoader = null;
        try {
            try {
                ConfigurationHandlerFactory chf = this.serviceContext.getCoreContext().getConfigurationHandlerFactory();
                handler = chf.getConfigurationHandler();
                Configuration rootConfig = handler.openConfiguration(ROOT_CFG_NAME, 0);
                previousLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$dbpool$deploy$DataSourceManagerImpl == null ? (class$com$sap$engine$services$dbpool$deploy$DataSourceManagerImpl = DataSourceManagerImpl.class$("com.sap.engine.services.dbpool.deploy.DataSourceManagerImpl")) : class$com$sap$engine$services$dbpool$deploy$DataSourceManagerImpl).getClassLoader());
                hashtable = (Hashtable)rootConfig.getConfigEntry(name);
                Object var8_12 = null;
                if (previousLoader != null) {
                    Thread.currentThread().setContextClassLoader(previousLoader);
                }
                if (handler == null) return hashtable;
            }
            catch (NameNotFoundException nnfex) {
                Hashtable<String, String[]> result = new Hashtable<String, String[]>();
                if (DRV_HT_NAME.equals(name)) {
                    result.put("SYSTEM_DRIVER", new String[]{"The system driver of the engine"});
                }
                Hashtable<String, String[]> hashtable2 = result;
                Object var8_13 = null;
                if (previousLoader != null) {
                    Thread.currentThread().setContextClassLoader(previousLoader);
                }
                if (handler == null) return hashtable2;
                try {
                    handler.closeAllConfigurations();
                    return hashtable2;
                }
                catch (ConfigurationException cex) {
                    BaseRemoteException brex = new BaseRemoteException("dbpool_0400", (Throwable)((Object)cex));
                    brex.log();
                    throw brex;
                }
            }
            catch (ConfigurationException cex) {
                BaseRemoteException brex = new BaseRemoteException("dbpool_0400", (Throwable)((Object)cex));
                brex.log();
                throw brex;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (previousLoader != null) {
                Thread.currentThread().setContextClassLoader(previousLoader);
            }
            if (handler == null) throw throwable;
            try {}
            catch (ConfigurationException cex) {
                BaseRemoteException brex = new BaseRemoteException("dbpool_0400", (Throwable)((Object)cex));
                brex.log();
                throw brex;
            }
            handler.closeAllConfigurations();
            throw throwable;
        }
        try {}
        catch (ConfigurationException cex) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0400", (Throwable)((Object)cex));
            brex.log();
            throw brex;
        }
        handler.closeAllConfigurations();
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateConfigEntry(String name, Object obj) throws RemoteException {
        ConfigurationHandler handler = null;
        Configuration rootConfig = null;
        try {
            try {
                ConfigurationHandlerFactory chf = this.serviceContext.getCoreContext().getConfigurationHandlerFactory();
                handler = chf.getConfigurationHandler();
                try {
                    rootConfig = handler.openConfiguration(ROOT_CFG_NAME, 1);
                }
                catch (NameNotFoundException nnfex) {
                    rootConfig = handler.createRootConfiguration(ROOT_CFG_NAME);
                }
                try {
                    rootConfig.modifyConfigEntry(name, obj);
                }
                catch (NameNotFoundException nnfex) {
                    rootConfig.addConfigEntry(name, obj);
                }
                Object var9_10 = null;
                if (handler == null) return;
            }
            catch (ConfigurationLockedException clex) {
                if (location.beLogged(300)) {
                    location.logT(300, "DataSourceManagerImpl.updateConfigEntry(): Writing is not possible. Other cluster element has locked the DB.");
                }
                Object var9_11 = null;
                if (handler == null) return;
                try {
                    handler.commit();
                    handler.closeAllConfigurations();
                    return;
                }
                catch (ConfigurationException cex) {
                    BaseRemoteException brex = new BaseRemoteException("dbpool_0409", (Throwable)((Object)cex));
                    brex.log();
                    throw brex;
                }
            }
            catch (ConfigurationException cex) {
                BaseRemoteException brex = new BaseRemoteException("dbpool_0409", (Throwable)((Object)cex));
                brex.log();
                throw brex;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (handler == null) throw throwable;
            try {}
            catch (ConfigurationException cex) {
                BaseRemoteException brex = new BaseRemoteException("dbpool_0409", (Throwable)((Object)cex));
                brex.log();
                throw brex;
            }
            handler.commit();
            handler.closeAllConfigurations();
            throw throwable;
        }
        try {}
        catch (ConfigurationException cex) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0409", (Throwable)((Object)cex));
            brex.log();
            throw brex;
        }
        handler.commit();
        handler.closeAllConfigurations();
    }

    private String makeLibraryJar(String libName, String[] jars, String[] mappings) throws IOException {
        Vector<InfoObject> entries = new Vector<InfoObject>();
        if (mappings == null) {
            mappings = new String[jars.length];
        }
        InfoObject info = new InfoObject("");
        int i = 0;
        while (i < jars.length) {
            if (mappings[i] == null || mappings[i].equals("")) {
                mappings[i] = new File(jars[i]).getName();
            }
            info = new InfoObject(mappings[i], jars[i]);
            entries.add(info);
            ++i;
        }
        String libJarName = null;
        libJarName = libName.toLowerCase().startsWith("library:") ? "library_".concat(libName.substring("library:".length())) : "library_".concat(libName);
        libJarName = new File(new File(this.workDir), libJarName + ".jar").getAbsolutePath();
        String tempProviderXml = this.workDir + File.separator + "TempProvider.xml";
        try {
            LibProviderDocument provider = new LibProviderDocument();
            provider.setDisplayName(libName);
            provider.setComponentName(libName);
            provider.setJars(mappings);
            provider.loadDocumentFromFields();
            StandardDOMWriter writer = DataSourceManagerImpl.createStandardDOMWriter();
            writer.write(provider.getMainDocument(), tempProviderXml, "<!DOCTYPE provider-descriptor [<!ELEMENT provider-descriptor (display-name, component-name, description?, major-version, minor-version, micro-version, provider-name?, group-name?, references?, jars)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT component-name (#PCDATA)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT major-version (#PCDATA)>\n<!ELEMENT minor-version (#PCDATA)>\n<!ELEMENT micro-version (#PCDATA)>\n<!ELEMENT provider-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT references (reference)*>\n<!ELEMENT reference (#PCDATA)>\n  <!ATTLIST reference type (service|library|interface) #REQUIRED>\n  <!ATTLIST reference strength (weak) #REQUIRED>\n<!ELEMENT jars (jar-name)+>\n<!ELEMENT jar-name (#PCDATA)>\n]>");
            entries.add(new InfoObject("server/provider.xml", tempProviderXml));
            JarUtils jarUtil = new JarUtils();
            jarUtil.makeJarFromFiles(libJarName, entries);
            Object var13_12 = null;
            new File(tempProviderXml).delete();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            new File(tempProviderXml).delete();
            throw throwable;
        }
        return libJarName;
    }

    private void checkSerializableFile(SerializableFile serFile, String fileType) throws RemoteException {
        byte[] content = serFile.getBytes();
        if (content == null) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0416", new Object[]{fileType, serFile.getAbsoluteFilePath()});
            brex.log();
            throw brex;
        }
        if (content.length == 0) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0417", new Object[]{fileType, serFile.getAbsoluteFilePath()});
            brex.log();
            throw brex;
        }
    }

    private File writeLocalFile(SerializableFile serFile) throws RemoteException {
        File temp = new File(this.workDir + File.separatorChar + serFile.getFileName());
        byte[] fileBytes = serFile.getBytes();
        ByteArrayInputStream fileIS = new ByteArrayInputStream(fileBytes);
        try {
            FileUtils.writeToFile(fileIS, temp);
        }
        catch (IOException ioex) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0410", new Object[]{serFile.getFileName(), "a remote", "the local file system"}, (Throwable)ioex);
            brex.log();
            throw brex;
        }
        return temp;
    }

    private JDBCDescriptor getJDBCDescriptorFromContainer(String dsName) {
        if (this.sysDSDescr != null) {
            if (dsName.equals(this.sysDSDescr.getDataSourceName())) {
                return this.sysDSDescr;
            }
            String[] sysDSAliases = this.sysDSDescr.getAliases();
            if (sysDSAliases != null) {
                int i = 0;
                while (i < sysDSAliases.length) {
                    if (dsName.equals(sysDSAliases[i])) {
                        return this.sysDSDescr;
                    }
                    ++i;
                }
            }
        }
        Hashtable datasources = this.containerImpl.appsDescr;
        Enumeration htEnum = datasources.keys();
        while (htEnum.hasMoreElements()) {
            String appName = (String)htEnum.nextElement();
            Enumeration vecEnum = ((Vector)datasources.get(appName)).elements();
            while (vecEnum.hasMoreElements()) {
                JDBCDescriptor descr = (JDBCDescriptor)vecEnum.nextElement();
                if (dsName.equals(descr.getDataSourceName())) {
                    return descr;
                }
                String[] aliases = descr.getAliases();
                if (aliases.length == 0) continue;
                int i = 0;
                while (i < aliases.length) {
                    if (dsName.equals(aliases[i])) {
                        return descr;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private String executeFromAppThread(String dsName, StatementEntry[] statements) throws RemoteException {
        Throwable ex = null;
        CountDown cd = new CountDown(1);
        DBInitializer dbInitializer = new DBInitializer(dsName, statements, cd);
        ThreadSystem ts = this.serviceContext.getCoreContext().getThreadSystem();
        ts.startThread(dbInitializer, false);
        try {
            cd.acquire();
            ex = dbInitializer.getThrowable();
        }
        catch (InterruptedException iex) {
            ex = iex;
        }
        if (ex != null) {
            BaseRemoteException brex = new BaseRemoteException("dbpool_0411", new Object[]{dsName, ex.toString()}, ex);
            brex.log();
            throw brex;
        }
        return dbInitializer.getResults();
    }

    private static StandardDOMWriter createStandardDOMWriter() {
        ClassLoader previousLoader = null;
        try {
            previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$dbpool$deploy$DataSourceManagerImpl == null ? (class$com$sap$engine$services$dbpool$deploy$DataSourceManagerImpl = DataSourceManagerImpl.class$("com.sap.engine.services.dbpool.deploy.DataSourceManagerImpl")) : class$com$sap$engine$services$dbpool$deploy$DataSourceManagerImpl).getClassLoader());
            StandardDOMWriter standardDOMWriter = new StandardDOMWriter();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            return standardDOMWriter;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

