/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.deploy;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.core.configuration.ChangeEvent;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationChangedListener;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.InconsistentReadException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.frame.core.load.FileReferencedLoader;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.frame.core.load.res.JarResource;
import com.sap.engine.frame.core.locking.LockException;
import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.lib.util.HashMapObjectInt;
import com.sap.engine.services.connector.ResourceObjectFactory;
import com.sap.engine.services.connector.jca.deploy.MCFWrapper;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.dbpool.deploy.JDBCDescriptor;
import com.sap.engine.services.dbpool.deploy.XMLUtils;
import com.sap.engine.services.dbpool.exceptions.BaseDeploymentException;
import com.sap.engine.services.dbpool.exceptions.BaseWarningException;
import com.sap.engine.services.dbpool.spi.CPManagedConnectionFactoryImpl;
import com.sap.engine.services.dbpool.spi.ManagedConnectionFactoryImpl;
import com.sap.engine.services.dbpool.spi.XAManagedConnectionFactoryImpl;
import com.sap.engine.services.deploy.container.AdditionalAppInfo;
import com.sap.engine.services.deploy.container.ApplicationDeployInfo;
import com.sap.engine.services.deploy.container.ContainerDeploymentInfo;
import com.sap.engine.services.deploy.container.ContainerInfo;
import com.sap.engine.services.deploy.container.ContainerInterface;
import com.sap.engine.services.deploy.container.DeployCommunicator;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.ExportInfo;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.container.ProgressListener;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.sql.connect.OpenSQLConnectionFactory;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnectionFactory;
import org.w3c.dom.Document;

public class ContainerImpl
implements ContainerInterface,
ConfigurationChangedListener {
    public static final String OPEN_SQL_JAR = "opensqlport.jar";
    public static final String META_INF = "META-INF";
    public static final String meta_inf = "meta-inf";
    public static final String DEFAULT_DS_XML_FILENAME = "META-INF/data-sources.xml";
    public static final String default_ds_xml_filename = "meta-inf/data-sources.xml";
    public static final String DS_XML_FILENAME = "data-sources.xml";
    public static final String DEFAULT_ALIASES_XML_FILENAME = "META-INF/data-source-aliases.xml";
    public static final String default_aliases_xml_filename = "meta-inf/data-source-aliases.xml";
    public static final String ALIASES_XML_FILENAME = "data-source-aliases.xml";
    public static final String DATASOURCE_RESOURCE_TYPE = "javax.sql.DataSource";
    public static final String CONTAINER_NAME = "JDBCConnector";
    public static final String SERVICE_SUFFIX = " Service";
    public static final String LIBRARY_SUFFIX = " Library";
    public static final String APPLICATION_SUFFIX = " Application";
    public static final String DATASOURCE_SUFFIX = " DataSource";
    private static final String SECURE_SUB_CONFIGURATION = "Secure";
    private static final int APP_PRIORITY = 95;
    private static final Category category = Category.SYS_SERVER;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$deploy$ContainerImpl == null ? (class$com$sap$engine$services$dbpool$deploy$ContainerImpl = ContainerImpl.class$("com.sap.engine.services.dbpool.deploy.ContainerImpl")) : class$com$sap$engine$services$dbpool$deploy$ContainerImpl));
    private static final int logDebug = 100;
    private long mcfid;
    private ManagementListener managementListener;
    private Hashtable appsDescrCache;
    private Hashtable dsAliasesCache;
    private Hashtable runtimeChangedAppsDescr;
    private Hashtable runtimeChangedAppsRestart;
    private Hashtable runtimeChangedAliases;
    private Vector loadersWithOpenSqlRes;
    ApplicationServiceContext serviceContext;
    DataSourceManager dsManager;
    ContainerInfo containerInfo;
    DeployCommunicator deployCommunicator = null;
    Properties contextProps;
    Hashtable appsDescr;
    Hashtable dsAliases;
    Vector startedApps;
    Hashtable extAliasesCntr;
    private Object monitor = new Object();
    private boolean writeLockReleased = false;
    private Vector configPaths = new Vector();
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$deploy$ContainerImpl;

    public ContainerImpl(ApplicationServiceContext _serviceContext, DataSourceManager _dsManager) {
        this.serviceContext = _serviceContext;
        this.dsManager = _dsManager;
        this.contextProps = new Properties();
        ((Hashtable)this.contextProps).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        ((Hashtable)this.contextProps).put("domain", "true");
        this.containerInfo = new ContainerInfo();
        this.containerInfo.setName(CONTAINER_NAME);
        this.containerInfo.setModuleName(CONTAINER_NAME);
        this.containerInfo.setJ2EEContainer(false);
        this.containerInfo.setFileNames(new String[]{DEFAULT_DS_XML_FILENAME, DEFAULT_ALIASES_XML_FILENAME, DS_XML_FILENAME, ALIASES_XML_FILENAME, default_ds_xml_filename, default_aliases_xml_filename});
        this.containerInfo.setServiceName(this.serviceContext.getServiceState().getServiceName());
        this.containerInfo.setResourceTypes(new String[]{DATASOURCE_RESOURCE_TYPE});
        this.containerInfo.setPriority(95);
        this.mcfid = 0L;
        this.appsDescr = new Hashtable();
        this.dsAliases = new Hashtable();
        this.appsDescrCache = new Hashtable();
        this.dsAliasesCache = new Hashtable();
        this.runtimeChangedAppsDescr = new Hashtable();
        this.runtimeChangedAppsRestart = new Hashtable();
        this.runtimeChangedAliases = new Hashtable();
        this.loadersWithOpenSqlRes = new Vector();
        this.startedApps = new Vector();
        this.extAliasesCntr = new Hashtable();
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public ApplicationDeployInfo deploy(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.deploy(): Application name = " + dInfo.getApplicationName());
        }
        Configuration configuration = null;
        try {
            configuration = dInfo.getConfiguration().getSubConfiguration(CONTAINER_NAME);
        }
        catch (ConfigurationException cex) {
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)cex));
            }
            try {
                configuration = dInfo.getConfiguration().createSubConfiguration(CONTAINER_NAME);
            }
            catch (ConfigurationException cex2) {
                if (location.beLogged(500)) {
                    location.logT(500, "ContainerImpl.deploy(): Cannot create subconfiguration for JDBCConnector. Reason: " + ((Throwable)((Object)cex2)).toString());
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)cex2));
                }
                throw new BaseDeploymentException("dbpool_0000", CONTAINER_NAME, (Throwable)((Object)cex2));
            }
        }
        String appName = dInfo.getApplicationName();
        Vector<String> deployedComponentsVtr = new Vector<String>();
        Vector<String> warnings = new Vector<String>();
        String[] requiredResources = null;
        File dataSourcesXML = null;
        File aliasesXML = null;
        int i = 0;
        while (i < archiveFiles.length) {
            block44: {
                String path = archiveFiles[i].getAbsolutePath();
                if (path.indexOf(META_INF) > 0) {
                    if (path.endsWith(DS_XML_FILENAME)) {
                        dataSourcesXML = archiveFiles[i];
                    } else {
                        aliasesXML = archiveFiles[i];
                    }
                } else if (path.indexOf(meta_inf) > 0) {
                    if (path.endsWith(DS_XML_FILENAME)) {
                        warnings.add("There is 'META-INF' folder entry in your application archive, which is not written in capital letters. The name of this entry should not be written in small letters. The 'data-sources.xml' file from this entry will be ignored.");
                    } else {
                        warnings.add("There is 'META-INF' folder entry in your application archive, which is not written in capital letters. The name of this entry should not be written in small letters. The 'data-source-aliases.xml' file from this entry will be ignored.");
                    }
                } else if (path.endsWith(DS_XML_FILENAME)) {
                    warnings.add("There is 'data-sources.xml' file in the root of the application archive. It should be in 'META-INF' folder entry. Nevertheless, it will be deployed if there is no 'META-INF/data-sources.xml' file present. Otherwise it will be ignored.");
                    if (dataSourcesXML == null) {
                        dataSourcesXML = archiveFiles[i];
                    }
                } else if (path.endsWith(ALIASES_XML_FILENAME)) {
                    warnings.add("There is 'data-source-aliases.xml' file in the root of the application archive. It should be in 'META-INF' folder entry. Nevertheless, it will be deployed if there is no 'META-INF/data-source-aliases.xml' file present. Otherwise it will be ignored.");
                    if (aliasesXML == null) {
                        aliasesXML = archiveFiles[i];
                    }
                } else {
                    try {
                        if (XMLUtils.isDataSourceXML(archiveFiles[i]) != null) {
                            dataSourcesXML = archiveFiles[i];
                            break block44;
                        }
                        if (XMLUtils.isAliasesXML(archiveFiles[i])) {
                            aliasesXML = archiveFiles[i];
                            break block44;
                        }
                        if (category.beLogged(500)) {
                            category.logT(500, location, "File '" + archiveFiles[i] + "' does not contain DataSource or aliases descriptions.");
                        }
                        throw new BaseDeploymentException("dbpool_0013", new Object[]{archiveFiles[i].getName(), CONTAINER_NAME});
                    }
                    catch (IOException ioex) {
                        if (location.beLogged(500)) {
                            location.logT(500, "ContainerImpl.deploy(): IOException while parsing file '" + archiveFiles[i] + "': " + ioex.toString());
                        }
                        if (location.beLogged(100)) {
                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)ioex);
                        }
                        throw new BaseDeploymentException("dbpool_0001", archiveFiles[i], (Throwable)ioex);
                    }
                    catch (IllegalArgumentException iaex) {
                        if (location.beLogged(500)) {
                            location.logT(500, "ContainerImpl.deploy(): IllegalArgumentException while parsing file '" + archiveFiles[i] + "': " + iaex.toString());
                        }
                        if (location.beLogged(100)) {
                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)iaex);
                        }
                        throw new BaseDeploymentException("dbpool_0001", archiveFiles[i], (Throwable)iaex);
                    }
                }
            }
            ++i;
        }
        if (dataSourcesXML != null) {
            Vector dsVtr = this.checkDataSources(dataSourcesXML);
            this.appsDescr.put(appName, dsVtr);
            this.storeJDBCConnectorFile(configuration, dataSourcesXML);
            int j = 0;
            while (j < dsVtr.size()) {
                JDBCDescriptor descr = (JDBCDescriptor)dsVtr.get(j);
                deployedComponentsVtr.add(descr.getDataSourceName());
                String[] intAliases = descr.getAliases();
                int k = 0;
                while (k < intAliases.length) {
                    deployedComponentsVtr.add(intAliases[k]);
                    ++k;
                }
                ++j;
            }
        }
        if (aliasesXML != null) {
            Hashtable extAliases = this.checkAliases(aliasesXML);
            this.dsAliases.put(appName, extAliases);
            this.storeJDBCConnectorFile(configuration, aliasesXML);
            requiredResources = extAliases.keySet().toArray(new String[0]);
            Enumeration enumeration = extAliases.elements();
            while (enumeration.hasMoreElements()) {
                String[] aliasNamesArr = (String[])enumeration.nextElement();
                int j = 0;
                while (j < aliasNamesArr.length) {
                    deployedComponentsVtr.add(aliasNamesArr[j]);
                    ++j;
                }
            }
        }
        ApplicationDeployInfo result = new ApplicationDeployInfo();
        result.setDeployedComponentNames(deployedComponentsVtr.toArray(new String[0]));
        result.setWarnings(warnings);
        if (requiredResources != null) {
            int i2 = 0;
            while (i2 < requiredResources.length) {
                if (!deployedComponentsVtr.contains(requiredResources[i2])) {
                    result.addResourceReference(requiredResources[i2], DATASOURCE_RESOURCE_TYPE);
                }
                ++i2;
            }
        }
        result.setDeployProperties(props);
        if (category.beLogged(300)) {
            category.logT(300, location, "DataSources or DataSource aliases of '" + appName + "' application deployed successfully.");
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.deploy(): Application name = " + dInfo.getApplicationName());
        }
        return result;
    }

    public void notifyDeployedComponents(String applicationName, Properties props) throws WarningException {
    }

    public void prepareDeploy(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
    }

    public void commitDeploy(String applicationName) throws WarningException {
    }

    public void rollbackDeploy(String applicationName) throws WarningException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.rollbackDeploy(): Application name = " + applicationName);
        }
        try {
            this.remove(applicationName);
        }
        catch (DeploymentException dex) {
            BaseWarningException bwex = new BaseWarningException("dbpool_0103", (Throwable)((Object)dex));
            bwex.log();
            throw bwex;
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.rollbackDeploy(): Application name = " + applicationName);
        }
    }

    public boolean needUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        if (location.beLogged(100)) {
            location.logT(100, "<-> ContainerImpl.needUpdate(): Application name = " + dInfo.getApplicationName());
        }
        return true;
    }

    public boolean needStopOnUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        if (location.beLogged(100)) {
            location.logT(100, "<-> ContainerImpl.needStopOnUpdate(): Application name = " + dInfo.getApplicationName());
        }
        return true;
    }

    public ApplicationDeployInfo makeUpdate(File[] archiveFiles, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        WarningException we = null;
        try {
            this.remove(dInfo.getApplicationName());
        }
        catch (WarningException _we) {
            we = _we;
        }
        try {
            dInfo.getConfiguration().deleteConfiguration(CONTAINER_NAME);
        }
        catch (ConfigurationException cex) {
            Category.SYS_SERVER.logThrowableT(500, location, "configuration error: ", (Throwable)((Object)cex));
        }
        ApplicationDeployInfo appDeployInfo = this.deploy(archiveFiles, dInfo, props);
        if (we != null) {
            appDeployInfo.addWarnings(we.getWarnings());
        }
        return appDeployInfo;
    }

    public void notifyUpdatedComponents(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void prepareUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitUpdate(String applicationName) {
        return null;
    }

    public void rollbackUpdate(String applicationName, Configuration applicationConfig, Properties props) throws WarningException {
    }

    public void remove(String applicationName) throws DeploymentException, WarningException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.remove(): Application name = " + applicationName);
        }
        this.appsDescr.remove(applicationName);
        Hashtable extAliases = (Hashtable)this.dsAliases.remove(applicationName);
        if (category.beLogged(300)) {
            category.logT(300, location, "DataSources or DataSource aliases of '" + applicationName + "' application removed successfully.");
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.remove(): Application name = " + applicationName);
        }
    }

    public void downloadApplicationFiles(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
    }

    public void prepareStart(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
        Configuration config;
        String appDirName;
        File appDir;
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.prepareStart(): Application name = " + applicationName);
        }
        if (!(appDir = new File(appDirName = this.getAppWorkDir(applicationName))).exists()) {
            appDir.mkdirs();
        }
        try {
            config = appConfig.getSubConfiguration(CONTAINER_NAME);
        }
        catch (ConfigurationException cex) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.prepareStart(): Cannot get subconfiguration for JDBCConnector. Reason: " + ((Throwable)((Object)cex)).toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)cex));
            }
            throw new BaseDeploymentException("dbpool_0002", CONTAINER_NAME, (Throwable)((Object)cex));
        }
        String[] dbFiles = null;
        try {
            dbFiles = this.getAllSecureFilenames(config);
        }
        catch (ConfigurationException cex) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.prepareStart(): ConfigurationException while reading file entries from DB: " + ((Throwable)((Object)cex)).toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)cex));
            }
            throw new BaseDeploymentException("dbpool_0004", (Throwable)((Object)cex));
        }
        Vector descrVtr = null;
        Hashtable aliasesHT = null;
        int i = 0;
        while (i < dbFiles.length) {
            try {
                Document doc = XMLUtils.isDataSourceXML(this.getSecureFile(config, dbFiles[i]));
                if (doc != null) {
                    descrVtr = XMLUtils.processXML(this.getSecureFile(config, dbFiles[i]));
                } else if (XMLUtils.isAliasesXML(this.getSecureFile(config, dbFiles[i]))) {
                    aliasesHT = XMLUtils.processAliasesXML(this.getSecureFile(config, dbFiles[i]));
                }
            }
            catch (ConfigurationException cex) {
                if (location.beLogged(500)) {
                    location.logT(500, "ContainerImpl.prepareStart(): ConfigurationException while reading file '" + dbFiles[i] + "' from DB." + ((Throwable)((Object)cex)).toString());
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)cex));
                }
                throw new BaseDeploymentException("dbpool_0004", (Throwable)((Object)cex));
            }
            catch (IOException ioex) {
                if (location.beLogged(500)) {
                    location.logT(500, "ContainerImpl.prepareStart(): IOException while parsing file '" + dbFiles[i] + "': " + ioex.toString());
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)ioex);
                }
                throw new BaseDeploymentException("dbpool_0001", dbFiles[i], (Throwable)ioex);
            }
            catch (IllegalArgumentException iaex) {
                if (location.beLogged(500)) {
                    location.logT(500, "ContainerImpl.prepareStart(): IllegalArgumentException while parsing file '" + dbFiles[i] + "': " + iaex.toString());
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)iaex);
                }
                throw new BaseDeploymentException("dbpool_0001", dbFiles[i], (Throwable)iaex);
            }
            ++i;
        }
        if (descrVtr != null) {
            this.startDataSources(applicationName, descrVtr);
        }
        if (aliasesHT != null) {
            this.bindAndRegisterExternalAliases(applicationName, aliasesHT);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.prepareStart(): Application name = " + applicationName);
        }
    }

    public void commitStart(String applicationName) throws WarningException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.commitStart(): Application name = " + applicationName);
        }
        this.notifyManagementListener(applicationName, "add");
        this.startedApps.add(applicationName);
        if (category.beLogged(300)) {
            category.logT(300, location, "DataSources or DataSource aliases of '" + applicationName + "' application started successfully.");
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.commitStart(): Application name = " + applicationName);
        }
    }

    public void rollbackStart(String applicationName) throws WarningException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.rollbackStart(): Application name = " + applicationName);
        }
        this.clearNaming(applicationName);
        this.unbindAndUnregisterExternalAliases(applicationName);
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.rollbackStart(): Application name = " + applicationName);
        }
    }

    public void prepareStop(String applicationName, Configuration appConfig) throws DeploymentException, WarningException {
    }

    public void commitStop(String applicationName) throws WarningException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.commitStop(): Application name = " + applicationName);
        }
        this.notifyManagementListener(applicationName, "remove");
        this.rollbackStart(applicationName);
        this.startedApps.remove(applicationName);
        if (category.beLogged(300)) {
            category.logT(300, location, "DataSources or DataSource aliases of '" + applicationName + "' application stopped successfully.");
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.commitStop(): Application name = " + applicationName);
        }
    }

    public void rollbackStop(String applicationName) throws WarningException {
    }

    public File[] getClientJar(String applicationName) {
        return null;
    }

    public void addProgressListener(ProgressListener listener) {
    }

    public void removeProgressListener(ProgressListener listener) {
    }

    public ExportInfo[] getCurrentStatus(String applicationName) throws WarningException {
        return null;
    }

    public void notifyRuntimeChanges(String applicationName, Configuration appConfig) throws WarningException {
    }

    public void prepareRuntimeChanges(String applicationName) throws DeploymentException, WarningException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.prepareRuntimeChanges(): Application name = " + applicationName);
        }
        this.backupAppInfo(applicationName);
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.prepareRuntimeChanges(): Application name = " + applicationName);
        }
    }

    public ApplicationDeployInfo commitRuntimeChanges(String applicationName) throws WarningException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.commitRuntimeChanges(): Application name = " + applicationName);
        }
        Vector dsVtr = (Vector)this.runtimeChangedAppsDescr.remove(applicationName);
        Hashtable extAliases = (Hashtable)this.runtimeChangedAliases.remove(applicationName);
        Boolean restartApp = (Boolean)this.runtimeChangedAppsRestart.remove(applicationName);
        Vector<String> deployedComponentsVtr = new Vector<String>();
        if (dsVtr != null) {
            int j = 0;
            while (j < dsVtr.size()) {
                JDBCDescriptor descr = (JDBCDescriptor)dsVtr.get(j);
                deployedComponentsVtr.add(descr.getDataSourceName());
                String[] intAliases = descr.getAliases();
                int k = 0;
                while (k < intAliases.length) {
                    deployedComponentsVtr.add(intAliases[k]);
                    ++k;
                }
                ++j;
            }
            this.appsDescrCache.remove(applicationName);
            this.appsDescr.put(applicationName, dsVtr);
        }
        if (extAliases != null) {
            Enumeration enumeration = extAliases.elements();
            while (enumeration.hasMoreElements()) {
                String[] aliasNamesArr = (String[])enumeration.nextElement();
                int j = 0;
                while (j < aliasNamesArr.length) {
                    deployedComponentsVtr.add(aliasNamesArr[j]);
                    ++j;
                }
            }
            this.dsAliasesCache.remove(applicationName);
            if (!extAliases.isEmpty()) {
                this.dsAliases.put(applicationName, extAliases);
            }
        }
        ApplicationDeployInfo result = new ApplicationDeployInfo();
        result.setDeployedComponentNames(deployedComponentsVtr.toArray(new String[0]));
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.commitRuntimeChanges(): Application name = " + applicationName);
        }
        return result;
    }

    public void rollbackRuntimeChanges(String applicationName) throws WarningException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.rollbackRuntimeChanges(): Application name = " + applicationName);
        }
        this.runtimeChangedAppsDescr.remove(applicationName);
        this.runtimeChangedAppsRestart.remove(applicationName);
        this.runtimeChangedAliases.remove(applicationName);
        this.recoverAppInfo(applicationName);
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.rollbackRuntimeChanges(): Application name = " + applicationName);
        }
    }

    public boolean needStopOnSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException, WarningException {
        return false;
    }

    public ApplicationDeployInfo makeSingleFileUpdate(FileUpdateInfo[] files, ContainerDeploymentInfo dInfo, Properties props) throws DeploymentException {
        return null;
    }

    public void notifySingleFileUpdate(String applicationName, Configuration config, Properties props) throws WarningException {
    }

    public void prepareSingleFileUpdate(String applicationName) throws DeploymentException, WarningException {
    }

    public ApplicationDeployInfo commitSingleFileUpdate(String applicationName) throws WarningException {
        return null;
    }

    public void rollbackSingleFileUpdate(String applicationName, Configuration config) throws WarningException {
    }

    public String getApplicationName(File standaloneFile) throws DeploymentException {
        try {
            return XMLUtils.getApplicationName(standaloneFile);
        }
        catch (IllegalArgumentException iaex) {
            if (location.beLogged(300)) {
                location.logT(300, "ContainerImpl.getApplicationName(): " + iaex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)iaex);
            }
            throw new BaseDeploymentException("dbpool_0001", standaloneFile, (Throwable)iaex);
        }
        catch (IOException ioex) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.getApplicationName(): " + ioex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)ioex);
            }
            throw new BaseDeploymentException("dbpool_0001", standaloneFile, (Throwable)ioex);
        }
    }

    public void createDefaultDataSource(JDBCDescriptor sysDSDescr) {
        block20: {
            InitialContext naming;
            block19: {
                if (location.beLogged(100)) {
                    location.logT(100, "--> ContainerImpl.createDefaultDataSource(): DataSource name = " + sysDSDescr.getDataSourceName());
                }
                naming = null;
                try {
                    naming = new InitialContext(this.contextProps);
                }
                catch (NamingException ne) {
                    if (location.beLogged(500)) {
                        location.logT(500, "ContainerImpl.createDefaultDataSource(): Failed to create the default DataSource. Cannot get InitialContext. Reason: " + ne.toString());
                    }
                    if (!location.beLogged(100)) break block19;
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                }
            }
            String dsName = sysDSDescr.getDataSourceName();
            String[] aliases = sysDSDescr.getAliases();
            String driverName = sysDSDescr.getDriverName();
            try {
                int i;
                if (!"SYSTEM_DRIVER".equals(driverName)) {
                    this.checkDriverLoader(driverName);
                }
                ManagedConnectionFactoryImpl mcf = new ManagedConnectionFactoryImpl(this, sysDSDescr, this.mcfid++);
                MCFWrapper wrapper = new MCFWrapper(mcf, 1, aliases, sysDSDescr.getInitConnections(), sysDSDescr.getMaxConnections(), sysDSDescr.getMaxTimeToWaitConn(), sysDSDescr.getConnLifetime(), sysDSDescr.getRunCleanupThread());
                this.bind(naming, "mcf/" + dsName, wrapper);
                ResourceObjectFactory.addConnectionFactory(null, sysDSDescr.getDataSourceName(), DATASOURCE_RESOURCE_TYPE, false, true);
                Reference ref = this.createReference(dsName);
                Reference clref = this.createClientReference(dsName);
                Reference notxref = this.createNonTxReference(dsName);
                this.bind(naming, "jdbc/" + dsName, ref);
                this.bind(naming, "jdbc/client/jdbc/" + dsName, clref);
                this.bind(naming, "jdbc/notx/" + dsName, notxref);
                if (aliases != null && aliases.length != 0) {
                    i = 0;
                    while (i < aliases.length) {
                        this.bind(naming, "jdbc/" + aliases[i], ref);
                        this.bind(naming, "jdbc/client/jdbc/" + aliases[i], clref);
                        this.bind(naming, "jdbc/notx/" + aliases[i], notxref);
                        ++i;
                    }
                }
                this.bind(naming, "mcf_descriptors/dbpool/" + sysDSDescr.getDataSourceName(), sysDSDescr);
                this.startDataSource(dsName, aliases, null, sysDSDescr.isOpenSQL(), sysDSDescr.isNativeSQL());
                this.deployCommunicator.addAloneComponent(dsName, DATASOURCE_RESOURCE_TYPE, null);
                if (aliases != null) {
                    i = 0;
                    while (i < aliases.length) {
                        this.deployCommunicator.addAloneComponent(aliases[i], DATASOURCE_RESOURCE_TYPE, null);
                        ++i;
                    }
                }
            }
            catch (DeploymentException dex) {
                if (location.beLogged(500)) {
                    location.logT(500, "ContainerImpl.createDefaultDataSource(): Failed to create the default DataSource. Reason: " + ((Throwable)((Object)dex)).toString());
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)dex));
                }
                dex.log();
            }
            catch (ResourceException rex) {
                if (location.beLogged(500)) {
                    location.logT(500, "ContainerImpl.createDefaultDataSource(): Failed to create the default DataSource. Reason: " + rex.toString());
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                }
            }
            catch (Exception ex) {
                if (location.beLogged(500)) {
                    location.logT(500, "ContainerImpl.createDefaultDataSource(): Failed to create the default DataSource. Reason: " + ex.toString());
                }
                if (!location.beLogged(100)) break block20;
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)ex);
            }
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.createDefaultDataSource(): DataSource name = " + sysDSDescr.getDataSourceName());
        }
    }

    public void destroyDefaultDataSource(JDBCDescriptor sysDSDescr) {
        block46: {
            String dataSourceName;
            InitialContext naming;
            block44: {
                int i;
                String[] aliases;
                block43: {
                    block42: {
                        block41: {
                            block40: {
                                block39: {
                                    if (location.beLogged(100)) {
                                        location.logT(100, "--> ContainerImpl.destroyDefaultDataSource(): DataSource name = " + sysDSDescr.getDataSourceName());
                                    }
                                    naming = null;
                                    try {
                                        naming = new InitialContext(this.contextProps);
                                    }
                                    catch (NamingException ne) {
                                        if (location.beLogged(300)) {
                                            location.logT(300, "ContainerImpl.destroyDefaultDataSource(): Failed to destroy the default DataSource. Cannot get InitialContext. Reason: " + ne.toString());
                                        }
                                        if (!location.beLogged(100)) break block39;
                                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                                    }
                                }
                                dataSourceName = sysDSDescr.getDataSourceName();
                                aliases = sysDSDescr.getAliases();
                                try {
                                    this.stopDataSource(dataSourceName, aliases, null, sysDSDescr.isOpenSQL(), sysDSDescr.isNativeSQL());
                                }
                                catch (WarningException wex) {
                                    location.traceThrowableT(300, "Stop Warning:", (Throwable)wex);
                                }
                                try {
                                    Context mcfContext = (Context)naming.lookup("mcf/");
                                    this.unbind(mcfContext, dataSourceName);
                                    this.deleteTree(naming, "mcf");
                                }
                                catch (NamingException ne) {
                                    if (location.beLogged(300)) {
                                        location.logT(300, "ContainerImpl.destroyDefaultDataSource(): Failed to unbind the default DataSource from 'mcf' context. Reason: " + ne.toString());
                                    }
                                    if (!location.beLogged(100)) break block40;
                                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                                }
                            }
                            if (sysDSDescr.isNewDriver() && !sysDSDescr.isXADS()) {
                                try {
                                    Context cpdsContext = (Context)naming.lookup("ConnectionPoolDataSources/");
                                    this.unbind(cpdsContext, dataSourceName);
                                    this.deleteTree(naming, "ConnectionPoolDataSources");
                                }
                                catch (NamingException ne) {
                                    if (location.beLogged(300)) {
                                        location.logT(300, "ContainerImpl.destroyDefaultDataSource(): Failed to unbind the default DataSource from 'ConnectionPoolDataSources' context. Reason: " + ne.toString());
                                    }
                                    if (!location.beLogged(100)) break block41;
                                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                                }
                            }
                        }
                        try {
                            Context notxCtx = (Context)naming.lookup("jdbc/notx/");
                            if (dataSourceName != null) {
                                this.unbind(notxCtx, dataSourceName);
                            }
                            if (aliases != null) {
                                i = 0;
                                while (i < aliases.length) {
                                    this.unbind(notxCtx, aliases[i]);
                                    ++i;
                                }
                            }
                        }
                        catch (NamingException ne) {
                            if (location.beLogged(300)) {
                                location.logT(300, "ContainerImpl.destroyDefaultDataSource(): Failed to unbind the default DataSource and aliases from 'jdbc/notx' context. Reason: " + ne.toString());
                            }
                            if (!location.beLogged(100)) break block42;
                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                        }
                    }
                    try {
                        Context clCtx = (Context)naming.lookup("jdbc/client/jdbc/");
                        if (dataSourceName != null) {
                            this.unbind(clCtx, dataSourceName);
                        }
                        if (aliases != null) {
                            i = 0;
                            while (i < aliases.length) {
                                this.unbind(clCtx, aliases[i]);
                                ++i;
                            }
                        }
                    }
                    catch (NamingException ne) {
                        if (location.beLogged(300)) {
                            location.logT(300, "ContainerImpl.destroyDefaultDataSource(): Failed to unbind the default DataSource and aliases from 'jdbc/client/jdbc' context. Reason: " + ne.toString());
                        }
                        if (!location.beLogged(100)) break block43;
                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                    }
                }
                try {
                    Context refContext = (Context)naming.lookup("jdbc/");
                    if (dataSourceName != null) {
                        this.unbind(refContext, dataSourceName);
                    }
                    if (aliases != null) {
                        i = 0;
                        while (i < aliases.length) {
                            this.unbind(refContext, aliases[i]);
                            ++i;
                        }
                    }
                    this.deleteTree(naming, "jdbc");
                }
                catch (NamingException ne) {
                    if (location.beLogged(300)) {
                        location.logT(300, "ContainerImpl.destroyDefaultDataSource(): Failed to unbind the default DataSource and aliases from 'jdbc' context. Reason: " + ne.toString());
                    }
                    if (!location.beLogged(100)) break block44;
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                }
            }
            if (dataSourceName != null) {
                block45: {
                    try {
                        Context mcfD = (Context)naming.lookup("mcf_descriptors/dbpool/");
                        this.unbind(mcfD, dataSourceName);
                        this.deleteTree(naming, "mcf_descriptors");
                    }
                    catch (NamingException ne) {
                        if (location.beLogged(300)) {
                            location.logT(300, "ContainerImpl.destroyDefaultDataSource(): Failed to unbind the default DataSource and aliases from 'mcf_descriptors/dbpool' context. Reason: " + ne.toString());
                        }
                        if (!location.beLogged(100)) break block45;
                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                    }
                }
                try {
                    ResourceObjectFactory.removeConnectionFactory(dataSourceName);
                }
                catch (ResourceException rex) {
                    if (location.beLogged(300)) {
                        location.logT(300, "ContainerImpl.destroyDefaultDataSource(): Failed to remove the ConnectionFactory of the default DataSource. Reason: " + rex.toString());
                    }
                    if (!location.beLogged(100)) break block46;
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                }
            }
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.destroyDefaultDataSource(): DataSource name = " + sysDSDescr.getDataSourceName());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createServAndLibComponents(Hashtable xmlFiles, boolean isDataSource, boolean isService) {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.createServAndLibComponents(): isDataSource = " + isDataSource + ", isService = " + isService);
        }
        Enumeration enumeration = xmlFiles.keys();
        while (true) {
            Object var12_12;
            if (!enumeration.hasMoreElements()) {
                if (location.beLogged(100)) {
                    location.logT(100, "<-- ContainerImpl.createServAndLibComponents()");
                }
                return;
            }
            String serviceName = (String)enumeration.nextElement();
            File xml = (File)xmlFiles.get(serviceName);
            String appName = null;
            appName = isService ? serviceName.concat(SERVICE_SUFFIX) : serviceName.concat(LIBRARY_SUFFIX);
            try {
                try {
                    if (isDataSource) {
                        Vector descrVtr = XMLUtils.processXML(xml);
                        this.startDataSources(appName, descrVtr);
                        if (location.beLogged(100)) {
                            location.logT(100, "ContainerImpl.createServAndLibComponents(): DataSources for " + appName + " started successfully.");
                        }
                    } else {
                        Hashtable aliasesHT = XMLUtils.processAliasesXML(xml);
                        this.bindAndRegisterExternalAliases(appName, aliasesHT);
                        if (location.beLogged(100)) {
                            location.logT(100, "ContainerImpl.createServAndLibComponents(): Aliases for " + appName + " started successfully.");
                        }
                    }
                    this.commitStart(appName);
                }
                catch (IOException ioex) {
                    if (location.beLogged(500)) {
                        location.logT(500, "ContainerImpl.createServAndLibComponents(): Failed to create DataSources or aliases for " + appName + ". Reason: " + ioex.toString());
                    }
                    if (location.beLogged(100)) {
                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)ioex);
                    }
                    var12_12 = null;
                    xml.delete();
                    continue;
                }
                catch (IllegalArgumentException iaex) {
                    if (location.beLogged(500)) {
                        location.logT(500, "ContainerImpl.createServAndLibComponents(): Failed to create DataSources or aliases for " + appName + ". Reason: " + iaex.toString());
                    }
                    if (location.beLogged(100)) {
                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)iaex);
                    }
                    var12_12 = null;
                    xml.delete();
                    continue;
                }
                catch (DeploymentException dex) {
                    if (location.beLogged(500)) {
                        location.logT(500, "ContainerImpl.createServAndLibComponents(): Failed to create DataSources or aliases for " + appName + ". Reason: " + ((Throwable)((Object)dex)).toString());
                    }
                    if (location.beLogged(100)) {
                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)dex));
                    }
                    dex.log();
                    var12_12 = null;
                    xml.delete();
                    continue;
                }
                var12_12 = null;
                xml.delete();
            }
            catch (Throwable throwable) {
                var12_12 = null;
                xml.delete();
                throw throwable;
            }
        }
    }

    public void destroyServAndLibComponents() {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.destroyServAndLibComponents()");
        }
        Enumeration enumeration = this.dsAliases.keys();
        while (enumeration.hasMoreElements()) {
            String appName = (String)enumeration.nextElement();
            if (!appName.endsWith(SERVICE_SUFFIX) && !appName.endsWith(LIBRARY_SUFFIX)) continue;
            try {
                this.commitStop(appName);
                this.remove(appName);
            }
            catch (WarningException wex) {
                if (location.beLogged(300)) {
                    location.logT(300, "ContainerImpl.destroyServAndLibComponents(): Failed to unregister DataSource aliases of " + appName + ": " + wex.toString());
                }
                if (!location.beLogged(100)) continue;
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)wex);
            }
            catch (DeploymentException dex) {
                if (location.beLogged(300)) {
                    location.logT(300, "ContainerImpl.destroyServAndLibComponents(): Failed to unregister DataSource aliases of " + appName + ": " + ((Throwable)((Object)dex)).toString());
                }
                if (!location.beLogged(100)) continue;
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)dex));
            }
        }
        enum = this.appsDescr.keys();
        while (enum.hasMoreElements()) {
            String appName = (String)enum.nextElement();
            if (!appName.endsWith(SERVICE_SUFFIX) && !appName.endsWith(LIBRARY_SUFFIX)) continue;
            try {
                this.commitStop(appName);
                this.remove(appName);
            }
            catch (WarningException wex) {
                if (location.beLogged(300)) {
                    location.logT(300, "ContainerImpl.destroyServAndLibComponents(): Failed to unregister DataSources of " + appName + ": " + wex.toString());
                }
                if (!location.beLogged(100)) continue;
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)wex);
            }
            catch (DeploymentException dex) {
                if (location.beLogged(300)) {
                    location.logT(300, "ContainerImpl.destroyServAndLibComponents(): Failed to unregister DataSources of " + appName + ": " + ((Throwable)((Object)dex)).toString());
                }
                if (!location.beLogged(100)) continue;
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)dex));
            }
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.destroyServAndLibComponents()");
        }
    }

    public void setDeployCommunicator(DeployCommunicator _deployCommunicator) {
        this.deployCommunicator = _deployCommunicator;
        this.initAppsDescr();
    }

    public void setManagementListener(ManagementListener _managementListener) {
        this.managementListener = _managementListener;
        Enumeration htEnum = this.appsDescr.keys();
        while (htEnum.hasMoreElements()) {
            String appName = (String)htEnum.nextElement();
            try {
                if (!appName.endsWith(SERVICE_SUFFIX) && !appName.endsWith(LIBRARY_SUFFIX) && !this.dsManager.isApplicationStarted(appName)) continue;
                this.notifyManagementListener(appName, "add");
            }
            catch (RemoteException rex) {
                location.traceThrowableT(500, "Unexpected exception: ", (Throwable)rex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bindAndRegisterExternalAliases(String applicationName, Hashtable extAliases) throws DeploymentException {
        InitialContext naming = null;
        try {
            naming = new InitialContext(this.contextProps);
        }
        catch (NamingException ne) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.bindAndRegisterExternalAliases(): Cannot get InitialContext. Reason: " + ne.toString());
            }
            if (!location.beLogged(100)) throw new BaseDeploymentException("dbpool_0005", (Throwable)ne);
            location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
            throw new BaseDeploymentException("dbpool_0005", (Throwable)ne);
        }
        Hashtable<String, String[]> registeredExtAliases = new Hashtable<String, String[]>();
        Enumeration enumeration = extAliases.keys();
        while (enumeration.hasMoreElements()) {
            String dsName = (String)enumeration.nextElement();
            String[] thisExtAliases = (String[])extAliases.get(dsName);
            Vector<String> reducedExtAliases = new Vector<String>();
            Vector<String> thisRegisteredExtAliases = new Vector<String>();
            int i = 0;
            while (i < thisExtAliases.length) {
                block16: {
                    String cfName = ResourceObjectFactory.getConnectionFactoryForAlias(thisExtAliases[i]);
                    if (cfName != null) {
                        if (cfName.equals(dsName)) {
                            HashMapObjectInt count = (HashMapObjectInt)this.extAliasesCntr.remove(thisExtAliases[i]);
                            if (count == null) {
                                count = new HashMapObjectInt(1);
                                count.put(dsName, 1);
                            } else {
                                int countOfApps = count.get(dsName) + 1;
                                count.put(dsName, countOfApps);
                            }
                            this.extAliasesCntr.put(thisExtAliases[i], count);
                            thisRegisteredExtAliases.add(thisExtAliases[i]);
                            break block16;
                        } else {
                            if (thisRegisteredExtAliases.isEmpty()) {
                                if (registeredExtAliases.isEmpty()) throw new BaseDeploymentException("dbpool_0006", dsName);
                                this.dsAliases.put(applicationName, registeredExtAliases);
                                throw new BaseDeploymentException("dbpool_0006", dsName);
                            }
                            registeredExtAliases.put(dsName, thisRegisteredExtAliases.toArray(new String[0]));
                            this.dsAliases.put(applicationName, registeredExtAliases);
                            throw new BaseDeploymentException("dbpool_0006", dsName);
                        }
                    }
                    reducedExtAliases.add(thisExtAliases[i]);
                }
                ++i;
            }
            String[] reducedExtAliasesArray = reducedExtAliases.toArray(new String[0]);
            try {
                ResourceObjectFactory.registerAliases(dsName, reducedExtAliasesArray);
            }
            catch (ResourceException rex) {
                if (registeredExtAliases.isEmpty()) throw new BaseDeploymentException("dbpool_0006", dsName, (Throwable)rex);
                this.dsAliases.put(applicationName, registeredExtAliases);
                throw new BaseDeploymentException("dbpool_0006", dsName, (Throwable)rex);
            }
            try {
                Reference ref = this.createReference(dsName);
                Reference clref = this.createClientReference(dsName);
                Reference notxref = this.createNonTxReference(dsName);
                int i2 = 0;
                while (i2 < reducedExtAliasesArray.length) {
                    this.bind(naming, "jdbc/" + reducedExtAliasesArray[i2], ref);
                    this.bind(naming, "jdbc/client/jdbc/" + reducedExtAliasesArray[i2], clref);
                    this.bind(naming, "jdbc/notx/" + reducedExtAliasesArray[i2], notxref);
                    ++i2;
                }
            }
            catch (NamingException ne) {
                if (registeredExtAliases.isEmpty()) throw new BaseDeploymentException("dbpool_0006", dsName, (Throwable)ne);
                this.dsAliases.put(applicationName, registeredExtAliases);
                throw new BaseDeploymentException("dbpool_0006", dsName, (Throwable)ne);
            }
            registeredExtAliases.put(dsName, thisExtAliases);
        }
        this.dsAliases.put(applicationName, extAliases);
    }

    private void unbindAndUnregisterExternalAliases(String applicationName) {
        InitialContext naming;
        Hashtable extAliases;
        block22: {
            extAliases = (Hashtable)this.dsAliases.get(applicationName);
            if (extAliases == null) {
                return;
            }
            naming = null;
            try {
                naming = new InitialContext(this.contextProps);
            }
            catch (NamingException ne) {
                if (location.beLogged(300)) {
                    location.logT(300, "ContainerImpl.unbindAndUnregisterExternalAliases(): Cannot get InitialContext. Reason: " + ne.toString());
                }
                if (!location.beLogged(100)) break block22;
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
            }
        }
        Enumeration enumeration = extAliases.keys();
        while (enumeration.hasMoreElements()) {
            String[] reducedExtAliasesArray;
            Vector<String> reducedExtAliases;
            block25: {
                int i;
                String dsName;
                block24: {
                    block23: {
                        dsName = (String)enumeration.nextElement();
                        String[] thisExtAliases = (String[])extAliases.get(dsName);
                        reducedExtAliases = new Vector<String>();
                        int i2 = 0;
                        while (i2 < thisExtAliases.length) {
                            HashMapObjectInt count = (HashMapObjectInt)this.extAliasesCntr.remove(thisExtAliases[i2]);
                            if (count != null) {
                                int countOfApps = count.get(dsName) - 1;
                                if (countOfApps > 0) {
                                    count.put(dsName, countOfApps);
                                    this.extAliasesCntr.put(thisExtAliases[i2], count);
                                }
                            } else if (!this.isAliasInternal(thisExtAliases[i2])) {
                                reducedExtAliases.add(thisExtAliases[i2]);
                            }
                            ++i2;
                        }
                        reducedExtAliasesArray = reducedExtAliases.toArray(new String[0]);
                        try {
                            Context clCtx = (Context)naming.lookup("jdbc/client/jdbc/");
                            i = 0;
                            while (i < reducedExtAliasesArray.length) {
                                this.unbind(clCtx, reducedExtAliasesArray[i]);
                                ++i;
                            }
                        }
                        catch (NamingException ne) {
                            if (location.beLogged(300)) {
                                location.logT(300, "ContainerImpl.unbindAndUnregisterExternalAliases(): Failed to unbind '" + dsName + "' aliases from 'jdbc/client/jdbc' context. Reason: " + ne.toString());
                            }
                            if (!location.beLogged(100)) break block23;
                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                        }
                    }
                    try {
                        Context notxCtx = (Context)naming.lookup("jdbc/notx/");
                        i = 0;
                        while (i < reducedExtAliasesArray.length) {
                            this.unbind(notxCtx, reducedExtAliasesArray[i]);
                            ++i;
                        }
                    }
                    catch (NamingException ne) {
                        if (location.beLogged(300)) {
                            location.logT(300, "ContainerImpl.unbindAndUnregisterExternalAliases(): Failed to unbind '" + dsName + "' aliases from 'jdbc/notx' context. Reason: " + ne.toString());
                        }
                        if (!location.beLogged(100)) break block24;
                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                    }
                }
                try {
                    Context refContext = (Context)naming.lookup("jdbc/");
                    i = 0;
                    while (i < reducedExtAliasesArray.length) {
                        this.unbind(refContext, reducedExtAliasesArray[i]);
                        ++i;
                    }
                }
                catch (NamingException ne) {
                    if (location.beLogged(300)) {
                        location.logT(300, "ContainerImpl.unbindAndUnregisterExternalAliases(): Failed to unbind '" + dsName + "' aliases from 'jdbc' context. Reason: " + ne.toString());
                    }
                    if (!location.beLogged(100)) break block25;
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                }
            }
            if (reducedExtAliases.isEmpty()) continue;
            ResourceObjectFactory.unregisterAliases(reducedExtAliasesArray);
        }
    }

    public void beforeRuntimeChangesInDataSources(String appName, Vector dsVtr, boolean restartApp) {
        this.runtimeChangedAppsDescr.put(appName, dsVtr);
        this.runtimeChangedAppsRestart.put(appName, new Boolean(restartApp));
    }

    public void beforeRuntimeChangesInAliases(String appName, Hashtable aliases) {
        this.runtimeChangedAliases.put(appName, aliases);
    }

    private void backupAppInfo(String appName) {
        Object extAliases;
        Object descrVtr = this.appsDescr.remove(appName);
        if (descrVtr != null) {
            this.appsDescrCache.put(appName, descrVtr);
        }
        if ((extAliases = this.dsAliases.remove(appName)) != null) {
            this.dsAliasesCache.put(appName, extAliases);
        }
    }

    private void recoverAppInfo(String appName) {
        Object extAliases;
        Object descrVtr = this.appsDescrCache.remove(appName);
        if (descrVtr != null) {
            this.appsDescr.put(appName, descrVtr);
        }
        if ((extAliases = this.dsAliasesCache.remove(appName)) != null) {
            this.dsAliases.put(appName, extAliases);
        }
    }

    private void startDataSource(String dataSourceName, String[] aliases, String[] extAliases, boolean isOpenSQL, boolean isNativeSQL) throws DeploymentException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.startDataSource(): DataSource name = " + dataSourceName);
        }
        if (isOpenSQL || isNativeSQL) {
            OpenSQLConnectionFactory.dataSourceStateChanged((String)dataSourceName, (boolean)isOpenSQL, (int)1);
        }
        try {
            ResourceObjectFactory.startConnectionFactory(dataSourceName);
            if (aliases != null && aliases.length != 0 && !ResourceObjectFactory.aliasesExist(aliases)) {
                ResourceObjectFactory.registerAliases(dataSourceName, aliases);
            }
        }
        catch (ResourceException rex) {
            throw new BaseDeploymentException("dbpool_0015", dataSourceName, (Throwable)rex);
        }
        if (isOpenSQL || isNativeSQL) {
            OpenSQLConnectionFactory.dataSourceStateChanged((String)dataSourceName, (boolean)isOpenSQL, (int)2);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.startDataSource(): DataSource name = " + dataSourceName);
        }
    }

    private void stopDataSource(String dataSourceName, String[] aliases, String[] extAliases, boolean isOpenSQL, boolean isNativeSQL) throws WarningException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ContainerImpl.stopDataSource(): DataSource name = " + dataSourceName);
        }
        if (isOpenSQL || isNativeSQL) {
            OpenSQLConnectionFactory.dataSourceStateChanged((String)dataSourceName, (boolean)isOpenSQL, (int)3);
        }
        try {
            if (aliases != null && aliases.length != 0) {
                ResourceObjectFactory.unregisterAliases(aliases);
            }
            if (extAliases != null && extAliases.length != 0) {
                ResourceObjectFactory.unregisterAliases(extAliases);
            }
            if (dataSourceName != null) {
                ResourceObjectFactory.stopConnectionFactory(dataSourceName);
            }
        }
        catch (ResourceException rex) {
            throw new BaseWarningException("dbpool_0100", dataSourceName, (Throwable)rex);
        }
        if (isOpenSQL || isNativeSQL) {
            OpenSQLConnectionFactory.dataSourceStateChanged((String)dataSourceName, (boolean)isOpenSQL, (int)4);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ContainerImpl.stopDataSource(): DataSource name = " + dataSourceName);
        }
    }

    private boolean isStartedApplicationWithComponent(String applicationName, String componentName) {
        block17: {
            try {
                JDBCDescriptor sysDSDescr = this.dsManager.getSystemDataSourceDescriptor();
                if (sysDSDescr != null) {
                    if (componentName.equals(sysDSDescr.getDataSourceName())) {
                        return true;
                    }
                    String[] aliases = sysDSDescr.getAliases();
                    if (aliases != null) {
                        int i = 0;
                        while (i < aliases.length) {
                            if (componentName.equals(aliases[i])) {
                                return true;
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (RemoteException rex) {
                if (location.beLogged(300)) {
                    location.logT(300, "ContainerImpl.isStartedApplicationWithComponent(): Cannot get the default DataSource descriptor. Reason: " + rex.toString());
                }
                if (!location.beLogged(100)) break block17;
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
            }
        }
        Enumeration htEnum = this.appsDescr.keys();
        while (htEnum.hasMoreElements()) {
            String curAppName = (String)htEnum.nextElement();
            if (curAppName.equals(applicationName)) continue;
            Enumeration vecEnum = ((Vector)this.appsDescr.get(curAppName)).elements();
            while (vecEnum.hasMoreElements()) {
                JDBCDescriptor descr = (JDBCDescriptor)vecEnum.nextElement();
                if (componentName.equals(descr.getDataSourceName()) && this.startedApps.contains(curAppName)) {
                    return true;
                }
                String[] aliases = descr.getAliases();
                if (aliases == null) continue;
                int i = 0;
                while (i < aliases.length) {
                    if (componentName.equals(aliases[i]) && this.startedApps.contains(curAppName)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        Enumeration enumeration = this.dsAliases.keys();
        while (enumeration.hasMoreElements()) {
            String curAppName = (String)enumeration.nextElement();
            if (curAppName.equals(applicationName)) continue;
            Hashtable aliases = (Hashtable)this.dsAliases.get(curAppName);
            Enumeration intEnum = aliases.keys();
            while (intEnum.hasMoreElements()) {
                String curDSName = (String)intEnum.nextElement();
                String[] extAliasesOfThisApp = (String[])aliases.get(curDSName);
                int i = 0;
                while (i < extAliasesOfThisApp.length) {
                    if (componentName.equals(extAliasesOfThisApp[i]) && this.startedApps.contains(curAppName)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private void checkDriverLoader(String drName) throws DeploymentException {
        LoadContext loadCtx = this.serviceContext.getCoreContext().getLoadContext();
        try {
            Hashtable drivers = this.dsManager.getDrivers();
            if (loadCtx.getClassLoader("library:" + drName) == null) {
                if (drivers.get(drName) != null) {
                    this.dsManager.undefineJdbcDriver(drName);
                }
                throw new BaseDeploymentException("dbpool_0007", drName);
            }
            if (drivers.get(drName) == null) {
                this.dsManager.defineJdbcDriver(drName);
            }
        }
        catch (RemoteException rex) {
            throw new BaseDeploymentException("dbpool_0008", drName, (Throwable)rex);
        }
    }

    private Vector checkDataSources(File xml) throws DeploymentException {
        try {
            return XMLUtils.processXML(xml);
        }
        catch (IOException ioex) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.checkDataSources(): IOException while parsing file '" + xml + "': " + ioex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)ioex);
            }
            throw new BaseDeploymentException("dbpool_0001", xml, (Throwable)ioex);
        }
        catch (IllegalArgumentException iaex) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.checkDataSources(): IllegalArgumentException while parsing file '" + xml + "': " + iaex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)iaex);
            }
            throw new BaseDeploymentException("dbpool_0001", xml, (Throwable)iaex);
        }
    }

    private Hashtable checkAliases(File xml) throws DeploymentException {
        try {
            return XMLUtils.processAliasesXML(xml);
        }
        catch (IOException ioex) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.checkAliases(): IOException while parsing file '" + xml + "': " + ioex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)ioex);
            }
            throw new BaseDeploymentException("dbpool_0001", xml, (Throwable)ioex);
        }
        catch (IllegalArgumentException iaex) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.checkAliases(): IllegalArgumentException while parsing file '" + xml + "': " + iaex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)iaex);
            }
            throw new BaseDeploymentException("dbpool_0001", xml, (Throwable)iaex);
        }
    }

    private void startDataSources(String applicationName, Vector descrVtr) throws DeploymentException {
        this.appsDescr.put(applicationName, descrVtr);
        InitialContext naming = null;
        try {
            naming = new InitialContext(this.contextProps);
        }
        catch (NamingException ne) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.startDataSources(): Cannot get InitialContext. Reason: " + ne.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
            }
            throw new BaseDeploymentException("dbpool_0005", (Throwable)ne);
        }
        Enumeration enumeration = descrVtr.elements();
        while (enumeration.hasMoreElements()) {
            ManagedConnectionFactory mcf = null;
            MCFWrapper wrapper = null;
            JDBCDescriptor descriptor = (JDBCDescriptor)enumeration.nextElement();
            String dsName = descriptor.getDataSourceName();
            String[] aliases = descriptor.getAliases();
            try {
                String driverName = descriptor.getDriverName();
                if (!"SYSTEM_DRIVER".equals(driverName)) {
                    this.checkDriverLoader(driverName);
                }
                if (descriptor.isNewDriver()) {
                    if (descriptor.isXADS()) {
                        mcf = new XAManagedConnectionFactoryImpl(this, descriptor, this.mcfid++);
                        wrapper = new MCFWrapper(mcf, 2, aliases, descriptor.getInitConnections(), descriptor.getMaxConnections(), descriptor.getMaxTimeToWaitConn(), descriptor.getConnLifetime(), descriptor.getRunCleanupThread());
                    } else {
                        Class<?> cpdsClass;
                        mcf = new CPManagedConnectionFactoryImpl(this, descriptor, this.mcfid++);
                        wrapper = new MCFWrapper(mcf, 1, aliases, descriptor.getInitConnections(), descriptor.getMaxConnections(), descriptor.getMaxTimeToWaitConn(), descriptor.getConnLifetime(), descriptor.getRunCleanupThread());
                        if ("SYSTEM_DRIVER".equals(driverName)) {
                            cpdsClass = Class.forName(descriptor.getCPDSClassName());
                        } else {
                            LoadContext loadCtx = this.serviceContext.getCoreContext().getLoadContext();
                            cpdsClass = loadCtx.getClassLoader("library:" + driverName).loadClass(descriptor.getCPDSClassName());
                        }
                        Object cpdsInstance = cpdsClass.newInstance();
                        this.bind(naming, "ConnectionPoolDataSources/" + descriptor.getDataSourceName(), cpdsInstance);
                    }
                } else {
                    mcf = new ManagedConnectionFactoryImpl(this, descriptor, this.mcfid++);
                    wrapper = new MCFWrapper(mcf, 1, aliases, descriptor.getInitConnections(), descriptor.getMaxConnections(), descriptor.getMaxTimeToWaitConn(), descriptor.getConnLifetime(), descriptor.getRunCleanupThread());
                }
                this.bind(naming, "mcf/" + dsName, wrapper);
                boolean isStandAlone = applicationName.endsWith(SERVICE_SUFFIX) || applicationName.endsWith(LIBRARY_SUFFIX) ? true : this.dsManager.isStandAloneApplication(applicationName);
                ResourceObjectFactory.addConnectionFactory(applicationName, descriptor.getDataSourceName(), DATASOURCE_RESOURCE_TYPE, false, isStandAlone);
                Reference ref = this.createReference(dsName);
                Reference clref = this.createClientReference(dsName);
                Reference notxref = this.createNonTxReference(dsName);
                this.bind(naming, "jdbc/" + dsName, ref);
                this.bind(naming, "jdbc/client/jdbc/" + dsName, clref);
                this.bind(naming, "jdbc/notx/" + dsName, notxref);
                if (aliases != null && aliases.length != 0) {
                    int i = 0;
                    while (i < aliases.length) {
                        String cfName = ResourceObjectFactory.getConnectionFactoryForAlias(aliases[i]);
                        if (cfName == null) {
                            this.bind(naming, "jdbc/" + aliases[i], ref);
                            this.bind(naming, "jdbc/client/jdbc/" + aliases[i], clref);
                            this.bind(naming, "jdbc/notx/" + aliases[i], notxref);
                        } else if (!cfName.equals(dsName)) {
                            throw new BaseDeploymentException("dbpool_0014", aliases[i]);
                        }
                        ++i;
                    }
                }
                this.bind(naming, "mcf_descriptors/dbpool/" + descriptor.getDataSourceName(), descriptor);
                this.startDataSource(dsName, aliases, null, descriptor.isOpenSQL(), descriptor.isNativeSQL());
            }
            catch (DeploymentException dex) {
                throw dex;
            }
            catch (ResourceException rex) {
                if (location.beLogged(500)) {
                    location.logT(500, "ContainerImpl.startDataSources(): Cannot create ManagedConnectionFactory for DataSource: " + descriptor.getDataSourceName() + ". Reason: " + rex.toString());
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                }
                throw new BaseDeploymentException("dbpool_0011", descriptor.getDataSourceName(), (Throwable)rex);
            }
            catch (Exception ex) {
                if (location.beLogged(500)) {
                    location.logT(500, "ContainerImpl.startDataSources(): Cannot create DataSource: " + descriptor.getDataSourceName() + ". Reason: " + ex.toString());
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)ex);
                }
                throw new BaseDeploymentException("dbpool_0009", descriptor.getDataSourceName(), (Throwable)ex);
            }
        }
    }

    private Reference createReference(String dsName) {
        Reference ref = new Reference("com.sap.engine.services.dbpool.cci.ConnectionFactory", "com.sap.engine.services.connector.ResourceObjectFactory", "service:connector");
        ref.add(new StringRefAddr("res-type", DATASOURCE_RESOURCE_TYPE));
        ref.add(new StringRefAddr("res-auth", "Container"));
        ref.add(new StringRefAddr("sharing-scope", "Shareable"));
        ref.add(new StringRefAddr("res-name", dsName));
        return ref;
    }

    private Reference createClientReference(String dsName) {
        Reference clref = new Reference("com.sap.engine.services.dbpool.cci.ConnectionFactory", "com.sap.engine.services.connector.ResourceObjectFactory", "service:connector");
        clref.add(new StringRefAddr("res-type", DATASOURCE_RESOURCE_TYPE));
        clref.add(new StringRefAddr("res-auth", "Container"));
        clref.add(new StringRefAddr("sharing-scope", "Shareable"));
        clref.add(new StringRefAddr("res-name", dsName));
        clref.add(new StringRefAddr("client", "client"));
        return clref;
    }

    private Reference createNonTxReference(String dsName) {
        Reference notxref = new Reference("com.sap.engine.services.dbpool.cci.ConnectionFactory", "com.sap.engine.services.connector.ResourceObjectFactory", "service:connector");
        notxref.add(new StringRefAddr("res-type", DATASOURCE_RESOURCE_TYPE));
        notxref.add(new StringRefAddr("res-auth", "Application"));
        notxref.add(new StringRefAddr("sharing-scope", "Shareable"));
        notxref.add(new StringRefAddr("res-name", dsName));
        notxref.add(new StringRefAddr("tx-support", "false"));
        return notxref;
    }

    private void clearNaming(String applicationName) throws WarningException {
        Vector descrVtr = (Vector)this.appsDescr.get(applicationName);
        if (descrVtr == null) {
            return;
        }
        InitialContext naming = null;
        try {
            naming = new InitialContext(this.contextProps);
        }
        catch (NamingException ne) {
            if (location.beLogged(300)) {
                location.logT(300, "ContainerImpl.clearNaming(): Cannot get InitialContext. Reason: " + ne.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
            }
            throw new BaseWarningException("dbpool_0101", (Throwable)ne);
        }
        Enumeration enumeration = descrVtr.elements();
        while (enumeration.hasMoreElements()) {
            String dataSourceName;
            block44: {
                block43: {
                    int i;
                    String[] aliases;
                    block42: {
                        block41: {
                            block40: {
                                JDBCDescriptor descr = (JDBCDescriptor)enumeration.nextElement();
                                dataSourceName = this.refine(applicationName, descr.getDataSourceName());
                                aliases = this.refine(applicationName, descr.getAliases());
                                this.stopDataSource(dataSourceName, aliases, null, descr.isOpenSQL(), descr.isNativeSQL());
                                if (dataSourceName != null) {
                                    block39: {
                                        try {
                                            Context mcfContext = (Context)naming.lookup("mcf/");
                                            this.unbind(mcfContext, dataSourceName);
                                            this.deleteTree(naming, "mcf");
                                        }
                                        catch (NamingException ne) {
                                            if (location.beLogged(300)) {
                                                location.logT(300, "ContainerImpl.clearNaming(): Failed to unbind '" + dataSourceName + "' from 'mcf' context. Reason: " + ne.toString());
                                            }
                                            if (!location.beLogged(100)) break block39;
                                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                                        }
                                    }
                                    if (descr.isNewDriver() && !descr.isXADS()) {
                                        try {
                                            Context cpdsContext = (Context)naming.lookup("ConnectionPoolDataSources/");
                                            this.unbind(cpdsContext, dataSourceName);
                                            this.deleteTree(naming, "ConnectionPoolDataSources");
                                        }
                                        catch (NamingException ne) {
                                            if (location.beLogged(300)) {
                                                location.logT(300, "ContainerImpl.clearNaming(): Failed to unbind '" + dataSourceName + "' from 'ConnectionPoolDataSources' context. Reason: " + ne.toString());
                                            }
                                            if (!location.beLogged(100)) break block40;
                                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                                        }
                                    }
                                }
                            }
                            try {
                                Context notxCtx = (Context)naming.lookup("jdbc/notx/");
                                if (dataSourceName != null) {
                                    this.unbind(notxCtx, dataSourceName);
                                }
                                if (aliases != null) {
                                    i = 0;
                                    while (i < aliases.length) {
                                        this.unbind(notxCtx, aliases[i]);
                                        ++i;
                                    }
                                }
                            }
                            catch (NamingException ne) {
                                if (location.beLogged(300)) {
                                    location.logT(300, "ContainerImpl.clearNaming(): Failed to unbind '" + dataSourceName + "' and its aliases from 'jdbc/notx' context. Reason: " + ne.toString());
                                }
                                if (!location.beLogged(100)) break block41;
                                location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                            }
                        }
                        try {
                            Context clCtx = (Context)naming.lookup("jdbc/client/jdbc/");
                            if (dataSourceName != null) {
                                this.unbind(clCtx, dataSourceName);
                            }
                            if (aliases != null) {
                                i = 0;
                                while (i < aliases.length) {
                                    this.unbind(clCtx, aliases[i]);
                                    ++i;
                                }
                            }
                        }
                        catch (NamingException ne) {
                            if (location.beLogged(300)) {
                                location.logT(300, "ContainerImpl.clearNaming(): Failed to unbind '" + dataSourceName + "' and its aliases from 'jdbc/client/jdbc' context. Reason: " + ne.toString());
                            }
                            if (!location.beLogged(100)) break block42;
                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                        }
                    }
                    try {
                        Context refContext = (Context)naming.lookup("jdbc/");
                        if (dataSourceName != null) {
                            this.unbind(refContext, dataSourceName);
                        }
                        if (aliases != null) {
                            i = 0;
                            while (i < aliases.length) {
                                this.unbind(refContext, aliases[i]);
                                ++i;
                            }
                        }
                        this.deleteTree(naming, "jdbc");
                    }
                    catch (NamingException ne) {
                        if (location.beLogged(300)) {
                            location.logT(300, "ContainerImpl.clearNaming(): Failed to unbind '" + dataSourceName + "' and its aliases from 'jdbc' context. Reason: " + ne.toString());
                        }
                        if (!location.beLogged(100)) break block43;
                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                    }
                }
                if (dataSourceName == null) continue;
                try {
                    Context mcfD = (Context)naming.lookup("mcf_descriptors/dbpool/");
                    this.unbind(mcfD, dataSourceName);
                    this.deleteTree(naming, "mcf_descriptors");
                }
                catch (NamingException ne) {
                    if (location.beLogged(300)) {
                        location.logT(300, "ContainerImpl.clearNaming(): Failed to unbind '" + dataSourceName + "' and its aliases from 'mcf_descriptors/dbpool' context. Reason: " + ne.toString());
                    }
                    if (!location.beLogged(100)) break block44;
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)ne);
                }
            }
            try {
                ResourceObjectFactory.removeConnectionFactory(dataSourceName);
            }
            catch (ResourceException re) {
                if (location.beLogged(300)) {
                    location.logT(300, "ContainerImpl.clearNaming(): Failed to remove ConnectionFactory for '" + dataSourceName + "' DataSource. Reason: " + re.toString());
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)re);
                }
                throw new BaseWarningException("dbpool_0102", dataSourceName, (Throwable)re);
            }
        }
    }

    private String refine(String applicationName, String componentName) {
        return this.isStartedApplicationWithComponent(applicationName, componentName) ? null : componentName;
    }

    private String[] refine(String applicationName, String[] componentsArray) {
        Vector<String> refinedComponents = new Vector<String>();
        if (componentsArray != null) {
            int i = 0;
            while (i < componentsArray.length) {
                if (!this.isStartedApplicationWithComponent(applicationName, componentsArray[i])) {
                    refinedComponents.add(componentsArray[i]);
                }
                ++i;
            }
        }
        return refinedComponents.toArray(new String[0]);
    }

    private boolean isAliasInternal(String extAlias) {
        block9: {
            try {
                String[] aliases;
                JDBCDescriptor sysDSDescr = this.dsManager.getSystemDataSourceDescriptor();
                if (sysDSDescr != null && (aliases = sysDSDescr.getAliases()) != null) {
                    int i = 0;
                    while (i < aliases.length) {
                        if (extAlias.equals(aliases[i])) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
            catch (RemoteException rex) {
                if (!location.beLogged(300)) break block9;
                location.traceThrowableT(300, "ContainerImpl.isAliasInternal(): Cannot get the default DataSource descriptor. Reason: ", (Throwable)rex);
            }
        }
        Enumeration enumeration = this.appsDescr.elements();
        while (enumeration.hasMoreElements()) {
            Vector dsVtr = (Vector)enumeration.nextElement();
            Enumeration vtrEnum = dsVtr.elements();
            while (vtrEnum.hasMoreElements()) {
                JDBCDescriptor descr = (JDBCDescriptor)vtrEnum.nextElement();
                String[] aliases = descr.getAliases();
                if (aliases == null) continue;
                int i = 0;
                while (i < aliases.length) {
                    if (extAlias.equals(aliases[i])) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public synchronized void ensureOpenSqlResForLoader(ResourceLoader loader) {
        if (!this.loadersWithOpenSqlRes.contains(loader)) {
            FileReferencedLoader coreLibLoader = (FileReferencedLoader)this.serviceContext.getCoreContext().getLoadContext().getClassLoader("library:core_lib");
            String[] allRes = coreLibLoader.getResourceNames();
            int i = 0;
            while (i < allRes.length) {
                String res = allRes[i];
                if (res.endsWith(File.separatorChar + OPEN_SQL_JAR)) {
                    loader.addResource(new JarResource(res));
                    break;
                }
                ++i;
            }
            this.loadersWithOpenSqlRes.add(loader);
        }
    }

    private void bind(Context root, String name, Object obj) throws NamingException, DeploymentException {
        String s;
        Context ic = root;
        Context current = null;
        StringTokenizer st = new StringTokenizer(name, "/");
        while (true) {
            s = st.nextToken();
            if (!st.hasMoreTokens()) break;
            try {
                current = (Context)ic.lookup(s);
            }
            catch (javax.naming.NameNotFoundException e) {
                try {
                    current = ic.createSubcontext(s);
                }
                catch (NameAlreadyBoundException nabe) {
                    current = (Context)ic.lookup(s);
                }
            }
            ic = current;
        }
        try {
            ic.bind(s, obj);
        }
        catch (NameAlreadyBoundException nabex) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.bind(): The name '" + name + "' already exists as a DataSource name or an alias. " + nabex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)nabex);
            }
            throw new BaseDeploymentException("dbpool_0014", s, (Throwable)nabex);
        }
    }

    private void unbind(Context root, String name) throws NamingException {
        int index = name.lastIndexOf(47);
        if (index == -1) {
            root.unbind("/" + name);
        } else {
            ((Context)root.lookup(name.substring(0, index))).unbind("/" + name.substring(index + 1));
            this.destroyContext(root, name.substring(0, index));
        }
    }

    private void destroyContext(Context root, String contextName) throws NamingException {
        block5: {
            if (contextName.equals("")) {
                return;
            }
            int index = contextName.indexOf(47);
            try {
                if (index == -1) {
                    root.destroySubcontext(contextName);
                } else {
                    String s = contextName.substring(0, index);
                    this.destroyContext((Context)root.lookup(contextName.substring(0, index)), contextName.substring(index + 1));
                    root.destroySubcontext(s);
                }
            }
            catch (ContextNotEmptyException cne) {
                if (!location.beLogged(300)) break block5;
                location.traceThrowableT(300, "ContainerImpl.destroyContext(): Cannot destroy context '" + contextName + "'. Reason: ", (Throwable)cne);
            }
        }
    }

    private void deleteTree(Context naming, String contextName) {
        block2: {
            try {
                this.deleteSubTree(naming, contextName);
                naming.destroySubcontext(contextName);
            }
            catch (NamingException nex) {
                if (!location.beLogged(100)) break block2;
                location.traceThrowableT(100, "ContainerImpl.deleteTree(): Cannot destroy subcontext '" + contextName + "' because it is not empty. ", (Throwable)nex);
            }
        }
    }

    private void deleteSubTree(Context naming, String location) throws NamingException {
        NamingEnumeration<NameClassPair> namingEnumeration = naming.list(location);
        while (namingEnumeration.hasMore()) {
            NameClassPair item = namingEnumeration.next();
            if (!this.isContext(item.getClassName())) continue;
            this.deleteSubTree(naming, location + "/" + item.getName());
            naming.destroySubcontext(location + "/" + item.getName());
        }
    }

    private boolean isContext(String nm) {
        return nm.indexOf("javax.naming.Context") != -1 || nm.indexOf("javax.naming.directory.DirContext") != -1;
    }

    private String getAppWorkDir(String applicationName) throws DeploymentException {
        try {
            return this.deployCommunicator.getMyWorkDirectory(applicationName);
        }
        catch (IOException ioex) {
            throw new BaseDeploymentException("dbpool_0010", CONTAINER_NAME, (Throwable)ioex);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initAppsDescr() {
        Enumeration enumeration22222;
        ConfigurationHandler configurationHandler = null;
        String[] myApps = this.deployCommunicator.getMyApplications();
        if (myApps == null) return;
        Hashtable _appsDescr = new Hashtable();
        Hashtable _dsAliases = new Hashtable();
        try {
            Enumeration enumeration22222;
            block40: {
                block37: {
                    Enumeration enumeration22222;
                    Enumeration enumeration22222;
                    Enumeration enumeration22222;
                    Enumeration enumeration22222;
                    try {
                        block38: {
                            configurationHandler = this.serviceContext.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
                            if (this.checkIfSecuredAndRead(configurationHandler, myApps, _appsDescr, _dsAliases)) {
                                this.appsDescr = _appsDescr;
                                this.dsAliases = _dsAliases;
                                break block37;
                            }
                            try {
                                this.secureAppData(configurationHandler, myApps);
                            }
                            catch (ConfigurationLockedException clex) {
                                if (!location.beLogged(100)) break block38;
                                location.traceThrowableT(100, "ContainerImpl.initAppsDescr(): Other cluster element does the writing.", (Throwable)((Object)clex));
                            }
                        }
                        this.waitAndReadAppData(configurationHandler, myApps);
                    }
                    catch (InconsistentReadException irex) {
                        block39: {
                            if (location.beLogged(100)) {
                                location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)irex));
                            }
                            try {
                                this.waitAndReadAppData(configurationHandler, myApps);
                            }
                            catch (IOException ioex) {
                                if (location.beLogged(300)) {
                                    location.logT(300, "ContainerImpl.initAppsDescr(): IOException occured during init of the applications cache after the update from other cluster element. Reason: " + ioex.toString());
                                }
                                if (location.beLogged(100)) {
                                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)ioex);
                                }
                            }
                            catch (ConfigurationException cex) {
                                if (location.beLogged(300)) {
                                    location.logT(300, "ContainerImpl.initAppsDescr(): ConfigurationException occured during init of the applications cache after the update from other cluster element. Reason: " + ((Throwable)((Object)cex)).toString());
                                }
                                if (location.beLogged(100)) {
                                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)cex));
                                }
                            }
                            catch (RuntimeException rex) {
                                if (location.beLogged(300)) {
                                    location.logT(300, "ContainerImpl.initAppsDescr(): RuntimeException occured during init of the applications cache after the update from other cluster element. Reason: " + rex.toString());
                                }
                                if (!location.beLogged(100)) break block39;
                                location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                            }
                        }
                        Object var11_8 = null;
                        if (configurationHandler == null) return;
                        enumeration22222 = this.configPaths.elements();
                    }
                    while (true) {
                        if (!enumeration22222.hasMoreElements()) break;
                        configurationHandler.removeConfigurationChangedListener(this, (String)enumeration22222.nextElement());
                    }
                    this.configPaths.clear();
                    return;
                    catch (LockException lex) {
                        if (location.beLogged(300)) {
                            location.logT(300, "ContainerImpl.initAppsDescr(): Application which has to be changed is locked: " + ((Throwable)((Object)lex)).toString());
                        }
                        if (location.beLogged(100)) {
                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)lex));
                        }
                        Object var11_9 = null;
                        if (configurationHandler == null) return;
                        enumeration22222 = this.configPaths.elements();
                    }
                    while (true) {
                        if (!enumeration22222.hasMoreElements()) break;
                        configurationHandler.removeConfigurationChangedListener(this, (String)enumeration22222.nextElement());
                    }
                    this.configPaths.clear();
                    return;
                    catch (IOException ioex) {
                        if (location.beLogged(300)) {
                            location.logT(300, "ContainerImpl.initAppsDescr(): IOException occured during init of the applications cache. Reason: " + ioex.toString());
                        }
                        if (location.beLogged(100)) {
                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)ioex);
                        }
                        Object var11_10 = null;
                        if (configurationHandler == null) return;
                        enumeration22222 = this.configPaths.elements();
                    }
                    while (true) {
                        if (!enumeration22222.hasMoreElements()) break;
                        configurationHandler.removeConfigurationChangedListener(this, (String)enumeration22222.nextElement());
                    }
                    this.configPaths.clear();
                    return;
                    catch (ConfigurationException cex) {
                        if (location.beLogged(300)) {
                            location.logT(300, "ConfigurationException.initAppsDescr(): ConfigurationException occured during init of the applications cache. Reason: " + ((Throwable)((Object)cex)).toString());
                        }
                        if (location.beLogged(100)) {
                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)cex));
                        }
                        Object var11_11 = null;
                        if (configurationHandler == null) return;
                        enumeration22222 = this.configPaths.elements();
                    }
                    while (true) {
                        if (!enumeration22222.hasMoreElements()) break;
                        configurationHandler.removeConfigurationChangedListener(this, (String)enumeration22222.nextElement());
                    }
                    this.configPaths.clear();
                    return;
                    catch (RuntimeException rex) {
                        if (location.beLogged(300)) {
                            location.logT(300, "ConfigurationException.initAppsDescr(): RuntimeException occured during init of the applications cache. Reason: " + rex.toString());
                        }
                        if (location.beLogged(100)) {
                            location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                        }
                        Object var11_12 = null;
                        if (configurationHandler == null) return;
                        enumeration22222 = this.configPaths.elements();
                        break block40;
                    }
                }
                Object var11_7 = null;
                if (configurationHandler == null) return;
                Enumeration enumeration22222 = this.configPaths.elements();
                while (true) {
                    if (!enumeration22222.hasMoreElements()) break;
                    configurationHandler.removeConfigurationChangedListener(this, (String)enumeration22222.nextElement());
                }
                this.configPaths.clear();
                return;
            }
            while (true) {
                if (!enumeration22222.hasMoreElements()) break;
                configurationHandler.removeConfigurationChangedListener(this, (String)enumeration22222.nextElement());
            }
            this.configPaths.clear();
            return;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (configurationHandler == null) throw throwable;
            enumeration22222 = this.configPaths.elements();
        }
        while (true) {
            if (!enumeration22222.hasMoreElements()) {
                this.configPaths.clear();
                throw throwable;
            }
            configurationHandler.removeConfigurationChangedListener(this, (String)enumeration22222.nextElement());
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkIfSecuredAndRead(ConfigurationHandler configurationHandler, String[] myApps, Hashtable _appsDescr, Hashtable _dsAliases) throws IOException, ConfigurationException, InconsistentReadException {
        block17: {
            try {
                i = 0;
                block6: while (true) {
                    if (i >= myApps.length) {
                        var6_7 = true;
                        break block17;
                    }
                    app = myApps[i];
                    configPath = this.deployCommunicator.getAppConfigPath(app) + '/' + "JDBCConnector";
                    configurationHandler.addConfigurationChangedListener(this, configPath);
                    this.configPaths.add(configPath);
                    appConfig = configurationHandler.openConfiguration(configPath, 0);
                    if (appConfig.getAllFileEntryNames().length > 0) {
                        var9_11 = false;
                        var14_15 = null;
                        break;
                    }
                    dbFiles = this.getAllSecureFilenames(appConfig);
                    j = 0;
                    while (true) {
                        if (j >= dbFiles.length) {
                            ++i;
                            continue block6;
                        }
                        doc = XMLUtils.isDataSourceXML(this.getSecureFile(appConfig, dbFiles[j]));
                        if (doc != null) {
                            descrVtr = XMLUtils.processXML(doc);
                            _appsDescr.put(app, descrVtr);
                        } else if (XMLUtils.isAliasesXML(this.getSecureFile(appConfig, dbFiles[j]))) {
                            extAliases = XMLUtils.processAliasesXML(this.getSecureFile(appConfig, dbFiles[j]));
                            _dsAliases.put(app, extAliases);
                        }
                        ++j;
                    }
                    break;
                }
            }
            catch (Throwable var13_21) {
                var14_17 = null;
                try {
                    configurationHandler.closeAllConfigurations();
                    throw var13_21;
                }
                catch (ConfigurationException cex) {
                    if (ContainerImpl.location.beLogged(300)) {
                        ContainerImpl.location.logT(300, "ContainerImpl.checkIfSecuredAndRead(): Cannot close configurations. Reason: " + cex.toString());
                    }
                    if (ContainerImpl.location.beLogged(100) == false) throw var13_21;
                    ContainerImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)cex);
                    throw var13_21;
                }
            }
            ** try [egrp 1[TRYBLOCK] [1 : 235->244)] { 
lbl53:
            // 1 sources

            configurationHandler.closeAllConfigurations();
            return var9_11;
lbl55:
            // 1 sources

            catch (ConfigurationException cex) {
                if (ContainerImpl.location.beLogged(300)) {
                    ContainerImpl.location.logT(300, "ContainerImpl.checkIfSecuredAndRead(): Cannot close configurations. Reason: " + cex.toString());
                }
                if (ContainerImpl.location.beLogged(100) == false) return var9_11;
                ContainerImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)cex);
            }
            return var9_11;
        }
        var14_16 = null;
        ** try [egrp 1[TRYBLOCK] [1 : 235->244)] { 
lbl66:
        // 1 sources

        configurationHandler.closeAllConfigurations();
        return var6_7;
lbl68:
        // 1 sources

        catch (ConfigurationException cex) {
            if (ContainerImpl.location.beLogged(300)) {
                ContainerImpl.location.logT(300, "ContainerImpl.checkIfSecuredAndRead(): Cannot close configurations. Reason: " + cex.toString());
            }
            if (ContainerImpl.location.beLogged(100) == false) return var6_7;
            ContainerImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)cex);
        }
        return var6_7;
    }

    /*
     * Unable to fully structure code
     */
    private void secureAppData(ConfigurationHandler configurationHandler, String[] myApps) throws LockException, IOException, ConfigurationException, ConfigurationLockedException {
        block26: {
            block23: {
                block22: {
                    i = 0;
                    while (i < myApps.length) {
                        this.deployCommunicator.startModification(myApps[i]);
                        ++i;
                    }
                    ok = false;
                    i = 0;
                    while (i < myApps.length) {
                        app = myApps[i];
                        appConfig = configurationHandler.openConfiguration(this.deployCommunicator.getAppConfigPath(app) + '/' + "JDBCConnector", 1);
                        fileNames = appConfig.getAllFileEntryNames();
                        j = 0;
                        while (j < fileNames.length) {
                            fileStream = appConfig.getFile(fileNames[j]);
                            baos = new ByteArrayOutputStream();
                            data = new byte[1024];
                            count = -1;
                            while ((count = fileStream.read(data)) != -1) {
                                baos.write(data, 0, count);
                            }
                            baos.close();
                            fileStream.close();
                            data = baos.toByteArray();
                            secureConfig = appConfig.createSubConfiguration("Secure", 1);
                            propertySheet = secureConfig.getPropertySheetInterface();
                            propertySheet.createSecurePropertyEntry(fileNames[j], new String(data), fileNames[j]);
                            appConfig.deleteFile(fileNames[j]);
                            ++j;
                        }
                        ++i;
                    }
                    ok = true;
                    var17_16 = null;
                    try {
                        if (ok) {
                            configurationHandler.commit();
                        } else {
                            configurationHandler.rollback();
                        }
                    }
                    catch (ConfigurationException cex) {
                        if (ContainerImpl.location.beLogged(300)) {
                            ContainerImpl.location.logT(300, "ContainerImpl.secureAppData(): " + cex.toString());
                        }
                        if (!ContainerImpl.location.beLogged(100)) break block22;
                        ContainerImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)cex);
                    }
                }
                try {
                    configurationHandler.closeAllConfigurations();
                }
                catch (ConfigurationException cex) {
                    if (ContainerImpl.location.beLogged(300)) {
                        ContainerImpl.location.logT(300, "ContainerImpl.secureAppData(): " + cex.toString());
                    }
                    if (!ContainerImpl.location.beLogged(100)) break block23;
                    ContainerImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)cex);
                }
            }
            i = 0;
            while (i < myApps.length) {
                this.deployCommunicator.modificationDone(myApps[i]);
                ++i;
            }
            break block26;
            catch (Throwable var16_22) {
                block25: {
                    block24: {
                        var17_17 = null;
                        try {
                            if (ok) {
                                configurationHandler.commit();
                            } else {
                                configurationHandler.rollback();
                            }
                        }
                        catch (ConfigurationException cex) {
                            if (ContainerImpl.location.beLogged(300)) {
                                ContainerImpl.location.logT(300, "ContainerImpl.secureAppData(): " + cex.toString());
                            }
                            if (!ContainerImpl.location.beLogged(100)) break block24;
                            ContainerImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)cex);
                        }
                    }
                    try {
                        configurationHandler.closeAllConfigurations();
                    }
                    catch (ConfigurationException cex) {
                        if (ContainerImpl.location.beLogged(300)) {
                            ContainerImpl.location.logT(300, "ContainerImpl.secureAppData(): " + cex.toString());
                        }
                        if (!ContainerImpl.location.beLogged(100)) break block25;
                        ContainerImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)cex);
                    }
                }
                i = 0;
                ** while (i < myApps.length)
            }
lbl-1000:
            // 1 sources

            {
                this.deployCommunicator.modificationDone(myApps[i]);
                ++i;
                continue;
            }
lbl101:
            // 1 sources

            throw var16_22;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitAndReadAppData(ConfigurationHandler configurationHandler, String[] myApps) throws IOException, ConfigurationException {
        block20: {
            var3_3 = this.monitor;
            synchronized (var3_3) {
                while (true) {
                    if (this.writeLockReleased) {
                        // MONITOREXIT @DISABLED, blocks:[18, 4, 9] lbl5 : MonitorExitStatement: MONITOREXIT : var3_3
                        ** try [egrp 2[TRYBLOCK] [2 : 66->250)] { 
lbl7:
                        // 1 sources

                        break;
                    }
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException iex) {
                        if (!ContainerImpl.location.beLogged(100)) continue;
                        ContainerImpl.location.traceThrowableT(100, "ContainerImpl.waitAndReadAppData(): InterruptedException occured while waiting internal securing procedures: ", (Throwable)iex);
                    }
                }
            }
            {
                i = 0;
                block10: while (true) {
                    if (i >= myApps.length) {
                        var12_12 = null;
                        break block20;
                    }
                    app = myApps[i];
                    appConfig = configurationHandler.openConfiguration(this.deployCommunicator.getAppConfigPath(app) + '/' + "JDBCConnector", 0);
                    dbFiles = this.getAllSecureFilenames(appConfig);
                    j = 0;
                    while (true) {
                        if (j >= dbFiles.length) {
                            ++i;
                            continue block10;
                        }
                        doc = XMLUtils.isDataSourceXML(this.getSecureFile(appConfig, dbFiles[j]));
                        if (doc != null) {
                            descrVtr = XMLUtils.processXML(doc);
                            this.appsDescr.put(app, descrVtr);
                        } else if (XMLUtils.isAliasesXML(this.getSecureFile(appConfig, dbFiles[j]))) {
                            extAliases = XMLUtils.processAliasesXML(this.getSecureFile(appConfig, dbFiles[j]));
                            this.dsAliases.put(app, extAliases);
                        }
                        ++j;
                    }
                    break;
                }
            }
lbl42:
            // 1 sources

            catch (Throwable var11_16) {
                var12_13 = null;
                try {
                    configurationHandler.closeAllConfigurations();
                    throw var11_16;
                }
                catch (ConfigurationException cex) {
                    if (ContainerImpl.location.beLogged(300)) {
                        ContainerImpl.location.logT(300, "ContainerImpl.waitAndReadAppData(): Cannot close configurations. Reason: " + cex.toString());
                    }
                    if (ContainerImpl.location.beLogged(100) == false) throw var11_16;
                    ContainerImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)cex);
                }
                throw var11_16;
            }
        }
        try {}
        catch (ConfigurationException cex) {
            if (ContainerImpl.location.beLogged(300)) {
                ContainerImpl.location.logT(300, "ContainerImpl.waitAndReadAppData(): Cannot close configurations. Reason: " + cex.toString());
            }
            if (ContainerImpl.location.beLogged(100) == false) return;
            ContainerImpl.location.traceThrowableT(100, "Full stacktrace:", (Throwable)cex);
            return;
        }
        configurationHandler.closeAllConfigurations();
    }

    public void configurationChanged(ChangeEvent ce) {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.writeLockReleased) {
                this.writeLockReleased = true;
                this.monitor.notify();
            }
        }
    }

    private void notifyManagementListener(String appName, String message) {
        Vector descrVtr;
        if (this.managementListener != null && (descrVtr = (Vector)this.appsDescr.get(appName)) != null) {
            Enumeration vecEnum = descrVtr.elements();
            while (vecEnum.hasMoreElements()) {
                JDBCDescriptor descr = (JDBCDescriptor)vecEnum.nextElement();
                this.managementListener.notify(descr.getDataSourceName(), message);
            }
        }
    }

    public void storeSecureFile(Configuration config, String name, File deployFile) throws ConfigurationException, IOException {
        byte[] data = new byte[(int)deployFile.length()];
        RandomAccessFile file = new RandomAccessFile(deployFile, "r");
        file.readFully(data);
        file.close();
        Configuration secureConfig = null;
        secureConfig = !config.existsSubConfiguration(SECURE_SUB_CONFIGURATION) ? config.createSubConfiguration(SECURE_SUB_CONFIGURATION, 1) : config.getSubConfiguration(SECURE_SUB_CONFIGURATION);
        PropertySheet propertySheet = secureConfig.getPropertySheetInterface();
        try {
            PropertyEntry entry = propertySheet.getPropertyEntry(name);
            entry.setDefault(new String(data));
        }
        catch (NameNotFoundException nnfe) {
            propertySheet.createSecurePropertyEntry(name, new String(data), name);
        }
    }

    public void deleteSecureFile(Configuration config, String name) throws ConfigurationException {
        config = config.getSubConfiguration(SECURE_SUB_CONFIGURATION);
        PropertySheet propertySheet = config.getPropertySheetInterface();
        propertySheet.deletePropertyEntry(name);
    }

    public InputStream getSecureFile(Configuration config, String name) throws ConfigurationException {
        config = config.getSubConfiguration(SECURE_SUB_CONFIGURATION);
        PropertySheet propertySheet = config.getPropertySheetInterface();
        PropertyEntry entry = propertySheet.getPropertyEntry(name);
        String data = (String)entry.getValue();
        return new ByteArrayInputStream(data.getBytes());
    }

    public String[] getAllSecureFilenames(Configuration config) throws ConfigurationException {
        config = config.getSubConfiguration(SECURE_SUB_CONFIGURATION);
        PropertySheet propertySheet = config.getPropertySheetInterface();
        Properties props = propertySheet.getProperties();
        return ((Hashtable)props).keySet().toArray(new String[0]);
    }

    private void storeJDBCConnectorFile(Configuration config, File file) throws DeploymentException {
        try {
            this.storeSecureFile(config, file.getName(), file);
        }
        catch (ConfigurationException cex) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.storeJDBCConnectorFile(): Cannot update DB. Reason: " + ((Throwable)((Object)cex)).toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)((Object)cex));
            }
            throw new BaseDeploymentException("dbpool_0003", new Object[]{file, "file system", "DB"}, (Throwable)((Object)cex));
        }
        catch (IOException ioex) {
            if (location.beLogged(500)) {
                location.logT(500, "ContainerImpl.storeJDBCConnectorFile(): Cannot update DB. Reason: " + ioex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)ioex);
            }
            throw new BaseDeploymentException("dbpool_0003", new Object[]{file, "file system", "DB"}, (Throwable)ioex);
        }
    }

    public void applicationStatusChanged(String applicationName, byte status) {
    }

    public String[] getResourcesForTempLoader(String applicationName) throws DeploymentException {
        return null;
    }

    public boolean acceptedAppInfoChange(String appName, AdditionalAppInfo addAppInfo) throws DeploymentException {
        return false;
    }

    public boolean needStopOnAppInfoChanged(String appName, AdditionalAppInfo addAppInfo) {
        return false;
    }

    public void makeAppInfoChange(String appName, AdditionalAppInfo addAppInfo, Configuration configuration) throws WarningException, DeploymentException {
    }

    public void appInfoChangedCommit(String appName) throws WarningException {
    }

    public void appInfoChangedRollback(String appName) throws WarningException {
    }

    public void notifyAppInfoChanged(String appName) throws WarningException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

