/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;

public class UndeployJDBCDriver
implements Command {
    private DataSourceManager jdbcManager = null;

    public UndeployJDBCDriver(DataSourceManager _jdbcManager) {
        this.jdbcManager = _jdbcManager;
    }

    public String getName() {
        return "undeploy_jdbc_driver";
    }

    public String getGroup() {
        return "dbpool";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 1 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        try {
            this.jdbcManager.undeployJdbcDriver(params[0]);
            out.println(" Driver undeployed successfully.\n");
        }
        catch (RemoteException exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "Cannot undeploy driver. Reason: ", (Throwable)exc);
            out.println(" Cannot undeploy driver. Reason: " + exc.toString());
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nRemoves completely a JDBC driver from J2EE Engine.\n\nUsage: UNDEPLOY_JDBC_DRIVER <driverName>\nParameters:\n\t<driverName> - the name of the JDBC driver to be removed\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

