/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;

public class TestDS
implements Command {
    private DataSourceManager manager;

    public TestDS(DataSourceManager _manager) {
        this.manager = _manager;
    }

    public String getName() {
        return "test_ds";
    }

    public String getGroup() {
        return "dbpool";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length < 2 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        String sql = "";
        int i = 1;
        while (i < params.length) {
            sql = sql + " " + params[i];
            ++i;
        }
        try {
            out.println(this.manager.testDS(params[0], sql));
        }
        catch (RemoteException exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "Unexpected exception: ", (Throwable)exc);
            out.println(exc.toString());
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nTests if the specified DataSource functions properly.\n\nUsage: TEST_DS <dataSourceName> <sqlStatement>\nParameters:\n\t<dataSourceName> - the name of the DataSource to be tested\n\t<sqlStatement>   - an SQL statement to be executed using the DataSource\n\nExamples: TEST_DS myDS SELECT * from TEST\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

