/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.util.ArrayLong;
import com.sap.engine.lib.util.HashMapLongObject;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;

public class ListConnections
implements Command {
    private DataSourceManager manager;

    public ListConnections(DataSourceManager _manager) {
        this.manager = _manager;
    }

    public String getName() {
        return "list_conn";
    }

    public String getGroup() {
        return "dbpool";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 1 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        try {
            int i;
            ArrayLong freeMCIDs = this.manager.listFreeConnections(params[0]);
            HashMapLongObject usedMCIDs = this.manager.listUsedConnections(params[0]);
            out.println("\r\n---------------- used connections ----------------");
            if (usedMCIDs.isEmpty()) {
                out.println(" none");
            } else {
                long[] keys = usedMCIDs.getAllKeys();
                i = 0;
                while (i < keys.length) {
                    out.println(" ManagedConnection ID = " + keys[i]);
                    long[] handleIDs = ((ArrayLong)usedMCIDs.get(keys[i])).toArray();
                    int j = 0;
                    while (j < handleIDs.length) {
                        out.println("   ConnectionHandle ID = " + handleIDs[j]);
                        ++j;
                    }
                    ++i;
                }
            }
            out.println("\n---------------- free connections ----------------");
            if (freeMCIDs.isEmpty()) {
                out.println(" none");
            } else {
                long[] idArray = freeMCIDs.toArray();
                i = 0;
                while (i < idArray.length) {
                    out.println(" ManagedConnection ID = " + idArray[i]);
                    ++i;
                }
            }
        }
        catch (RemoteException exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "There is no such DataSource currently deployed. ", (Throwable)exc);
            out.println(" There is no such DataSource currently deployed.");
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nReturns a list of the IDs of both free and used physical connections created using the specified DataSource, and the IDs of the corresponding ConnectionHandle objects.\n\nUsage: LIST_CONN <dataSourceName>\nParameters:\n\t<dataSourceName> - the name of the DataSource for which the list of IDs is displayed\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

