/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;

public class GetUsedConnectionsCount
implements Command {
    private DataSourceManager manager;

    public GetUsedConnectionsCount(DataSourceManager _manager) {
        this.manager = _manager;
    }

    public String getName() {
        return "get_used_conn";
    }

    public String getGroup() {
        return "dbpool";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 1 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        try {
            out.println(" Used connections count = " + this.manager.listUsedConnections(params[0]).size());
        }
        catch (RemoteException exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "There is no such DataSource currently deployed. ", (Throwable)exc);
            out.println(" There is no such DataSource currently deployed.");
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nReturns the number of used physical connections created using the specified DataSource.\n\nUsage: GET_USED_CONN <dataSourceName>\nParameters:\n\t<dataSourceName> - the name of the DataSource for which the number of used connections is displayed\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

