/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import com.sap.engine.services.dbpool.deploy.StatementEntry;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;

public class GetInitStatements
implements Command {
    private DataSourceManager jdbcManager;

    public GetInitStatements(DataSourceManager _jdbcManager) {
        this.jdbcManager = _jdbcManager;
    }

    public String getName() {
        return "get_init_statements";
    }

    public String getGroup() {
        return "dbpool";
    }

    /*
     * Unable to fully structure code
     */
    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        block6: {
            out = new PrintStream(os);
            if (params.length != 1 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
                out.println(this.getHelpMessage());
                return;
            }
            try {
                block7: {
                    ht = this.jdbcManager.getInitStatements();
                    if (!params[0].equals("-all")) break block7;
                    enum = ht.keys();
                    if (enum.hasMoreElements()) ** GOTO lbl14
                    out.println(" There are no any initializing statements specified.\n");
                    return;
lbl-1000:
                    // 1 sources

                    {
                        dsName = (String)enum.nextElement();
                        out.print(this.getStatements(dsName, (StatementEntry[])ht.get(dsName)));
lbl14:
                        // 2 sources

                        ** while (enum.hasMoreElements())
                    }
lbl15:
                    // 1 sources

                    break block6;
                }
                dsName = params[0];
                statements = (StatementEntry[])ht.get(dsName);
                if (statements != null) {
                    out.print(this.getStatements(dsName, statements));
                } else {
                    out.println(" There are no init statements for this DataSource.\n");
                }
            }
            catch (RemoteException exc) {
                DBPoolResourceAccessor.location.traceThrowableT(100, "Cannot get initializing statements for this DataSource. Reason: ", (Throwable)exc);
                out.println(" Cannot get initializing statements for this DataSource. Reason: " + exc.toString());
                exc.printStackTrace(out);
                return;
            }
        }
    }

    public String getHelpMessage() {
        return "\nReturns the SQL statements for database initialization either for a particular DataSource or for all DataSource objects.\n\nUsage: GET_INIT_STATEMENTS <parameters>\nParameters:\n\t<dataSourceName> - the name of a DataSource; the SQL statements for this DataSource are displayed only\n\t-all             - the SQL statements for all existing DataSource objects are displayed\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    private String getStatements(String dsName, StatementEntry[] statements) {
        StringBuffer sb = new StringBuffer();
        sb.append("-----------------------------------------\n");
        sb.append(" Data source:\n");
        sb.append("   " + dsName + "\n");
        sb.append(" Statement entries:\n");
        int i = 0;
        while (i < statements.length) {
            sb.append("   ignore-error = ");
            sb.append(statements[i].getIgnoreError());
            if (statements[i].getIgnoreError()) {
                sb.append("  :  ");
            } else {
                sb.append(" :  ");
            }
            sb.append(statements[i].getStatement());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }
}

