/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class DeployJDBCDriver
implements Command {
    private DataSourceManager jdbcManager;

    public DeployJDBCDriver(DataSourceManager _jdbcManager) {
        this.jdbcManager = _jdbcManager;
    }

    public String getName() {
        return "deploy_jdbc_driver";
    }

    public String getGroup() {
        return "dbpool";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 2 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        SerializableFile[] files = null;
        StringTokenizer parser = new StringTokenizer(params[1], ";");
        Vector<SerializableFile> vtr = new Vector<SerializableFile>();
        while (parser.hasMoreTokens()) {
            File file = new File(parser.nextToken().trim());
            if (!file.exists()) {
                out.println("File not found.\r\n");
                return;
            }
            if (file.isDirectory()) {
                out.println(file.getName() + " is not a file, but directory.\n");
                return;
            }
            SerializableFile sfile = new SerializableFile(file);
            vtr.add(sfile);
        }
        files = vtr.toArray(new SerializableFile[0]);
        try {
            this.jdbcManager.deployJdbcDriver(params[0], files);
            out.println(" Driver deployed successfully.\n");
        }
        catch (Exception exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "Cannot deploy driver. Reason: ", (Throwable)exc);
            out.println(" Cannot deploy driver. Reason: " + exc.toString());
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nDeploys a JDBC driver on J2EE Engine.\n\nUsage: DEPLOY_JDBC_DRIVER <driverName> <fileNames>\nParameters:\n\t<driverName> - an arbitrary name for the JDBC driver\n\t<fileNames>  - the path(s) to the archive file(s) that contains the classes of the JDBC driver.\n\t               If there is more than 1 path, others should be separated by semicolon\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

