/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.command;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.dbpool.DBPoolResourceAccessor;
import com.sap.engine.services.dbpool.deploy.DataSourceManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;

public class DBInit
implements Command {
    private DataSourceManager jdbcManager;
    private SerializableFile xmlFile;

    public DBInit(DataSourceManager _jdbcManager) {
        this.jdbcManager = _jdbcManager;
    }

    public String getName() {
        return "db_init";
    }

    public String getGroup() {
        return "dbpool";
    }

    public void exec(Environment env, InputStream is, OutputStream os, String[] params) {
        PrintStream out = new PrintStream(os);
        if (params.length != 1 || params[0].equals("-?") || params[0].equalsIgnoreCase("-h") || params[0].equalsIgnoreCase("-help")) {
            out.println(this.getHelpMessage());
            return;
        }
        if (!params[0].endsWith(".xml")) {
            out.println("\nIncorrect file parameter.\n");
            return;
        }
        this.xmlFile = new SerializableFile(params[0]);
        if (!this.xmlFile.getAsFile().exists()) {
            out.println("\nFile not found.\n");
            return;
        }
        try {
            out.println(this.jdbcManager.dbInit(this.xmlFile));
        }
        catch (RemoteException exc) {
            DBPoolResourceAccessor.location.traceThrowableT(100, "Cannot initialize DB. Reason: ", (Throwable)exc);
            out.println(" Cannot initialize DB. Reason: " + exc.toString());
            exc.printStackTrace(out);
            return;
        }
    }

    public String getHelpMessage() {
        return "\nExecutes SQL statements using a DataSource to initialize a database.\n\nUsage: DB_INIT <fileName>\nParameters:\n\t<fileName> - the path to the XML file that contains the SQL statements for database initialization\n";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }
}

