/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.cci;

import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.exceptions.BaseResourceException;
import com.sap.engine.services.dbpool.exceptions.BaseSQLException;
import com.sap.engine.services.dbpool.spi.LocalTXManagedConnectionImpl;
import com.sap.engine.services.dbpool.wrappers.CallableStatementWrapper;
import com.sap.engine.services.dbpool.wrappers.PreparedStatementWrapper;
import com.sap.engine.services.dbpool.wrappers.StatementWrapper;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LazyAssociatableConnectionManager;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectionHandle
implements Connection {
    private static final Category category = Category.SYS_SERVER;
    private static final Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$cci$ConnectionHandle == null ? (class$com$sap$engine$services$dbpool$cci$ConnectionHandle = ConnectionHandle.class$("com.sap.engine.services.dbpool.cci.ConnectionHandle")) : class$com$sap$engine$services$dbpool$cci$ConnectionHandle));
    private static final int logDebug = 100;
    private LocalTXManagedConnectionImpl mc;
    protected Connection con;
    private long hid;
    boolean dissociated;
    boolean autoCommitMode;
    boolean isClosed;
    private int localIsolationLevel = -1;
    private ManagedConnectionFactory mcf;
    private ConnectionManager cxManager;
    private ConnectionRequestInfo cri;
    private String dsName;
    protected Vector stmtWrappers = new Vector();
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$cci$ConnectionHandle;

    public ConnectionHandle(LocalTXManagedConnectionImpl mc, long handleID) throws ResourceException {
        this.mc = mc;
        this.hid = handleID;
        this.con = mc.getPhysicalConnection();
        this.mcf = mc.getManagedConnectionFactory();
        this.cri = mc.getConnectionRequestInfo();
        this.autoCommitMode = true;
        this.dissociated = false;
        this.isClosed = false;
        this.dsName = PoolFrame.getDSName(this.mcf);
    }

    public Statement createStatement() throws SQLException {
        this.checkIfValid();
        StatementWrapper stmtWrapper = new StatementWrapper(this.con.createStatement());
        stmtWrapper.setConnectionHandle(this);
        this.stmtWrappers.add(stmtWrapper);
        return stmtWrapper;
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkIfValid();
        StatementWrapper stmtWrapper = new StatementWrapper(this.con.createStatement(resultSetType, resultSetConcurrency));
        stmtWrapper.setConnectionHandle(this);
        stmtWrapper.setCreateParameters(resultSetType, resultSetConcurrency);
        this.stmtWrappers.add(stmtWrapper);
        return stmtWrapper;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkIfValid();
        PreparedStatementWrapper pstmtWrapper = new PreparedStatementWrapper(this.con.prepareStatement(sql));
        pstmtWrapper.setConnectionHandle(this);
        pstmtWrapper.setCreateParameters(sql);
        this.stmtWrappers.add(pstmtWrapper);
        return pstmtWrapper;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkIfValid();
        PreparedStatementWrapper pstmtWrapper = new PreparedStatementWrapper(this.con.prepareStatement(sql, resultSetType, resultSetConcurrency));
        pstmtWrapper.setConnectionHandle(this);
        pstmtWrapper.setCreateParameters(sql, resultSetType, resultSetConcurrency);
        this.stmtWrappers.add(pstmtWrapper);
        return pstmtWrapper;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkIfValid();
        CallableStatementWrapper cstmtWrapper = new CallableStatementWrapper(this.con.prepareCall(sql));
        cstmtWrapper.setConnectionHandle(this);
        cstmtWrapper.setCreateParameters(sql);
        this.stmtWrappers.add(cstmtWrapper);
        return cstmtWrapper;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkIfValid();
        CallableStatementWrapper cstmtWrapper = new CallableStatementWrapper(this.con.prepareCall(sql, resultSetType, resultSetConcurrency));
        cstmtWrapper.setConnectionHandle(this);
        cstmtWrapper.setCreateParameters(sql, resultSetType, resultSetConcurrency);
        this.stmtWrappers.add(cstmtWrapper);
        return cstmtWrapper;
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkIfValid();
        return this.con.nativeSQL(sql);
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ConnectionHandle.setAutoCommit(" + autoCommit + "): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
        this.checkIfClosed();
        if (this.dissociated) {
            if (location.beLogged(100)) {
                location.logT(100, "ConnectionHandle.setAutoCommit(" + autoCommit + "): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this + " is currently dissociated.");
            }
            this.autoCommitMode = autoCommit;
            return;
        }
        this.checkIfInvalid();
        if (this.mc.getGotLocalTX() || this.mc.getGotXAResource()) {
            BaseSQLException bsex = new BaseSQLException("dbpool_0301", (Object)this.dsName);
            bsex.setSQLState("0A001");
            bsex.log();
            throw bsex;
        }
        boolean oldAutoCommit = this.con.getAutoCommit();
        try {
            if (oldAutoCommit && !autoCommit) {
                if (this.mc.getCciLocalTXStarted()) {
                    BaseSQLException bsex = new BaseSQLException("dbpool_0313", (Object)this.dsName);
                    bsex.setSQLState("25000");
                    bsex.log();
                    throw bsex;
                }
                this.mc.clientBegin(this);
                this.autoCommitMode = false;
            } else if (!oldAutoCommit && autoCommit) {
                this.mc.clientCommit(this);
                this.autoCommitMode = true;
            }
        }
        catch (ResourceException rex) {
            if (location.beLogged(500)) {
                location.logT(500, "ConnectionHandle.setAutoCommit(): DataSource name = '" + this.dsName + "'. Error occured: " + rex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
            }
            throw new BaseSQLException("dbpool_0300", new Object[]{"ResourceException", "ConnectionHandle.setAutoCommit()", rex.toString()}, (Throwable)rex);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ConnectionHandle.setAutoCommit(" + autoCommit + "): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkIfClosed();
        if (this.dissociated) {
            return this.autoCommitMode;
        }
        this.checkIfInvalid();
        return this.con.getAutoCommit();
    }

    public void commit() throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ConnectionHandle.commit(): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
        this.checkIfClosed();
        if (this.dissociated) {
            if (location.beLogged(100)) {
                location.logT(100, "ConnectionHandle.commit(): commit() invoked on dissociated connection handle which is not used after previous commit(), rollback() or getConnection(). If there are no cached Statements this is not a problem.");
            }
            return;
        }
        this.checkIfInvalid();
        if (this.mc.getGotLocalTX() || this.mc.getGotXAResource()) {
            BaseSQLException bsex = new BaseSQLException("dbpool_0305", (Object)this.dsName);
            bsex.setSQLState("2D000");
            bsex.log();
            throw bsex;
        }
        try {
            this.mc.clientCommit(this);
        }
        catch (ResourceException rex) {
            if (location.beLogged(500)) {
                location.logT(500, "ConnectionHandle.commit(): DataSource name: '" + this.dsName + "'. Error occured: " + rex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
            }
            throw new BaseSQLException("dbpool_0300", new Object[]{"ResourceException", "ConnectionHandle.commit()", rex.toString()}, (Throwable)rex);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ConnectionHandle.commit(): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
    }

    public void rollback() throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ConnectionHandle.rollback(): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
        this.checkIfClosed();
        if (this.dissociated) {
            if (location.beLogged(100)) {
                location.logT(100, "ConnectionHandle.rollback(): rollback() invoked on dissociated connection handle which is not used after previous commit(), rollback() or getConnection(). If there are no cached Statements this is not a problem.");
            }
            return;
        }
        this.checkIfInvalid();
        if (this.mc.getGotLocalTX() || this.mc.getGotXAResource()) {
            BaseSQLException bsex = new BaseSQLException("dbpool_0308", (Object)this.dsName);
            bsex.setSQLState("2D000");
            bsex.log();
            throw bsex;
        }
        try {
            this.mc.clientRollback(this);
        }
        catch (ResourceException rex) {
            if (location.beLogged(500)) {
                location.logT(500, "ConnectionHandle.rollback(): DataSource name: '" + this.dsName + "'. Error occured: " + rex.toString());
            }
            if (location.beLogged(100)) {
                location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
            }
            throw new BaseSQLException("dbpool_0300", new Object[]{"ResourceException", "ConnectionHandle.rollback()", rex.toString()}, (Throwable)rex);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ConnectionHandle.rollback(): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
    }

    public void close() throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ConnectionHandle.close(): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
        if (this.isClosed) {
            return;
        }
        if (!this.dissociated) {
            block11: {
                block10: {
                    try {
                        this.closeStatements();
                    }
                    catch (SQLException sex) {
                        if (location.beLogged(300)) {
                            location.logT(300, "ConnectionHandle.close(): SQLException occured while closing statements: " + sex.toString());
                        }
                        if (!location.beLogged(100)) break block10;
                        location.traceThrowableT(100, "Full stacktrace:", (Throwable)sex);
                    }
                }
                try {
                    this.checkIfInvalid();
                    this.mc.removeConnectionHandle(this);
                }
                catch (SQLException sex) {
                    if (location.beLogged(300)) {
                        location.logT(300, "ConnectionHandle.close(): SQLException occured while closing handle: " + sex.toString());
                    }
                    if (!location.beLogged(100)) break block11;
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)sex);
                }
            }
            this.invalidate();
        }
        this.stmtWrappers.clear();
        this.isClosed = true;
        if (location.beLogged(100)) {
            location.logT(100, "<-- ConnectionHandle.close(): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfValid();
        return this.con.getMetaData();
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkIfValid();
        this.con.setReadOnly(readOnly);
    }

    public boolean isReadOnly() throws SQLException {
        this.checkIfValid();
        return this.con.isReadOnly();
    }

    public void setCatalog(String catalog) throws SQLException {
        this.checkIfValid();
        this.con.setCatalog(catalog);
    }

    public String getCatalog() throws SQLException {
        this.checkIfValid();
        return this.con.getCatalog();
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ConnectionHandle.setTransactionIsolation(" + level + "): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
        this.checkIfValid();
        if (this.mc.getIsolationLevel() == -1) {
            this.mc.setIsolationLevel(this.con.getTransactionIsolation());
        }
        this.localIsolationLevel = level;
        if (this.mc.getConnectionSet().size() > 1) {
            BaseSQLException bsex = new BaseSQLException("dbpool_0315", (Object)this.dsName);
            bsex.log();
            throw bsex;
        }
        this.con.setTransactionIsolation(level);
        if (location.beLogged(100)) {
            location.logT(100, "<-- ConnectionHandle.setTransactionIsolation(): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkIfClosed();
        if (this.dissociated) {
            return this.localIsolationLevel;
        }
        this.checkIfInvalid();
        return this.con.getTransactionIsolation();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkIfValid();
        return this.con.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.checkIfValid();
        this.con.clearWarnings();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkIfValid();
        this.con.setTypeMap(map);
    }

    public Map getTypeMap() throws SQLException {
        this.checkIfValid();
        return this.con.getTypeMap();
    }

    public void associateConnection(LocalTXManagedConnectionImpl newMc) throws SQLException, ResourceException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ConnectionHandle.associateConnection(" + newMc + "): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
        if (!this.dissociated) {
            if (location.beLogged(100)) {
                location.logT(100, "--> ConnectionHandle.associateConnection(" + newMc + "): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this + ". This handle was not dissociated.");
            }
            this.checkIfInvalid();
            this.dissociateStatements();
            this.mc.removeConnectionHandle(this);
        }
        this.mc = newMc;
        this.con = this.mc.getPhysicalConnection();
        this.hid = this.mc.getAndIncHID();
        boolean newMcAutoCommit = this.con.getAutoCommit();
        boolean toSetIsolationLevel = false;
        if (this.localIsolationLevel != -1 && this.localIsolationLevel != this.con.getTransactionIsolation()) {
            toSetIsolationLevel = true;
        }
        if (this.autoCommitMode) {
            if (this.mc.getConnectionSet().isEmpty()) {
                newMc.addConnectionHandle(this);
                if (toSetIsolationLevel) {
                    this.con.setTransactionIsolation(this.localIsolationLevel);
                }
            } else {
                if (newMcAutoCommit) {
                    location.logT(500, "ConnectionHandle.associateConnection(): DataSource name = '" + this.dsName + "'. Internal Error: There is already a handle associated to this ManagedConnection. Connection sharing should not be possible outside the global transaction.");
                    throw new BaseResourceException("dbpool_0212", this.dsName);
                }
                if (this.mc.getCciLocalTXStarted()) {
                    location.logT(500, "ConnectionHandle.associateConnection(): DataSource name = '" + this.dsName + "'. Internal Error: There is already a handle associated to this ManagedConnection. Connection sharing should not be possible outside the global transaction.");
                    throw new BaseResourceException("dbpool_0212", this.dsName);
                }
                newMc.addConnectionHandle(this);
            }
        } else if (this.mc.getConnectionSet().isEmpty()) {
            newMc.addConnectionHandle(this);
            if (toSetIsolationLevel) {
                this.con.setTransactionIsolation(this.localIsolationLevel);
            }
            if (newMcAutoCommit) {
                this.mc.clientBegin(this);
            }
        } else {
            if (newMcAutoCommit) {
                location.logT(500, "ConnectionHandle.associateConnection(): DataSource name = '" + this.dsName + "'. Internal Error: There is already a handle associated to this ManagedConnection. Connection sharing should not be possible outside the global transaction.");
                throw new BaseResourceException("dbpool_0212", this.dsName);
            }
            if (this.mc.getCciLocalTXStarted()) {
                location.logT(500, "ConnectionHandle.associateConnection(): DataSource name = '" + this.dsName + "'. Internal Error: There is already a handle associated to this ManagedConnection. Connection sharing should not be possible outside the global transaction.");
                throw new BaseResourceException("dbpool_0212", this.dsName);
            }
            if (toSetIsolationLevel) {
                location.logT(500, "ConnectionHandle.associateConnection(): DataSource name = '" + this.dsName + "'. Cannot associate a handle with different isolationLevel to a ManagedConnection participating in a global transaction.");
                throw new BaseResourceException("dbpool_0213", this.dsName);
            }
            newMc.addConnectionHandle(this);
        }
        if (location.beLogged(100)) {
            location.logT(100, "<-- ConnectionHandle.associateConnection(" + newMc + "): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
    }

    public void dissociateConnection() throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ConnectionHandle.dissociateConnection(): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
        this.dissociated = true;
        this.dissociateStatements();
        this.invalidate();
        if (location.beLogged(100)) {
            location.logT(100, "<-- ConnectionHandle.associateConnection(): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
    }

    public void checkIfValid() throws SQLException {
        this.checkIfClosed();
        if (this.dissociated && this.cxManager instanceof LazyAssociatableConnectionManager) {
            try {
                ((LazyAssociatableConnectionManager)this.cxManager).associateConnection((Object)this, this.mcf, this.cri);
                this.dissociated = false;
            }
            catch (ResourceException rex) {
                if (category.beLogged(500)) {
                    category.logT(500, location, "ConnectionHandle.checkIfValid(): This connection is no longer valid due to: " + rex.toString());
                }
                if (location.beLogged(500)) {
                    location.logT(500, "ConnectionHandle.checkIfValid(): DataSource name = '" + this.dsName + "'. ResourceException occured during re-association of the ConnectionHandle: " + rex.toString());
                }
                if (location.beLogged(100)) {
                    location.traceThrowableT(100, "Full stacktrace:", (Throwable)rex);
                }
                BaseSQLException bsex = new BaseSQLException("dbpool_0312", new Object[]{this.dsName, rex.toString()}, (Throwable)rex);
                bsex.setSQLState("HZ421");
                throw bsex;
            }
        }
        this.checkIfInvalid();
    }

    public void checkIfClosed() throws SQLException {
        if (this.isClosed) {
            BaseSQLException bsex = new BaseSQLException("dbpool_0314");
            bsex.setSQLState("08006");
            bsex.log();
            throw bsex;
        }
    }

    public void checkIfInvalid() throws SQLException {
        if (this.con == null || this.mc == null) {
            BaseSQLException bsex = new BaseSQLException("dbpool_0311");
            bsex.setSQLState("08006");
            bsex.log();
            throw bsex;
        }
    }

    public void invalidate() {
        if (location.beLogged(100)) {
            location.logT(100, "--> ConnectionHandle.invalidate(): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this + ". Full stacktrace: " + PoolFrame.getMessageAndStackTrace(new Exception()));
        }
        this.mc = null;
        this.con = null;
        if (location.beLogged(100)) {
            location.logT(100, "<-- ConnectionHandle.invalidate(): DataSource name = '" + this.dsName + "'. ConnectionHandle object: " + this);
        }
    }

    private void closeStatements() throws SQLException {
        Enumeration enumeration = this.stmtWrappers.elements();
        while (enumeration.hasMoreElements()) {
            ((StatementWrapper)enumeration.nextElement()).internalClose();
        }
    }

    private void dissociateStatements() throws SQLException {
        Enumeration enumeration = this.stmtWrappers.elements();
        while (enumeration.hasMoreElements()) {
            ((StatementWrapper)enumeration.nextElement()).dissociateStatement();
        }
    }

    public void removeStatement(StatementWrapper stmtWrapper) {
        this.stmtWrappers.remove(stmtWrapper);
    }

    public ManagedConnection getManagedConnection() {
        return this.mc;
    }

    public Connection getPhysicalConnection() {
        return this.con;
    }

    public long getHandleID() {
        return this.hid;
    }

    public void setConnectionManager(ConnectionManager _cxManager) {
        this.cxManager = _cxManager;
    }

    public ConnectionRequestInfo getCri() {
        return this.cri;
    }

    public ManagedConnectionFactory getMcf() {
        return this.mcf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

