/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.dbpool.cci;

import com.sap.engine.services.dbpool.PoolFrame;
import com.sap.engine.services.dbpool.cci.ConnectionHandle;
import com.sap.engine.services.dbpool.exceptions.BaseSQLException;
import com.sap.engine.services.dbpool.spi.ConnectionRequestInfoImpl;
import com.sap.engine.services.dbpool.spi.DefaultConnectionManagerImpl;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;

public class ConnectionFactoryImpl
implements DataSource,
Serializable {
    static final long serialVersionUID = -3940448231192391010L;
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$dbpool$cci$ConnectionFactoryImpl == null ? (class$com$sap$engine$services$dbpool$cci$ConnectionFactoryImpl = ConnectionFactoryImpl.class$("com.sap.engine.services.dbpool.cci.ConnectionFactoryImpl")) : class$com$sap$engine$services$dbpool$cci$ConnectionFactoryImpl));
    private static final int logDebug = 100;
    private ManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private int loginTime = 0;
    static /* synthetic */ Class class$com$sap$engine$services$dbpool$cci$ConnectionFactoryImpl;

    public ConnectionFactoryImpl(ManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm == null ? new DefaultConnectionManagerImpl() : cm;
    }

    public Connection getConnection() throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ConnectionFactoryImpl.getConnection(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". ConnectionFactoryImpl object: " + this + ". Full stacktrace: " + PoolFrame.getMessageAndStackTrace(new Exception()));
        }
        try {
            ConnectionHandle handle = (ConnectionHandle)this.cm.allocateConnection(this.mcf, null);
            handle.setConnectionManager(this.cm);
            if (location.beLogged(100)) {
                location.logT(100, "<-- ConnectionFactoryImpl.getConnection(): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". ConnectionFactoryImpl object: " + this);
            }
            return handle;
        }
        catch (ResourceException ex) {
            BaseSQLException bsex = new BaseSQLException("dbpool_0300", new Object[]{"ResourceException", "ConnectionFactoryImpl.getConnection()", ex.toString()}, (Throwable)ex);
            Throwable nestedException = bsex.getCause();
            if (nestedException != null && nestedException instanceof SQLException) {
                bsex.setSQLState(((SQLException)nestedException).getSQLState());
            } else {
                bsex.setSQLState("08003");
            }
            bsex.log();
            throw bsex;
        }
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (location.beLogged(100)) {
            location.logT(100, "--> ConnectionFactoryImpl.getConnection(" + username + ", **********): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". ConnectionFactoryImpl object: " + this + ". Full stacktrace: " + PoolFrame.getMessageAndStackTrace(new Exception()));
        }
        try {
            ConnectionRequestInfoImpl info = new ConnectionRequestInfoImpl(username, password);
            ConnectionHandle handle = (ConnectionHandle)this.cm.allocateConnection(this.mcf, (ConnectionRequestInfo)info);
            handle.setConnectionManager(this.cm);
            if (location.beLogged(100)) {
                location.logT(100, "<-- ConnectionFactoryImpl.getConnection(" + username + ", **********): DataSource name = " + PoolFrame.getDSName(this.mcf) + ". ConnectionFactoryImpl object: " + this);
            }
            return handle;
        }
        catch (ResourceException ex) {
            BaseSQLException bsex = new BaseSQLException("dbpool_0300", new Object[]{"ResourceException", "ConnectionFactoryImpl.getConnection()", ex.toString()}, (Throwable)ex);
            Throwable nestedException = bsex.getCause();
            if (nestedException != null && nestedException instanceof SQLException) {
                bsex.setSQLState(((SQLException)nestedException).getSQLState());
            } else {
                bsex.setSQLState("08003");
            }
            bsex.log();
            throw bsex;
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTime;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTime = seconds;
    }

    public PrintWriter getLogWriter() throws SQLException {
        try {
            return this.mcf.getLogWriter();
        }
        catch (ResourceException ex) {
            BaseSQLException bsex = new BaseSQLException("dbpool_0300", new Object[]{"ResourceException", "ConnectionFactoryImpl.getLogWriter()", ex.toString()}, (Throwable)ex);
            bsex.log();
            throw bsex;
        }
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        try {
            this.mcf.setLogWriter(out);
        }
        catch (ResourceException ex) {
            BaseSQLException bsex = new BaseSQLException("dbpool_0300", new Object[]{"ResourceException", "ConnectionFactoryImpl.setLogWriter()", ex.toString()}, (Throwable)ex);
            bsex.log();
            throw bsex;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

