/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.resource.impl;

import com.sap.engine.interfaces.transaction.LocalTxProvider;
import com.sap.engine.interfaces.transaction.TransactionExtension;
import com.sap.engine.lib.util.base.ConcurrentBaseDoublyLinkedList;
import com.sap.engine.lib.util.base.NextItem;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.connector.exceptions.BaseResourceException;
import com.sap.engine.services.connector.exceptions.BaseSystemException;
import com.sap.engine.services.connector.resource.ResourceSet;
import com.sap.engine.services.connector.resource.impl.HandleWrapper;
import com.sap.engine.services.connector.resource.impl.MCEventHandler;
import com.sap.tc.logging.Location;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class ResourceSetImpl
implements ResourceSet {
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$connector$resource$impl$ResourceSetImpl == null ? (class$com$sap$engine$services$connector$resource$impl$ResourceSetImpl = ResourceSetImpl.class$("com.sap.engine.services.connector.resource.impl.ResourceSetImpl")) : class$com$sap$engine$services$connector$resource$impl$ResourceSetImpl));
    private static int severityDebug = 100;
    private static int severityWarning = 400;
    private ConcurrentBaseDoublyLinkedList handleWrappers = null;
    protected String applicationName = null;
    protected String componentName = null;
    protected String methodName = null;
    protected int isolationLevel = 1;
    protected TransactionExtension transaction = null;
    private static final int SHOW_ALL_CURRENT_STATE = 1;
    private static final int SHOW_TRANSACTION_STATE = 2;
    private static final int SHOW_HANDLE_WRAPPERS = 4;
    private static final int CHANGE_TRANSACTION_STATE = 8;
    private static final int CHANGE_GIVEN_STATE = 16;
    private static final int ADD_WITH_OUT_ENLIST = 32;
    private static final int ADD_AND_ENLIST = 64;
    private static final int ENLIST_ONLY = 128;
    private static final int REMOVE = 256;
    private static final int ERROR_STATE = 512;
    private static final int DEBUG_INFO = 1024;
    private static final int SHOW_USAGE = 2048;
    static /* synthetic */ Class class$com$sap$engine$services$connector$resource$impl$ResourceSetImpl;

    public ResourceSetImpl(String application_name, String component_name) {
        this.applicationName = application_name;
        this.componentName = component_name;
        this.isolationLevel = 1;
        this.handleWrappers = new ConcurrentBaseDoublyLinkedList();
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("<constructor>", null, null, 1));
        }
    }

    public ResourceSetImpl(String application_name, String component_name, int iso_level) {
        this.applicationName = application_name;
        this.componentName = component_name;
        this.isolationLevel = iso_level;
        this.handleWrappers = new ConcurrentBaseDoublyLinkedList();
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("<constructor>", null, null, 1));
        }
    }

    public ResourceSetImpl(Transaction transaction, String application_name, String component_name) throws RollbackException, SystemException {
        this.applicationName = application_name;
        this.componentName = component_name;
        this.isolationLevel = 1;
        this.transaction = (TransactionExtension)transaction;
        this.handleWrappers = new ConcurrentBaseDoublyLinkedList();
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("<constructor>", null, null, 1));
        }
        this.enlistAll(transaction);
    }

    public ResourceSetImpl(Transaction transaction, String application_name, String component_name, int iso_level) throws RollbackException, SystemException {
        this.applicationName = application_name;
        this.componentName = component_name;
        this.isolationLevel = iso_level;
        this.transaction = (TransactionExtension)transaction;
        this.handleWrappers = new ConcurrentBaseDoublyLinkedList();
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("<constructor>", null, null, 1));
        }
        this.enlistAll(transaction);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public void setIsolationLevel(int iso_level) {
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("setIsolationLevel()", String.valueOf(this.isolationLevel), String.valueOf(iso_level), 16));
        }
        this.isolationLevel = iso_level;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction trans) {
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("setTransaction()", Log.objectToString(this.transaction), Log.objectToString(trans), 12));
        }
        this.transaction = (TransactionExtension)trans;
    }

    public String setMethodName(String method_name) {
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("setMethodName()", method_name, this.methodName, 16));
        }
        String oldMethodName = this.methodName;
        this.methodName = method_name;
        return oldMethodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void addWithoutEnlist(HandleWrapper wrapper) {
        if (wrapper == null) {
            BaseIllegalArgumentException biaExc = new BaseIllegalArgumentException("connector_0306", new String[]{"HandleWrapper"});
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(severityDebug, this.toString("addWithoutEnlist()", null, null, 2592), (Throwable)biaExc);
            }
            throw biaExc;
        }
        wrapper.setDelisted(false);
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("addWithoutEnlist()", wrapper.toString(), null, 32));
        }
        this.handleWrappers.addLastItem(wrapper);
        wrapper.setResourceSet(this);
    }

    public void addAndEnlist(HandleWrapper wrapper) throws RollbackException, SystemException, ResourceException {
        if (wrapper == null) {
            BaseIllegalArgumentException biaExc = new BaseIllegalArgumentException("connector_0306", new String[]{"HandleWrapper"});
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(severityDebug, this.toString("addAndEnlist()", null, null, 2624), (Throwable)biaExc);
            }
            throw biaExc;
        }
        wrapper.setDelisted(false);
        MCEventHandler mcHandler = wrapper.getMcEventHandler();
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("addAndEnlist()", wrapper.toString(), null, 64));
        }
        if (this.transaction != null) {
            if (mcHandler.isLocalTxSupport()) {
                this.transaction.enlistLocalResource((LocalTxProvider)mcHandler);
                mcHandler.registerSynchronization((Transaction)this.transaction);
            } else {
                this.transaction.enlistResource(mcHandler.getXAResource());
            }
        }
        this.handleWrappers.addLastItem(wrapper);
        wrapper.setResourceSet(this);
    }

    public void enlistOnly(HandleWrapper wrapper) throws RollbackException, SystemException, ResourceException {
        if (wrapper == null) {
            BaseIllegalArgumentException biaExc = new BaseIllegalArgumentException("connector_0306", new String[]{"HandleWrapper"});
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(severityDebug, this.toString("enlistOnly()", null, null, 2688), (Throwable)biaExc);
            }
            throw biaExc;
        }
        wrapper.setDelisted(false);
        MCEventHandler mcHandler = wrapper.getMcEventHandler();
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("enlistOnly()", wrapper.toString(), null, 128));
        }
        if (this.transaction != null) {
            if (mcHandler.isLocalTxSupport()) {
                this.transaction.enlistLocalResource((LocalTxProvider)mcHandler);
                mcHandler.registerSynchronization((Transaction)this.transaction);
            } else {
                this.transaction.enlistResource(mcHandler.getXAResource());
            }
        }
    }

    public void checkEnlist() throws ResourceException {
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("checkEnlist()", null, null, 6));
        }
        if (this.transaction != null && (this.transaction.getLocalResource() != null || this.hasLocalResources())) {
            BaseResourceException brExc = new BaseResourceException("connector_0202", new String[]{this.componentName, this.applicationName});
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(severityDebug, this.toString("checkEnlist()", null, null, 512), (Throwable)((Object)brExc));
            }
            throw brExc;
        }
    }

    public void remove(HandleWrapper handleWrapper, int flag) throws ResourceException {
        if (handleWrapper == null) {
            BaseResourceException brExc = new BaseResourceException("connector_0514", new String[]{null, Integer.toString(flag)});
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(severityDebug, this.toString("remove()", null, null, 2816), (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        MCEventHandler mcEventHandler = handleWrapper.getMcEventHandler();
        if (mcEventHandler == null) {
            BaseResourceException brExc = new BaseResourceException("connector_0514", new String[]{null, Integer.toString(flag)});
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(severityDebug, this.toString("remove()", handleWrapper.toString(), null, 2816), (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        try {
            block10: {
                try {
                    if (location.beLogged(severityDebug)) {
                        location.logT(severityDebug, this.toString("remove()", handleWrapper.toString(), String.valueOf(flag), 256));
                    }
                    if (mcEventHandler.isLocalTxSupport() || this.transaction == null || mcEventHandler.handleWrappersHashSet.size() != 1) break block10;
                    mcEventHandler.delistFromTransaction((Transaction)this.transaction, flag);
                }
                catch (SystemException sysEx) {
                    BaseResourceException brExc = new BaseResourceException("connector_0515", sysEx.toString());
                    if (location.beLogged(severityDebug)) {
                        location.traceThrowableT(severityDebug, this.toString("remove()", handleWrapper.toString(), null, 2816), (Throwable)((Object)brExc));
                    }
                    throw brExc;
                }
            }
            Object var7_7 = null;
            this.handleWrappers.removeItem(handleWrapper);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.handleWrappers.removeItem(handleWrapper);
            throw throwable;
        }
    }

    public void removeHandleWrapper(HandleWrapper handleWrapper) throws ResourceException {
        if (handleWrapper == null) {
            BaseResourceException brExc = new BaseResourceException("connector_0514", new String[]{null, null});
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(severityDebug, this.toString("remove()", null, null, 2816), (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        MCEventHandler mcEventHandler = handleWrapper.getMcEventHandler();
        if (mcEventHandler == null) {
            BaseResourceException brExc = new BaseResourceException("connector_0514", new String[]{null, null});
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(severityDebug, this.toString("remove()", handleWrapper.toString(), null, 2816), (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        this.handleWrappers.removeItem(handleWrapper);
    }

    public MCEventHandler getSharedEventHandler(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo cRequestInfo, int tr_support) throws ResourceException {
        if (this.transaction != null) {
            MCEventHandler mcHandler = (MCEventHandler)this.transaction.getLocalResource();
            if (mcHandler != null && mcHandler.match(mcf, subject, cRequestInfo, tr_support)) {
                if (location.beLogged(severityDebug)) {
                    location.logT(severityDebug, this.toString("getSharedEventHandler()", "mcf: " + mcf + ", subj: " + subject + ", reqInfo: " + cRequestInfo + ", trSupport: " + tr_support, mcHandler.toString(), 1024));
                }
                return mcHandler;
            }
            HandleWrapper wrapper = (HandleWrapper)this.handleWrappers.getFirstItem();
            while (wrapper != null) {
                mcHandler = wrapper.getMcEventHandler();
                if (mcHandler != null && mcHandler.match(mcf, subject, cRequestInfo, tr_support)) {
                    if (location.beLogged(severityDebug)) {
                        location.logT(severityDebug, this.toString("getSharedEventHandler()", "mcf: " + mcf + ", subj: " + subject + ", reqInfo: " + cRequestInfo + ", trSupport: " + tr_support, mcHandler.toString(), 1024));
                    }
                    return mcHandler;
                }
                wrapper = (HandleWrapper)wrapper.getNext();
            }
        }
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("getSharedEventHandler()", "mcf: " + mcf + ", subj: " + subject + ", reqInfo: " + cRequestInfo + ", trSupport: " + tr_support, null, 1024));
        }
        return null;
    }

    public void enlistAll(Transaction newTx) throws RollbackException, SystemException {
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("enlistAll()", Log.objectToString(this.transaction), Log.objectToString(newTx), 12));
        }
        this.transaction = (TransactionExtension)newTx;
        if (this.transaction == null) {
            return;
        }
        if (this.hasMoreThanOneLocalResource()) {
            BaseSystemException bsExc = new BaseSystemException("connector_0207", new String[]{this.componentName, this.applicationName});
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(severityDebug, this.toString("enlistAll()", null, null, 512), (Throwable)((Object)bsExc));
            }
            throw bsExc;
        }
        HandleWrapper wrapper = (HandleWrapper)this.handleWrappers.getFirstItem();
        while (wrapper != null) {
            MCEventHandler mcHandler = wrapper.getMcEventHandler();
            wrapper.setDelisted(false);
            if (mcHandler != null) {
                try {
                    if (mcHandler.isLocalTxSupport()) {
                        MCEventHandler transactionMCHandler = (MCEventHandler)this.transaction.getLocalResource();
                        if (transactionMCHandler == null) {
                            this.transaction.enlistLocalResource((LocalTxProvider)mcHandler);
                            mcHandler.registerSynchronization((Transaction)this.transaction);
                        } else {
                            transactionMCHandler.associateHandleWrapper(wrapper);
                        }
                    } else {
                        this.transaction.enlistResource(mcHandler.getXAResource());
                    }
                }
                catch (ResourceException resEx) {
                    BaseSystemException bsExc = new BaseSystemException("connector_0201", new String[]{this.componentName, this.applicationName}, (Throwable)resEx);
                    if (location.beLogged(severityDebug)) {
                        location.traceThrowableT(severityDebug, this.toString("enlistAll()", null, null, 518), (Throwable)((Object)bsExc));
                    }
                    throw bsExc;
                }
            }
            wrapper = (HandleWrapper)wrapper.getNext();
        }
    }

    public void delistAll(int flag) throws SystemException {
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("delistAll()", String.valueOf(flag), null, 1024));
        }
        if (this.transaction == null) {
            return;
        }
        Object[] cachedHandles = this.handleWrappers.toArray();
        try {
            int i = 0;
            while (i < cachedHandles.length) {
                block14: {
                    HandleWrapper wrapper = (HandleWrapper)cachedHandles[i];
                    MCEventHandler mcHandler = wrapper.getMcEventHandler();
                    if (mcHandler != null && !wrapper.isDelisted()) {
                        if (!mcHandler.isLocalTxSupport()) {
                            try {
                                mcHandler.delistFromTransaction((Transaction)this.transaction, flag);
                            }
                            catch (ResourceException resExc) {
                                if (location.beLogged(severityDebug)) {
                                    location.traceThrowableT(severityDebug, this.toString("delistAll()", wrapper.toString(), null, 512), (Throwable)resExc);
                                }
                                throw new BaseSystemException("connector_0208", new String[]{this.componentName, this.applicationName}, (Throwable)resExc);
                            }
                        }
                        try {
                            mcHandler.dissociateHandles();
                        }
                        catch (ResourceException resExc) {
                            BaseSystemException bsExc = new BaseSystemException("connector_0209", new String[]{this.componentName, this.applicationName}, (Throwable)resExc);
                            if (!location.beLogged(severityDebug)) break block14;
                            location.traceThrowableT(severityDebug, this.toString("delistAll()", wrapper.toString(), null, 512), (Throwable)((Object)bsExc));
                        }
                    }
                }
                ++i;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (location.beLogged(severityDebug)) {
                location.logT(severityDebug, this.toString("delistAll()", null, this.transaction.toString(), 12));
            }
            this.transaction = null;
            throw throwable;
        }
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("delistAll()", null, this.transaction.toString(), 12));
        }
        this.transaction = null;
    }

    public void enlistAllStateful(Transaction newTx) throws RollbackException, SystemException {
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("enlistAllStateful()", null, null, 12));
        }
        this.transaction = (TransactionExtension)newTx;
        Object[] cachedHandles = this.handleWrappers.toArray();
        int i = 0;
        while (i < cachedHandles.length) {
            HandleWrapper wrapper = (HandleWrapper)cachedHandles[i];
            MCEventHandler mcHandler = wrapper.getMcEventHandler();
            if (mcHandler != null) {
                try {
                    mcHandler.checkTransaction((Transaction)this.transaction);
                }
                catch (ResourceException resEx) {
                    BaseSystemException bsExc = new BaseSystemException("connector_0205", new String[]{this.componentName, this.applicationName}, (Throwable)resEx);
                    if (location.beLogged(severityDebug)) {
                        location.logT(severityDebug, this.toString("enlistAllStateful()", wrapper.toString(), null, 512));
                    }
                    throw bsExc;
                }
            }
            ++i;
        }
        if (this.transaction == null) {
            return;
        }
        if (this.hasMoreThanOneLocalResource()) {
            BaseSystemException bsExc = new BaseSystemException("connector_0207", new String[]{this.componentName, this.applicationName});
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(severityDebug, this.toString("enlistAllStateful()", null, null, 512), (Throwable)((Object)bsExc));
            }
            throw bsExc;
        }
        cachedHandles = this.handleWrappers.toArray();
        int i2 = 0;
        while (i2 < cachedHandles.length) {
            HandleWrapper wrapper = (HandleWrapper)cachedHandles[i2];
            MCEventHandler mcHandler = wrapper.getMcEventHandler();
            wrapper.setDelisted(false);
            if (mcHandler != null) {
                try {
                    if (mcHandler.isLocalTxSupport()) {
                        MCEventHandler transactionMCHandler = (MCEventHandler)this.transaction.getLocalResource();
                        if (transactionMCHandler == null) {
                            this.transaction.enlistLocalResource((LocalTxProvider)mcHandler);
                            mcHandler.registerSynchronization((Transaction)this.transaction);
                        } else if (transactionMCHandler != mcHandler) {
                            transactionMCHandler.associateHandleWrapper(wrapper);
                        }
                    } else {
                        this.transaction.enlistResource(mcHandler.getXAResource());
                    }
                }
                catch (ResourceException resEx) {
                    BaseSystemException bsExc = new BaseSystemException("connector_0201", new String[]{this.componentName, this.applicationName}, (Throwable)resEx);
                    if (location.beLogged(severityDebug)) {
                        location.traceThrowableT(severityDebug, this.toString("enlistAllStateful()", wrapper.toString(), null, 518), (Throwable)((Object)bsExc));
                    }
                    throw bsExc;
                }
            }
            ++i2;
        }
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("enlistAllStateful()", null, null, 6));
        }
    }

    public void delistAllStateful(int flag) throws SystemException {
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("delistAllStateful()", String.valueOf(flag), null, 1024));
        }
        if (this.transaction == null) {
            return;
        }
        try {
            Object[] cachedHandles = this.handleWrappers.toArray();
            int i = 0;
            while (i < cachedHandles.length) {
                HandleWrapper wrapper = (HandleWrapper)cachedHandles[i];
                MCEventHandler mcHandler = wrapper.getMcEventHandler();
                if (mcHandler != null && !wrapper.isDelisted() && !mcHandler.isLocalTxSupport()) {
                    try {
                        mcHandler.delistFromTransaction((Transaction)this.transaction, flag);
                    }
                    catch (ResourceException resEx) {
                        throw new BaseSystemException("connector_0208", new String[]{this.componentName, this.applicationName}, (Throwable)resEx);
                    }
                }
                ++i;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (location.beLogged(severityDebug)) {
                location.logT(severityDebug, this.toString("delistAllStateful()", null, this.transaction.toString(), 12));
            }
            this.transaction = null;
            throw throwable;
        }
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("delistAllStateful()", null, this.transaction.toString(), 12));
        }
        this.transaction = null;
    }

    private boolean hasLocalResources() {
        HandleWrapper wrapper = (HandleWrapper)this.handleWrappers.getFirstItem();
        while (wrapper != null) {
            MCEventHandler mcHandler = wrapper.getMcEventHandler();
            if (mcHandler != null && mcHandler.isLocalTxSupport()) {
                return true;
            }
            wrapper = (HandleWrapper)wrapper.getNext();
        }
        return false;
    }

    private boolean hasMoreThanOneLocalResource() {
        MCEventHandler firstLocalResource = null;
        HandleWrapper wrapper = (HandleWrapper)this.handleWrappers.getFirstItem();
        while (wrapper != null) {
            MCEventHandler mcHandler = wrapper.getMcEventHandler();
            if (mcHandler != null && mcHandler.isLocalTxSupport()) {
                if (firstLocalResource == null) {
                    firstLocalResource = mcHandler;
                } else if (firstLocalResource != mcHandler) {
                    return true;
                }
            }
            wrapper = (HandleWrapper)wrapper.getNext();
        }
        return false;
    }

    public boolean isEmpty() {
        return this.handleWrappers.isEmpty();
    }

    public HandleWrapper getHandleWrapperWithHandle(Object handle) {
        Object wrappedHandlerElem = null;
        boolean wrapperNotFound = true;
        HandleWrapper wrapper = (HandleWrapper)this.handleWrappers.getFirstItem();
        while (wrapper != null && wrapperNotFound) {
            wrappedHandlerElem = wrapper.getHandle();
            if (wrappedHandlerElem == handle) {
                wrapperNotFound = false;
                continue;
            }
            wrapper = (HandleWrapper)wrapper.getNext();
        }
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("getHandleWrapperWithHandle()", handle.toString(), Log.objectToString(wrapper), 1024));
        }
        return wrapper;
    }

    public void clear() {
        block7: {
            if (location.beLogged(severityDebug)) {
                location.logT(severityDebug, this.toString("clear()", null, null, 1024));
            }
            try {
                if (this.transaction != null) {
                    this.delistAll(0x20000000);
                    this.transaction.rollback();
                }
                Object[] cachedHandles = this.handleWrappers.toArray();
                int i = 0;
                while (i < cachedHandles.length) {
                    HandleWrapper wrapper = (HandleWrapper)cachedHandles[i];
                    MCEventHandler mcHandler = wrapper.getMcEventHandler();
                    if (mcHandler != null) {
                        mcHandler.clearHandles();
                    }
                    ++i;
                }
            }
            catch (Exception exc) {
                if (!location.beLogged(severityDebug)) break block7;
                location.traceThrowableT(severityDebug, this.toString("clear()", null, null, 512), (Throwable)exc);
            }
        }
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("clear()", null, null, 6));
        }
    }

    public void clearStateless() throws ResourceException {
        boolean okStatus = true;
        Object[] cachedHandles = this.handleWrappers.toArray();
        int i = 0;
        while (i < cachedHandles.length) {
            HandleWrapper wrapper = (HandleWrapper)cachedHandles[i];
            MCEventHandler mcHandler = wrapper.getMcEventHandler();
            if (mcHandler != null) {
                boolean clearResult = mcHandler.clearHandles();
                okStatus = okStatus && clearResult;
            }
            ++i;
        }
        if (!okStatus && location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("clearStateless()", "Unclosed connections will be invalidated from the server, so they cannot be used.", null, 2560));
        }
        if (location.beLogged(severityDebug)) {
            location.logT(severityDebug, this.toString("clearStateless()", null, null, 6));
        }
    }

    public void clearStateful() throws ResourceException {
        boolean okStatus = true;
        Object[] cachedHandles = this.handleWrappers.toArray();
        int i = 0;
        while (i < cachedHandles.length) {
            HandleWrapper wrapper = (HandleWrapper)cachedHandles[i];
            MCEventHandler mcHandler = wrapper.getMcEventHandler();
            if (mcHandler != null) {
                boolean dissociateResult = mcHandler.dissociateDissociatableHandles();
                okStatus = okStatus && dissociateResult;
            }
            ++i;
        }
        if (!okStatus) {
            if (location.beLogged(severityWarning)) {
                location.logT(severityWarning, this.toString("clearStateful()", "There are unclosed connections after exiting \"" + this.methodName + "\"", null, 2048));
            }
            if (location.beLogged(severityDebug)) {
                location.logT(severityDebug, this.toString("clearStateful()", null, null, 4));
            }
        }
    }

    public String toString(String methodSignature, String params, String retValue, int show) {
        StringBuffer result = new StringBuffer();
        result.append(">>> ").append(super.toString()).append(".").append(methodSignature).append(" --> ");
        if ((show & 1) != 0) {
            if (this.transaction == null) {
                result.append("not associated to any transaction");
            } else {
                result.append(this.transaction.toString());
            }
            result.append("(").append(this.isolationLevel).append(")").append(" << ");
            if (this.handleWrappers == null) {
                result.append("{}");
            } else {
                result.append("{");
                NextItem temp = this.handleWrappers.getFirstItem();
                while (temp != null) {
                    result.append(temp + ", ");
                    temp = temp.getNext();
                }
                result.append("}");
            }
            result.append(" : '").append(this.componentName).append("' component in '").append(this.applicationName).append("' application");
        } else if ((show & 2) != 0) {
            if ((show & 0x200) != 0) {
                result.append("Error occurred. ");
            }
            if (this.transaction == null) {
                result.append("not associated to any transaction");
            } else {
                result.append(this.transaction.toString());
            }
            if ((show & 4) != 0) {
                result.append(" << ");
                if (this.handleWrappers == null) {
                    result.append("{}");
                } else {
                    result.append("{");
                    NextItem temp = this.handleWrappers.getFirstItem();
                    while (temp != null) {
                        result.append(temp + ", ");
                        temp = temp.getNext();
                    }
                    result.append("}");
                }
            }
        } else if ((show & 8) != 0) {
            if (this.transaction == null) {
                result.append("not associated to any transaction");
            } else {
                result.append(this.transaction.toString());
            }
            result.append(" -> ");
            if (params != null) {
                result.append("not associated to any transaction");
            } else {
                result.append(params);
            }
            if ((show & 4) != 0) {
                result.append(" << ");
                if (this.handleWrappers == null) {
                    result.append("{}");
                } else {
                    result.append("{");
                    NextItem temp = this.handleWrappers.getFirstItem();
                    while (temp != null) {
                        result.append(temp + ", ");
                        temp = temp.getNext();
                    }
                    result.append("}");
                }
            }
        } else if ((show & 4) != 0) {
            if ((show & 0x200) != 0) {
                result.append("Error occurred. ");
            }
            if (this.handleWrappers == null) {
                result.append("{}");
            } else {
                result.append("{");
                NextItem temp = this.handleWrappers.getFirstItem();
                while (temp != null) {
                    result.append(temp + ", ");
                    temp = temp.getNext();
                }
                result.append("}");
            }
        } else if ((show & 0x10) != 0) {
            if (retValue == null) {
                result.append("not initialized");
            } else {
                result.append(retValue);
            }
            result.append(" -> ");
            if (params != null) {
                result.append("not initialized");
            } else {
                result.append(params);
            }
        } else if ((show & 0x20) != 0) {
            if ((show & 0x200) != 0) {
                result.append("Error occurred while adding without enlist ");
                if (params != null) {
                    result.append(params);
                } else {
                    result.append(" unspecified HandleWrapper");
                }
                if ((show & 0x800) != 0) {
                    result.append(" : '").append(this.componentName).append("' component in '").append(this.applicationName).append("' application");
                }
                return result.toString();
            }
            if (this.transaction != null) {
                result.append("{").append(this.transaction.toString());
            } else {
                result.append("{").append("not associated to any transaction");
            }
            result.append("} <-X- ").append(params);
            if (this.handleWrappers == null) {
                result.append(" -{-> }");
            } else {
                result.append(" -{-> ");
                NextItem temp = this.handleWrappers.getFirstItem();
                while (temp != null) {
                    result.append(temp + ", ");
                    temp = temp.getNext();
                }
                result.append("}");
            }
        } else if ((show & 0x40) != 0) {
            if ((show & 0x200) != 0) {
                result.append("Error occurred while adding and enlisting ");
                if (params != null) {
                    result.append(params);
                } else {
                    result.append(" unspecified HandleWrapper");
                }
                if ((show & 0x800) != 0) {
                    result.append(" : '").append(this.componentName).append("' component in '").append(this.applicationName).append("' application");
                }
                return result.toString();
            }
            if (this.transaction != null) {
                result.append("{").append(this.transaction.toString()).append(" <-}- ");
            }
            result.append(params);
            if (this.handleWrappers == null) {
                result.append(" -{-> }");
            } else {
                result.append(" -{-> ");
                NextItem temp = this.handleWrappers.getFirstItem();
                while (temp != null) {
                    result.append(temp + ", ");
                    temp = temp.getNext();
                }
                result.append("}");
            }
        } else if ((show & 0x80) != 0) {
            if ((show & 0x200) != 0) {
                result.append("Error occurred while enlist ");
                if (params != null) {
                    result.append(params);
                } else {
                    result.append(" unspecified HandleWrapper");
                }
                if ((show & 0x800) != 0) {
                    result.append(" : '").append(this.componentName).append("' component in '").append(this.applicationName).append("' application");
                }
                return result.toString();
            }
            if (this.transaction != null) {
                result.append("{").append(this.transaction.toString()).append(" <-}- ").append(params);
            } else {
                result.append("{").append("not associated to any transaction").append("} <-X- ").append(params);
                result.append(" {");
                NextItem temp = this.handleWrappers.getFirstItem();
                while (temp != null) {
                    if (temp.toString() == params) {
                        result.append(temp).append("(not enlisted)").append(", ");
                    } else {
                        result.append(temp).append(", ");
                    }
                    temp = temp.getNext();
                }
                result.append("}");
            }
        } else if ((show & 0x100) != 0) {
            if ((show & 0x200) != 0) {
                result.append("Error occurred while removing ");
                if (params != null) {
                    result.append(params);
                } else {
                    result.append(" unspecified HandleWrapper");
                }
                if ((show & 0x800) != 0) {
                    result.append(" : '").append(this.componentName).append("' component in '").append(this.applicationName).append("' application");
                }
                return result.toString();
            }
            if (this.transaction != null) {
                result.append("{").append(this.transaction.toString()).append(" -}-> ");
            } else {
                result.append("{").append("not associated to any transaction").append("} -X-> ");
            }
            result.append(params).append("(").append(retValue).append(")").append(" <-{- ");
            NextItem temp = this.handleWrappers.getFirstItem();
            while (temp != null) {
                if (temp.toString() != params) {
                    result.append(temp).append(", ");
                }
                temp = temp.getNext();
            }
            result.append("}");
        } else if ((show & 0x400) != 0) {
            result.append(params).append(" -> ").append(retValue);
        } else if ((show & 0x800) != 0) {
            if ((show & 0x200) != 0) {
                result.append("Error occurred. ");
            }
            result.append(params).append(" : '").append(this.componentName).append("' component in '").append(this.applicationName).append("' application");
        }
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.transaction == null) {
            result.append("not associated to any transaction");
        } else {
            result.append(this.transaction.toString());
        }
        result.append(" << ");
        if (this.handleWrappers == null) {
            result.append("{}");
        } else {
            result.append("{");
            NextItem temp = this.handleWrappers.getFirstItem();
            while (temp != null) {
                result.append(temp + ", ");
                temp = temp.getNext();
            }
            result.append("}");
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

