/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.resource.impl;

import com.sap.engine.interfaces.transaction.LocalTxProvider;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.connector.exceptions.BaseResourceException;
import com.sap.engine.services.connector.exceptions.BaseRuntimeException;
import com.sap.engine.services.connector.exceptions.BaseSystemException;
import com.sap.engine.services.connector.jca.ConnectionHashSet;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.resource.impl.HandleWrapper;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Iterator;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public final class MCEventHandler
implements ConnectionEventListener,
Synchronization,
LocalTxProvider {
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$connector$resource$impl$MCEventHandler == null ? (class$com$sap$engine$services$connector$resource$impl$MCEventHandler = MCEventHandler.class$("com.sap.engine.services.connector.resource.impl.MCEventHandler")) : class$com$sap$engine$services$connector$resource$impl$MCEventHandler));
    private static int severityDebug = 100;
    private ManagedConnection mc = null;
    private ManagedConnectionFactory mcFactory = null;
    private Subject securitySubject = null;
    private ConnectionRequestInfo cRequestInfo = null;
    private ConnectionHashSet mcSet = null;
    protected HashSet handleWrappersHashSet = new HashSet();
    private XAResource xaResource;
    private LocalTransaction localTx = null;
    private boolean sharing_scope;
    private boolean supportDeassociation = false;
    private int tr_support;
    private boolean spiLocalTxStarted = false;
    private boolean cciLocalTxStarted = false;
    private boolean inGlobalXATx = false;
    private boolean destroyed = false;
    protected Transaction registeredTransaction = null;
    private String appName = null;
    private String compName = null;
    boolean debugMode = false;
    public static final int NO_TRANSACTION = -1;
    public static final int LOCAL_SPI_TRANSACTION_STARTED = 3;
    public static final int LOCAL_SPI_TRANSACTION_COMMITED = 4;
    public static final int LOCAL_SPI_TRANSACTION_ROLLEDBACK = 5;
    public static final int XA_TRANSACTION_STARTED = 6;
    public static final int XA_TRANSACTION_COMMITED = 7;
    public static final int XA_TRANSACTION_ROLLEDBACK = 8;
    private String spiTrBornPosition = null;
    private String spiTrCommitPosition = null;
    private String spiTrRollbackPosition = null;
    private String xaTrBornPosition = null;
    private String xaTrCommitPosition = null;
    private String xaTrRollbackPosition = null;
    private String matchPosition = null;
    static /* synthetic */ Class class$com$sap$engine$services$connector$resource$impl$MCEventHandler;

    public MCEventHandler(ConnectionHashSet mc_set, ManagedConnection mConnection, ManagedConnectionFactory mConnectionFactory, Subject subject, ConnectionRequestInfo cRequestInfo, int tr_support, boolean sharing_scope, boolean support_deassociation) {
        this.mcSet = mc_set;
        this.mc = mConnection;
        this.mcFactory = mConnectionFactory;
        this.securitySubject = subject;
        this.cRequestInfo = cRequestInfo;
        this.tr_support = tr_support;
        this.sharing_scope = sharing_scope;
        this.supportDeassociation = support_deassociation;
        this.debugMode = this.mcSet.beDebugMode();
        if (this.debugMode) {
            mc_set.addManagedConnectionInfo(this);
            this.setMatchPosition();
        }
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".<constructor>(adapterName: " + mc_set.getAdapterName() + ", mcf: " + mConnectionFactory + ", subj: " + subject + ", reqInfo: " + cRequestInfo + ", trSupp: " + JCDescriptor.TR_SUPPORTS[tr_support] + ", sharingScope: " + sharing_scope + ", suppDiss: " + support_deassociation + ")");
        }
    }

    public XAResource getXAResource() throws ResourceException {
        if (this.tr_support != 2) {
            BaseRuntimeException brExc = new BaseRuntimeException("connector_0600", "XAResource");
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ".getXAResource(), XAResource is not supported due to adapter transaction type is not appropriate", (Throwable)brExc);
            }
            throw brExc;
        }
        if (this.cciLocalTxStarted || this.spiLocalTxStarted) {
            BaseRuntimeException brExc = null;
            if (this.spiLocalTxStarted) {
                brExc = new BaseRuntimeException("connector_0601", new String[]{"JTA Transaction(xa)", "JTATransaction(spi)"});
                if (location.beLogged(severityDebug)) {
                    location.traceThrowableT(100, ">>> " + this + ".getXAResource(), Cannot get XAResource due to LocalTransaction(spi) is already started.", (Throwable)brExc);
                }
            } else {
                brExc = new BaseRuntimeException("connector_0601", new String[]{"LocalTransaction(xa)", "LocalTransaction(cci)"});
                location.traceThrowableT(100, ">>> " + this + ".getXAResource(), Cannot get XAResource) due to LocalTransaction(cci) is already started.", (Throwable)brExc);
            }
            throw brExc;
        }
        if (this.xaResource == null) {
            try {
                this.xaResource = this.mc.getXAResource();
            }
            catch (ResourceException resExc) {
                if (location.beLogged(severityDebug)) {
                    location.traceThrowableT(100, ">>> " + this + ".getXAResource(), Cannot get XAResource.", (Throwable)resExc);
                }
                throw resExc;
            }
        }
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".getXAResource(): " + this.xaResource);
        }
        this.inGlobalXATx = true;
        if (this.debugMode) {
            this.setTransactionStatus(6);
        }
        return this.xaResource;
    }

    public Object getLocalTransaction() throws SystemException {
        if (this.xaResource != null || this.cciLocalTxStarted) {
            BaseRuntimeException brExc = null;
            if (this.xaResource != null) {
                brExc = new BaseRuntimeException("connector_0601", new String[]{"LocalTransaction(spi)", "JTA Transaction"});
                if (location.beLogged(severityDebug)) {
                    location.traceThrowableT(100, ">>> " + this + ".getLocalTransaction(), Cannot get LocalTransaction(spi) due to JTATransaction(xa) is already started.", (Throwable)brExc);
                }
            } else {
                brExc = new BaseRuntimeException("connector_0601", new String[]{"LocalTransaction(spi)", "LocalTransaction(cci)"});
                location.traceThrowableT(100, ">>> " + this + ".getLocalTransaction(), Cannot get LocalTransaction(spi) due to LocalTransaction(cci) is already started.", (Throwable)brExc);
            }
            throw brExc;
        }
        if (this.tr_support == 0) {
            BaseRuntimeException brExc = new BaseRuntimeException("connector_0600", "LocalTransaction");
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ", LocalTransaction(spi) is not supported due to adapter transaction type is not appropriate", (Throwable)brExc);
            }
            throw brExc;
        }
        if (this.localTx == null) {
            try {
                this.localTx = this.mc.getLocalTransaction();
            }
            catch (ResourceException resExc) {
                BaseSystemException bsExc = new BaseSystemException("connector_0200", new Object[]{this.compName, this.appName}, (Throwable)resExc);
                if (location.beLogged(severityDebug)) {
                    location.traceThrowableT(100, ">>> " + this + ".getLocalTransaction(), Cannot get LocalTransaction(spi).", (Throwable)((Object)bsExc));
                }
                throw bsExc;
            }
        }
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".getLocalTransaction(): " + this.localTx);
        }
        this.spiLocalTxStarted = true;
        if (this.debugMode) {
            this.setTransactionStatus(3);
        }
        return this.localTx;
    }

    public boolean isLocalTxSupport() {
        return this.tr_support == 1;
    }

    /*
     * Loose catch block
     */
    private void cleanup(boolean success) {
        block28: {
            if (location.beLogged(severityDebug)) {
                location.logT(100, ">>> " + this + ".cleanup({0}), invoked from: {1}", (Object[])new String[]{String.valueOf(success), Log.getStackTrace()});
            }
            this.mc.removeConnectionEventListener((ConnectionEventListener)this);
            Object var4_2 = null;
            try {
                try {
                    if (success) {
                        this.mcSet.destroy(this.appName, this.mc, false);
                    } else {
                        this.destroyed = true;
                        this.mcSet.destroy(this.appName, this.mc, true);
                    }
                    Object var6_5 = null;
                    if (this.debugMode) {
                        this.mcSet.removeManagedConnectionInfo(this);
                    }
                    this.mc = null;
                    break block28;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (this.debugMode) {
                        this.mcSet.removeManagedConnectionInfo(this);
                    }
                    this.mc = null;
                    throw throwable;
                }
            }
            catch (Exception resExc2) {
                if (location.beLogged(500)) {
                    location.traceThrowableT(500, ">>> " + this + ".cleanup(), Cannot destroy({0}) ManagedConnection.", String.valueOf(success), (Throwable)resExc2);
                }
                break block28;
            }
            {
                catch (Exception resExc) {
                    if (location.beLogged(500)) {
                        location.traceThrowableT(500, ">>> " + this + ".cleanup(), Cannot remove ConnectionEventListener.", (Throwable)resExc);
                    }
                    success = false;
                    Object var4_3 = null;
                    try {
                        try {
                            if (success) {
                                this.mcSet.destroy(this.appName, this.mc, false);
                            } else {
                                this.destroyed = true;
                                this.mcSet.destroy(this.appName, this.mc, true);
                            }
                            Object var6_7 = null;
                            if (this.debugMode) {
                                this.mcSet.removeManagedConnectionInfo(this);
                            }
                            this.mc = null;
                            break block28;
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            if (this.debugMode) {
                                this.mcSet.removeManagedConnectionInfo(this);
                            }
                            this.mc = null;
                            throw throwable;
                        }
                    }
                    catch (Exception resExc2) {
                        if (location.beLogged(500)) {
                            location.traceThrowableT(500, ">>> " + this + ".cleanup(), Cannot destroy({0}) ManagedConnection.", String.valueOf(success), (Throwable)resExc2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block29: {
                    Object var4_4 = null;
                    try {
                        try {
                            if (success) {
                                this.mcSet.destroy(this.appName, this.mc, false);
                            } else {
                                this.destroyed = true;
                                this.mcSet.destroy(this.appName, this.mc, true);
                            }
                            Object var6_9 = null;
                            if (this.debugMode) {
                                this.mcSet.removeManagedConnectionInfo(this);
                            }
                            this.mc = null;
                        }
                        catch (Throwable throwable2) {
                            Object var6_10 = null;
                            if (this.debugMode) {
                                this.mcSet.removeManagedConnectionInfo(this);
                            }
                            this.mc = null;
                            throw throwable2;
                        }
                    }
                    catch (Exception resExc2) {
                        if (!location.beLogged(500)) break block29;
                        location.traceThrowableT(500, ">>> " + this + ".cleanup(), Cannot destroy({0}) ManagedConnection.", String.valueOf(success), (Throwable)resExc2);
                    }
                }
                throw throwable;
            }
        }
    }

    public void localTransactionStarted(ConnectionEvent event) {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".localTransactionStarted(" + event + ") from connection " + event.getConnectionHandle());
        }
        if (this.inGlobalXATx || this.spiLocalTxStarted || this.cciLocalTxStarted) {
            BaseRuntimeException brExc = null;
            if (this.inGlobalXATx) {
                brExc = new BaseRuntimeException("connector_0601", new String[]{"LocalTransaction(cci)", "JTA Transaction"});
                if (location.beLogged(severityDebug)) {
                    location.traceThrowableT(100, ">>> " + this + ".localTransactionStarted(), Cannot start LocalTransaction(cci) due to JTATransaction(xa) is already started.", (Throwable)brExc);
                }
            } else if (this.spiLocalTxStarted) {
                brExc = new BaseRuntimeException("connector_0601", new String[]{"LocalTransaction(cci)", "LocalTransaction(spi)"});
                location.traceThrowableT(100, ">>> " + this + ".localTransactionStarted(), Cannot start LocalTransaction(ci) due to LocalTransaction(spi) is already started.", (Throwable)brExc);
            } else {
                brExc = new BaseRuntimeException("connector_0601", new String[]{"LocalTransaction(cci)", "LocalTransaction(spi)"});
                location.traceThrowableT(100, ">>> " + this + ".localTransactionStarted(), Cannot start LocalTransaction(ci) due to another LocalTransaction(cci) is already started.", (Throwable)brExc);
            }
            throw brExc;
        }
        if (this.handleWrappersHashSet.size() != 1) {
            BaseRuntimeException brExc = new BaseRuntimeException("Internal ResourceHandling error. Please report the problem. Handles are: " + this.handleWrappersHashSet.size());
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ".localTransactionStarted(). Internal ResourceHandling error. Handles are: {0} ", this.handleWrappersHashSet.toString(), (Throwable)brExc);
            }
            throw brExc;
        }
        this.cciLocalTxStarted = true;
        if (this.debugMode) {
            this.setTransactionStatus(event, 0);
        }
    }

    public void localTransactionCommitted(ConnectionEvent event) {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".localTransactionCommitted(" + event + ") from connection " + event.getConnectionHandle() + ", all handles are: " + this.handleWrappersHashSet.toString());
        }
        if (!this.cciLocalTxStarted) {
            BaseRuntimeException brExc = new BaseRuntimeException("connector_0603", "LocalTransaction(cci)");
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ".localTransactionCommitted(), Cannot commit LocalTransaction(cci).", (Throwable)brExc);
            }
            throw brExc;
        }
        if (this.inGlobalXATx || this.spiLocalTxStarted) {
            BaseRuntimeException brExc = null;
            brExc = this.inGlobalXATx ? new BaseRuntimeException("connector_0606", new String[]{"JTATransaction(xa)", "commit", "LocalTransaction(cci)"}) : new BaseRuntimeException("connector_0606", new String[]{"LocalTransaction(spi)", "commit", "LocalTransaction(cci)"});
            brExc.log();
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ".localTransactionCommitted(), Cannot commit LocalTransaction(cci).", (Throwable)brExc);
            }
            throw brExc;
        }
        if (this.handleWrappersHashSet.size() != 1) {
            BaseRuntimeException brExc = new BaseRuntimeException("connector_0604", Integer.toString(this.handleWrappersHashSet.size()));
            brExc.log();
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ".localTransactionCommitted(). Internal ResourceHandling error. Possible reason: event fired while connection was closed. Handles are: {0} ", this.handleWrappersHashSet.toString(), (Throwable)brExc);
            }
            throw brExc;
        }
        this.cciLocalTxStarted = false;
        if (this.debugMode) {
            this.setTransactionStatus(event, 1);
        }
        try {
            this.dissociateAfterLocalTransaction();
        }
        catch (ResourceException resExc) {
            if (location.beLogged(500)) {
                location.traceThrowableT(500, ">>> " + this + ".localTransactionCommitted(). Cannot dissociate handles. All handles are: ", this.handleWrappersHashSet.toString(), (Throwable)resExc);
            }
            this.cleanup(false);
        }
        if (this.handleWrappersHashSet.size() == 0) {
            this.cleanup(true);
        }
    }

    public void localTransactionRolledback(ConnectionEvent event) {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".localTransactionRolledback(" + event + ") from connection " + event.getConnectionHandle() + ", all handles are: " + this.handleWrappersHashSet.toString());
        }
        if (!this.cciLocalTxStarted) {
            BaseRuntimeException brExc = new BaseRuntimeException("connector_0603", "LocalTransaction(cci)");
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ".localTransactionRolledback(), Cannot rollback LocalTransaction(cci).", (Throwable)brExc);
            }
            throw brExc;
        }
        if (this.inGlobalXATx || this.spiLocalTxStarted) {
            BaseRuntimeException brExc = null;
            brExc = this.inGlobalXATx ? new BaseRuntimeException("connector_0606", new String[]{"JTATransaction(xa)", "rollback", "LocalTransaction(cci)"}) : new BaseRuntimeException("connector_0606", new String[]{"LocalTransaction(spi)", "rollback", "LocalTransaction(cci)"});
            brExc.log();
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ".localTransactionRolledback(), Cannot rollback LocalTransaction(cci).", (Throwable)brExc);
            }
            throw brExc;
        }
        if (this.handleWrappersHashSet.size() != 1) {
            BaseRuntimeException brExc = new BaseRuntimeException("connector_0604", Integer.toString(this.handleWrappersHashSet.size()));
            brExc.log();
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ".localTransactionRolledback(). Internal ResourceHandling error. Possible reason: event fired while connection was closed. Handles are: {0} ", this.handleWrappersHashSet.toString(), (Throwable)brExc);
            }
            throw brExc;
        }
        this.cciLocalTxStarted = false;
        if (this.debugMode) {
            this.setTransactionStatus(event, 2);
        }
        try {
            this.dissociateAfterLocalTransaction();
        }
        catch (ResourceException resExc) {
            if (location.beLogged(500)) {
                location.traceThrowableT(500, ">>> " + this + ".localTransactionRolledback(). Cannot dissociate handles. All handles are: ", this.handleWrappersHashSet.toString(), (Throwable)resExc);
            }
            this.cleanup(false);
        }
        if (this.handleWrappersHashSet.size() == 0) {
            this.cleanup(true);
        }
    }

    public void connectionClosed(ConnectionEvent event) {
        Object tmpWrapper;
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".connectionClosed(" + event + ") + from connection " + event.getConnectionHandle());
        }
        Object callingHandle = event.getConnectionHandle();
        HandleWrapper wrapper = null;
        Iterator iter = this.handleWrappersHashSet.iterator();
        while (iter.hasNext()) {
            tmpWrapper = (HandleWrapper)iter.next();
            if (!callingHandle.equals(((HandleWrapper)tmpWrapper).getHandle())) continue;
            wrapper = tmpWrapper;
            break;
        }
        if (wrapper == null) {
            if (location.beLogged(500)) {
                location.logT(500, ">>> " + this + ".connectionClosed(). Internal resource handling error. Please report the problem. Received connectionClosed event from unknown handle. Invoked from: {1}", (Object[])new String[]{Log.getStackTrace()});
            }
            return;
        }
        try {
            block16: {
                try {
                    wrapper.removeItselfFromResourceSet(0x4000000);
                    if (this.debugMode) {
                        tmpWrapper = this;
                        synchronized (tmpWrapper) {
                            this.handleWrappersHashSet.remove(wrapper);
                            break block16;
                        }
                    }
                    this.handleWrappersHashSet.remove(wrapper);
                }
                catch (Exception exc) {
                    if (location.beLogged(500)) {
                        location.traceThrowableT(500, ">>> " + this + ".connectionClosed(). Error occurred. Please report the problem.", (Throwable)exc);
                    }
                    Object var8_9 = null;
                    if (this.handleWrappersHashSet.size() == 0 && !this.spiLocalTxStarted) {
                        this.cleanup(true);
                    }
                }
            }
            Object var8_8 = null;
            if (this.handleWrappersHashSet.size() == 0 && !this.spiLocalTxStarted) {
                this.cleanup(true);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.handleWrappersHashSet.size() == 0 && !this.spiLocalTxStarted) {
                this.cleanup(true);
            }
            throw throwable;
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".connectionErrorOccurred(" + event + ") + from connection " + event.getConnectionHandle());
        }
        if (location.beLogged(100)) {
            location.logT(100, ">>> " + this + ".connectionErrorOccurred() event invoked from: {0}.", (Object[])new String[]{Log.getStackTrace()});
        }
        try {
            Iterator iter = this.handleWrappersHashSet.iterator();
            while (iter.hasNext()) {
                try {
                    ((HandleWrapper)iter.next()).removeItselfFromResourceSet(0x20000000);
                }
                catch (Exception exc) {
                    if (!location.beLogged(500)) continue;
                    location.traceThrowableT(500, ">>> " + this + ".connectionErrorOccurred(). Error occurred.", (Throwable)exc);
                }
            }
            Object var5_4 = null;
            this.cleanup(false);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cleanup(false);
            throw throwable;
        }
    }

    public boolean match(ManagedConnectionFactory mcf, Subject subj, ConnectionRequestInfo info, int tr_support) {
        if (!this.sharing_scope || !this.mcFactory.equals((Object)mcf) || this.securitySubject == null && subj != null || this.securitySubject != null && !this.securitySubject.equals(subj) || this.cRequestInfo == null && info != null || this.cRequestInfo != null && !this.cRequestInfo.equals((Object)info) || this.tr_support != tr_support) {
            if (location.beLogged(severityDebug)) {
                location.logT(100, ">>> " + this + ".match(mcf: " + mcf + ", subj: " + subj + ", reqInfo: " + info + ", trSupport: " + tr_support + "): false");
            }
            return false;
        }
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".match(mcf: " + mcf + ", subj: " + subj + ", reqInfo: " + info + ", trSupport: " + tr_support + "): true");
        }
        return true;
    }

    public HandleWrapper createConnectionHandle(Subject subject, ConnectionRequestInfo cRequestInfo) throws ResourceException {
        Object handle = this.mc.getConnection(subject, cRequestInfo);
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".createConnectionHandle(subj: " + subject + ", reqInfo: " + cRequestInfo + ", shScope: " + this.sharing_scope + "): " + handle);
        }
        HandleWrapper wrapper = new HandleWrapper(handle, this, this.sharing_scope);
        if (this.debugMode) {
            MCEventHandler mCEventHandler = this;
            synchronized (mCEventHandler) {
                this.handleWrappersHashSet.add(wrapper);
            }
        } else {
            this.handleWrappersHashSet.add(wrapper);
        }
        return wrapper;
    }

    public void dissociateAfterLocalTransaction() throws ResourceException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".dissociateAfterLocalTransaction(), supportDissociation: " + this.supportDeassociation);
        }
        if (this.supportDeassociation) {
            ((DissociatableManagedConnection)this.mc).dissociateConnections();
            if (this.handleWrappersHashSet.size() > 1) {
                BaseResourceException brExc = new BaseResourceException("connector_0516");
                if (location.beLogged(severityDebug)) {
                    location.traceThrowableT(100, ">>> " + this + ".dissociateAfterLocalTransaction(). Internal ResourceHandling error. Handles are: {0} ", this.handleWrappersHashSet.toString(), (Throwable)((Object)brExc));
                }
                throw brExc;
            }
            HandleWrapper wrapper = (HandleWrapper)this.handleWrappersHashSet.iterator().next();
            wrapper.justRemoveFromResourceSet();
            this.cleanup(true);
        }
    }

    public void delistFromTransaction(Transaction associatedTransaction, int flag) throws ResourceException, SystemException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".delistFromTransaction: " + associatedTransaction + " flag: " + flag);
        }
        Iterator iter = this.handleWrappersHashSet.iterator();
        while (iter.hasNext()) {
            HandleWrapper tmpWrapper = (HandleWrapper)iter.next();
            tmpWrapper.setDelisted(true);
        }
        associatedTransaction.delistResource(this.getXAResource(), flag);
    }

    public void dissociateHandles() throws ResourceException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".dissociateHandles() supportDissociation: " + this.supportDeassociation + " isLocalTxSupport: " + this.isLocalTxSupport());
        }
        if (this.supportDeassociation) {
            Object tmpWrapper;
            ((DissociatableManagedConnection)this.mc).dissociateConnections();
            Iterator iter = this.handleWrappersHashSet.iterator();
            while (iter.hasNext()) {
                tmpWrapper = (HandleWrapper)iter.next();
                ((HandleWrapper)tmpWrapper).justRemoveFromResourceSet();
            }
            if (this.debugMode) {
                tmpWrapper = this;
                synchronized (tmpWrapper) {
                    this.handleWrappersHashSet.clear();
                }
            } else {
                this.handleWrappersHashSet.clear();
            }
        } else if (this.isLocalTxSupport()) {
            Object tmpWrapper;
            Iterator iter = this.handleWrappersHashSet.iterator();
            while (iter.hasNext()) {
                tmpWrapper = (HandleWrapper)iter.next();
                ManagedConnection mConnection = this.mcSet.match(this.appName, this.securitySubject, this.cRequestInfo);
                MCEventHandler newMcEventHandler = new MCEventHandler(this.mcSet, mConnection, this.mcFactory, this.securitySubject, this.cRequestInfo, this.tr_support, this.sharing_scope, false);
                newMcEventHandler.setUsageFrom(this.compName, this.appName);
                mConnection.associateConnection(((HandleWrapper)tmpWrapper).getHandle());
                mConnection.addConnectionEventListener((ConnectionEventListener)newMcEventHandler);
                if (this.debugMode) {
                    MCEventHandler mCEventHandler = newMcEventHandler;
                    synchronized (mCEventHandler) {
                        newMcEventHandler.handleWrappersHashSet.add(tmpWrapper);
                    }
                } else {
                    newMcEventHandler.handleWrappersHashSet.add(tmpWrapper);
                }
                ((HandleWrapper)tmpWrapper).setMcEventHandler(newMcEventHandler);
                ((HandleWrapper)tmpWrapper).setDelisted(true);
            }
            if (this.debugMode) {
                tmpWrapper = this;
                synchronized (tmpWrapper) {
                    this.handleWrappersHashSet.clear();
                }
            } else {
                this.handleWrappersHashSet.clear();
            }
        } else {
            Iterator iter = this.handleWrappersHashSet.iterator();
            while (iter.hasNext()) {
                HandleWrapper tmpWrapper = (HandleWrapper)iter.next();
                ManagedConnection mConnection = this.mcSet.match(this.appName, this.securitySubject, this.cRequestInfo);
                MCEventHandler newMcEventHandler = new MCEventHandler(this.mcSet, mConnection, this.mcFactory, this.securitySubject, this.cRequestInfo, this.tr_support, this.sharing_scope, false);
                newMcEventHandler.setUsageFrom(this.compName, this.appName);
                mConnection.associateConnection(tmpWrapper.getHandle());
                mConnection.addConnectionEventListener((ConnectionEventListener)newMcEventHandler);
                if (this.debugMode) {
                    MCEventHandler mCEventHandler = newMcEventHandler;
                    synchronized (mCEventHandler) {
                        newMcEventHandler.handleWrappersHashSet.add(tmpWrapper);
                    }
                } else {
                    newMcEventHandler.handleWrappersHashSet.add(tmpWrapper);
                }
                tmpWrapper.setMcEventHandler(newMcEventHandler);
                tmpWrapper.setDelisted(true);
            }
            if (this.debugMode) {
                MCEventHandler mCEventHandler = this;
                synchronized (mCEventHandler) {
                    this.handleWrappersHashSet.clear();
                }
            } else {
                this.handleWrappersHashSet.clear();
            }
            this.cleanup(true);
        }
    }

    public void associateHandleWrapper(HandleWrapper handleWrapper) throws ResourceException {
        MCEventHandler oldMCHandler;
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".associateHandleWrapper(" + handleWrapper + ")");
        }
        if ((oldMCHandler = handleWrapper.getMcEventHandler()) == null) {
            BaseResourceException brExc = new BaseResourceException("connector_0511");
            location.traceThrowableT(500, "", (Throwable)((Object)brExc));
            throw brExc;
        }
        if (!this.sharing_scope) {
            BaseResourceException brExc = new BaseResourceException("connector_0512");
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ".associateHandleWrapper(), {0} cannot be associated, because it is not shareable.", handleWrapper.toString(), (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        if (!this.match(oldMCHandler.mcFactory, oldMCHandler.securitySubject, oldMCHandler.cRequestInfo, oldMCHandler.tr_support)) {
            BaseResourceException brExc = new BaseResourceException("connector_0513");
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ".associateHandleWrapper(), {0} cannot be associated, because old {1} is not identical", (Object[])new String[]{handleWrapper.toString(), oldMCHandler.toString()}, (Throwable)((Object)brExc));
            }
            throw brExc;
        }
        this.mc.associateConnection(handleWrapper.getHandle());
        handleWrapper.setMcEventHandler(this);
        if (this.debugMode) {
            MCEventHandler mCEventHandler = this;
            synchronized (mCEventHandler) {
                this.handleWrappersHashSet.add(handleWrapper);
            }
        } else {
            this.handleWrappersHashSet.add(handleWrapper);
        }
        if (!oldMCHandler.spiLocalTxStarted) {
            oldMCHandler.cleanup(true);
        }
    }

    public HandleWrapper associateConnectionHandle(Object handle) throws ResourceException {
        HandleWrapper wrapper = new HandleWrapper(handle, this, this.sharing_scope);
        if (this.debugMode) {
            MCEventHandler mCEventHandler = this;
            synchronized (mCEventHandler) {
                this.handleWrappersHashSet.add(wrapper);
            }
        } else {
            this.handleWrappersHashSet.add(wrapper);
        }
        try {
            this.mc.associateConnection(handle);
        }
        catch (ResourceException re) {
            if (this.debugMode) {
                MCEventHandler mCEventHandler = this;
                synchronized (mCEventHandler) {
                    this.handleWrappersHashSet.remove(wrapper);
                }
            } else {
                this.handleWrappersHashSet.remove(wrapper);
            }
            throw re;
        }
        catch (RuntimeException re) {
            if (this.debugMode) {
                MCEventHandler mCEventHandler = this;
                synchronized (mCEventHandler) {
                    this.handleWrappersHashSet.remove(wrapper);
                }
            } else {
                this.handleWrappersHashSet.remove(wrapper);
            }
            throw re;
        }
        return wrapper;
    }

    public void registerSynchronization(Transaction synchTransaction) throws RollbackException, SystemException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".registerSynchronization(" + synchTransaction + ")");
        }
        synchTransaction.registerSynchronization((Synchronization)this);
        this.registeredTransaction = synchTransaction;
    }

    public void checkTransaction(Transaction tx) throws ResourceException {
        if (this.registeredTransaction != null && !this.registeredTransaction.equals(tx)) {
            if (location.beLogged(severityDebug)) {
                location.logT(100, ">>> " + this + ".checkTransaction(" + tx + ") will dissociate handles.");
            }
            this.dissociateHandles();
        }
    }

    public void beforeCompletion() {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".beforeCompletion() , registeredTransaction: " + this.registeredTransaction);
        }
        if (!this.spiLocalTxStarted) {
            BaseRuntimeException brExc = new BaseRuntimeException("connector_0605");
            if (location.beLogged(severityDebug)) {
                location.traceThrowableT(100, ">>> " + this + ".beforeCompletion(). Error in before completion", (Throwable)brExc);
            }
            throw brExc;
        }
    }

    public void afterCompletion(int i) {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".afterCompletion(" + i + ") , registeredTransaction: " + this.registeredTransaction + ", destroyed: " + this.destroyed + ", isLocalTxSupport: " + this.isLocalTxSupport());
        }
        if (this.destroyed) {
            return;
        }
        this.registeredTransaction = null;
        if (this.debugMode) {
            if (i == 3) {
                if (this.spiLocalTxStarted) {
                    this.setTransactionStatus(4);
                } else {
                    this.setTransactionStatus(7);
                }
            } else if (this.spiLocalTxStarted) {
                this.setTransactionStatus(5);
            } else {
                this.setTransactionStatus(8);
            }
        }
        if (this.isLocalTxSupport()) {
            block14: {
                if (this.handleWrappersHashSet.size() > 0) {
                    try {
                        this.dissociateHandles();
                    }
                    catch (ResourceException resExc) {
                        if (!location.beLogged(severityDebug)) break block14;
                        location.traceThrowableT(severityDebug, ">>> " + this + ".afterCompletion(). Cannot dissociate connections.", (Throwable)resExc);
                    }
                }
            }
            this.cleanup(true);
        }
        if (this.mc != null && location.beLogged(severityDebug)) {
            location.logT(severityDebug, ">>> " + this + ".afterCompletion(). Internal resource handling error. Managed connection is not released at the end of afterCompletion.");
        }
    }

    public boolean clearHandles() throws ResourceException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".clearHandles() , cciLocalTxStarted: " + this.cciLocalTxStarted + ", supportDeassociation: " + this.supportDeassociation);
        }
        boolean exitStatus = false;
        if (this.cciLocalTxStarted) {
            this.cleanup(true);
            exitStatus = false;
        } else {
            if (!this.supportDeassociation) {
                return true;
            }
            ((DissociatableManagedConnection)this.mc).dissociateConnections();
            this.cleanup(true);
            exitStatus = true;
        }
        Iterator iter = this.handleWrappersHashSet.iterator();
        while (iter.hasNext()) {
            HandleWrapper tmpWrapper = (HandleWrapper)iter.next();
            tmpWrapper.justRemoveFromResourceSet();
        }
        if (this.debugMode) {
            MCEventHandler mCEventHandler = this;
            synchronized (mCEventHandler) {
                this.handleWrappersHashSet.clear();
            }
        } else {
            this.handleWrappersHashSet.clear();
        }
        return exitStatus;
    }

    public boolean dissociateDissociatableHandles() throws ResourceException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".dissociateDissociatableHandles() , cciLocalTxStarted = " + this.cciLocalTxStarted + ", supportDeassociation = " + this.supportDeassociation);
        }
        if (this.cciLocalTxStarted || !this.supportDeassociation) {
            return false;
        }
        ((DissociatableManagedConnection)this.mc).dissociateConnections();
        this.cleanup(true);
        Iterator iter = this.handleWrappersHashSet.iterator();
        while (iter.hasNext()) {
            HandleWrapper tmpWrapper = (HandleWrapper)iter.next();
            tmpWrapper.justRemoveFromResourceSet();
        }
        if (this.debugMode) {
            MCEventHandler mCEventHandler = this;
            synchronized (mCEventHandler) {
                this.handleWrappersHashSet.clear();
            }
        } else {
            this.handleWrappersHashSet.clear();
        }
        return true;
    }

    public void setUsageFrom(String compName, String appName) {
        this.compName = compName;
        this.appName = appName;
        if (compName == null) {
            compName = "system";
        }
        if (appName == null) {
            appName = "system";
        }
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".setUsageFrom(" + compName + ", " + appName + ")");
        }
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getComponentName() {
        return this.compName;
    }

    public ManagedConnection getManagedConnection() {
        return this.mc;
    }

    public synchronized void setMatchPosition() {
        this.matchPosition = this.getStackTrace();
    }

    public String getMatchPosition() {
        return this.matchPosition;
    }

    public String getResRefTrStatusAsString() {
        if (this.tr_support == 0) {
            return "NoTransaction";
        }
        if (this.tr_support == 1) {
            return "LocalTransaction";
        }
        if (this.tr_support == 2) {
            return "XATransaction";
        }
        return "Unknown";
    }

    public void setTransactionStatus(int transactionStatus) {
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".setTransactionStatus(" + transactionStatus + ")");
        }
        if (transactionStatus > 8 || transactionStatus < 3 && transactionStatus != -1) {
            BaseIllegalArgumentException biaExc = new BaseIllegalArgumentException("connector_0313", new String[]{String.valueOf(transactionStatus)});
            location.traceThrowableT(100, "", (Throwable)biaExc);
        }
        if (transactionStatus == 3) {
            this.spiTrBornPosition = this.getStackTrace();
        } else if (transactionStatus == 4) {
            this.spiTrCommitPosition = this.getStackTrace();
        } else if (transactionStatus == 5) {
            this.spiTrRollbackPosition = this.getStackTrace();
        } else if (transactionStatus == 6) {
            this.xaTrBornPosition = this.getStackTrace();
        } else if (transactionStatus == 7) {
            this.xaTrCommitPosition = this.getStackTrace();
        } else {
            this.xaTrRollbackPosition = this.getStackTrace();
        }
    }

    public void setTransactionStatus(ConnectionEvent event, int transactionStatus) {
        Object callingHandle = event.getConnectionHandle();
        if (location.beLogged(severityDebug)) {
            location.logT(100, ">>> " + this + ".setTransactionStatus(" + event + ", " + transactionStatus + ") + from connection " + callingHandle);
        }
        HandleWrapper wrapper = null;
        Iterator iter = this.handleWrappersHashSet.iterator();
        while (iter.hasNext()) {
            HandleWrapper tmpWrapper = (HandleWrapper)iter.next();
            if (!callingHandle.equals(tmpWrapper.getHandle())) continue;
            wrapper = tmpWrapper;
            break;
        }
        if (wrapper == null) {
            if (location.beLogged(100)) {
                location.logT(100, ">>> " + this + ".setTransactionStatus(). Internal resource handling error. Please report the problem. Received setTransactionStatus event from unknown handle. Invoked from: {1}", (Object[])new String[]{Log.getStackTrace()});
            }
            return;
        }
        wrapper.setTransactionStatus(transactionStatus);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(super.toString()).append(" --> ");
        if (this.mc != null) {
            result.append(this.mc.toString()).append("(locTrSupp:").append(this.isLocalTxSupport()).append(")");
        } else {
            result.append("not associated").append(", " + this.isLocalTxSupport());
        }
        return result.toString();
    }

    public synchronized String getInfo(boolean traceMode) {
        Iterator connHandlesInfoIter;
        StringBuffer info = new StringBuffer();
        info.append("ManagedConnection : " + this.mc + "\n\n");
        info.append("   resRef transaction status : " + this.getResRefTrStatusAsString() + "\n");
        if (traceMode) {
            info.append("   match position            : " + this.matchPosition + "\n");
        } else {
            info.append("   match position            : precised, but not traced\n");
        }
        info.append("   transaction status        : ");
        if (this.spiTrBornPosition != null) {
            info.append("\n\n");
            info.append("     spi transaction status\n");
            if (traceMode) {
                info.append("         started at            : " + this.spiTrBornPosition + "\n");
                if (this.spiTrCommitPosition != null) {
                    info.append("         committed at          : " + this.spiTrCommitPosition + "\n");
                } else {
                    info.append("         committed at          : not available\n");
                }
                if (this.spiTrRollbackPosition != null) {
                    info.append("         rolledback at         : " + this.spiTrRollbackPosition + "\n");
                } else {
                    info.append("         rolledback at         : not available\n");
                }
            } else {
                info.append("         started at            : precised, but not traced\n");
                if (this.spiTrCommitPosition != null) {
                    info.append("         committed at          : precised, but not traced\n");
                } else {
                    info.append("         committed at          : not available\n");
                }
                if (this.spiTrRollbackPosition != null) {
                    info.append("         rolledback at         : precised, but not traced\n");
                } else {
                    info.append("         rolledback at         : not available\n");
                }
            }
        }
        if (this.xaTrBornPosition != null) {
            info.append("\n\n");
            if (traceMode) {
                info.append("     xa transaction status\n");
                info.append("         started at            : " + this.xaTrBornPosition + "\n");
                if (this.xaTrCommitPosition != null) {
                    info.append("         committed at          : " + this.xaTrCommitPosition + "\n");
                } else {
                    info.append("         committed at          : not available\n");
                }
                if (this.xaTrRollbackPosition != null) {
                    info.append("         rolledback at         : " + this.xaTrRollbackPosition + "\n");
                } else {
                    info.append("         rolledback at         : not available\n");
                }
            } else {
                info.append("     xa transaction status\n");
                info.append("         started at            : precised, but not traced\n");
                if (this.xaTrCommitPosition != null) {
                    info.append("         committed at          : precised, but not traced\n");
                } else {
                    info.append("         committed at          : not available\n");
                }
                if (this.xaTrRollbackPosition != null) {
                    info.append("         rolledback at         : precised, but not traced\n");
                } else {
                    info.append("         rolledback at         : not available\n");
                }
            }
        }
        if (this.spiTrBornPosition == null && this.xaTrBornPosition == null) {
            info.append("none\n");
        }
        if (!(connHandlesInfoIter = this.handleWrappersHashSet.iterator()).hasNext()) {
            info.append("\n     none\n");
        } else {
            info.append("\n");
        }
        while (connHandlesInfoIter.hasNext()) {
            String connHandleInfo = ((HandleWrapper)connHandlesInfoIter.next()).getInfo(traceMode);
            info.append(connHandleInfo);
        }
        return info.toString();
    }

    public ConnectionHashSet getConnectionHashSet() {
        return this.mcSet;
    }

    public HashSet getConnectionHandlesInfo() {
        return this.handleWrappersHashSet;
    }

    private String getStackTrace() {
        return Log.getStackTrace();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

