/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.resource.impl;

import com.sap.engine.lib.util.base.LinearItemAdapter;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.connector.resource.impl.MCEventHandler;
import com.sap.engine.services.connector.resource.impl.ResourceSetImpl;
import com.sap.tc.logging.Location;
import javax.resource.ResourceException;

public final class HandleWrapper
extends LinearItemAdapter {
    private static Location location = Location.getLocation((Class)(class$com$sap$engine$services$connector$resource$impl$HandleWrapper == null ? (class$com$sap$engine$services$connector$resource$impl$HandleWrapper = HandleWrapper.class$("com.sap.engine.services.connector.resource.impl.HandleWrapper")) : class$com$sap$engine$services$connector$resource$impl$HandleWrapper));
    private static int severityDebug = 100;
    private Object handle = null;
    private MCEventHandler mcEventHandler = null;
    private boolean isShareable = false;
    private boolean isDelisted = true;
    private ResourceSetImpl resSet = null;
    public static final int NO_TRANSACTION = -1;
    public static final int LOCAL_CCI_TRANSACTION_STARTED = 0;
    public static final int LOCAL_CCI_TRANSACTION_COMMITED = 1;
    public static final int LOCAL_CCI_TRANSACTION_ROLLEDBACK = 2;
    private String creationPosition = null;
    private String cciTrBornPosition = null;
    private String cciTrCommitPosition = null;
    private String cciTrRollbackPosition = null;
    private int transactionStatus = -1;
    static /* synthetic */ Class class$com$sap$engine$services$connector$resource$impl$HandleWrapper;

    public HandleWrapper(Object handle, MCEventHandler mcEventHandler, boolean is_shareable) {
        this.handle = handle;
        this.mcEventHandler = mcEventHandler;
        this.isShareable = is_shareable;
        if (mcEventHandler.debugMode) {
            this.setCreationPosition();
        }
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".<constructor>(shareable: " + is_shareable + ")");
        }
    }

    public Object getHandle() {
        return this.handle;
    }

    public MCEventHandler getMcEventHandler() {
        return this.mcEventHandler;
    }

    public void setMcEventHandler(MCEventHandler newMCEventHandler) {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".setMcEventHandler(" + newMCEventHandler + "): " + this.mcEventHandler);
        }
        this.mcEventHandler = newMCEventHandler;
    }

    public boolean isShareable() {
        return this.isShareable();
    }

    public boolean isDelisted() {
        return this.isDelisted;
    }

    public void setDelisted(boolean flag) {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".setDelisted({0}): {1}", (Object[])new String[]{String.valueOf(flag), String.valueOf(this.isDelisted)});
        }
        this.isDelisted = flag;
    }

    public void removeItselfFromResourceSet(int flag) throws ResourceException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".removeItselfFromResourceSet({0})", (Object[])new String[]{String.valueOf(flag)});
        }
        if (this.resSet != null) {
            this.resSet.remove(this, flag);
        }
    }

    public void justRemoveFromResourceSet() throws ResourceException {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".justRemoveFromResourceSet({0})");
        }
        if (this.resSet != null) {
            this.resSet.removeHandleWrapper(this);
        }
    }

    public void setResourceSet(ResourceSetImpl rs_set) {
        if (location.beLogged(severityDebug)) {
            location.logT(100, "--> " + this + ".setResourceSet(" + rs_set + "): " + this.resSet);
        }
        this.resSet = rs_set;
    }

    public void setCreationPosition() {
        this.creationPosition = this.getStackTrace();
    }

    public synchronized String getCreationPosition() {
        return this.creationPosition;
    }

    public void setTransactionStatus(int transactionStatus) {
        if (transactionStatus > 2 || transactionStatus < -1) {
            throw new BaseIllegalArgumentException("connector_0313", new String[]{String.valueOf(transactionStatus)});
        }
        this.transactionStatus = transactionStatus;
        if (transactionStatus == 1) {
            this.cciTrCommitPosition = this.getStackTrace();
        } else if (transactionStatus == 2) {
            this.cciTrRollbackPosition = this.getStackTrace();
        } else {
            this.cciTrBornPosition = this.getStackTrace();
        }
    }

    public synchronized int getTransactionStatus() {
        return this.transactionStatus;
    }

    public synchronized String getTransactionBornPosition() {
        return this.cciTrBornPosition;
    }

    public synchronized String getTransactionCommitPosition() {
        return this.cciTrCommitPosition;
    }

    public synchronized String getTransactionRollbackPosition() {
        return this.cciTrRollbackPosition;
    }

    public String getInfo(boolean traceMode) {
        StringBuffer info = new StringBuffer();
        info.append("     ConnectionHandle : " + this.handle + "\n\n");
        if (traceMode) {
            info.append("        create or associate position           : " + this.creationPosition + "\n");
        } else {
            info.append("        create or associate position           : precised, but not traced\n");
        }
        info.append("        transaction status        : ");
        if (this.cciTrBornPosition != null) {
            info.append("        cci transaction status\n");
            if (traceMode) {
                info.append("              started at          : " + this.cciTrBornPosition + "\n");
                if (this.cciTrCommitPosition != null) {
                    info.append("              committed at        : " + this.cciTrCommitPosition + "\n");
                } else {
                    info.append("              committed at        : not available\n");
                }
                if (this.cciTrRollbackPosition != null) {
                    info.append("              rolledback at       : " + this.cciTrRollbackPosition + "\n");
                } else {
                    info.append("              rolledback at       : not available\n");
                }
            } else {
                info.append("              started at          : precised, but not traced\n");
                if (this.cciTrCommitPosition != null) {
                    info.append("              committed at        : precised, but not traced\n");
                } else {
                    info.append("              committed at        : not available\n");
                }
                if (this.cciTrRollbackPosition != null) {
                    info.append("              rolledback at       : precised, but not traced\n");
                } else {
                    info.append("              rolledback at       : not available\n");
                }
            }
        } else {
            info.append("  none\n");
        }
        return info.toString();
    }

    private synchronized String getStackTrace() {
        return Log.getStackTrace();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(super.toString()).append("[").append(this.handle).append("](delisted:").append(this.isDelisted).append(") -> ");
        if (this.mcEventHandler != null) {
            result.append(this.mcEventHandler);
        } else {
            result.append("not associated");
        }
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

