/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.gui;

import com.sap.engine.services.connector.jca.deploy.descriptor.ConfigProperty;
import com.sap.engine.services.connector.jca15.gui.AdvancedPropertiesTableModel;
import com.sap.engine.services.connector.jca15.gui.PropertyEditorView;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.JTextComponent;

public class PropertyEditor
extends PropertyEditorView {
    protected AdvancedPropertiesTableModel tableModel = new AdvancedPropertiesTableModel(new String[]{"Key", "Type", "Value", "Description"});
    protected ConfigProperty[] props;
    protected ChangeListener listener;

    public PropertyEditor(ActionListener saveButtonListener) {
        this.initEditor(saveButtonListener);
    }

    public void setChangeListener(ChangeListener cl) {
        this.listener = cl;
    }

    private void initEditor(ActionListener saveButtonListener) {
        this.table.setModel(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.keyTextField.addKeyListener(this);
        this.keyTextField.getDocument().addDocumentListener(this);
        this.valueTextField.addKeyListener(this);
    }

    public void setFrame(Frame frame) {
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.addButton) {
            this.addBtnAction();
        } else if (source == this.removeButton) {
            this.removeBtnAction();
        }
    }

    private void addBtnAction() {
        if (this.keyTextField.getText().trim().length() == 0) {
            return;
        }
        this.tableModel.addRow(this.keyTextField.getText().trim(), (String)this.typeComboBox.getSelectedItem(), this.valueTextField.getText().trim(), this.descriptionTextField.getText().trim());
        this.keyTextField.setText("");
        ((JTextComponent)this.valueTextField).setText("");
        this.descriptionTextField.setText("");
        this.keyTextField.requestFocus();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    private void removeBtnAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        this.tableModel.removeRow(selRow);
        if (selRow >= this.table.getRowCount() && this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
        this.table_valueChanged();
        if (this.listener != null) {
            this.listener.stateChanged(null);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        this.table_valueChanged();
    }

    private void table_valueChanged() {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.removeButton.setEnabled(false);
            return;
        }
        this.removeButton.setEnabled(true);
        this.keyTextField.setText((String)this.tableModel.getValueAt(row, 0));
        this.typeComboBox.setSelectedItem(this.tableModel.getValueAt(row, 1));
        ((JTextComponent)this.valueTextField).setText((String)this.tableModel.getValueAt(row, 2));
        this.descriptionTextField.setText((String)this.tableModel.getValueAt(row, 3));
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.addBtnAction();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void changedUpdate(DocumentEvent de) {
        if (de.getDocument() == this.keyTextField.getDocument()) {
            this.propertyTypeChanged();
        }
    }

    public void insertUpdate(DocumentEvent de) {
        if (de.getDocument() == this.keyTextField.getDocument()) {
            this.propertyTypeChanged();
        }
    }

    public void removeUpdate(DocumentEvent de) {
        if (de.getDocument() == this.keyTextField.getDocument()) {
            this.propertyTypeChanged();
        }
    }

    public void propertyTypeChanged() {
        if (this.keyTextField.getText().trim().equalsIgnoreCase("password")) {
            if (!this.valueTextField.echoCharIsSet()) {
                ((JTextComponent)this.valueTextField).setText("");
                this.valueTextField.setEchoChar('*');
            }
        } else if (this.valueTextField.echoCharIsSet()) {
            ((JTextComponent)this.valueTextField).setText("");
            this.valueTextField.setEchoChar('\u0000');
        }
    }

    public void initProperties(ConfigProperty[] properties) {
        this.tableModel.clearAll();
        this.keyTextField.setText("");
        ((JTextComponent)this.valueTextField).setText("");
        this.descriptionTextField.setText("");
        this.table.getSelectionModel().clearSelection();
        if (properties == null) {
            return;
        }
        this.props = properties;
        int i = 0;
        while (i < properties.length) {
            ConfigProperty prop = properties[i];
            this.tableModel.addRow(prop.getConfigPropertyName(), prop.getConfigPropertyType(), prop.getConfigPropertyValue(), prop.getDescription());
            ++i;
        }
    }

    public Properties getProps() {
        Properties properties = new Properties();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            properties.setProperty((String)this.tableModel.getValueAt(i, 0), (String)this.tableModel.getValueAt(i, 1));
            ++i;
        }
        return properties;
    }

    public ConfigProperty[] getProperties() {
        int size = this.tableModel.getRowCount();
        ConfigProperty[] all = new ConfigProperty[size];
        int i = 0;
        while (i < size) {
            ConfigProperty prop = new ConfigProperty();
            prop.setConfigPropertyName((String)this.tableModel.data[0].get(i));
            prop.setConfigPropertyType((String)this.tableModel.data[1].get(i));
            prop.setConfigPropertyValue((String)this.tableModel.data[2].get(i));
            prop.setDescription((String)this.tableModel.data[3].get(i));
            all[i] = prop;
            ++i;
        }
        return all;
    }
}

