/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.gui;

import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectionDefinition;
import com.sap.engine.services.connector.jca15.gui.PoolPropsEditorView;
import java.awt.event.ItemEvent;

public class PoolPropsEditorLogical
extends PoolPropsEditorView {
    protected Object descr = null;

    public void itemStateChanged(ItemEvent ie) {
        Object src = ie.getSource();
        if (src == this.expCheckBox) {
            this.expAction();
        }
    }

    private void expAction() {
        this.connLifeField.setEnabled(this.expCheckBox.isSelected());
        this.runThreadField.setEnabled(this.expCheckBox.isSelected());
        if (!this.expCheckBox.isSelected()) {
            this.connLifeField.setValue(0);
            this.runThreadField.setValue(0);
        }
    }

    public void updateConnectionPoolPanel(Object descr) {
        if (descr instanceof JCDescriptor) {
            this.updateConnectionPoolPanel((JCDescriptor)descr);
        } else {
            this.updateConnectionPoolPanel((ConnectionDefinition)descr);
        }
    }

    private void updateConnectionPoolPanel(JCDescriptor descr) {
        this.maxConnField.setValue(descr.getMaxConnectionsNumber());
        this.ttwConnField.setValue(descr.getMaxTimeToWaitConnection());
        this.expCheckBox.setSelected(descr.getConnectionLifetime() > 0 && descr.getRunCleanupThreadTime() > 0);
        this.expAction();
        this.connLifeField.setValue(descr.getConnectionLifetime());
        this.runThreadField.setValue(descr.getRunCleanupThreadTime());
        this.descr = descr;
    }

    private void updateConnectionPoolPanel(ConnectionDefinition descr) {
        this.maxConnField.setValue(descr.getMaxConnectionsNumber());
        this.ttwConnField.setValue(descr.getMaxTimeToWaitConnection());
        this.expCheckBox.setSelected(descr.getConnectionLifeTime() > 0 && descr.getRunCleanupThreadTime() > 0);
        this.expAction();
        this.connLifeField.setValue(descr.getConnectionLifeTime());
        this.runThreadField.setValue(descr.getRunCleanupThreadTime());
        this.descr = descr;
    }

    public void setToDescriptor(Object descr) {
        if (descr instanceof JCDescriptor) {
            this.updateDescriptorFromGui((JCDescriptor)descr);
        } else {
            this.updateConnDefinitionFromGui((ConnectionDefinition)descr);
        }
    }

    private void updateDescriptorFromGui(JCDescriptor descr) {
        descr.setMaxConnectionsNumber(this.maxConnField.getValue());
        descr.setMaxTimeToWaitConnection(this.ttwConnField.getValue());
        descr.setConnectionLifetime(this.connLifeField.getValue());
        descr.setRunCleanupThreadTime(this.runThreadField.getValue());
    }

    private void updateConnDefinitionFromGui(ConnectionDefinition descr) {
        descr.setMaxConnectionsNumber(this.maxConnField.getValue());
        descr.setMaxTimeToWaitConnection(this.ttwConnField.getValue());
        descr.setConnectionLifeTime(this.connLifeField.getValue());
        descr.setRunCleanupThreadTime(this.runThreadField.getValue());
    }
}

