/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.UnsupportedEditorException;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.services.connector.jca.deploy.descriptor.AuthMechanism;
import com.sap.engine.services.connector.jca.deploy.descriptor.ConfigProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.DriverInfo;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.ManagedFactoryProperty;
import com.sap.engine.services.connector.jca.deploy.descriptor.SecurityPermission;
import com.sap.engine.services.connector.jca15.gui.ApplicationNode;
import com.sap.engine.services.connector.jca15.gui.ConnectorTree;
import com.sap.engine.services.connector.jca15.gui.ErrorDialog;
import com.sap.engine.services.connector.jca15.gui.PoolPropsEditorLogical;
import com.sap.engine.services.connector.jca15.gui.PropertiesTableModel;
import com.sap.engine.services.connector.jca15.gui.PropertyEditor;
import com.sap.engine.services.connector.jca15.gui.RuntimeControls;
import com.sap.engine.services.connector.jca15.gui.SimpleListPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class GeneralRuntimeControlView
extends JPanel
implements VisualRuntimeControl,
TreeSelectionListener,
ActionListener {
    public static final String[] COLUMN_NAMES = new String[]{"Name", "Type", "Value", "Description"};
    public static final String[] COLUMN_NAMES1 = new String[]{"Name", "Description"};
    public static final String[] COLUMN_NAMES_ALIASES = new String[]{"Name"};
    public static final String[] COLUMN_NAMES_DRIVERS = new String[]{"Driver Name", "Driver Class Name", "File Names"};
    public static final String[] COLUMN_NAMES_SECURITY = new String[]{"Security Permission Spec", "Description"};
    public static final String[] COLUMN_NAMES_AUTH = new String[]{"Authentication Mechanism Type", "Credential Interface", "Description"};
    public static final String[] COLUMN_NAMES_PROPERTIES = new String[]{"Key", "Value"};
    public static final String[] COLUMN_NAMES_IDENT_SUB = new String[]{"Resource Principal", "Caller Principal"};
    protected JSplitPane splitPanel = null;
    protected JSplitPane outboundSplitPanel = null;
    protected JSplitPane inboundSplitPanel = null;
    protected JPanel rightPanel = null;
    protected JPanel infoPanel = null;
    protected JPanel raPanel = null;
    protected JPanel propertiesPanel = null;
    protected JPanel leftPanel = null;
    protected JPanel outboundLeftPanel = null;
    protected JPanel inboundLeftPanel = null;
    protected JPanel messageListenerPanel = null;
    protected JPanel messageRightPanel = null;
    protected JPanel messPropertiesPanel = null;
    protected JPanel connDefPanel = null;
    protected PoolPropsEditorLogical connDefPoolPropsPanel = null;
    protected JPanel connDefPropsPanel = null;
    protected JPanel connRightPanel = null;
    protected JPanel connPropertiesPanel = null;
    protected PropertyEditor connPropertiesEditor = null;
    protected SimpleListPanel aliasesPanel = null;
    protected JPanel loadersPanel = null;
    protected JPanel driversPanel = null;
    protected JPanel securityPanel = null;
    protected JPanel authPanel = null;
    protected JPanel outboundGeneralPanel = null;
    protected JPanel connector10MainPanel = null;
    protected JPanel secPanel = null;
    protected JPanel identitySubjectPanel = null;
    protected ConnectorTree connectorsTree = null;
    protected ConnectorTree outboundRATree = null;
    protected ConnectorTree inboundRATree = null;
    protected JScrollPane scrollPanel = null;
    protected JScrollPane outboundScrollPanel = null;
    protected JScrollPane inboundScrollPanel = null;
    protected JTabbedPane tabbedPanel = null;
    protected JTabbedPane generalPanel = null;
    protected JTabbedPane outboundTabbedPanel = null;
    protected JTabbedPane connTabbedPanel = null;
    protected JTabbedPane connector10Panel = null;
    protected Frame frame = null;
    protected JLabel displayNameLabel = null;
    protected JLabel descriptionLabel = null;
    protected JLabel vendorNameLabel = null;
    protected JLabel eisTypeLabel = null;
    protected JLabel resourceAdapterVersionLabel = null;
    protected JLabel licenseDescriptionLabel = null;
    protected JLabel isLicenseRequiredLabel = null;
    protected JLabel rarNameLabel = null;
    protected JLabel isRealApplicationLabel = null;
    protected JLabel raClassLabel = null;
    protected JLabel activationSpecLabel = null;
    protected JLabel messageListenerLabel = null;
    protected JLabel connFactInterfaceLabel = null;
    protected JLabel connFactImplLabel = null;
    protected JLabel connInterfaceLabel = null;
    protected JLabel connImplLabel = null;
    protected JLabel jndiLabel = null;
    protected JLabel raJndiLabel = null;
    protected JLabel connectorGroupLabel = null;
    protected JLabel transactionSupportLabel = null;
    protected JLabel reauthenticationSupportLabel = null;
    protected JLabel specVersionLabel = null;
    protected JLabel mcfClassLabel = null;
    protected JLabel authTypeLabel = null;
    protected JLabel userStoreLabel = null;
    protected JLabel internalUserStoreLabel = null;
    protected JTextArea descriptionArea = null;
    protected JTextArea licenseDescriptionArea = null;
    protected JTextField displayNameField = null;
    protected JTextField vendorNameField = null;
    protected JTextField eisTypeField = null;
    protected JTextField resourceAdapterVersionField = null;
    protected JTextField rarNameField = null;
    protected JTextField raClassField = null;
    protected JTextField activationSpecField = null;
    protected JTextField messageListenerField = null;
    protected JTextField connFactInterfaceField = null;
    protected JTextField connFactImplField = null;
    protected JTextField connInterfaceField = null;
    protected JTextField connImplField = null;
    protected JTextField jndiField = null;
    protected JTextField raJndiField = null;
    protected JTextField connectorGroupField = null;
    protected JTextField transactionSupportField = null;
    protected JTextField specVersionField = null;
    protected JTextField mcfClassField = null;
    protected JTextField authTypeField = null;
    protected JTextField userStoreField = null;
    protected JCheckBox reauthenticationSupportBox = null;
    protected JCheckBox isLicenseRequiredBox = null;
    protected JCheckBox isRealApplicationBox = null;
    protected JCheckBox isInternalStoreBox = null;
    protected JTable raPropertiesTable = null;
    protected JTable messPropertiesTable = null;
    protected JTable connPropertiesTable = null;
    protected JTable loadersTable = null;
    protected JTable driversTable = null;
    protected JTable securityTable = null;
    protected JTable authTable = null;
    protected JTable identitySubjectTable = null;
    protected PropertiesTableModel tableModel = null;
    protected SimpleListPanel classLoaderReferencesPanel;
    protected JButton[] runtimeButtons;
    protected JButton copyBtn;
    protected JButton removeBtn;
    protected JButton saveBtn;
    protected JButton refreshBtn;
    protected JButton startBtn;
    protected JButton stopBtn;
    protected Object[][] data = null;
    protected JCDescriptor currentJCDescriptor;
    protected String currentAppName;
    protected RuntimeControls runtime;

    public GeneralRuntimeControlView() {
        this.init();
        this.initRuntimeButtons();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.connectorsTree = new ConnectorTree("Connectors");
        this.connectorsTree.addTreeSelectionListener(this);
        this.scrollPanel = new JScrollPane(this.connectorsTree);
        this.scrollPanel.setPreferredSize(new Dimension(20, 40));
        this.leftPanel = new JPanel(new GridBagLayout());
        this.leftPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Connector Container"));
        this.leftPanel.add((Component)this.scrollPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.tabbedPanel = new JTabbedPane();
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.add(this.tabbedPanel);
        this.splitPanel = new JSplitPane(1, true, this.leftPanel, this.rightPanel);
        this.splitPanel.setDividerLocation(225);
        this.add((Component)this.splitPanel, "Center");
    }

    public void initRuntimeButtons() {
        this.runtimeButtons = new JButton[6];
        this.copyBtn = new JButton(new ImageIcon(this.getClass().getResource("images/copy.gif")));
        this.copyBtn.setToolTipText("Clone");
        this.copyBtn.addActionListener(this);
        this.copyBtn.setEnabled(false);
        this.runtimeButtons[0] = this.copyBtn;
        this.removeBtn = new JButton(new ImageIcon(this.getClass().getResource("images/remove.gif")));
        this.removeBtn.setToolTipText("Remove");
        this.removeBtn.addActionListener(this);
        this.removeBtn.setEnabled(false);
        this.runtimeButtons[1] = this.removeBtn;
        this.saveBtn = new JButton(new ImageIcon(this.getClass().getResource("images/save.gif")));
        this.saveBtn.setToolTipText("Save Changes");
        this.saveBtn.addActionListener(this);
        this.saveBtn.setEnabled(false);
        this.runtimeButtons[2] = this.saveBtn;
        this.refreshBtn = new JButton(new ImageIcon(this.getClass().getResource("images/refresh.gif")));
        this.refreshBtn.setToolTipText("Refresh");
        this.refreshBtn.addActionListener(this);
        this.runtimeButtons[3] = this.refreshBtn;
        this.startBtn = new JButton(new ImageIcon(this.getClass().getResource("images/start.gif")));
        this.startBtn.setToolTipText("Start");
        this.startBtn.addActionListener(this);
        this.startBtn.setEnabled(false);
        this.runtimeButtons[4] = this.startBtn;
        this.stopBtn = new JButton(new ImageIcon(this.getClass().getResource("images/stop.gif")));
        this.stopBtn.setToolTipText("Stop");
        this.stopBtn.addActionListener(this);
        this.stopBtn.setEnabled(false);
        this.runtimeButtons[5] = this.stopBtn;
    }

    public void initDriverPanel() {
        this.driversPanel = new JPanel(new GridBagLayout());
        this.driversTable = new JTable();
        JScrollPane scrollPane1 = new JScrollPane(this.driversTable);
        scrollPane1.setBorder(BorderFactory.createEtchedBorder());
        this.driversPanel.add((Component)scrollPane1, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void initSecurityPanel() {
        this.securityPanel = new JPanel(new GridBagLayout());
        this.securityTable = new JTable();
        JScrollPane scrollPane1 = new JScrollPane(this.securityTable);
        scrollPane1.setBorder(BorderFactory.createEtchedBorder());
        this.securityPanel.add((Component)scrollPane1, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void initOutboundRAPanel() {
        this.outboundTabbedPanel = new JTabbedPane();
        this.initOutboundGeneralPanel();
        this.outboundTabbedPanel.add("Main", this.outboundGeneralPanel);
        this.outboundRATree = new ConnectorTree("MCF");
        this.outboundRATree.addTreeSelectionListener(this);
        this.outboundScrollPanel = new JScrollPane(this.outboundRATree);
        this.outboundScrollPanel.setPreferredSize(new Dimension(20, 40));
        this.outboundLeftPanel = new JPanel(new GridBagLayout());
        this.outboundLeftPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "MCF"));
        this.outboundLeftPanel.add((Component)this.outboundScrollPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.connTabbedPanel = new JTabbedPane();
        this.connRightPanel = new JPanel(new BorderLayout());
        this.connRightPanel.add(this.connTabbedPanel);
        this.outboundSplitPanel = new JSplitPane(1, true, this.outboundLeftPanel, this.connRightPanel);
        this.outboundSplitPanel.setDividerLocation(300);
        this.outboundTabbedPanel.add("Connection Definitions", this.outboundSplitPanel);
    }

    public void initOutboundGeneralPanel() {
        this.outboundGeneralPanel = new JPanel(new GridBagLayout());
        this.transactionSupportLabel = new JLabel("Transaction Support :");
        this.outboundGeneralPanel.add((Component)this.transactionSupportLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.transactionSupportField = new JTextField();
        this.transactionSupportField.setEnabled(false);
        this.outboundGeneralPanel.add((Component)this.transactionSupportField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.reauthenticationSupportLabel = new JLabel("Reauthentication Support :");
        this.outboundGeneralPanel.add((Component)this.reauthenticationSupportLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.reauthenticationSupportBox = new JCheckBox();
        this.reauthenticationSupportBox.setEnabled(false);
        this.outboundGeneralPanel.add((Component)this.reauthenticationSupportBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.authPanel = new JPanel(new GridBagLayout());
        this.authPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), "Authentication Mechanisms"));
        this.authTable = new JTable();
        JScrollPane scrollPane1 = new JScrollPane(this.authTable);
        scrollPane1.setBorder(BorderFactory.createEtchedBorder());
        this.authPanel.add((Component)scrollPane1, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.outboundGeneralPanel.add((Component)this.authPanel, new GridBagConstraints(0, 2, 2, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void initInboundRAPanel() {
        this.inboundRATree = new ConnectorTree("Inbound Resource Adapter");
        this.inboundRATree.addTreeSelectionListener(this);
        this.inboundScrollPanel = new JScrollPane(this.inboundRATree);
        this.inboundScrollPanel.setPreferredSize(new Dimension(20, 40));
        this.inboundLeftPanel = new JPanel(new GridBagLayout());
        this.inboundLeftPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Inbound Resource Adapter"));
        this.inboundLeftPanel.add((Component)this.inboundScrollPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.messageListenerPanel = new JPanel();
        this.messageRightPanel = new JPanel(new BorderLayout());
        this.messageRightPanel.add(this.messageListenerPanel);
        this.inboundSplitPanel = new JSplitPane(1, true, this.inboundLeftPanel, this.messageRightPanel);
        this.inboundSplitPanel.setDividerLocation(300);
    }

    public void initConnectionDefinitionPanel() {
        this.connTabbedPanel = new JTabbedPane(3);
        this.connDefPanel = new JPanel(new GridBagLayout());
        this.connDefPropsPanel = new JPanel(new GridBagLayout());
        this.connFactInterfaceLabel = new JLabel("Connection Factory Interface :");
        this.connDefPanel.add((Component)this.connFactInterfaceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.connFactInterfaceField = new JTextField();
        this.connFactInterfaceField.setEnabled(false);
        this.connDefPanel.add((Component)this.connFactInterfaceField, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.connFactImplLabel = new JLabel("Connection Factory Impl Class :");
        this.connDefPanel.add((Component)this.connFactImplLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.connFactImplField = new JTextField();
        this.connFactImplField.setEnabled(false);
        this.connDefPanel.add((Component)this.connFactImplField, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.connInterfaceLabel = new JLabel("Connection Interface :");
        this.connDefPanel.add((Component)this.connInterfaceLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.connInterfaceField = new JTextField();
        this.connInterfaceField.setEnabled(false);
        this.connDefPanel.add((Component)this.connInterfaceField, new GridBagConstraints(0, 5, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.connImplLabel = new JLabel("Connection Impl Class :");
        this.connDefPanel.add((Component)this.connImplLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.connImplField = new JTextField();
        this.connImplField.setEnabled(false);
        this.connDefPanel.add((Component)this.connImplField, new GridBagConstraints(0, 7, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jndiLabel = new JLabel("JNDI Name :");
        this.connDefPanel.add((Component)this.jndiLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jndiField = new JTextField();
        this.jndiField.setEnabled(false);
        this.connDefPanel.add((Component)this.jndiField, new GridBagConstraints(0, 9, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.connDefPoolPropsPanel = new PoolPropsEditorLogical();
        this.connDefPanel.add((Component)this.connDefPoolPropsPanel, new GridBagConstraints(0, 10, 2, 1, 1.0, 0.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.connPropertiesPanel = new JPanel(new GridBagLayout());
        this.connPropertiesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), "Configuration Properties"));
        this.connPropertiesTable = new JTable();
        JScrollPane scrollPane = new JScrollPane(this.connPropertiesTable);
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.connPropertiesPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.connDefPropsPanel.add((Component)this.connPropertiesPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.aliasesPanel = new SimpleListPanel();
        this.aliasesPanel.setQuestionParameters("Aliases", "Add new alias:", "Edit alias:", "Alias", "Alias");
        this.connDefPropsPanel.add((Component)this.aliasesPanel, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.connTabbedPanel.add("Connections", this.connDefPanel);
        this.connTabbedPanel.add("Properties", this.connDefPropsPanel);
        this.connRightPanel.add(this.connTabbedPanel);
    }

    public void initMessageListenerPanel() {
        this.messageListenerPanel = new JPanel(new GridBagLayout());
        this.messageListenerPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), "Message Listener Information"));
        this.activationSpecLabel = new JLabel("Activation Specification Class Name :");
        this.messageListenerPanel.add((Component)this.activationSpecLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.activationSpecField = new JTextField();
        this.activationSpecField.setEnabled(false);
        this.messageListenerPanel.add((Component)this.activationSpecField, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.messageListenerLabel = new JLabel("Message Listener Name :");
        this.messageListenerPanel.add((Component)this.messageListenerLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.messageListenerField = new JTextField();
        this.messageListenerField.setEnabled(false);
        this.messageListenerPanel.add((Component)this.messageListenerField, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.messPropertiesPanel = new JPanel(new GridBagLayout());
        this.messPropertiesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), "Required Properties"));
        this.messPropertiesTable = new JTable();
        JScrollPane scrollPane = new JScrollPane(this.messPropertiesTable);
        scrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.messPropertiesPanel.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.messageListenerPanel.add((Component)this.messPropertiesPanel, new GridBagConstraints(0, 4, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.messageRightPanel.add(this.messageListenerPanel);
    }

    public void initConnector10() {
        this.connector10Panel = new JTabbedPane();
        this.connector10MainPanel = new JPanel(new GridBagLayout());
        this.connector10Panel.add("General", this.connector10MainPanel);
        this.displayNameLabel = new JLabel("Display Name :");
        this.connector10MainPanel.add((Component)this.displayNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.displayNameField = new JTextField();
        this.displayNameField.setEnabled(false);
        this.connector10MainPanel.add((Component)this.displayNameField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.descriptionLabel = new JLabel("Description :");
        this.connector10MainPanel.add((Component)this.descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.descriptionArea = new JTextArea();
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setLineWrap(true);
        JScrollPane scrPane1 = new JScrollPane(this.descriptionArea);
        this.connector10MainPanel.add((Component)scrPane1, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.vendorNameLabel = new JLabel("Vendor Name :");
        this.connector10MainPanel.add((Component)this.vendorNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.vendorNameField = new JTextField();
        this.vendorNameField.setEnabled(false);
        this.connector10MainPanel.add((Component)this.vendorNameField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.specVersionLabel = new JLabel("Spec Version :");
        this.connector10MainPanel.add((Component)this.specVersionLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.specVersionField = new JTextField();
        this.specVersionField.setEnabled(false);
        this.connector10MainPanel.add((Component)this.specVersionField, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.eisTypeLabel = new JLabel("EIS Type :");
        this.connector10MainPanel.add((Component)this.eisTypeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.eisTypeField = new JTextField();
        this.eisTypeField.setEnabled(false);
        this.connector10MainPanel.add((Component)this.eisTypeField, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.resourceAdapterVersionLabel = new JLabel("Version :");
        this.connector10MainPanel.add((Component)this.resourceAdapterVersionLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.resourceAdapterVersionField = new JTextField();
        this.resourceAdapterVersionField.setEnabled(false);
        this.connector10MainPanel.add((Component)this.resourceAdapterVersionField, new GridBagConstraints(1, 5, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.licenseDescriptionLabel = new JLabel("License Description :");
        this.connector10MainPanel.add((Component)this.licenseDescriptionLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.licenseDescriptionArea = new JTextArea();
        this.licenseDescriptionArea.setEditable(false);
        this.licenseDescriptionArea.setLineWrap(true);
        JScrollPane scrPane2 = new JScrollPane(this.licenseDescriptionArea);
        this.connector10MainPanel.add((Component)scrPane2, new GridBagConstraints(1, 6, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.isLicenseRequiredLabel = new JLabel("Is License Required :");
        this.connector10MainPanel.add((Component)this.isLicenseRequiredLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.isLicenseRequiredBox = new JCheckBox();
        this.isLicenseRequiredBox.setEnabled(false);
        this.connector10MainPanel.add((Component)this.isLicenseRequiredBox, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.rarNameLabel = new JLabel("Rar File Name :");
        this.connector10MainPanel.add((Component)this.rarNameLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.rarNameField = new JTextField();
        this.rarNameField.setEnabled(false);
        this.connector10MainPanel.add((Component)this.rarNameField, new GridBagConstraints(1, 8, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.isRealApplicationLabel = new JLabel("Is Real Application :");
        this.connector10MainPanel.add((Component)this.isRealApplicationLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.isRealApplicationBox = new JCheckBox();
        this.isRealApplicationBox.setEnabled(false);
        this.connector10MainPanel.add((Component)this.isRealApplicationBox, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.raPanel = new JPanel(new GridBagLayout());
        this.connector10Panel.add("Resource Adapter", this.raPanel);
        this.connectorGroupLabel = new JLabel("Connector Group :");
        this.raPanel.add((Component)this.connectorGroupLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.connectorGroupField = new JTextField();
        this.connectorGroupField.setEnabled(false);
        this.raPanel.add((Component)this.connectorGroupField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.propertiesPanel = new JPanel(new GridBagLayout());
        this.propertiesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), "Additional Properties"));
        this.raPropertiesTable = new JTable();
        JScrollPane scrollPane4 = new JScrollPane(this.raPropertiesTable);
        scrollPane4.setBorder(BorderFactory.createEtchedBorder());
        this.propertiesPanel.add((Component)scrollPane4, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.raPanel.add((Component)this.propertiesPanel, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.classLoaderReferencesPanel = new SimpleListPanel();
        this.classLoaderReferencesPanel.setQuestionParameters("Loader References", "Add new loader reference:", "Edit loader reference:", "Loader Reference", "Loader Reference");
        this.raPanel.add((Component)this.classLoaderReferencesPanel, new GridBagConstraints(0, 2, 2, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.outboundTabbedPanel = new JTabbedPane();
        this.connector10Panel.add("Managed Connection Factory", this.outboundTabbedPanel);
        this.outboundGeneralPanel = new JPanel(new GridBagLayout());
        this.outboundTabbedPanel.add("Main", this.outboundGeneralPanel);
        this.mcfClassLabel = new JLabel("Managed Connection Factory Class :");
        this.outboundGeneralPanel.add((Component)this.mcfClassLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mcfClassField = new JTextField();
        this.mcfClassField.setEnabled(false);
        this.outboundGeneralPanel.add((Component)this.mcfClassField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.transactionSupportLabel = new JLabel("Transaction Support :");
        this.outboundGeneralPanel.add((Component)this.transactionSupportLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.transactionSupportField = new JTextField();
        this.transactionSupportField.setEnabled(false);
        this.outboundGeneralPanel.add((Component)this.transactionSupportField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.reauthenticationSupportLabel = new JLabel("Reauthentication Support :");
        this.outboundGeneralPanel.add((Component)this.reauthenticationSupportLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.reauthenticationSupportBox = new JCheckBox();
        this.reauthenticationSupportBox.setEnabled(false);
        this.outboundGeneralPanel.add((Component)this.reauthenticationSupportBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.authPanel = new JPanel(new GridBagLayout());
        this.authPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), "Authentication Mechanisms"));
        this.authTable = new JTable();
        JScrollPane scrollPane1 = new JScrollPane(this.authTable);
        scrollPane1.setBorder(BorderFactory.createEtchedBorder());
        this.authPanel.add((Component)scrollPane1, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.outboundGeneralPanel.add((Component)this.authPanel, new GridBagConstraints(0, 3, 2, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.connDefPanel = new JPanel(new GridBagLayout());
        this.connDefPropsPanel = new JPanel(new GridBagLayout());
        this.outboundTabbedPanel.add("Connection Definition", this.connDefPanel);
        this.outboundTabbedPanel.add("Properties", this.connDefPropsPanel);
        this.connFactInterfaceLabel = new JLabel("Connection Factory Interface :");
        this.connDefPanel.add((Component)this.connFactInterfaceLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.connFactInterfaceField = new JTextField();
        this.connFactInterfaceField.setEnabled(false);
        this.connDefPanel.add((Component)this.connFactInterfaceField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.connFactImplLabel = new JLabel("Connection Factory Impl Class :");
        this.connDefPanel.add((Component)this.connFactImplLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.connFactImplField = new JTextField();
        this.connFactImplField.setEnabled(false);
        this.connDefPanel.add((Component)this.connFactImplField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.connInterfaceLabel = new JLabel("Connection Interface :");
        this.connDefPanel.add((Component)this.connInterfaceLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.connInterfaceField = new JTextField();
        this.connInterfaceField.setEnabled(false);
        this.connDefPanel.add((Component)this.connInterfaceField, new GridBagConstraints(1, 2, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.connImplLabel = new JLabel("Connection Impl Class :");
        this.connDefPanel.add((Component)this.connImplLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.connImplField = new JTextField();
        this.connImplField.setEnabled(false);
        this.connDefPanel.add((Component)this.connImplField, new GridBagConstraints(1, 3, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jndiLabel = new JLabel("Connector JNDI Name :");
        this.connDefPanel.add((Component)this.jndiLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jndiField = new JTextField();
        this.jndiField.setEnabled(false);
        this.connDefPanel.add((Component)this.jndiField, new GridBagConstraints(1, 4, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.connDefPoolPropsPanel = new PoolPropsEditorLogical();
        this.connDefPanel.add((Component)this.connDefPoolPropsPanel, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.3, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.connPropertiesPanel = new JPanel(new GridBagLayout());
        this.connPropertiesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), "Configuration Properties"));
        this.connPropertiesEditor = new PropertyEditor(this);
        this.connPropertiesPanel.add((Component)this.connPropertiesEditor, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.connDefPropsPanel.add((Component)this.connPropertiesPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.aliasesPanel = new SimpleListPanel();
        this.aliasesPanel.setQuestionParameters("Aliases", "Add new alias:", "Edit alias:", "Alias", "Alias");
        this.connDefPropsPanel.add((Component)this.aliasesPanel, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.securityPanel = new JPanel(new GridBagLayout());
        this.connector10Panel.add("Security", this.securityPanel);
        this.authTypeLabel = new JLabel("Auth Type :");
        this.securityPanel.add((Component)this.authTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.authTypeField = new JTextField();
        this.authTypeField.setEnabled(false);
        this.securityPanel.add((Component)this.authTypeField, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.userStoreLabel = new JLabel("User Store :");
        this.securityPanel.add((Component)this.userStoreLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.userStoreField = new JTextField();
        this.userStoreField.setEnabled(false);
        this.securityPanel.add((Component)this.userStoreField, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.internalUserStoreLabel = new JLabel("Is Internal Store :");
        this.securityPanel.add((Component)this.internalUserStoreLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.isInternalStoreBox = new JCheckBox();
        this.isInternalStoreBox.setEnabled(false);
        this.securityPanel.add((Component)this.isInternalStoreBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.identitySubjectPanel = new JPanel(new GridBagLayout());
        this.identitySubjectPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), "Identity Subjects"));
        this.identitySubjectTable = new JTable();
        JScrollPane scrollPane7 = new JScrollPane(this.identitySubjectTable);
        scrollPane7.setBorder(BorderFactory.createEtchedBorder());
        this.identitySubjectPanel.add((Component)scrollPane7, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.securityPanel.add((Component)this.identitySubjectPanel, new GridBagConstraints(0, 3, 2, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.secPanel = new JPanel(new GridBagLayout());
        this.secPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), "Security Permissions"));
        this.securityTable = new JTable();
        JScrollPane scrollPane6 = new JScrollPane(this.securityTable);
        scrollPane6.setBorder(BorderFactory.createEtchedBorder());
        this.secPanel.add((Component)scrollPane6, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.securityPanel.add((Component)this.secPanel, new GridBagConstraints(0, 4, 2, 1, 0.1, 0.1, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.initDriverPanel();
        this.connector10Panel.add("Drivers", this.driversPanel);
        this.rightPanel.add(this.connector10Panel);
    }

    public void valueChanged(TreeSelectionEvent tse) {
        JCDescriptor oldDescr = null;
        if (tse.getNewLeadSelectionPath() != null) {
            oldDescr = this.currentJCDescriptor;
        }
        JCDescriptor guiJCDescriptor = null;
        if (oldDescr != null) {
            guiJCDescriptor = (JCDescriptor)oldDescr.clone();
            this.fillDescriptorFromGui(guiJCDescriptor);
            if (!guiJCDescriptor.equals(oldDescr)) {
                final TreePath oldPath = tse.getOldLeadSelectionPath();
                int result = JOptionPane.showConfirmDialog(this.frame, "Do you want to save changes?", "Question", 1);
                if (result == 0) {
                    try {
                        this.runtime.updateConnectorSP10(guiJCDescriptor.getApplicationName(), guiJCDescriptor);
                        JOptionPane.showMessageDialog(this.frame, "Save successuful.");
                    }
                    catch (Exception exc) {
                        ErrorDialog.showErrorDialog(this.frame, exc.getMessage(), exc);
                    }
                    this.refresh();
                } else if (result == 2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GeneralRuntimeControlView.this.connectorsTree.setSelectionPath(oldPath);
                        }
                    });
                }
            }
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.connectorsTree.getLastSelectedPathComponent();
        ApplicationNode appNode = null;
        this.currentAppName = null;
        this.currentJCDescriptor = null;
        if (node instanceof ApplicationNode) {
            appNode = (ApplicationNode)node;
            this.currentAppName = appNode.getAppName();
            this.currentJCDescriptor = appNode.getJCDescriptor();
        }
        this.checkButtons(appNode);
        if (appNode == null || this.currentJCDescriptor == null) {
            this.rightPanel.removeAll();
            this.rightPanel.validate();
            this.rightPanel.repaint();
            return;
        }
        AuthMechanism[] authMechanisms = this.currentJCDescriptor.getAuthMechanisms();
        ManagedFactoryProperty property = this.currentJCDescriptor.getManagedFactoryProperty();
        String[] aliases = this.currentJCDescriptor.getAliases();
        ConfigProperty[] props = null;
        props = property == null || property.getConfigProperties() == null ? new ConfigProperty[]{} : property.getConfigProperties();
        DriverInfo[] drivers = this.currentJCDescriptor.getDrivers();
        Properties addProps = this.currentJCDescriptor.getProperties();
        String[] loaders = this.currentJCDescriptor.getLoaderReferences();
        SecurityPermission[] securityPermissions = this.currentJCDescriptor.getSecurityPermissions();
        IdentitySubject[] identitySubjects = this.currentJCDescriptor.getIdentitySubjects();
        this.rightPanel.removeAll();
        this.initConnector10();
        this.displayNameField.setText(this.currentJCDescriptor.getDisplayName());
        this.descriptionArea.setText(this.currentJCDescriptor.getDescription());
        this.vendorNameField.setText(this.currentJCDescriptor.getVendorName());
        this.specVersionField.setText(this.currentJCDescriptor.getSpecVersion());
        this.eisTypeField.setText(this.currentJCDescriptor.getEisType());
        this.resourceAdapterVersionField.setText(this.currentJCDescriptor.getVersion());
        this.licenseDescriptionArea.setText(this.currentJCDescriptor.getLicenseDescription());
        this.isLicenseRequiredBox.setSelected(this.currentJCDescriptor.getLicenseRequired());
        this.rarNameField.setText(this.currentJCDescriptor.getRarName());
        this.isRealApplicationBox.setSelected(this.currentJCDescriptor.isRealApplication());
        this.connectorGroupField.setText(this.currentJCDescriptor.getConnectorGroup());
        if (addProps != null) {
            this.data = new Object[((Hashtable)addProps).size()][2];
            Enumeration keys = ((Hashtable)addProps).keys();
            int i = 0;
            while (i < ((Hashtable)addProps).size() && keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.data[i][0] = key;
                this.data[i][1] = addProps.getProperty(key);
                ++i;
            }
            this.tableModel = new PropertiesTableModel(COLUMN_NAMES_PROPERTIES, this.data);
            this.raPropertiesTable.setModel(this.tableModel);
        }
        if (loaders != null) {
            this.classLoaderReferencesPanel.initList(loaders);
        }
        this.mcfClassField.setText(this.currentJCDescriptor.getManagedConnectionFactoryClass());
        this.transactionSupportField.setText(this.currentJCDescriptor.getTransactionSupport());
        this.reauthenticationSupportBox.setSelected(this.currentJCDescriptor.getReauthenticationSupport());
        if (authMechanisms != null) {
            this.data = new Object[authMechanisms.length][3];
            int i = 0;
            while (i < authMechanisms.length) {
                this.data[i][0] = authMechanisms[i].getAuthMechType();
                this.data[i][1] = authMechanisms[i].getCredentialInterface();
                this.data[i][2] = authMechanisms[i].getDescription();
                ++i;
            }
            this.tableModel = new PropertiesTableModel(COLUMN_NAMES_AUTH, this.data);
            this.authTable.setModel(this.tableModel);
        }
        this.connFactInterfaceField.setText(this.currentJCDescriptor.getConnectionFactoryInterface());
        this.connFactImplField.setText(this.currentJCDescriptor.getConnectionFactoryImplClass());
        this.connInterfaceField.setText(this.currentJCDescriptor.getConnectionInterface());
        this.connImplField.setText(this.currentJCDescriptor.getConnectionImplClass());
        this.jndiField.setText(this.currentJCDescriptor.getConnectorJNDIName());
        this.connDefPoolPropsPanel.updateConnectionPoolPanel((Object)this.currentJCDescriptor);
        this.connPropertiesEditor.initProperties(props);
        if (aliases != null) {
            this.aliasesPanel.initList(aliases);
        }
        this.authTypeField.setText(this.currentJCDescriptor.getAuthenticationType());
        this.userStoreField.setText(this.currentJCDescriptor.getUserStore());
        this.isInternalStoreBox.setSelected(this.currentJCDescriptor.isInternalUserStore());
        if (identitySubjects != null) {
            this.data = new Object[identitySubjects.length][2];
            int i = 0;
            while (i < identitySubjects.length) {
                this.data[i][0] = identitySubjects[i].getResourcePrincipal();
                this.data[i][1] = identitySubjects[i].getCallerPrincipal();
                ++i;
            }
            this.tableModel = new PropertiesTableModel(COLUMN_NAMES_IDENT_SUB, this.data);
            this.securityTable.setModel(this.tableModel);
        }
        if (securityPermissions != null) {
            this.data = new Object[securityPermissions.length][2];
            int i = 0;
            while (i < securityPermissions.length) {
                this.data[i][0] = securityPermissions[i].getSecurityPermissionSpec();
                this.data[i][1] = securityPermissions[i].getDescription();
                ++i;
            }
            this.tableModel = new PropertiesTableModel(COLUMN_NAMES_SECURITY, this.data);
            this.securityTable.setModel(this.tableModel);
        }
        if (drivers != null) {
            this.data = new Object[drivers.length][3];
            int i = 0;
            while (i < drivers.length) {
                this.data[i][0] = drivers[i].getDriverName();
                this.data[i][1] = drivers[i].getDriverClassName();
                HashSet jars = drivers[i].getJars();
                if (jars != null) {
                    Iterator files = jars.iterator();
                    StringBuffer buffer = new StringBuffer();
                    while (files.hasNext()) {
                        buffer.append(files.next()).append(";");
                    }
                    this.data[i][2] = buffer;
                } else {
                    this.data[i][2] = "";
                }
                ++i;
            }
            this.tableModel = new PropertiesTableModel(COLUMN_NAMES_DRIVERS, this.data);
            this.driversTable.setModel(this.tableModel);
        }
        this.rightPanel.validate();
        this.rightPanel.repaint();
    }

    private void checkButtons(ApplicationNode appNode) {
        this.copyBtn.setEnabled(this.currentJCDescriptor != null);
        this.removeBtn.setEnabled(this.currentJCDescriptor != null);
        this.saveBtn.setEnabled(this.currentJCDescriptor != null);
        if (this.currentJCDescriptor != null) {
            this.stopBtn.setEnabled(false);
            this.startBtn.setEnabled(false);
        }
        boolean isAppNode = false;
        boolean isAppStarted = false;
        if (appNode != null && appNode.isApplicationNode()) {
            isAppNode = true;
            isAppStarted = appNode.isAppStarted();
        }
        if (!isAppNode) {
            this.startBtn.setEnabled(false);
            this.stopBtn.setEnabled(false);
        } else {
            this.startBtn.setEnabled(!isAppStarted);
            this.stopBtn.setEnabled(isAppStarted);
        }
    }

    private void fillDescriptorFromGui(JCDescriptor descrToFill) {
        ManagedFactoryProperty property = descrToFill.getManagedFactoryProperty();
        ConfigProperty[] confProps = this.connPropertiesEditor.getProperties();
        if (confProps.length > 0) {
            if (property == null) {
                property = new ManagedFactoryProperty();
                property.setManagedFactoryPropertyName(descrToFill.getConnectorJNDIName());
                property.setConfigProperties(confProps);
                descrToFill.setManagedFactoryProperty(property);
            } else {
                property.setConfigProperties(confProps);
            }
        } else {
            descrToFill.clearManagedFactoryProperty();
        }
        String[] loaderRefs = this.classLoaderReferencesPanel.getListDataArray();
        if (loaderRefs.length == 0) {
            loaderRefs = null;
        }
        descrToFill.setLoaderReferences(loaderRefs);
        String[] aliases = this.aliasesPanel.getListDataArray();
        if (aliases.length == 0) {
            aliases = null;
        }
        descrToFill.setAliases(aliases);
        this.connDefPoolPropsPanel.setToDescriptor(descrToFill);
    }

    protected void copyAction() {
        this.valueChanged(new TreeSelectionEvent((Object)this.connectorsTree, null, false, null, null));
        String raName = JOptionPane.showInputDialog(this.frame, (Object)"Enter resource adapter jndi name.");
        if (raName == null) {
            return;
        }
        if ((raName = raName.trim()).length() == 0) {
            return;
        }
        try {
            this.runtime.cloneConnectorSP10(this.currentAppName, raName, this.currentJCDescriptor);
            JOptionPane.showMessageDialog(this.frame, "Clone successful.");
        }
        catch (Exception exc) {
            ErrorDialog.showErrorDialog(this.frame, exc.getMessage(), exc);
        }
        this.refresh();
    }

    protected void removeAction() {
        String compName = this.currentJCDescriptor.getConnectorJNDIName();
        if (JOptionPane.showConfirmDialog(this.frame, "Are you sure that you want to remove the component '" + compName + "' from the application " + this.currentAppName + "?", "Confirm", 0) != 0) {
            return;
        }
        try {
            this.runtime.removeConnector(this.currentAppName, compName);
        }
        catch (Exception exc) {
            ErrorDialog.showErrorDialog(this.frame, exc.getMessage(), exc);
        }
        this.refresh();
    }

    protected void saveAction() {
        this.fillDescriptorFromGui(this.currentJCDescriptor);
        try {
            this.runtime.updateConnectorSP10(this.currentAppName, this.currentJCDescriptor);
            JOptionPane.showMessageDialog(this.frame, "Save successuful.");
        }
        catch (Exception exc) {
            ErrorDialog.showErrorDialog(this.frame, exc.getMessage(), exc);
        }
        this.refresh();
    }

    protected void refresh() {
        JCDescriptor[][] allAppsDescrs = null;
        try {
            allAppsDescrs = this.runtime.getAllJCDescriptorsSP10();
        }
        catch (Exception exc) {
            ErrorDialog.showErrorDialog(this.frame, exc.getMessage(), exc);
        }
        this.refreshApplications(allAppsDescrs);
        this.connectorsTree.expandConnectors();
        this.valueChanged(new TreeSelectionEvent((Object)this.connectorsTree, null, false, null, null));
        this.connectorsTree.validate();
        this.connectorsTree.repaint();
    }

    protected void refreshApplications(JCDescriptor[][] allAppsDescrs) {
        String appName;
        DefaultTreeModel treeModel = (DefaultTreeModel)this.connectorsTree.getModel();
        HashMap allApps = new HashMap();
        int i = 0;
        while (i < allAppsDescrs.length) {
            JCDescriptor[] appDescrs = allAppsDescrs[i];
            HashMap<String, JCDescriptor> appCompsMap = null;
            int j = 0;
            while (j < appDescrs.length) {
                JCDescriptor appDescr = appDescrs[j];
                if (appCompsMap == null) {
                    appCompsMap = new HashMap<String, JCDescriptor>();
                    allApps.put(appDescr.getApplicationName(), appCompsMap);
                }
                appCompsMap.put(appDescr.getConnectorJNDIName(), appDescr);
                ++j;
            }
            ++i;
        }
        DefaultMutableTreeNode connectorAppsTree = this.connectorsTree.getConnectorsNode();
        int i2 = 0;
        while (i2 < connectorAppsTree.getChildCount()) {
            ApplicationNode appNode = (ApplicationNode)connectorAppsTree.getChildAt(i2);
            appName = appNode.getAppName();
            HashMap appCompsMap = (HashMap)allApps.remove(appName);
            if (appCompsMap != null) {
                try {
                    appNode.setAppStarted(this.runtime.isStartedApplication(appName));
                }
                catch (Exception exc) {
                    ErrorDialog.showErrorDialog(this.frame, exc.getMessage(), exc);
                }
                this.updateComponents(appNode, appCompsMap, treeModel);
                ++i2;
                continue;
            }
            treeModel.removeNodeFromParent(appNode);
        }
        Iterator appNames = allApps.keySet().iterator();
        while (appNames.hasNext()) {
            appName = (String)appNames.next();
            ApplicationNode appNodeToAdd = null;
            Iterator descrs = ((HashMap)allApps.get(appName)).values().iterator();
            while (descrs.hasNext()) {
                JCDescriptor descrToAdd = (JCDescriptor)descrs.next();
                if (appNodeToAdd == null) {
                    appNodeToAdd = new ApplicationNode(appName, descrToAdd.isRealApplication());
                    try {
                        appNodeToAdd.setAppStarted(this.runtime.isStartedApplication(appName));
                    }
                    catch (Exception exc) {
                        ErrorDialog.showErrorDialog(this.frame, exc.getMessage(), exc);
                    }
                    treeModel.insertNodeInto(appNodeToAdd, connectorAppsTree, connectorAppsTree.getChildCount());
                }
                ApplicationNode compToAdd = new ApplicationNode(descrToAdd);
                treeModel.insertNodeInto(compToAdd, appNodeToAdd, appNodeToAdd.getChildCount());
            }
        }
    }

    protected void startAction() {
        block4: {
            try {
                String appName = ((ApplicationNode)this.connectorsTree.getLastSelectedPathComponent()).getAppName();
                int result = JOptionPane.showConfirmDialog(this.frame, "Do you want to start this application on all servers in cluster?\n(If you choose yes, the application will start in entire cluster,\nif you choose no it will start only on this server)", "Question", 1);
                if (result == 0) {
                    this.runtime.startApplication(appName, true);
                    break block4;
                }
                if (result == 1) {
                    this.runtime.startApplication(appName, false);
                    break block4;
                }
                return;
            }
            catch (RemoteException e) {
                ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
            }
        }
        this.refresh();
    }

    protected void stopAction() {
        block4: {
            try {
                String appName = ((ApplicationNode)this.connectorsTree.getLastSelectedPathComponent()).getAppName();
                int result = JOptionPane.showConfirmDialog(this.frame, "Do you want to stop this application on all servers in cluster?\n(If you choose yes, the application will stop in entire cluster,\nif you choose no it will stop only on this server)", "Question", 1);
                if (result == 0) {
                    this.runtime.stopApplication(appName, true);
                    break block4;
                }
                if (result == 1) {
                    this.runtime.stopApplication(appName, false);
                    break block4;
                }
                return;
            }
            catch (RemoteException e) {
                ErrorDialog.showErrorDialog(this.frame, e.getMessage(), e);
            }
        }
        this.refresh();
    }

    private void updateComponents(ApplicationNode appNodeToUpdate, HashMap appCompsMap, DefaultTreeModel treeModel) {
        int j = 0;
        while (j < appNodeToUpdate.getChildCount()) {
            ApplicationNode compNode = (ApplicationNode)appNodeToUpdate.getChildAt(j);
            JCDescriptor descr = (JCDescriptor)appCompsMap.remove(compNode.getName());
            if (descr != null) {
                compNode.setJCDescriptor(descr);
                ++j;
            } else {
                treeModel.removeNodeFromParent(compNode);
            }
            Iterator descrsToAdd = appCompsMap.values().iterator();
            while (descrsToAdd.hasNext()) {
                JCDescriptor descrToAdd = (JCDescriptor)descrsToAdd.next();
                treeModel.insertNodeInto(new ApplicationNode(descrToAdd), appNodeToUpdate, appNodeToUpdate.getChildCount());
            }
        }
    }

    public abstract void setTaskManager(EditorViewManager var1);

    public abstract void freeResources();

    public abstract void setFrame(Frame var1);

    public abstract JButton[] getRuntimeButtons();

    public abstract JMenu getRuntimeMenu();

    public abstract JComponent getRuntimeControlComponent();

    public abstract void show(ManagementInterface var1);

    public abstract void setEnvironment(String var1, Object var2) throws UnsupportedEditorException;

    public abstract void actionPerformed(ActionEvent var1);
}

