/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.endpoint;

import com.sap.engine.interfaces.endpoint.EndpointActivation;
import com.sap.engine.services.connector.Log;
import com.sap.engine.services.connector.jca15.deploy.Container15Impl;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectorDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.MessageListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.endpoint.MessageEndpointFactory;

public class EndpointActivationImpl
implements EndpointActivation {
    private Hashtable adapterInfos = null;
    static /* synthetic */ Class class$java$lang$String;

    public EndpointActivationImpl(Container15Impl container) {
        this.adapterInfos = container.getDescriptors();
    }

    public void activateEndpoint(String messageListenerName, MessageEndpointFactory endpointFactory, Properties activationProperties, String messageType) throws ResourceException {
        ConnectorDescriptor conDescriptor = this.findSuitableResourceAdapter(messageListenerName, messageType);
        ActivationSpec activationSpec = this.createActivationSpec(conDescriptor, endpointFactory, activationProperties, messageType);
        conDescriptor.getResourceAdapterDescriptor().getResourceAdapter().endpointActivation(endpointFactory, activationSpec);
    }

    public void deactivateEndpoint(String messageListenerName, MessageEndpointFactory endpointFactory, Properties activationProperties, String messageType) throws ResourceException {
        ConnectorDescriptor conDescriptor = this.findSuitableResourceAdapter(messageListenerName, messageType);
        ActivationSpec activationSpec = this.getActivationSpec(conDescriptor, endpointFactory, activationProperties, messageType);
        conDescriptor.getResourceAdapterDescriptor().getResourceAdapter().endpointDeactivation(endpointFactory, activationSpec);
    }

    public String[] getAllMessageListenerNames() {
        Vector<String> result = new Vector<String>();
        Enumeration e = this.adapterInfos.elements();
        while (e.hasMoreElements()) {
            ConnectorDescriptor[] conDescriptors = (ConnectorDescriptor[])e.nextElement();
            int j = 0;
            while (j < conDescriptors.length) {
                ConnectorDescriptor conDescr = conDescriptors[j];
                MessageListener[] messageListeners = conDescr.getResourceAdapterDescriptor().getInboundResourceAdapter().getMessageListeners();
                int i = 0;
                while (i < messageListeners.length) {
                    String name = messageListeners[i].getMessageListenerName();
                    if (name != null) {
                        result.add(name);
                    }
                    ++i;
                }
                ++j;
            }
        }
        return result.toArray(new String[0]);
    }

    public String[] getSupportedMessageTypes(String raJNDIName) {
        Vector<String> result = new Vector<String>();
        Enumeration e = this.adapterInfos.elements();
        while (e.hasMoreElements()) {
            ConnectorDescriptor[] conDescriptors = (ConnectorDescriptor[])e.nextElement();
            int j = 0;
            while (j < conDescriptors.length) {
                ConnectorDescriptor conDescr = conDescriptors[j];
                if (conDescr.getResourceAdapterDescriptor().getRaJNDIName().equals(raJNDIName)) {
                    MessageListener[] messListeners = conDescr.getResourceAdapterDescriptor().getInboundResourceAdapter().getMessageListeners();
                    int i = 0;
                    while (i < messListeners.length) {
                        result.add(messListeners[i].getMessageListenerType());
                        ++i;
                    }
                }
                ++j;
            }
        }
        return result.toArray(new String[0]);
    }

    private ConnectorDescriptor findSuitableResourceAdapter(String messageListenerName, String messageType) throws ResourceException {
        Enumeration e = this.adapterInfos.elements();
        while (e.hasMoreElements()) {
            ConnectorDescriptor[] conDescriptors = (ConnectorDescriptor[])e.nextElement();
            int j = 0;
            while (j < conDescriptors.length) {
                int i;
                ConnectorDescriptor conDescr = conDescriptors[j];
                MessageListener[] messListeners = conDescr.getResourceAdapterDescriptor().getInboundResourceAdapter().getMessageListeners();
                if (messageListenerName == null) {
                    i = 0;
                    while (i < messListeners.length) {
                        if (messListeners[i].getMessageListenerType().equals(messageType)) {
                            return conDescr;
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < messListeners.length) {
                        if (messageListenerName.equals(messListeners[i].getMessageListenerName())) {
                            return conDescr;
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        throw new ResourceException("Suitable ResourceAdapter for message type " + messageType + " is not started or deployed");
    }

    private ActivationSpec createActivationSpec(ConnectorDescriptor conDescr, MessageEndpointFactory endpointFactory, Properties activationProperties, String messageType) throws ResourceException {
        ClassLoader loader = conDescr.getClassLoader();
        MessageListener listener = null;
        ActivationSpec result = null;
        MessageListener[] messListeners = conDescr.getResourceAdapterDescriptor().getInboundResourceAdapter().getMessageListeners();
        int i = 0;
        while (i < messListeners.length) {
            if (messListeners[i].getMessageListenerType().equals(messageType)) {
                listener = messListeners[i];
                break;
            }
            ++i;
        }
        if (listener == null) {
            throw new ResourceException("ResourceAdapter for messageType " + messageType + " not found");
        }
        listener.setMessageEndpointFactory(endpointFactory);
        try {
            String activationSpecClassName = listener.getActivationSpecClass();
            if (activationSpecClassName == null) {
                throw new ResourceException("activation spec class is null");
            }
            Class<?> activationSpecClass = loader.loadClass(activationSpecClassName);
            result = (ActivationSpec)activationSpecClass.newInstance();
            listener.setActivationSpec(result);
            Enumeration e = ((Hashtable)activationProperties).keys();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                String setMethodName = "set" + propertyName.toUpperCase().charAt(0) + propertyName.substring(1);
                activationSpecClass.getMethod(setMethodName, class$java$lang$String == null ? EndpointActivationImpl.class$("java.lang.String") : class$java$lang$String).invoke((Object)result, activationProperties.getProperty(propertyName));
            }
            result.setResourceAdapter(conDescr.getResourceAdapterDescriptor().getResourceAdapter());
            try {
                result.validate();
            }
            catch (UnsupportedOperationException e2) {
                Log.logThrowable(e2);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new ResourceException("cannot load ActivationSpecClass " + cnfe.toString());
        }
        catch (InstantiationException instEx) {
            throw new ResourceException("cannot instantiate ActivationSpec " + instEx.toString());
        }
        catch (IllegalAccessException illAc) {
            throw new ResourceException("cannot  load or instantiate ActivationSpec " + illAc.toString());
        }
        catch (NoSuchMethodException nsmEx) {
            throw new ResourceException("One of the required set method does not exist" + nsmEx.toString());
        }
        catch (InvocationTargetException ite) {
            throw new ResourceException("Exception from set method of ActivationSpec " + ite.getTargetException().toString());
        }
        return result;
    }

    private ActivationSpec getActivationSpec(ConnectorDescriptor conDescr, MessageEndpointFactory endpointFactory, Properties activationProperties, String messageType) throws ResourceException {
        MessageListener[] messListeners = conDescr.getResourceAdapterDescriptor().getInboundResourceAdapter().getMessageListeners();
        int i = 0;
        while (i < messListeners.length) {
            if (messListeners[i].getMessageListenerType().equals(messageType)) {
                return messListeners[i].getActivationSpec();
            }
            ++i;
        }
        throw new ResourceException("ActivationSpec is null , may be ResourceAdapter is not started");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

