/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.verify;

import com.sap.engine.services.connector.jca15.deploy.descriptors.ConfigProperty;
import com.sap.engine.services.connector.jca15.deploy.verify.CheckResult;
import com.sap.engine.services.connector.jca15.deploy.verify.Log;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;

public class Utilities {
    static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    static /* synthetic */ Class class$java$lang$Object;

    static CheckResult isJavaBeanForTheeseProperties(ClassLoader classLoader, String javaBeanClassName, ConfigProperty[] configPropsArr) {
        CheckResult checkResult = new CheckResult();
        Class<?> classInstance = null;
        try {
            classInstance = classLoader.loadClass(javaBeanClassName);
        }
        catch (ClassNotFoundException e) {
            checkResult.addError("Could not load the " + javaBeanClassName + " class! " + Utilities.getThrowableTrace(e));
            return checkResult;
        }
        BeanInfo bi = null;
        try {
            bi = Introspector.getBeanInfo(classInstance, class$java$lang$Object == null ? (class$java$lang$Object = Utilities.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (IntrospectionException ie) {
            checkResult.addError("The " + javaBeanClassName + " class is not JavaBean compatible");
            return checkResult;
        }
        if (configPropsArr == null || configPropsArr.length == 0) {
            return checkResult;
        }
        PropertyDescriptor[] propDescrArr = bi.getPropertyDescriptors();
        HashMap<String, PropertyDescriptor> beanPropDescriptorsMap = null;
        int propDescrArrLen = 0;
        if (propDescrArr == null) {
            beanPropDescriptorsMap = new HashMap<String, PropertyDescriptor>();
        } else {
            propDescrArrLen = propDescrArr.length;
            beanPropDescriptorsMap = new HashMap((int)((double)propDescrArrLen * 1.34 + 1.0));
        }
        int i = 0;
        while (i < propDescrArrLen) {
            beanPropDescriptorsMap.put(propDescrArr[i].getName(), propDescrArr[i]);
            ++i;
        }
        int configPropsArrLen = configPropsArr.length;
        PropertyDescriptor propDescriptor = null;
        ConfigProperty configProperty = null;
        String configPropName = null;
        String configPropType = null;
        String configPropValue = null;
        String configPropDecapitName = null;
        String beanPropAndMethodsStr1 = "Class " + javaBeanClassName + ": Could not find bean property with name ";
        String beanPropAndMethodsStr2 = ". Check if you have get/is and set methods with public access or fix corresponding config-property tag contents.";
        int i2 = 0;
        while (i2 < configPropsArrLen) {
            configProperty = configPropsArr[i2];
            Log.logError("Utilities.isJavaBeanForTheeseProperties(): Config prop: " + configProperty.toString());
            configPropName = configProperty.getConfigPropertyName();
            configPropType = configProperty.getConfigPropertyType();
            configPropValue = configProperty.getConfigPropertyValue();
            configPropDecapitName = Introspector.decapitalize(configPropName);
            propDescriptor = (PropertyDescriptor)beanPropDescriptorsMap.get(configPropDecapitName);
            if (propDescriptor != null) {
                if (propDescriptor.getReadMethod() == null || propDescriptor.getWriteMethod() == null) {
                    Log.logError("Utilities.isJavaBeanForTheeseProperties(): No read or write method");
                    checkResult.addError(beanPropAndMethodsStr1 + configPropDecapitName + ". Check if you have get/is and set methods with public access or fix corresponding config-property tag contents.");
                }
            } else {
                Log.logError("Utilities.isJavaBeanForTheeseProperties(): Not found property: " + configPropDecapitName);
                checkResult.addError(beanPropAndMethodsStr1 + configPropDecapitName + ". Check if you have get/is and set methods with public access or fix corresponding config-property tag contents.");
            }
            ++i2;
        }
        String interfaceNameToBeChecked = "java.io.Serializable";
        try {
            if (!Utilities.classImplementsInterface(classLoader, javaBeanClassName, interfaceNameToBeChecked)) {
                checkResult.addError("The passed class (" + javaBeanClassName + ") does not implement " + interfaceNameToBeChecked + " interface!");
            }
        }
        catch (ClassNotFoundException e) {
            checkResult.addError("Could not load class " + javaBeanClassName + "!");
        }
        return checkResult;
    }

    static boolean classImplementsInterface(ClassLoader classLoader, String checkedClassName, String interfaceFQN) throws ClassNotFoundException, IllegalArgumentException {
        if (classLoader == null || Utilities.nullOrEmpty(checkedClassName) || Utilities.nullOrEmpty(interfaceFQN)) {
            throw new IllegalArgumentException("Some of the arguments is null or empty!");
        }
        Class<?> checkedClass = classLoader.loadClass(checkedClassName);
        return Utilities.classImplementsInterface(checkedClass, interfaceFQN);
    }

    static boolean classImplementsInterface(Class checkedClass, String interfaceFQN) {
        Log.logDebug("into Utilities.classImplementsInterface(" + checkedClass + ", " + interfaceFQN + ") ");
        Class<?>[] implementedIfacesArr = checkedClass.getInterfaces();
        int arrSize = implementedIfacesArr.length;
        Class<?> tmpClass = null;
        String ifaceName = null;
        boolean interfaceIsImplemented = false;
        int i = 0;
        while (i < arrSize && !interfaceIsImplemented) {
            tmpClass = implementedIfacesArr[i];
            ifaceName = tmpClass.getName();
            Log.logDebug("Utilities.classImplementsInterface(): checking: " + ifaceName);
            if (ifaceName.equals(interfaceFQN)) {
                interfaceIsImplemented = true;
                Log.logDebug("Utilities.classImplementsInterface(): " + ifaceName + ". Matches!");
            } else {
                interfaceIsImplemented = Utilities.classImplementsInterface(tmpClass, interfaceFQN);
            }
            ++i;
        }
        if (!interfaceIsImplemented) {
            Log.logDebug("Utilities.classImplementsInterface(). Current class (" + checkedClass + ") doesn't implement " + interfaceFQN + " interface so tying with superclasses.");
            Class parent = checkedClass.getSuperclass();
            if (parent != null) {
                interfaceIsImplemented = Utilities.classImplementsInterface(parent, interfaceFQN);
            }
        }
        Log.logDebug("end of Utilities.classImplementsInterface(" + checkedClass + "," + interfaceFQN + "). interfaceIsImplemented: " + interfaceIsImplemented);
        return interfaceIsImplemented;
    }

    private static boolean isNormalClassName(String className) {
        return !className.startsWith("[");
    }

    static CheckResult instantiateClassCheck(ClassLoader classLoader, String javaBeanClassName) {
        CheckResult checkResult = new CheckResult();
        try {
            Class<?> classObj = classLoader.loadClass(javaBeanClassName);
            Object instance = classObj.newInstance();
        }
        catch (ClassNotFoundException e) {
            checkResult.addError("Error while trying to load class " + javaBeanClassName);
        }
        catch (Throwable e) {
            checkResult.addError("Error while trying to instantiate " + javaBeanClassName + ". Probably default constructor is missing. Reason: " + Utilities.getThrowableTrace(e));
        }
        return checkResult;
    }

    static String getThrowableTrace(Throwable t) {
        StringWriter sw = new StringWriter(200);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        return sw.toString();
    }

    private static boolean nullOrEmpty(String str) {
        return str == null || str.length() == 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

