/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.verify;

import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectorDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.InboundResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.verify.CheckResult;
import com.sap.engine.services.connector.jca15.deploy.verify.Log;
import com.sap.engine.services.connector.jca15.deploy.verify.Utilities;
import com.sap.engine.services.connector.jca15.deploy.verify.Verifier;

class ResAdapterClassImplVerifier
extends Verifier {
    public ResAdapterClassImplVerifier(ConnectorDescriptor connectorDescriptor, ResourceLoader resourceLoader) {
        super(connectorDescriptor, resourceLoader);
    }

    CheckResult verify() {
        boolean isRAClassCheckNeeded;
        Log.logDebug(this + ".verify()");
        ResourceAdapterDescriptor raDescriptor = this.connectorDescriptor.getResourceAdapterDescriptor();
        String resourceAdapterClassName = raDescriptor.getResourceAdapterClass();
        InboundResourceAdapterDescriptor inboundDescriptor = raDescriptor.getInboundResourceAdapter();
        boolean bl = isRAClassCheckNeeded = inboundDescriptor != null;
        if (!isRAClassCheckNeeded) {
            return null;
        }
        Log.logDebug("inbound-resourceadapter tag is present so resourceadapter-class tag is required");
        CheckResult checkResult = new CheckResult();
        try {
            if (resourceAdapterClassName == null) {
                checkResult.addError("ResourceAdapter implementation class is not specified in the resourceadapter-class! inbound-resourceadapter tag is present so resourceadapter-class tag is required");
                return checkResult;
            }
            if ((resourceAdapterClassName = resourceAdapterClassName.trim()).length() == 0) {
                checkResult.addError("ResourceAdapter implementation class is not specified in the resourceadapter-class! inbound-resourceadapter tag is present so resourceadapter-class tag is required");
                return checkResult;
            }
            CheckResult tmpCheckResult = Utilities.instantiateClassCheck(this.resourceLoader, resourceAdapterClassName);
            if (tmpCheckResult.hasErrors()) {
                checkResult.appendCheckResult(tmpCheckResult);
                return checkResult;
            }
            String interfaceNameToBeChecked = "javax.resource.spi.ResourceAdapter";
            if (!Utilities.classImplementsInterface(this.resourceLoader, resourceAdapterClassName, interfaceNameToBeChecked)) {
                checkResult.addError("The passed resource adapter implementation class does not implement " + interfaceNameToBeChecked + " interface!");
            }
            if (!Utilities.classImplementsInterface(this.resourceLoader, resourceAdapterClassName, interfaceNameToBeChecked = "java.io.Serializable")) {
                checkResult.addError("The passed resource adapter implementation class does not implement " + interfaceNameToBeChecked + " interface!");
            }
        }
        catch (ClassNotFoundException e) {
            Log.logThrowable(e);
            checkResult.addError("Class not found!" + Utilities.getThrowableTrace(e));
        }
        return checkResult;
    }
}

