/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.descriptors.xml;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.StandardDOMWriterNoSpace;
import com.sap.engine.services.connector.exceptions.BaseXMLParserException;
import com.sap.engine.services.connector.jca15.deploy.descriptors.AdminObjectDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.AuthenticationMechanism;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConfigProperty;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectionDefinition;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectorDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.InboundResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.MessageListener;
import com.sap.engine.services.connector.jca15.deploy.descriptors.OutboundResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.RequiredConfigProperty;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.SecurityPermission;
import com.sap.engine.services.deploy.container.DeploymentException;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XMLGenerator {
    static /* synthetic */ Class class$com$sap$engine$services$connector$jca15$deploy$descriptors$xml$XMLGenerator;

    public void generateXML(ConnectorDescriptor connectorDescriptor, String xmlFileName) throws DeploymentException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$connector$jca15$deploy$descriptors$xml$XMLGenerator == null ? (class$com$sap$engine$services$connector$jca15$deploy$descriptors$xml$XMLGenerator = XMLGenerator.class$("com.sap.engine.services.connector.jca15.deploy.descriptors.xml.XMLGenerator")) : class$com$sap$engine$services$connector$jca15$deploy$descriptors$xml$XMLGenerator).getClassLoader());
        Document document = null;
        try {
            document = StandardDOMParser.createDocument();
            Object var6_5 = null;
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Thread.currentThread().setContextClassLoader(cl);
            throw throwable;
        }
        Element root = document.createElement("connector");
        Element tempElement = null;
        String tempString = null;
        boolean tempFlag = false;
        tempString = connectorDescriptor.getDescription();
        if (tempString != null) {
            XMLGenerator.createSubElement(document, root, tempString, "description");
        }
        if ((tempString = connectorDescriptor.getDisplayName()) != null) {
            XMLGenerator.createSubElement(document, root, tempString, "display-name");
        }
        SerializableFile smallIcon = connectorDescriptor.getSmallIcon();
        SerializableFile largeIcon = connectorDescriptor.getLargeIcon();
        if (smallIcon != null || largeIcon != null) {
            tempElement = document.createElement("icon");
            if (smallIcon != null) {
                XMLGenerator.createSubElement(document, tempElement, smallIcon.getFileName(), "small-icon");
            }
            if (largeIcon != null) {
                XMLGenerator.createSubElement(document, tempElement, largeIcon.getFileName(), "large-icon");
            }
            root.appendChild(tempElement);
        }
        XMLGenerator.createSubElement(document, root, connectorDescriptor.getVendorName(), "vendor-name");
        XMLGenerator.createSubElement(document, root, connectorDescriptor.getEisType(), "eis-type");
        XMLGenerator.createSubElement(document, root, connectorDescriptor.getResourceAdapterVersion(), "resourceadapter-version");
        tempString = connectorDescriptor.getLicenseDescription();
        tempFlag = connectorDescriptor.isLicenseRequired();
        if (tempString != null || tempFlag) {
            tempElement = document.createElement("license");
            if (tempString != null) {
                XMLGenerator.createSubElement(document, tempElement, tempString, "description");
            }
            XMLGenerator.createSubElement(document, tempElement, "true", "license-required");
            root.appendChild(tempElement);
        }
        this.loadResourceAdapter(document, root, connectorDescriptor.getResourceAdapterDescriptor());
        root.setAttribute("xmlns", "http://java.sun.com/xml/ns/j2ee");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:schemaLocation", "http://java.sun.com/xml/ns/j2ee connector_1_5.xsd");
        root.setAttribute("version", "1.5");
        document.appendChild(root);
        XMLGenerator.writeToFile(document, xmlFileName);
    }

    private void loadResourceAdapter(Document document, Element element, ResourceAdapterDescriptor resourceAdapter) {
        SecurityPermission[] securityPermissions;
        AdminObjectDescriptor[] adminObjects;
        InboundResourceAdapterDescriptor inboundResourceAdapter;
        OutboundResourceAdapterDescriptor outboundResourceAdapter;
        ConfigProperty[] configProperties;
        Element raElement = document.createElement("resourceadapter");
        Element tempElement = null;
        String tempString = null;
        tempString = resourceAdapter.getResourceAdapterClass();
        if (tempString != null) {
            XMLGenerator.createSubElement(document, raElement, tempString, "resourceadapter-class");
        }
        if ((configProperties = resourceAdapter.getConfigProperties()) != null) {
            this.loadConfigProperties(document, raElement, configProperties);
        }
        if ((outboundResourceAdapter = resourceAdapter.getOutboundResourceAdapter()) != null) {
            tempElement = document.createElement("outbound-resourceadapter");
            this.loadConnectionDefinitions(document, tempElement, outboundResourceAdapter.getConnectionDefinitions());
            XMLGenerator.createSubElement(document, tempElement, outboundResourceAdapter.getTransactionSupport(), "transaction-support");
            AuthenticationMechanism[] authenticationMechanisms = outboundResourceAdapter.getAuthenticationMechanisms();
            if (authenticationMechanisms != null) {
                this.loadAuthenticationMechanisms(document, tempElement, authenticationMechanisms);
            }
            XMLGenerator.createSubElement(document, tempElement, !outboundResourceAdapter.isReauthenticationSupport() ? "false" : "true", "reauthentication-support");
            raElement.appendChild(tempElement);
        }
        if ((inboundResourceAdapter = resourceAdapter.getInboundResourceAdapter()) != null) {
            tempElement = document.createElement("inbound-resourceadapter");
            Element el = document.createElement("messageadapter");
            MessageListener[] messageListeners = inboundResourceAdapter.getMessageListeners();
            if (messageListeners != null) {
                this.loadMessageListeners(document, el, messageListeners);
            }
            tempElement.appendChild(el);
            raElement.appendChild(tempElement);
        }
        if ((adminObjects = resourceAdapter.getAdminObjects()) != null) {
            this.loadAdminObjects(document, raElement, adminObjects);
        }
        if ((securityPermissions = resourceAdapter.getSecurityPermissions()) != null) {
            this.loadSecurityPermissions(document, tempElement, securityPermissions);
        }
        element.appendChild(raElement);
    }

    private void loadConfigProperties(Document document, Element element, ConfigProperty[] configProperties) {
        Element cpElement = null;
        String tempString = null;
        int i = 0;
        while (i < configProperties.length) {
            if (configProperties[i] != null && configProperties[i].getConfigPropertyName() != null && configProperties[i].getConfigPropertyType() != null) {
                cpElement = document.createElement("config-property");
                tempString = configProperties[i].getDescription();
                if (tempString != null) {
                    XMLGenerator.createSubElement(document, cpElement, tempString, "description");
                }
                XMLGenerator.createSubElement(document, cpElement, configProperties[i].getConfigPropertyName(), "config-property-name");
                XMLGenerator.createSubElement(document, cpElement, configProperties[i].getConfigPropertyType(), "config-property-type");
                tempString = configProperties[i].getConfigPropertyValue();
                if (tempString != null) {
                    XMLGenerator.createSubElement(document, cpElement, tempString, "config-property-value");
                }
                element.appendChild(cpElement);
            }
            ++i;
        }
    }

    private void loadConnectionDefinitions(Document document, Element element, ConnectionDefinition[] connectionDefinitions) {
        Element cdElement = null;
        int i = 0;
        while (i < connectionDefinitions.length) {
            if (connectionDefinitions[i] != null && connectionDefinitions[i].getManagedConnectionFactoryClass() != null && connectionDefinitions[i].getConnectionFactoryInterface() != null && connectionDefinitions[i].getConnectionFactoryImplClass() != null && connectionDefinitions[i].getConnectionInterface() != null && connectionDefinitions[i].getConnectionImplClass() != null) {
                cdElement = document.createElement("connection-definition");
                XMLGenerator.createSubElement(document, cdElement, connectionDefinitions[i].getManagedConnectionFactoryClass(), "managedconnectionfactory-class");
                ConfigProperty[] configProperties = connectionDefinitions[i].getConfigProperties();
                if (configProperties != null) {
                    this.loadConfigProperties(document, cdElement, configProperties);
                }
                XMLGenerator.createSubElement(document, cdElement, connectionDefinitions[i].getConnectionFactoryInterface(), "connectionfactory-interface");
                XMLGenerator.createSubElement(document, cdElement, connectionDefinitions[i].getConnectionFactoryImplClass(), "connectionfactory-impl-class");
                XMLGenerator.createSubElement(document, cdElement, connectionDefinitions[i].getConnectionInterface(), "connection-interface");
                XMLGenerator.createSubElement(document, cdElement, connectionDefinitions[i].getConnectionImplClass(), "connection-impl-class");
                element.appendChild(cdElement);
            }
            ++i;
        }
    }

    private void loadAuthenticationMechanisms(Document document, Element element, AuthenticationMechanism[] authenticationMechanisms) {
        Element amElement = null;
        String tempString = null;
        int i = 0;
        while (i < authenticationMechanisms.length) {
            if (authenticationMechanisms[i] != null && authenticationMechanisms[i].getAuthenticationMechanismType() != null && authenticationMechanisms[i].getCredentialInterface() != null) {
                amElement = document.createElement("authentication-mechanism");
                tempString = authenticationMechanisms[i].getDescription();
                if (tempString != null) {
                    XMLGenerator.createSubElement(document, amElement, tempString, "description");
                }
                XMLGenerator.createSubElement(document, amElement, authenticationMechanisms[i].getAuthenticationMechanismType(), "authentication-mechanism-type");
                XMLGenerator.createSubElement(document, amElement, authenticationMechanisms[i].getCredentialInterface(), "credential-interface");
                element.appendChild(amElement);
            }
            ++i;
        }
    }

    private void loadSecurityPermissions(Document document, Element element, SecurityPermission[] securityPermissions) {
        Element spElement = null;
        String tempString = null;
        int i = 0;
        while (i < securityPermissions.length) {
            if (securityPermissions[i] != null && securityPermissions[i].getSecurityPermissionSpec() != null) {
                spElement = document.createElement("security-permission");
                tempString = securityPermissions[i].getDescription();
                if (tempString != null) {
                    XMLGenerator.createSubElement(document, spElement, tempString, "description");
                }
                XMLGenerator.createSubElement(document, spElement, securityPermissions[i].getSecurityPermissionSpec(), "security-permission-spec");
                element.appendChild(spElement);
            }
            ++i;
        }
    }

    private void loadMessageListeners(Document document, Element element, MessageListener[] messageListeners) {
        Element mlElement = null;
        int i = 0;
        while (i < messageListeners.length) {
            if (messageListeners[i] != null && messageListeners[i].getMessageListenerType() != null && messageListeners[i].getActivationSpecClass() != null) {
                mlElement = document.createElement("messagelistener");
                XMLGenerator.createSubElement(document, mlElement, messageListeners[i].getMessageListenerType(), "messagelistener-type");
                Element el = document.createElement("activationspec");
                XMLGenerator.createSubElement(document, el, messageListeners[i].getActivationSpecClass(), "activationspec-class");
                RequiredConfigProperty[] requiredConfigProperties = messageListeners[i].getRequiredConfigProperties();
                if (requiredConfigProperties != null) {
                    this.loadRequiredConfigProperties(document, el, requiredConfigProperties);
                }
                mlElement.appendChild(el);
                element.appendChild(mlElement);
            }
            ++i;
        }
    }

    private void loadAdminObjects(Document document, Element element, AdminObjectDescriptor[] adminObjects) {
        Element aoElement = null;
        int i = 0;
        while (i < adminObjects.length) {
            if (adminObjects[i] != null && adminObjects[i].getAdminObjectInterface() != null && adminObjects[i].getAdminObjectClass() != null) {
                aoElement = document.createElement("adminobject");
                XMLGenerator.createSubElement(document, aoElement, adminObjects[i].getAdminObjectInterface(), "adminobject-interface");
                XMLGenerator.createSubElement(document, aoElement, adminObjects[i].getAdminObjectClass(), "adminobject-class");
                ConfigProperty[] configProperties = adminObjects[i].getConfigProperties();
                if (configProperties != null) {
                    this.loadConfigProperties(document, aoElement, configProperties);
                }
                element.appendChild(aoElement);
            }
            ++i;
        }
    }

    private void loadRequiredConfigProperties(Document document, Element element, RequiredConfigProperty[] requiredConfigProperties) {
        Element rcpElement = null;
        String tempString = null;
        int i = 0;
        while (i < requiredConfigProperties.length) {
            if (requiredConfigProperties[i] != null && requiredConfigProperties[i].getConfigPropertyName() != null) {
                rcpElement = document.createElement("required-config-property");
                tempString = requiredConfigProperties[i].getDescription();
                if (tempString != null) {
                    XMLGenerator.createSubElement(document, rcpElement, tempString, "description");
                }
                XMLGenerator.createSubElement(document, rcpElement, requiredConfigProperties[i].getConfigPropertyName(), "config-property-name");
                element.appendChild(rcpElement);
            }
            ++i;
        }
    }

    public static Element createSubElement(Document document, Element element, String value, String elementName) {
        if (value == null) {
            value = new String("");
        }
        Element subElement = document.createElement(elementName);
        Text textNode = document.createTextNode(value);
        subElement.appendChild(textNode);
        element.appendChild(subElement);
        return subElement;
    }

    public static void writeToFile(Document document, String xmlFileName) throws DeploymentException {
        StandardDOMWriterNoSpace writer = XMLGenerator.createStandardDOMWriterNoSpace();
        try {
            writer.write(document, xmlFileName, "");
        }
        catch (IOException ioe) {
            throw new BaseXMLParserException("connector_0801", new Object[]{xmlFileName}, (Throwable)ioe);
        }
    }

    private static StandardDOMWriterNoSpace createStandardDOMWriterNoSpace() {
        ClassLoader previousLoader = null;
        try {
            previousLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$connector$jca15$deploy$descriptors$xml$XMLGenerator == null ? (class$com$sap$engine$services$connector$jca15$deploy$descriptors$xml$XMLGenerator = XMLGenerator.class$("com.sap.engine.services.connector.jca15.deploy.descriptors.xml.XMLGenerator")) : class$com$sap$engine$services$connector$jca15$deploy$descriptors$xml$XMLGenerator).getClassLoader());
            StandardDOMWriterNoSpace standardDOMWriterNoSpace = new StandardDOMWriterNoSpace();
            Object var3_2 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            return standardDOMWriterNoSpace;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Thread.currentThread().setContextClassLoader(previousLoader);
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

