/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.descriptors.xml;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.connector.exceptions.BaseDeploymentException;
import com.sap.engine.services.connector.exceptions.BaseXMLParserException;
import com.sap.engine.services.connector.jca.deploy.descriptor.CallerPrincipal;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca.deploy.descriptor.ResourcePrincipal;
import com.sap.engine.services.connector.jca15.deploy.descriptors.AdminObjectDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.AuthenticationMechanism;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConfigProperty;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectionDefinition;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConnectorDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.DriverDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.InboundResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.MessageListener;
import com.sap.engine.services.connector.jca15.deploy.descriptors.OutboundResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.RequiredConfigProperty;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ResourceAdapterDescriptor;
import com.sap.engine.services.connector.jca15.deploy.descriptors.SecurityPermission;
import com.sap.engine.services.deploy.container.DeploymentException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConnectorParser {
    static /* synthetic */ Class class$com$sap$engine$services$connector$jca15$deploy$descriptors$xml$ConnectorParser;

    public void parseXml(BufferedInputStream xmlStream, ConnectorDescriptor descriptor, boolean isAddXML, String filename, Vector warnings) throws DeploymentException {
        this.parseXml(ConnectorParser.getDocument(xmlStream, filename), descriptor, isAddXML, warnings);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document getDocument(BufferedInputStream xmlStream, String filename) throws DeploymentException {
        ClassLoader prevCL = null;
        StandardDOMParser domParser = null;
        try {
            prevCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader((class$com$sap$engine$services$connector$jca15$deploy$descriptors$xml$ConnectorParser == null ? (class$com$sap$engine$services$connector$jca15$deploy$descriptors$xml$ConnectorParser = ConnectorParser.class$("com.sap.engine.services.connector.jca15.deploy.descriptors.xml.ConnectorParser")) : class$com$sap$engine$services$connector$jca15$deploy$descriptors$xml$ConnectorParser).getClassLoader());
            domParser = new StandardDOMParser();
            Object var5_4 = null;
            Thread.currentThread().setContextClassLoader(prevCL);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Thread.currentThread().setContextClassLoader(prevCL);
            throw throwable;
        }
        Document document = null;
        try {
            try {
                document = domParser.parse((InputStream)xmlStream);
                xmlStream.close();
            }
            catch (IOException ioe) {
                throw new BaseXMLParserException("connector_0801", new Object[]{filename}, (Throwable)ioe);
            }
            catch (SAXException saxe) {
                throw new BaseXMLParserException("connector_0800", new Object[]{filename}, (Throwable)saxe);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (xmlStream == null) throw throwable;
                xmlStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new BaseXMLParserException("connector_0802", new Object[]{filename}, (Throwable)ioe);
            }
        }
        try {}
        catch (IOException ioe) {
            throw new BaseXMLParserException("connector_0802", new Object[]{filename}, (Throwable)ioe);
        }
        if (xmlStream == null) return document;
        xmlStream.close();
        return document;
    }

    public void parseXml(Document document, ConnectorDescriptor result, boolean isAddXML, Vector warnings) throws DeploymentException {
        Element connector = document.getDocumentElement();
        if (isAddXML) {
            ResourceAdapterDescriptor raDescriptor = result.getResourceAdapterDescriptor();
            Vector<DriverDescriptor> driverDescriptors = new Vector<DriverDescriptor>();
            Vector<String> loaderNames = new Vector<String>();
            OutboundResourceAdapterDescriptor outboundRADescriptor = raDescriptor.getOutboundResourceAdapter();
            ConnectionDefinition[] connectionDefinitions = outboundRADescriptor.getConnectionDefinitions();
            InboundResourceAdapterDescriptor inboundRADesctiptor = raDescriptor.getInboundResourceAdapter();
            MessageListener[] messageListeners = inboundRADesctiptor.getMessageListeners();
            int position = -1;
            int counter = 0;
            NodeList connectorList0 = connector.getElementsByTagName("resourceadapter");
            Element raElement = (Element)connectorList0.item(0);
            NodeList connectorList = raElement.getChildNodes();
            int i = 0;
            while (i < connectorList.getLength()) {
                if (connectorList.item(i).getNodeType() == 1) {
                    Element el2;
                    String el2Name;
                    int j;
                    NodeList list;
                    Element element = (Element)connectorList.item(i);
                    String elementName = element.getNodeName();
                    if (elementName.equals("outbound")) {
                        list = element.getChildNodes();
                        j = 0;
                        while (j < list.getLength()) {
                            if (list.item(j).getNodeType() == 1 && (el2Name = (el2 = (Element)list.item(j)).getNodeName()).equals("connection-definition")) {
                                this.processAddConnDef(el2, connectionDefinitions[counter]);
                                ++counter;
                            }
                            ++j;
                        }
                    } else if (elementName.equals("inbound")) {
                        list = element.getChildNodes();
                        j = 0;
                        while (j < list.getLength()) {
                            if (list.item(j).getNodeType() == 1 && (el2Name = (el2 = (Element)list.item(j)).getNodeName()).equals("messagelistener")) {
                                NodeList list1 = el2.getChildNodes();
                                int k = 0;
                                while (k < list1.getLength()) {
                                    if (list1.item(k).getNodeType() == 1) {
                                        Element el3 = (Element)list1.item(k);
                                        String el3Name = el3.getNodeName();
                                        if (el3Name.equals("messagelistener-type")) {
                                            String textValue = this.getTextValue(el3);
                                            int l = 0;
                                            while (l < messageListeners.length) {
                                                if (textValue.equals(messageListeners[l].getMessageListenerType())) {
                                                    position = l;
                                                    break;
                                                }
                                                ++l;
                                            }
                                        } else if (el3Name.equals("messagelistener-name") && position != -1) {
                                            messageListeners[position].setMessageListenerName(this.getTextValue(el3));
                                        }
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    } else if (elementName.equals("ra-jndi-name")) {
                        raDescriptor.setRaJNDIName(this.getTextValue(element));
                    } else if (elementName.equals("connector-group")) {
                        raDescriptor.setConnectorGroup(this.getTextValue(element));
                    } else if (elementName.equals("loader-references")) {
                        list = element.getChildNodes();
                        j = 0;
                        while (j < list.getLength()) {
                            if (list.item(j).getNodeType() == 1 && (el2Name = (el2 = (Element)list.item(j)).getNodeName()).equals("loader-name")) {
                                loaderNames.add(this.getTextValue(el2));
                            }
                            ++j;
                        }
                    } else if (elementName.equals("driver")) {
                        driverDescriptors.add(this.processDriver(element));
                    }
                }
                ++i;
            }
            outboundRADescriptor.setConnectionDefinitions(connectionDefinitions);
            inboundRADesctiptor.setMessageListeners(messageListeners);
            raDescriptor.setOutboundResourceAdapter(outboundRADescriptor);
            raDescriptor.setInboundResourceAdapter(inboundRADesctiptor);
            raDescriptor.setLoaderNames(loaderNames.toArray(new String[loaderNames.size()]));
            raDescriptor.setDriverDescriptors(driverDescriptors.toArray(new DriverDescriptor[driverDescriptors.size()]));
            result.setResourceAdapterDescriptor(raDescriptor);
        } else {
            NodeList connectorList = connector.getChildNodes();
            int i = 0;
            while (i < connectorList.getLength()) {
                if (connectorList.item(i).getNodeType() == 1) {
                    Element element = (Element)connectorList.item(i);
                    String elementName = element.getNodeName();
                    if (elementName.equals("description")) {
                        result.setDescription(this.getTextValue(element));
                    } else if (elementName.equals("display-name")) {
                        result.setDisplayName(this.getTextValue(element));
                    } else if (elementName.equals("icon")) {
                        this.processIcon(element, result);
                    } else if (elementName.equals("vendor-name")) {
                        result.setVendorName(this.getTextValue(element));
                    } else if (elementName.equals("eis-type")) {
                        result.setEisType(this.getTextValue(element));
                    } else if (elementName.equals("resourceadapter-version")) {
                        result.setResourceAdapterVersion(this.getTextValue(element));
                    } else if (elementName.equals("license")) {
                        this.processLicense(element, result);
                    } else if (elementName.equals("resourceadapter")) {
                        result.setResourceAdapterDescriptor(this.processResourceAdapter(element, warnings));
                    }
                }
                ++i;
            }
        }
    }

    private void processIcon(Element element, ConnectorDescriptor result) {
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("small-icon")) {
                    result.setSmallIcon(this.processString(this.getTextValue(el), false));
                } else if (elName.equals("large-icon")) {
                    result.setLargeIcon(this.processString(this.getTextValue(el), false));
                }
            }
            ++i;
        }
    }

    private String processString(String str, boolean saving) {
        char separator = File.separatorChar;
        String str2 = new String();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (saving) {
                if (ch == separator) {
                    ch = '\\';
                }
            } else if (ch == '\\') {
                ch = separator;
            }
            str2 = new String(str2 + ch);
            ++i;
        }
        return str2;
    }

    private void processLicense(Element element, ConnectorDescriptor result) {
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("description")) {
                    result.setLicenseDescription(this.getTextValue(el));
                } else if (elName.equals("license-required")) {
                    String value = this.getTextValue(el);
                    if (value.equals("true")) {
                        result.setLicenseRequired(true);
                    } else {
                        result.setLicenseRequired(false);
                    }
                }
            }
            ++i;
        }
    }

    private ResourceAdapterDescriptor processResourceAdapter(Element element, Vector warnings) {
        ResourceAdapterDescriptor resourceAdapter = new ResourceAdapterDescriptor();
        Vector<ConfigProperty> configProperties = new Vector<ConfigProperty>();
        Vector<AdminObjectDescriptor> adminObjects = new Vector<AdminObjectDescriptor>();
        Vector<SecurityPermission> securityPermissions = new Vector<SecurityPermission>();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("resourceadapter-class")) {
                    resourceAdapter.setResourceAdapterClass(this.getTextValue(el));
                } else if (elName.equals("config-property")) {
                    configProperties.add(this.processConfigProperty(el));
                } else if (elName.equals("outbound-resourceadapter")) {
                    resourceAdapter.setOutboundResourceAdapter(this.processOutboundResourceAdapter(el, warnings));
                } else if (elName.equals("inbound-resourceadapter")) {
                    resourceAdapter.setInboundResourceAdapter(this.processInboundResourceAdapter(el, warnings));
                } else if (elName.equals("adminobject")) {
                    adminObjects.add(this.processAdminObject(el));
                } else if (elName.equals("security-permission")) {
                    securityPermissions.add(this.processSecurityPermission(el));
                }
            }
            ++i;
        }
        resourceAdapter.setConfigProperties(configProperties.toArray(new ConfigProperty[configProperties.size()]));
        resourceAdapter.setAdminObjects(adminObjects.toArray(new AdminObjectDescriptor[adminObjects.size()]));
        resourceAdapter.setSecurityPermissions(securityPermissions.toArray(new SecurityPermission[securityPermissions.size()]));
        return resourceAdapter;
    }

    private ConfigProperty processConfigProperty(Element element) {
        ConfigProperty configProperty = new ConfigProperty();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("description")) {
                    configProperty.setDescription(this.getTextValue(el));
                } else if (elName.equals("config-property-name")) {
                    configProperty.setConfigPropertyName(this.getTextValue(el));
                } else if (elName.equals("config-property-type")) {
                    configProperty.setConfigPropertyType(this.getTextValue(el));
                } else if (elName.equals("config-property-value")) {
                    configProperty.setConfigPropertyValue(this.getTextValue(el));
                }
            }
            ++i;
        }
        return configProperty;
    }

    private OutboundResourceAdapterDescriptor processOutboundResourceAdapter(Element element, Vector warnings) {
        OutboundResourceAdapterDescriptor outboundResourceAdapter = new OutboundResourceAdapterDescriptor();
        ConnectionDefinition connectionDefinition = new ConnectionDefinition();
        Vector<ConnectionDefinition> connectionDefinitions = new Vector<ConnectionDefinition>();
        Vector<AuthenticationMechanism> authenticationMechanisms = new Vector<AuthenticationMechanism>();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("connection-definition")) {
                    connectionDefinition = this.processConnectionDefinition(el);
                    boolean found = false;
                    int k = 0;
                    while (k < connectionDefinitions.size()) {
                        String conInterface = ((ConnectionDefinition)connectionDefinitions.elementAt(i)).getConnectionFactoryInterface();
                        if (connectionDefinition.getConnectionFactoryInterface().equals(conInterface)) {
                            found = true;
                            break;
                        }
                        ++k;
                    }
                    if (!found) {
                        connectionDefinitions.add(connectionDefinition);
                    } else {
                        warnings.add("Can not add a connection definition with not unique connection factory interface" + connectionDefinition.getConnectionFactoryInterface());
                    }
                } else if (elName.equals("transaction-support")) {
                    outboundResourceAdapter.setTransactionSupport(this.getTextValue(el));
                } else if (elName.equals("authentication-mechanism")) {
                    authenticationMechanisms.add(this.processAuthenticationMechanism(el));
                } else if (elName.equals("reauthentication-support")) {
                    String value = this.getTextValue(el);
                    if (value.equals("true")) {
                        outboundResourceAdapter.setReauthenticationSupport(true);
                    } else {
                        outboundResourceAdapter.setReauthenticationSupport(false);
                    }
                }
            }
            ++i;
        }
        outboundResourceAdapter.setConnectionDefinitions(connectionDefinitions.toArray(new ConnectionDefinition[connectionDefinitions.size()]));
        outboundResourceAdapter.setAuthenticationMechanisms(authenticationMechanisms.toArray(new AuthenticationMechanism[authenticationMechanisms.size()]));
        return outboundResourceAdapter;
    }

    private ConnectionDefinition processConnectionDefinition(Element element) {
        ConnectionDefinition connectionDefinition = new ConnectionDefinition();
        Vector<ConfigProperty> configProperties = new Vector<ConfigProperty>();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("managedconnectionfactory-class")) {
                    connectionDefinition.setManagedConnectionFactoryClass(this.getTextValue(el));
                } else if (elName.equals("config-property")) {
                    configProperties.add(this.processConfigProperty(el));
                } else if (elName.equals("connectionfactory-interface")) {
                    connectionDefinition.setConnectionFactoryInterface(this.getTextValue(el));
                } else if (elName.equals("connectionfactory-impl-class")) {
                    connectionDefinition.setConnectionFactoryImplClass(this.getTextValue(el));
                } else if (elName.equals("connection-interface")) {
                    connectionDefinition.setConnectionInterface(this.getTextValue(el));
                } else if (elName.equals("connection-impl-class")) {
                    connectionDefinition.setConnectionImplClass(this.getTextValue(el));
                }
            }
            ++i;
        }
        connectionDefinition.setConfigProperties(configProperties.toArray(new ConfigProperty[configProperties.size()]));
        return connectionDefinition;
    }

    private AuthenticationMechanism processAuthenticationMechanism(Element element) {
        AuthenticationMechanism authenticationMechanism = new AuthenticationMechanism();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("description")) {
                    authenticationMechanism.setDescription(this.getTextValue(el));
                } else if (elName.equals("authentication-mechanism-type")) {
                    authenticationMechanism.setAuthenticationMechanismType(this.getTextValue(el));
                } else if (elName.equals("credential-interface")) {
                    authenticationMechanism.setCredentialInterface(this.getTextValue(el));
                }
            }
            ++i;
        }
        return authenticationMechanism;
    }

    private SecurityPermission processSecurityPermission(Element element) {
        SecurityPermission securityPermission = new SecurityPermission();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("description")) {
                    securityPermission.setDescription(this.getTextValue(el));
                } else if (elName.equals("security-permission-spec")) {
                    securityPermission.setSecurityPermissionSpec(this.getTextValue(el));
                }
            }
            ++i;
        }
        return securityPermission;
    }

    private InboundResourceAdapterDescriptor processInboundResourceAdapter(Element element, Vector warnings) {
        InboundResourceAdapterDescriptor inboundResourceAdapter = new InboundResourceAdapterDescriptor();
        MessageListener messageListener = new MessageListener();
        Vector<MessageListener> messageListeners = new Vector<MessageListener>();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Element el;
            String elName;
            if (list.item(i).getNodeType() == 1 && (elName = (el = (Element)list.item(i)).getNodeName()).equals("messageadapter")) {
                NodeList messagelist = el.getChildNodes();
                int j = 0;
                while (j < messagelist.getLength()) {
                    Element el2;
                    String el2Name;
                    if (messagelist.item(j).getNodeType() == 1 && (el2Name = (el2 = (Element)messagelist.item(j)).getNodeName()).equals("messagelistener")) {
                        messageListener = this.processMessageListener(el2);
                        boolean found = false;
                        int k = 0;
                        while (k < messageListeners.size()) {
                            String type = ((MessageListener)messageListeners.elementAt(k)).getMessageListenerType();
                            if (messageListener.getMessageListenerType().equals(type)) {
                                found = true;
                                break;
                            }
                            ++k;
                        }
                        if (!found) {
                            messageListeners.add(messageListener);
                        } else {
                            warnings.add("Can not add a message listener with not unique message listener type" + messageListener.getMessageListenerType());
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        inboundResourceAdapter.setMessageListeners(messageListeners.toArray(new MessageListener[messageListeners.size()]));
        return inboundResourceAdapter;
    }

    private MessageListener processMessageListener(Element element) {
        MessageListener messageListener = new MessageListener();
        Vector<RequiredConfigProperty> requiredConfigProperties = new Vector<RequiredConfigProperty>();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("messagelistener-type")) {
                    messageListener.setMessageListenerType(this.getTextValue(el));
                } else if (elName.equals("activationspec")) {
                    NodeList activationlist = el.getChildNodes();
                    int j = 0;
                    while (j < activationlist.getLength()) {
                        if (activationlist.item(j).getNodeType() == 1) {
                            Element el2 = (Element)activationlist.item(j);
                            String el2Name = el2.getNodeName();
                            if (el2Name.equals("activationspec-class")) {
                                messageListener.setActivationSpecClass(this.getTextValue(el2));
                            } else if (el2Name.equals("required-config-property")) {
                                requiredConfigProperties.add(this.processRequiredConfigProperty(el2));
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        messageListener.setRequiredConfigProperties(requiredConfigProperties.toArray(new RequiredConfigProperty[requiredConfigProperties.size()]));
        return messageListener;
    }

    private RequiredConfigProperty processRequiredConfigProperty(Element element) {
        RequiredConfigProperty requiredConfigProperty = new RequiredConfigProperty();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("description")) {
                    requiredConfigProperty.setDescription(this.getTextValue(el));
                } else if (elName.equals("config-property-name")) {
                    requiredConfigProperty.setConfigPropertyName(this.getTextValue(el));
                }
            }
            ++i;
        }
        return requiredConfigProperty;
    }

    private AdminObjectDescriptor processAdminObject(Element element) {
        AdminObjectDescriptor adminObject = new AdminObjectDescriptor();
        Vector<ConfigProperty> configProperties = new Vector<ConfigProperty>();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("adminobject-interface")) {
                    adminObject.setAdminObjectInterface(this.getTextValue(el));
                } else if (elName.equals("adminobject-class")) {
                    adminObject.setAdminObjectClass(this.getTextValue(el));
                } else if (elName.equals("config-property")) {
                    configProperties.add(this.processConfigProperty(el));
                }
            }
            ++i;
        }
        adminObject.setConfigProperties(configProperties.toArray(new ConfigProperty[configProperties.size()]));
        return adminObject;
    }

    private DriverDescriptor processDriver(Element element) {
        DriverDescriptor driverDescriptor = new DriverDescriptor();
        Vector<String> fileNames = new Vector<String>();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("driver-name")) {
                    driverDescriptor.setDriverName(this.getTextValue(el));
                } else if (elName.equals("driver-class-name")) {
                    driverDescriptor.setDriverClassName(this.getTextValue(el));
                } else if (elName.equals("file-name")) {
                    fileNames.add(this.getTextValue(el));
                }
            }
            ++i;
        }
        driverDescriptor.setFileNames(fileNames.toArray(new String[fileNames.size()]));
        return driverDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processAddConnDef(Element element, ConnectionDefinition connectionDefinition) throws DeploymentException {
        boolean equality = false;
        Vector<String> aliases = new Vector<String>();
        Vector<IdentitySubject> identitySubjects = new Vector<IdentitySubject>();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("managedconnectionfactory-class")) {
                    String textValue = this.getTextValue(el);
                    if (!textValue.equals(connectionDefinition.getManagedConnectionFactoryClass())) throw new BaseDeploymentException("connector15-j2ee-engine.xml is not correct!");
                    equality = true;
                } else if (elName.equals("jndi-name")) {
                    if (equality) {
                        connectionDefinition.setJNDIName(this.getTextValue(el));
                    }
                } else if (elName.equals("alias")) {
                    if (equality) {
                        aliases.add(this.getTextValue(el));
                    }
                } else if (elName.equals("pool-params")) {
                    if (equality) {
                        NodeList list1 = el.getChildNodes();
                        int j = 0;
                        while (j < list1.getLength()) {
                            if (list1.item(j).getNodeType() == 1) {
                                Element el2 = (Element)list1.item(j);
                                String el2Name = el2.getNodeName();
                                if (el2Name.equals("max-connections-number")) {
                                    connectionDefinition.setMaxConnectionsNumber(new Integer(this.getTextValue(el2)));
                                } else if (el2Name.equals("max-time-to-wait-connection")) {
                                    connectionDefinition.setMaxTimeToWaitConnection(new Integer(this.getTextValue(el2)));
                                } else if (el2Name.equals("expiration-control")) {
                                    NodeList list2 = el2.getChildNodes();
                                    int k = 0;
                                    while (k < list2.getLength()) {
                                        if (list2.item(k).getNodeType() == 1) {
                                            Element el3 = (Element)list2.item(k);
                                            String el3Name = el3.getNodeName();
                                            if (el3Name.equals("connection-lifetime")) {
                                                connectionDefinition.setConnectionLifeTime(new Integer(this.getTextValue(el3)));
                                            } else if (el3Name.equals("run-cleanup-thread")) {
                                                connectionDefinition.setRunCleanupThreadTime(new Integer(this.getTextValue(el3)));
                                            }
                                        }
                                        ++k;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                } else if (elName.equals("authentication-type")) {
                    if (equality) {
                        connectionDefinition.setAuthenticationType(this.getTextValue(el));
                    }
                } else if (elName.equals("user-store")) {
                    if (equality) {
                        connectionDefinition.setUserStore(this.getTextValue(el));
                    }
                } else if (elName.equals("identity-subject") && equality) {
                    identitySubjects.add(this.processIdentitySubject(el));
                }
            }
            ++i;
        }
        connectionDefinition.setIdentitySubjects(identitySubjects.toArray(new IdentitySubject[identitySubjects.size()]));
        connectionDefinition.setAliases(aliases.toArray(new String[aliases.size()]));
    }

    private IdentitySubject processIdentitySubject(Element element) {
        IdentitySubject identitySubject = new IdentitySubject();
        CallerPrincipal callerPrincipal = new CallerPrincipal();
        ResourcePrincipal resourcePrincipal = new ResourcePrincipal();
        HashSet<String> groupNames = new HashSet<String>();
        HashSet<String> userNames = new HashSet<String>();
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                String el2Name;
                Element el2;
                int k;
                NodeList list1;
                Element el = (Element)list.item(i);
                String elName = el.getNodeName();
                if (elName.equals("caller-principal")) {
                    list1 = el.getChildNodes();
                    k = 0;
                    while (k < list1.getLength()) {
                        if (list1.item(k).getNodeType() == 1) {
                            el2 = (Element)list1.item(k);
                            el2Name = el2.getNodeName();
                            if (el2Name.equals("group-name")) {
                                groupNames.add(this.getTextValue(el2));
                            } else if (el2Name.equals("user-name")) {
                                userNames.add(this.getTextValue(el2));
                            }
                        }
                        ++k;
                    }
                } else if (elName.equals("resource-principal")) {
                    list1 = el.getChildNodes();
                    k = 0;
                    while (k < list1.getLength()) {
                        if (list1.item(k).getNodeType() == 1) {
                            el2 = (Element)list1.item(k);
                            el2Name = el2.getNodeName();
                            if (el2Name.equals("user-name")) {
                                resourcePrincipal.setUserName(this.getTextValue(el2));
                            } else if (el2Name.equals("user-password")) {
                                resourcePrincipal.setPassword(this.getTextValue(el2));
                            }
                        }
                        ++k;
                    }
                }
            }
            ++i;
        }
        callerPrincipal.setGroups(groupNames);
        callerPrincipal.setUserNames(userNames);
        identitySubject.setCallerPrincipal(callerPrincipal);
        identitySubject.setResourcePrincipal(resourcePrincipal);
        return identitySubject;
    }

    private String getTextValue(Element element) {
        if (element == null) {
            return new String();
        }
        Node node = element.getFirstChild();
        if (node != null && node.getNodeType() == 3) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return new String("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

