/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.descriptors;

import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.ear.common.EqualUtils;

public class DriverDescriptor {
    private String driverName = null;
    private String driverClassName = null;
    private String[] fileNames = null;

    public DriverDescriptor() {
    }

    public DriverDescriptor(String driverName, String driverClassName, String[] fileNames) {
        this.setDriverName(driverName);
        this.setDriverClassName(driverClassName);
        this.setFileNames(fileNames);
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        if (driverName == null) {
            throw new BaseIllegalArgumentException("connector_0306", "driver-name");
        }
        this.driverName = driverName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        if (driverClassName == null) {
            throw new BaseIllegalArgumentException("connector_0306", "driver-class-name");
        }
        this.driverClassName = driverClassName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public void setFileNames(String[] fileNames) {
        this.fileNames = fileNames;
    }

    public Object clone() {
        DriverDescriptor cloning = new DriverDescriptor();
        cloning.driverName = this.driverName == null ? null : new String(this.driverName);
        String string = cloning.driverClassName = this.driverClassName == null ? null : new String(this.driverClassName);
        if (this.fileNames == null) {
            cloning.fileNames = null;
        } else {
            cloning.fileNames = new String[this.fileNames.length];
            int i = 0;
            while (i < this.fileNames.length) {
                cloning.fileNames[i] = this.fileNames[i] == null ? null : this.fileNames[i];
                ++i;
            }
        }
        return cloning;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DriverDescriptor)) {
            return false;
        }
        DriverDescriptor driverDescriptor = (DriverDescriptor)object;
        if (driverDescriptor.driverName != null ? !driverDescriptor.driverName.equals(this.driverName) : this.driverName != null) {
            return false;
        }
        if (driverDescriptor.driverClassName != null ? !driverDescriptor.driverClassName.equals(this.driverClassName) : this.driverClassName != null) {
            return false;
        }
        return EqualUtils.equalUnOrderedArrays(driverDescriptor.fileNames, this.fileNames);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

