/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.descriptors;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ResourceAdapterDescriptor;
import java.io.Serializable;

public class ConnectorDescriptor
implements Serializable {
    private transient ClassLoader loader = null;
    private String displayName = null;
    private String description = null;
    private transient SerializableFile smallIcon = null;
    private transient SerializableFile largeIcon = null;
    private String vendorName = null;
    private String eisType = null;
    private String resourceAdapterVersion = null;
    private String licenseDescription = null;
    private boolean isLicenseRequired = false;
    private ResourceAdapterDescriptor resourceAdapterDescriptor = null;
    private boolean isRealApplication = false;
    private String rarFileName = null;
    private String applicationName = null;

    public ConnectorDescriptor() {
    }

    public ConnectorDescriptor(String displayName, String description, SerializableFile smallIcon, SerializableFile largeIcon, String vendorName, String eisType, String resourceAdapterVersion, String licenseDescription, boolean isLicenseRequired, ResourceAdapterDescriptor resourceAdapterDescriptor, boolean isRealApplication, String rarFileName, ClassLoader loader, String applicationName) {
        this.setDisplayName(displayName);
        this.setDescription(description);
        this.setSmallIcon(smallIcon);
        this.setLargeIcon(largeIcon);
        this.setVendorName(vendorName);
        this.setEisType(eisType);
        this.setResourceAdapterVersion(resourceAdapterVersion);
        this.setLicenseDescription(licenseDescription);
        this.setLicenseRequired(isLicenseRequired);
        this.setResourceAdapterDescriptor(resourceAdapterDescriptor);
        this.setRealApplication(isRealApplication);
        this.setRarFileName(rarFileName);
        this.setClassLoader(loader);
        this.setApplicationName(applicationName);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SerializableFile getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(SerializableFile largeIcon) {
        this.largeIcon = largeIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = new SerializableFile(largeIcon);
    }

    public SerializableFile getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = new SerializableFile(smallIcon);
    }

    public void setSmallIcon(SerializableFile smallIcon) {
        this.smallIcon = smallIcon;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public void setVendorName(String vendorName) {
        if (vendorName == null) {
            throw new BaseIllegalArgumentException("connector_0306", "vendor-name");
        }
        this.vendorName = vendorName;
    }

    public String getEisType() {
        return this.eisType;
    }

    public void setEisType(String eisType) {
        if (eisType == null) {
            throw new BaseIllegalArgumentException("connector_0306", "eis-type");
        }
        this.eisType = eisType;
    }

    public String getResourceAdapterVersion() {
        return this.resourceAdapterVersion;
    }

    public void setResourceAdapterVersion(String resourceAdapterVersion) {
        if (resourceAdapterVersion == null) {
            throw new BaseIllegalArgumentException("connector_0306", "resourceadapter-version");
        }
        this.resourceAdapterVersion = resourceAdapterVersion;
    }

    public String getLicenseDescription() {
        return this.licenseDescription;
    }

    public void setLicenseDescription(String licenseDescription) {
        this.licenseDescription = licenseDescription;
    }

    public boolean isLicenseRequired() {
        return this.isLicenseRequired;
    }

    public void setLicenseRequired(boolean isLicenseRequired) {
        this.isLicenseRequired = isLicenseRequired;
    }

    public ResourceAdapterDescriptor getResourceAdapterDescriptor() {
        return this.resourceAdapterDescriptor;
    }

    public void setResourceAdapterDescriptor(ResourceAdapterDescriptor resourceAdapterDescriptor) {
        if (resourceAdapterDescriptor == null) {
            throw new BaseIllegalArgumentException("connector_0306", "resourceadapter");
        }
        this.resourceAdapterDescriptor = resourceAdapterDescriptor;
    }

    public boolean isRealApplication() {
        return this.isRealApplication;
    }

    public void setRealApplication(boolean isRealApplication) {
        this.isRealApplication = isRealApplication;
    }

    public String getRarFileName() {
        return this.rarFileName;
    }

    public void setRarFileName(String rarFileName) {
        this.rarFileName = rarFileName;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public Object clone() {
        ConnectorDescriptor cloning = new ConnectorDescriptor();
        cloning.displayName = this.displayName == null ? null : new String(this.displayName);
        cloning.description = this.description == null ? null : new String(this.description);
        cloning.smallIcon = this.smallIcon != null ? (SerializableFile)this.smallIcon.clone() : null;
        cloning.largeIcon = this.largeIcon != null ? (SerializableFile)this.largeIcon.clone() : null;
        cloning.vendorName = this.vendorName == null ? null : new String(this.vendorName);
        cloning.eisType = this.eisType == null ? null : new String(this.eisType);
        cloning.resourceAdapterVersion = this.resourceAdapterVersion == null ? null : new String(this.resourceAdapterVersion);
        cloning.licenseDescription = this.licenseDescription == null ? null : new String(this.licenseDescription);
        cloning.isLicenseRequired = this.isLicenseRequired();
        cloning.resourceAdapterDescriptor = this.resourceAdapterDescriptor != null ? (ResourceAdapterDescriptor)this.resourceAdapterDescriptor.clone() : null;
        cloning.isRealApplication = this.isRealApplication();
        cloning.rarFileName = this.rarFileName == null ? null : new String(this.rarFileName);
        cloning.loader = this.loader;
        cloning.applicationName = this.applicationName == null ? null : new String(this.applicationName);
        return cloning;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ConnectorDescriptor)) {
            return false;
        }
        ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)object;
        if (connectorDescriptor.displayName != null ? !connectorDescriptor.displayName.equals(this.displayName) : this.displayName != null) {
            return false;
        }
        if (connectorDescriptor.description != null ? !connectorDescriptor.description.equals(this.description) : this.description != null) {
            return false;
        }
        if (connectorDescriptor.smallIcon != null ? !connectorDescriptor.smallIcon.equals(this.smallIcon) : this.smallIcon != null) {
            return false;
        }
        if (connectorDescriptor.largeIcon != null ? !connectorDescriptor.largeIcon.equals(this.largeIcon) : this.largeIcon != null) {
            return false;
        }
        if (connectorDescriptor.vendorName != null ? !connectorDescriptor.vendorName.equals(this.vendorName) : this.vendorName != null) {
            return false;
        }
        if (connectorDescriptor.eisType != null ? !connectorDescriptor.eisType.equals(this.eisType) : this.eisType != null) {
            return false;
        }
        if (connectorDescriptor.resourceAdapterVersion != null ? !connectorDescriptor.resourceAdapterVersion.equals(this.resourceAdapterVersion) : this.resourceAdapterVersion != null) {
            return false;
        }
        if (connectorDescriptor.licenseDescription != null ? !connectorDescriptor.licenseDescription.equals(this.licenseDescription) : this.licenseDescription != null) {
            return false;
        }
        if (connectorDescriptor.isLicenseRequired != this.isLicenseRequired) {
            return false;
        }
        if (connectorDescriptor.resourceAdapterDescriptor != null ? !connectorDescriptor.resourceAdapterDescriptor.equals(this.resourceAdapterDescriptor) : this.resourceAdapterDescriptor != null) {
            return false;
        }
        if (connectorDescriptor.isRealApplication != this.isRealApplication) {
            return false;
        }
        if (connectorDescriptor.rarFileName != null ? !connectorDescriptor.rarFileName.equals(this.rarFileName) : this.rarFileName != null) {
            return false;
        }
        if (connectorDescriptor.loader != null ? !connectorDescriptor.loader.equals(this.loader) : this.loader != null) {
            return false;
        }
        return !(connectorDescriptor.applicationName != null ? !connectorDescriptor.applicationName.equals(this.applicationName) : this.applicationName != null);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

