/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.descriptors;

import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.connector.jca.deploy.descriptor.IdentitySubject;
import com.sap.engine.services.connector.jca15.deploy.descriptors.ConfigProperty;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import java.io.Serializable;

public class ConnectionDefinition
implements Serializable {
    public static final String CONFIGURED_IDENTITY = "Configured Identity";
    public static final String PRINCIPAL_MAPPING = "Principal Mapping";
    public static final String CALLER_IMPERSONATION = "Caller Impersonation";
    public static final String CREDENTIALS_MAPPING = "Credentials Mapping";
    private String managedConnectionFactoryClass = null;
    private ConfigProperty[] configProperties = null;
    private String connectionFactoryInterface = null;
    private String connectionFactoryImplClass = null;
    private String connectionInterface = null;
    private String connectionImplClass = null;
    private String[] aliases = null;
    private int maxConnectionsNumber = -1;
    private int maxTimeToWaitConnection = -1;
    private int connectionLifeTime = -1;
    private int runCleanupThreadTime = -1;
    private String jndiName = null;
    private String authenticationType = null;
    private String userStore = null;
    private IdentitySubject[] identitySubjects = null;
    private boolean isInternalStore = false;

    public ConnectionDefinition() {
    }

    public ConnectionDefinition(String managedConnectionFactoryClass, ConfigProperty[] configProperties, String connectionFactoryInterface, String connectionFactoryImplClass, String connectionInterface, String connectionImplClass, String[] aliases, int maxConnectionsNumber, int maxTimeToWaitConnection, int connectionLifeTime, int runCleanupThreadTime, String jndiName, String authenticationType, String userStore, IdentitySubject[] identitySubjects, boolean isInternalStore) {
        this.setManagedConnectionFactoryClass(managedConnectionFactoryClass);
        this.setConfigProperties(configProperties);
        this.setConnectionFactoryInterface(connectionFactoryInterface);
        this.setConnectionFactoryImplClass(connectionFactoryImplClass);
        this.setConnectionInterface(connectionInterface);
        this.setConnectionImplClass(connectionImplClass);
        this.setAliases(aliases);
        this.setMaxConnectionsNumber(maxConnectionsNumber);
        this.setMaxTimeToWaitConnection(maxTimeToWaitConnection);
        this.setConnectionLifeTime(connectionLifeTime);
        this.setRunCleanupThreadTime(runCleanupThreadTime);
        this.setJNDIName(jndiName);
        this.setAuthenticationType(authenticationType);
        this.setUserStore(userStore);
        this.setIdentitySubjects(identitySubjects);
        this.setInternalUserStore(isInternalStore);
    }

    public String getManagedConnectionFactoryClass() {
        return this.managedConnectionFactoryClass;
    }

    public void setManagedConnectionFactoryClass(String managedConnectionFactoryClass) {
        if (managedConnectionFactoryClass == null) {
            throw new BaseIllegalArgumentException("connector_0306", "managedconnectionfactory-class");
        }
        this.managedConnectionFactoryClass = managedConnectionFactoryClass;
    }

    public ConfigProperty[] getConfigProperties() {
        return this.configProperties;
    }

    public void setConfigProperties(ConfigProperty[] configProperties) {
        this.configProperties = configProperties;
    }

    public String getConnectionFactoryInterface() {
        return this.connectionFactoryInterface;
    }

    public void setConnectionFactoryInterface(String connectionFactoryInterface) {
        if (connectionFactoryInterface == null) {
            throw new BaseIllegalArgumentException("connector_0306", "connectionfactory-interface");
        }
        this.connectionFactoryInterface = connectionFactoryInterface;
    }

    public String getConnectionFactoryImplClass() {
        return this.connectionFactoryImplClass;
    }

    public void setConnectionFactoryImplClass(String connectionFactoryImplClass) {
        if (connectionFactoryImplClass == null) {
            throw new BaseIllegalArgumentException("connector_0306", "connectionfactory-impl-class");
        }
        this.connectionFactoryImplClass = connectionFactoryImplClass;
    }

    public String getConnectionInterface() {
        return this.connectionInterface;
    }

    public void setConnectionInterface(String connectionInterface) {
        if (connectionInterface == null) {
            throw new BaseIllegalArgumentException("connector_0306", "connection-interface");
        }
        this.connectionInterface = connectionInterface;
    }

    public String getConnectionImplClass() {
        return this.connectionImplClass;
    }

    public void setConnectionImplClass(String connectionImplClass) {
        if (connectionImplClass == null) {
            throw new BaseIllegalArgumentException("connector_0306", "connection-impl-class");
        }
        this.connectionImplClass = connectionImplClass;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public void setMaxConnectionsNumber(int maxConnectionsNumber) {
        this.maxConnectionsNumber = maxConnectionsNumber;
    }

    public int getMaxConnectionsNumber() {
        return this.maxConnectionsNumber;
    }

    public void setMaxTimeToWaitConnection(int maxTimeToWaitConnection) {
        this.maxTimeToWaitConnection = maxTimeToWaitConnection;
    }

    public int getMaxTimeToWaitConnection() {
        return this.maxTimeToWaitConnection;
    }

    public void setConnectionLifeTime(int connectionLifeTime) {
        this.connectionLifeTime = connectionLifeTime;
    }

    public int getConnectionLifeTime() {
        return this.connectionLifeTime;
    }

    public void setRunCleanupThreadTime(int runCleanupThreadTime) {
        this.runCleanupThreadTime = runCleanupThreadTime;
    }

    public int getRunCleanupThreadTime() {
        return this.runCleanupThreadTime;
    }

    public void setJNDIName(String jndiName) {
        if (jndiName == null) {
            throw new BaseIllegalArgumentException("connector_0306", "jndi-name");
        }
        this.jndiName = jndiName;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public void setAuthenticationType(String authenticationType) {
        if (authenticationType == null || "".equals(authenticationType) || !authenticationType.equalsIgnoreCase(CONFIGURED_IDENTITY) && authenticationType.equalsIgnoreCase(PRINCIPAL_MAPPING) && authenticationType.equalsIgnoreCase(CALLER_IMPERSONATION) && authenticationType.equalsIgnoreCase(CREDENTIALS_MAPPING)) {
            throw new BaseIllegalArgumentException("connector_0303", new String[]{"authentication-type", "configured identity, principal mapping, caller impersonation or credentials mapping."});
        }
        this.authenticationType = authenticationType;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setUserStore(String userStore) {
        this.userStore = userStore;
    }

    public String getUserStore() {
        return this.userStore;
    }

    public void setIdentitySubjects(IdentitySubject[] identitySubjects) {
        this.identitySubjects = identitySubjects;
    }

    public IdentitySubject[] getIdentitySubjects() {
        return this.identitySubjects;
    }

    public void setInternalUserStore(boolean isInternalStore) {
        this.isInternalStore = isInternalStore;
    }

    public boolean isInternalUserStore() {
        return this.isInternalStore;
    }

    public Object clone() {
        int i;
        ConnectionDefinition cloning = new ConnectionDefinition();
        String string = cloning.managedConnectionFactoryClass = this.managedConnectionFactoryClass == null ? null : new String(this.managedConnectionFactoryClass);
        if (this.configProperties == null) {
            cloning.configProperties = null;
        } else {
            cloning.configProperties = new ConfigProperty[this.configProperties.length];
            i = 0;
            while (i < this.configProperties.length) {
                cloning.configProperties[i] = this.configProperties[i] == null ? null : (ConfigProperty)this.configProperties[i].clone();
                ++i;
            }
        }
        cloning.connectionFactoryInterface = this.connectionFactoryInterface == null ? null : new String(this.connectionFactoryInterface);
        cloning.connectionFactoryImplClass = this.connectionFactoryImplClass == null ? null : new String(this.connectionFactoryImplClass);
        cloning.connectionInterface = this.connectionInterface == null ? null : new String(this.connectionInterface);
        String string2 = cloning.connectionImplClass = this.connectionImplClass == null ? null : new String(this.connectionImplClass);
        if (this.aliases == null) {
            cloning.aliases = null;
        } else {
            cloning.aliases = new String[this.aliases.length];
            i = 0;
            while (i < this.aliases.length) {
                cloning.aliases[i] = this.aliases[i] == null ? null : new String(this.aliases[i]);
                ++i;
            }
        }
        cloning.maxConnectionsNumber = this.maxConnectionsNumber;
        cloning.maxTimeToWaitConnection = this.maxTimeToWaitConnection;
        cloning.connectionLifeTime = this.connectionLifeTime;
        cloning.runCleanupThreadTime = this.runCleanupThreadTime;
        cloning.jndiName = this.jndiName == null ? null : new String(this.jndiName);
        cloning.userStore = this.userStore == null ? null : new String(this.userStore);
        String string3 = cloning.authenticationType = this.authenticationType == null ? null : new String(this.authenticationType);
        if (this.identitySubjects == null) {
            cloning.identitySubjects = null;
        } else {
            cloning.identitySubjects = new IdentitySubject[this.identitySubjects.length];
            i = 0;
            while (i < this.identitySubjects.length) {
                cloning.identitySubjects[i] = this.identitySubjects[i] == null ? null : (IdentitySubject)this.identitySubjects[i].clone();
                ++i;
            }
        }
        cloning.isInternalStore = this.isInternalStore;
        return cloning;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ConnectionDefinition)) {
            return false;
        }
        ConnectionDefinition connectionDefinition = (ConnectionDefinition)object;
        if (connectionDefinition.managedConnectionFactoryClass != null ? !connectionDefinition.managedConnectionFactoryClass.equals(this.managedConnectionFactoryClass) : this.managedConnectionFactoryClass != null) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(connectionDefinition.configProperties, this.configProperties)) {
            return false;
        }
        if (connectionDefinition.connectionFactoryInterface != null ? !connectionDefinition.connectionFactoryInterface.equals(this.connectionFactoryInterface) : this.connectionFactoryInterface != null) {
            return false;
        }
        if (connectionDefinition.connectionFactoryImplClass != null ? !connectionDefinition.connectionFactoryImplClass.equals(this.connectionFactoryImplClass) : this.connectionFactoryImplClass != null) {
            return false;
        }
        if (connectionDefinition.connectionInterface != null ? !connectionDefinition.connectionInterface.equals(this.connectionInterface) : this.connectionInterface != null) {
            return false;
        }
        if (connectionDefinition.connectionImplClass != null ? !connectionDefinition.connectionImplClass.equals(this.connectionImplClass) : this.connectionImplClass != null) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(connectionDefinition.aliases, this.aliases)) {
            return false;
        }
        if (connectionDefinition.maxConnectionsNumber != this.maxConnectionsNumber) {
            return false;
        }
        if (connectionDefinition.maxTimeToWaitConnection != this.maxTimeToWaitConnection) {
            return false;
        }
        if (connectionDefinition.connectionLifeTime != this.connectionLifeTime) {
            return false;
        }
        if (connectionDefinition.runCleanupThreadTime != this.runCleanupThreadTime) {
            return false;
        }
        if (connectionDefinition.jndiName != null ? !connectionDefinition.jndiName.equals(this.jndiName) : this.jndiName != null) {
            return false;
        }
        if (connectionDefinition.authenticationType != null ? !connectionDefinition.authenticationType.equals(this.authenticationType) : this.authenticationType != null) {
            return false;
        }
        if (connectionDefinition.userStore != null ? !connectionDefinition.userStore.equals(this.userStore) : this.userStore != null) {
            return false;
        }
        if (connectionDefinition.identitySubjects != this.identitySubjects) {
            return false;
        }
        return connectionDefinition.isInternalStore == this.isInternalStore;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

