/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy.descriptors;

import com.sap.engine.services.connector.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.connector.jca15.deploy.descriptors.RequiredConfigProperty;
import java.io.Serializable;

public class ConfigProperty
extends RequiredConfigProperty
implements Serializable {
    private String configPropertyType = null;
    private String configPropertyValue = null;

    public ConfigProperty() {
    }

    public ConfigProperty(String description, String configPropertyName, String configPropertyType, String configPropertyValue) {
        super(description, configPropertyName);
        this.setConfigPropertyType(configPropertyType);
        this.setConfigPropertyValue(configPropertyValue);
    }

    public String getConfigPropertyType() {
        return this.configPropertyType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setConfigPropertyType(String configPropertyType) {
        if (configPropertyType == null) throw new BaseIllegalArgumentException("connector_0306", "config-property-type");
        if (configPropertyType.equals("java.lang.Boolean")) {
            this.configPropertyType = configPropertyType;
            return;
        } else if (configPropertyType.equals("java.lang.String")) {
            this.configPropertyType = configPropertyType;
            return;
        } else if (configPropertyType.equals("java.lang.Integer")) {
            this.configPropertyType = configPropertyType;
            return;
        } else if (configPropertyType.equals("java.lang.Double")) {
            this.configPropertyType = configPropertyType;
            return;
        } else if (configPropertyType.equals("java.lang.Byte")) {
            this.configPropertyType = configPropertyType;
            return;
        } else if (configPropertyType.equals("java.lang.Short")) {
            this.configPropertyType = configPropertyType;
            return;
        } else if (configPropertyType.equals("java.lang.Long")) {
            this.configPropertyType = configPropertyType;
            return;
        } else if (configPropertyType.equals("java.lang.Float")) {
            this.configPropertyType = configPropertyType;
            return;
        } else {
            if (!configPropertyType.equals("java.lang.Character")) throw new BaseIllegalArgumentException("connector_0303", new String[]{"config-property-type", "java.lang.Boolean,java.lang.String,java.lang.Integer,java.lang.Double,java.lang.Byte,java.lang.Short,java.lang.Long,java.lang.Float,java.lang.Character"});
            this.configPropertyType = configPropertyType;
        }
    }

    public String getConfigPropertyValue() {
        return this.configPropertyValue;
    }

    public void setConfigPropertyValue(String configPropertyValue) {
        this.configPropertyValue = configPropertyValue;
    }

    public Object clone() {
        ConfigProperty cloning = new ConfigProperty();
        cloning.description = this.description == null ? null : new String(this.description);
        cloning.configPropertyName = this.configPropertyName == null ? null : new String(this.configPropertyName);
        cloning.configPropertyType = this.configPropertyType == null ? null : new String(this.configPropertyType);
        cloning.configPropertyValue = this.configPropertyValue == null ? null : new String(this.configPropertyValue);
        return cloning;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ConfigProperty)) {
            return false;
        }
        ConfigProperty configProperty = (ConfigProperty)object;
        if (configProperty.description != null ? !configProperty.description.equals(this.description) : this.description != null) {
            return false;
        }
        if (configProperty.configPropertyName != null ? !configProperty.configPropertyName.equals(this.configPropertyName) : this.configPropertyName != null) {
            return false;
        }
        if (configProperty.configPropertyType != null ? !configProperty.configPropertyType.equals(this.configPropertyType) : this.configPropertyType != null) {
            return false;
        }
        return !(configProperty.configPropertyValue != null ? !configProperty.configPropertyValue.equals(this.configPropertyValue) : this.configPropertyValue != null);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

