/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.connector.jca15.deploy;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.engine.services.connector.ResourceObjectFactory;
import com.sap.engine.services.connector.exceptions.BaseDeploymentException;
import com.sap.engine.services.deploy.container.DeploymentException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.resource.ResourceException;

public class AdminUtils {
    public static final String DRIVERS = "drivers";
    public static final String JARS = ".jar";
    public static final char SEPARATOR_CHAR = File.separatorChar;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static void makeAllSubDirs(File dir, boolean isFile) throws DeploymentException {
        if (isFile && (dir = dir.getParentFile()) == null) {
            return;
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new BaseDeploymentException("connector_0015", dir.getAbsolutePath());
        }
    }

    public static String makeSubDirectory(String workAppDir, String subDir) {
        return workAppDir + SEPARATOR_CHAR + subDir;
    }

    public static String makeFileName(String appName, String workDirName, boolean local, String extension) {
        if (local) {
            return workDirName + SEPARATOR_CHAR + appName + "." + extension;
        }
        return appName + "." + extension;
    }

    public static String makeDriverJarName(String rarName, String driverName, String driverJarName) {
        StringBuffer result = new StringBuffer();
        result.append(rarName).append("-").append(driverName).append("-").append(driverJarName);
        return result.toString();
    }

    public static Configuration createSubConfiguration(Configuration rootConfig, String configurationName, int configurationType) throws DeploymentException {
        StringTokenizer tokenizer = new StringTokenizer(configurationName, "/");
        while (tokenizer.hasMoreElements()) {
            String subConfigName = tokenizer.nextToken();
            try {
                rootConfig = rootConfig.getSubConfiguration(subConfigName);
            }
            catch (ConfigurationException ce) {
                try {
                    rootConfig = rootConfig.createSubConfiguration(subConfigName, configurationType);
                }
                catch (ConfigurationException confExc) {
                    throw new BaseDeploymentException("connector_0000", new String[]{subConfigName, rootConfig.getPath()}, (Throwable)((Object)confExc));
                }
            }
        }
        return rootConfig;
    }

    public static void startFactory(String appName, String cfName, String connFactoryInterface, boolean supportContainerAuth, boolean isStandAlone) throws DeploymentException {
        try {
            ResourceObjectFactory.addConnectionFactory(appName, cfName, connFactoryInterface, supportContainerAuth, isStandAlone);
        }
        catch (ResourceException re) {
            throw new BaseDeploymentException("connector_0041", cfName, (Throwable)re);
        }
        try {
            ResourceObjectFactory.startConnectionFactory(cfName);
        }
        catch (ResourceException re) {
            throw new BaseDeploymentException("connector_0043", cfName, (Throwable)re);
        }
    }

    public static void stopFactory(String jndiName, String[] aliases, Vector warnings) {
        try {
            ResourceObjectFactory.stopConnectionFactory(jndiName);
        }
        catch (ResourceException re) {
            warnings.add("Can not stop factory '" + jndiName + "', reason : " + re.toString());
        }
        try {
            ResourceObjectFactory.removeConnectionFactory(jndiName);
        }
        catch (ResourceException re) {
            warnings.add("Can not remove factory '" + jndiName + "', reason : " + re.toString());
        }
        if (aliases != null && aliases.length > 1) {
            ResourceObjectFactory.unregisterAliases(aliases);
        }
    }

    public static void getAllFiles(File sourceDir, Vector files, boolean isJAR) {
        File[] list = sourceDir.listFiles();
        int i = 0;
        while (list != null && i < list.length) {
            if (list[i].isDirectory()) {
                AdminUtils.getAllFiles(list[i], files, isJAR);
            } else {
                String absPath = list[i].getAbsolutePath();
                if (!isJAR) {
                    files.add(absPath);
                } else if (absPath.startsWith(DRIVERS) || absPath.endsWith(JARS)) {
                    files.add(absPath);
                }
            }
            ++i;
        }
    }

    public static void getAllConfigFileEntries(String configName, Configuration config, Map map) throws ConfigurationException {
        Map tempMap = config.getAllFileEntries();
        Iterator keys = tempMap.keySet().iterator();
        while (keys.hasNext()) {
            String fileName = (String)keys.next();
            map.put(configName + "/" + fileName, tempMap.get(fileName));
        }
        Map configs = config.getAllSubConfigurations();
        keys = configs.keySet().iterator();
        while (keys.hasNext()) {
            String confName = (String)keys.next();
            AdminUtils.getAllConfigFileEntries(configName + "/" + confName, (Configuration)configs.get(confName), map);
        }
    }

    public static void getAllSecurePropertyEntries(String configName, Configuration config, Map map) throws DeploymentException, ConfigurationException {
        Iterator keys;
        PropertySheet propertySheet = null;
        if (config.getMetaData().getConfigurationType() == 1) {
            propertySheet = config.getPropertySheetInterface();
            Map tempMap = propertySheet.getPropertyMap();
            keys = tempMap.keySet().iterator();
            while (keys.hasNext()) {
                String fileName = (String)keys.next();
                map.put(configName + "/" + fileName, new ByteArrayInputStream(((String)tempMap.get(fileName)).getBytes()));
            }
        }
        Map configs = config.getAllSubConfigurations();
        keys = configs.keySet().iterator();
        while (keys.hasNext()) {
            String confName = (String)keys.next();
            AdminUtils.getAllSecurePropertyEntries(configName + "/" + confName, (Configuration)configs.get(confName), map);
        }
    }

    public static String setMethodName(String propertyName) {
        return "set" + propertyName.toUpperCase().charAt(0) + propertyName.substring(1);
    }

    public static Class getPrimaryTypeClass(String className) {
        if (className == null) {
            return null;
        }
        if (className.equals((class$java$lang$Integer == null ? (class$java$lang$Integer = AdminUtils.class$("java.lang.Integer")) : class$java$lang$Integer).getName())) {
            return Integer.TYPE;
        }
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals((class$java$lang$Byte == null ? (class$java$lang$Byte = AdminUtils.class$("java.lang.Byte")) : class$java$lang$Byte).getName())) {
            return Byte.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals((class$java$lang$Character == null ? (class$java$lang$Character = AdminUtils.class$("java.lang.Character")) : class$java$lang$Character).getName())) {
            return Character.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals((class$java$lang$Short == null ? (class$java$lang$Short = AdminUtils.class$("java.lang.Short")) : class$java$lang$Short).getName())) {
            return Short.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals((class$java$lang$Long == null ? (class$java$lang$Long = AdminUtils.class$("java.lang.Long")) : class$java$lang$Long).getName())) {
            return Long.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals((class$java$lang$Double == null ? (class$java$lang$Double = AdminUtils.class$("java.lang.Double")) : class$java$lang$Double).getName())) {
            return Double.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals((class$java$lang$Float == null ? (class$java$lang$Float = AdminUtils.class$("java.lang.Float")) : class$java$lang$Float).getName())) {
            return Float.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals((class$java$lang$String == null ? (class$java$lang$String = AdminUtils.class$("java.lang.String")) : class$java$lang$String).getName())) {
            return class$java$lang$String == null ? (class$java$lang$String = AdminUtils.class$("java.lang.String")) : class$java$lang$String;
        }
        if (className.equals((class$java$lang$Boolean == null ? (class$java$lang$Boolean = AdminUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName())) {
            return Boolean.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        return null;
    }

    public static void addFileAsStream(String entryName, Configuration config, InputStream in, boolean update, Vector warnings) throws DeploymentException {
        try {
            config.addFileAsStream(entryName, in);
        }
        catch (NameAlreadyExistsException nex) {
            if (!update) {
                throw new BaseDeploymentException("connector_0002", new String[]{entryName, config.getPath()}, (Throwable)((Object)nex));
            }
            try {
                config.updateFileAsStream(entryName, in);
            }
            catch (ConfigurationException cexc) {
                throw new BaseDeploymentException("connector_0005", new String[]{entryName, config.getPath()}, (Throwable)((Object)cexc));
            }
        }
        catch (ConfigurationException cexc) {
            try {
                in.close();
            }
            catch (IOException ioe) {
                warnings.add("Can not close stream, the reason is : " + ioe.toString());
            }
            throw new BaseDeploymentException("connector_0002", new String[]{entryName, config.getPath()}, (Throwable)((Object)cexc));
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties getPropertiesFromConfig(Configuration propertiesConfig, String appName, Vector warnings) throws DeploymentException {
        InputStream is = null;
        Properties props = new Properties();
        is = propertiesConfig.getFile(appName + ".properties");
        props.load(is);
        Object var8_5 = null;
        if (is == null) return props;
        try {
            is.close();
            return props;
        }
        catch (IOException ioexc) {
            warnings.add(ioexc.toString());
        }
        return props;
        {
            catch (IOException ioe) {
                throw new BaseDeploymentException("connector_0012", new String[]{appName + ".properties", propertiesConfig.getPath()}, (Throwable)ioe);
            }
            catch (ConfigurationException confExc) {
                throw new BaseDeploymentException("connector_0012", new String[]{appName + ".properties", propertiesConfig.getPath()}, (Throwable)((Object)confExc));
            }
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ioexc) {
                warnings.add(ioexc.toString());
            }
            throw throwable;
        }
    }

    public static void bind(Context root, String name, Object obj, boolean rebind) throws NamingException {
        String s;
        Context initialContext = root;
        Context current = null;
        StringTokenizer st = new StringTokenizer(name, "/");
        while (true) {
            s = st.nextToken();
            if (!st.hasMoreTokens()) break;
            try {
                current = (Context)initialContext.lookup(s);
            }
            catch (Exception e) {
                try {
                    current = initialContext.createSubcontext(s);
                }
                catch (NameAlreadyBoundException nabe) {
                    current = (Context)initialContext.lookup(s);
                }
            }
            initialContext = current;
        }
        if (rebind) {
            initialContext.rebind("/" + s, obj);
        } else {
            initialContext.bind("/" + s, obj);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

